﻿Ext.define('Keysystems.Reviz.Edit.Ap', {
	extend: 'Keysystems.Reviz.Edit.Resp',
	title: 'Реализация АП',
	tabKey: 'Ap',
	profileKey: 'taskGridAp',
	bridgeToolbars: function() {
		var me = this,
			res = me.callParent(arguments);
		me.dockedItems.push({
			xtype: 'toolbar',
			dock: 'top',
			items: [
				me.sksc('cbSDeloStatus', Ext.create('Keysystems.Controls.ComboBoxExtra', {
					labelWidth: 100,
					fieldLabel: 'Статус дела',
					padding: '0 0 0 10',
					editable: false,
					disabled: true,
					value: null,
					store: CBDataLib.getStore(CBDataLib.get(_, true, {})),
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					listeners: { change: function(th, v) { if (th.ksInitChangeEvent) me.changeSDeloStatus(v); } }
				}))
			]
		});
		return res;
	},

	getNextSDeloStatuses: function(statusLink) {
		var me = this,
			k = 'SDeloStatus_' + statusLink,
			res = me.gksm(k);
		if (!res) {
			res = me.sksm(k, new Promise(function(resolve, reject) {
				ajaxRequest({
					url: 'SStatus/GetNextStatuses_A',
					params: { status: statusLink, tLinks: [0], objCode: 'DICTIONARY_SDELO' },
					success: function(r) { resolve(r[0]); },
					failure: reject
				});
			}));
		}
		return res;
	},

	changeSDeloStatus: function(status) {
		var me = this,
			rec = me.getFrstSelect();
		if (rec && rec.data.S_DELO && status) {
			var cbSDeloStatus = me.gksc('cbSDeloStatus'),
				cbRec = cbSDeloStatus.store.getRecord(status, CBDataLib.valueField);

			cbSDeloStatus.disable();
			ajaxRequest({
				url: 'SDelo/ChangeStatus_A',
				params: { link: rec.data.S_DELO, status: status },
				success: function() {
					var name = cbRec.data[CBDataLib.displayField];
					Ext.each(me.getTreeDoc(rec), function(r) {
						r.set('S_DELO_STATUS', status);
						r.set('S_DELO_STATUS_NAME', name);
					});
				},
				callback: function() { if (rec === me.getFrstSelect()) me.loadSDeloStatusData(); }
			});
		}
	},

	//Получить всю ветку документа в виде массива
	getTreeDoc: function(rec) {
		while (rec.parentNode.data.parentId !== 'root') rec = rec.parentNode;

		var res = [],
			arr = [rec];
		while (arr.length) {
			res.push(rec = arr.pop());
			Ext.each(rec.childNodes, function(r) { arr.push(r); });
		}
		return res;
	},

	loadSDeloStatusData: function() {
		var me = this,
			cbSDeloStatus = me.gksc('cbSDeloStatus'),
			rec;

		if (!me.isRfn){
			cbSDeloStatus.setVisible(false);
		}
		else{
			cbSDeloStatus.ksInitChangeEvent = 0;
			cbSDeloStatus.disable();
			cbSDeloStatus.store.loadData(CBDataLib.get(_, true, {}));
			cbSDeloStatus.setValue(null);
			if ((rec = me.getFrstSelect()) && rec.data.parentId !== 'root') {
				var sLink = rec.data.S_DELO_STATUS;
				me.getNextSDeloStatuses(sLink || 0).then(function(nextStatuses) {
					if ((rec = me.getFrstSelect()) && sLink === rec.data.S_DELO_STATUS) {
						var d = CBDataLib.get(_, _, nextStatuses),
							v = {};
						v[CBDataLib.displayField] = rec.data.S_DELO_STATUS_NAME || '...';
						v[CBDataLib.valueField] = sLink || null;
						d.unshift(v);

						cbSDeloStatus.loadData(d);
						cbSDeloStatus.setValue(sLink || null);

						cbSDeloStatus.enable();
						cbSDeloStatus.ksInitChangeEvent = 1;
					}
				});
			}
			
		}			
	},

	edit: function(f, data, defCfg) {
		var me = this;
		defCfg = defCfg || {};

		defCfg.updRecord = function(row) {
			var res = this.callParent(arguments),
				rec = this.data;
			Ext.each(me.getTreeDoc(rec), function(r) {
				r.set('S_DELO', row.S_DELO);
				r.set('S_DELO_CODE', row.S_DELO_CODE);
				r.set('S_DELO_NAME', row.S_DELO_NAME);
				r.set('S_DELO_STATUS', row.S_DELO_STATUS);
				r.set('S_DELO_STATUS_NAME', row.S_DELO_STATUS_NAME);
			});
			return res;
		};
		if (me.ownerCt.ksReadOnly) data.readOnly = true;
		return me.callParent([f, data, defCfg]);
	},

	initComponent: function() {
		var me = this,
			res = me.callParent(arguments);

		me.on('selectionchange', me.loadSDeloStatusData.bind(me));

		return res;
	},
	setExtra: function(value) {
		var me = this;
		me.isRfn = value.isRfn;
		res = me.callParent(arguments);
	},
	setAccessBtns: Ext.emptyFn
});