Ext.define('Keysystems.Reports.Sign.List', {
		extend: 'Keysystems.Base.List',
		profileListeners: [
			{name: 'period', method: 'KsPeriodChange'},
			{name: 'periodDT', method: 'KsPeriodChange'},
			{name: 'REPORT_LIST', method: 'ksDictChange'},
			{name: 'S_ORG', method: 'ksDictChange'}
		],
		showNote: async function () {
			const me = this;
			const sel = me.Grid.getFrstSelect();
			if (!sel) return;

			let response = await ajaxRequestAsync({
				params: {link: sel.get('LINK'), html: true},
				url: 'SReportSign/GetNote_A'
			});
			if (!response) return;

			const htmlCfg = {
				text: response,
				title: "Примечание",
				hasIgnoreButton: false,
				noPreStyle: true,
				width: 800,
				height: 600
			};
			ChooseBox.ShowHTMLLog(htmlCfg);
		},
		editNote: async function () {
			const me = this;
			const sel = me.Grid.getFrstSelect();
			if (!sel) return;

			let response = await ajaxRequestAsync({
				params: {link: sel.get('LINK'), html: false},
				url: 'SReportSign/GetNote_A'
			});
			if (!response) return;

			Ext.create('Keysystems.Comment',
				{
					title: "Примечание",
					labelText: "Введите примечание для отчета",
					initText: response,
					minHeight: 200,
					minWidth: 600,
					textAreaHeight: 50,
					textAreaWidth: 588,
					okFn: function () {
						const value = this.textArea.getValue();
						const mask = new Ext.LoadMask({
							msg: "Сохранение примечания...",
							target: me.getLoadMaskTarget(),
							autoShow: true,
							rid: ajaxRequest({
								url: 'SReportSign/SaveNote_A',
								params: {
									link: sel.get('LINK'),
									value: value,
								},
								success: function (saved) {
									if (saved) {
										me.updRecord({
											LINK: sel.get('LINK'),
											NOTE: value,
										});
									}
								},
								callback: function () {
									mask.destroy();
								}
							})
						});
					}
				}).show();
		},
		createGridListeners: function () {
			const me = this;
			me.callParent(arguments);
			delete me.objs.gridListeners.itemdblclick;
			me.objs.gridListeners.itemdblclick = function (th1, record, item, index) {
				me.open(record);
			}
		},
		open: function (sel) {
			const me = this;
			if (!sel) sel = me.Grid.getFrstSelect();
			if (!sel) return;

			const fileName = sel.get('FILENAME');
			const loadMask = new Ext.LoadMask({
				msg: 'Подготовка файла...',
				target: me.getLoadMaskTarget(),
				autoShow: true,
				rid: ajaxRequest({
					params: {link: sel.get('LINK')},
					url: 'SReportSign/PrepareFileForDownload_A',
					success: function (response) {
						if (!response) return;
						UploaderLib.getFileAndFree(response, fileName);
					},
					callback: () => {
						loadMask.destroy();
					}
				}),
			});
		},
		saveAs: async function () {
			const me = this;
			const sel = me.Grid.getFrstSelect();
			if (!sel) return;

			const fileName = sel.get('FILENAME');
			const edsServiceModule = Ext.create('Keysystems.EDSServiceModule', {
				target: me.getLoadMaskTarget()
			});

			edsServiceModule.selectCertificate(async (cert) => {
					delete cert.id;

					let dataForSign = {
						Data: sel.get('PATH'),
						CertificateInfo: cert
					}

					const loadMask = new Ext.LoadMask({
						msg: 'Получение данных для подписи...',
						target: me.getLoadMaskTarget(),
						autoShow: true
					});

					let response = await ajaxRequestAsync({
						params: {data: JSON.stringify(dataForSign), fileName: fileName},
						url: 'SReportSign/PrepareForSaveAs_A'
					});
					if (!response) {
						loadMask.destroy();
						return;
					}

					loadMask.setMsg("Подпись данных...");
					dataForSign = response;
					const signer = window.Signer.SignHash.Data;
					signer.Sign2({
						data: dataForSign.Hash,
						B64: true,
						signParams: {
							CertInclude: 1,
						},
						certSubj: cert.serial,
						onSuccess: function (hash) {
							loadMask.setMsg("Подготовка архива...");
							const params = {
								path: dataForSign.File,
								signature: hash,
								fileName: fileName
							}
							ajaxRequest({
								params: {data: JSON.stringify(params)},
								url: 'SReportSign/PrepareZipForDownload_A',
								success: function (response) {
									if (!response) return;
									UploaderLib.getFileAndFree(response, fileName.replace(/\.[^/.]+$/, ""));
								},
								callback: () => {
									loadMask.destroy();
								}

							})
						}
					})
				}
			)

		},
		afterSignCompleted: function (response) {
			const me = this;
			if (!response?.rows) return;
			response.rows.forEach(row => {
				row.DATE_EDS = row.EDS_DATE;
			});
			me.callParent(arguments);
		},

		getGridCfg: function () {
			let res = this.callParent(arguments);
			res.userCls = 'rks-grid-with-filter-panel';
			return res;
		},

		createItems: function () {
			var me = this,
				objs = me.objs,
				items = me.callParent(arguments);
			me.isCreate = true;
			items.unshift(Ext.create('Ext.panel.Panel', {
				collapsible: true,
				title: 'Фильтр по Сохраненным отчетам',
				userCls: 'rks-filter-panel',
				border: 0,
				bodyBorder: 0,
				layout: {type: 'vbox', align: 'stretch'},
				bodyPadding: '10 0 5 10',
				animCollapse: false,
				items: [
					Ext.create('Ext.form.FieldContainer', {
						layout: {type: 'hbox', align: 'stretch'},
						items: [
							objs.period = Ext.create('Keysystems.Controls.KsPeriod', {
								startYear: new Date().getFullYear(),
								state: 4,
								allStates: 12,
								width: 400,
								listeners: {
									ksChange: function () {
										if (me.isLoading) return;
										me.refreshData();
									}
								}
							}),
							objs.REPORT_LIST = Ext.create('Keysystems.Controls.DictName.Edit', {
								fieldLabel: 'Отчет',
								labelWidth: 120,
								flex: 1,
								padding: '0 10 0 10',
								mode: 'MULTI',
								ksSetValue: function (value) {
									if (me.isLoading) return;
									this.setValue(value);
									me.refreshData();
								},
								handler: function () {
									dictFunc({
										mode: 'MULTI',
										parentView: objs.view,
										selectLinks: objs.REPORT_LIST.getValue(),
										code: dnl.REPORT_LIST,
										control: objs.REPORT_LIST,
										contextSearch: objs.REPORT_LIST.contextSearch
									}, {
										ok: function (value) {
											objs.REPORT_LIST.ksSetValue(value);
										}
									});
								}
							})
						]
					}),
					Ext.create('Ext.form.FieldContainer', {
						layout: {type: 'hbox', align: 'stretch'},
						items: [
							objs.periodDT = Ext.create('Keysystems.Controls.KsPeriod', {
								startYear: me.startYear,
								allStates: 12,
								width: 400,
								fieldLabel: 'Дата',
								listeners: {
									ksChange: function () {
										if (me.isLoading) return;
										me.refreshData();
									}
								}
							}),
							objs.S_ORG = Ext.create('Keysystems.Controls.Dict.Edit', {
								fieldLabel: 'Организация',
								labelWidth: 120,
								flex: 1,
								padding: '0 10 0 10',
								mode: 'MULTI',
								ksSetValue: function (value) {
									if (me.isLoading) return;
									this.setValue(value);
									me.refreshData();
								},
								handler: function () {
									dictFunc({
										mode: 'MULTI',
										parentView: objs.view,
										selectLinks: objs.S_ORG.getValue(),
										code: dnl.S_ORG,
										control: objs.S_ORG,
										contextSearch: objs.S_ORG.contextSearch
									}, {
										ok: function (value) {
											objs.S_ORG.ksSetValue(value);
										}
									});
								}
							})
						]
					})
				]
			}));

			me.isCreate = false;

			return items;
		},

		initializeFilter: function () {
			let me = this;
			if (!me.whereArgs) return;

			if (me.whereArgs.ReportsPreset) {
				me.objs.REPORT_LIST.setReadOnly(true);
			}
		},

		beforeSetData: function (data, params) {
			const me = this;
			const res = me.callParent(arguments);

			if (data.ReportsData) {
				me.objs.REPORT_LIST.setValue(data.ReportsData);
			}
			return res;
		},

		setWhereArgs: function () {
			const me = this;
			const reports = me.objs.REPORT_LIST.getLinks() || [];
			const sOrgs = me.objs.S_ORG.getLinks() || [];
			const period = me.objs.period.getValue();
			const periodDT = me.objs.periodDT.getValue();

			const whereArgs = {
				DBegin: {
					value: period.dh1,
					type: 'Date'
				},
				DEnd: {
					value: period.dh2,
					type: 'Date'
				},
				DTBegin: {
					value: periodDT.dh1,
					type: 'Date'
				},
				DTEnd: {
					value: periodDT.dh2,
					type: 'Date'
				},
				Reports: {
					value: JSON.stringify(reports),
					type: 'List_int'
				},
				SOrgs: {
					value: JSON.stringify(sOrgs),
					type: 'List_int'
				}
			};
			return Ext.apply(me.whereArgs, whereArgs);
		},

		refreshData: function () {
			const me = this;
			me.setWhereArgs();
			me.refresh();
		},
	}
)