Ext.define('Keysystems.Reports.Sign.Edit', {
	extend: 'Keysystems.Base.Edit',
	profileListeners: [{name: 'view', method: 'FormParam'}],
	viewCfg: function () {
		let cfg = this.callParent(arguments);
		cfg.resizable = true;
		cfg.maximizable = true;
		return cfg;
	},
	createItems: function () {
		var me = this,
			items = [
				me.sksc('chooseFileBtn', Ext.create('Keysystems.form.field.FileButtonMulti', {
					multiple: false,
					hidden: true,
					listeners: {
						change: function (th, e) {
							UploaderLib.uploadFiles(e.target.files, _, me.addFile.bind(me));
						},
						// afterrender: function(th) { if (!me.getReadOnly()) UploaderLib.bind(th.el.dom, me.addFile.bind(me), 1); }
					}
				})),
				me.sksc('FILE', Ext.create('Ext.form.field.Text', {
					fieldLabel: 'Файл',
					labelWidth: me.labelWidth,
					readOnly: true,
					//ksAllowEmpty: true, todo при потере фокуса сразу срабатывает валидация
					triggers: {
						dict: {
							cls: 'x_btn_dict x-dict-trigger',
							handler: function () {
								if (me.getLink()) return;
								me.gksc('chooseFileBtn').fileInputEl.dom.click();
							}
						}
					}
				})),

				me.sksc('OBJECT_VAR', Ext.create('Keysystems.Controls.DictName.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Отчет',
					//ksAllowEmpty: true,
					handler: function () {
						dictFunc({
							mode: 'SINGL',
							selectLinks: me.gksc('OBJECT_VAR').getValue(),
							code: dnl.REPORT_LIST,
							readOnly: me.gksc('OBJECT_VAR').readOnly,
							control: me.gksc('OBJECT_VAR'),
							contextSearch: me.gksc('OBJECT_VAR').contextSearch,
							initWhereArgs: function () {
								return {
									Mode: {value: '2', type: 'int'},
								}
							}
						}, {
							ok: function (value) {
								me.gksc('OBJECT_VAR').setValue(value);

								const status = me.gksc('S_STATUS').getValue();
								ajaxRequest({
									params: {
										link: me.getLink(),
										object_var: me.gksc('OBJECT_VAR').getLink(),
										status: status
									},
									url: 'SReportSign/GetStatuses_A',
									callback: function (response) {
										if (response?.statuses && !response.statuses.length) {
											me.gksc('S_STATUS').store.loadData(CBDataLib.get(_, status === null, response.statuses, -1), false);
											me.gksc('S_STATUS').setValue(status === null ? -1 : status);
											me.gksc('S_STATUS').setDisabled(false);
										} else {
											me.gksc('S_STATUS').store.loadData([], false);
											me.gksc('S_STATUS').setValue(null);
											me.gksc('S_STATUS').setDisabled(true);
										}
									}
								});
							}
						});
					}
				})),
				me.sksc('NOTE', Ext.create('Ext.form.field.TextArea', {
					flex: 1,
					fieldLabel: 'Комментарий',
					labelWidth: me.labelWidth,
				})),
				me.sksc('S_STATUS', Ext.create('Keysystems.Controls.ComboBoxExtra', {
					fieldLabel: 'Статус',
					labelWidth: me.labelWidth,
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					editable: false,
					queryMode: 'local',
					maxWidth: 400,
					store: Ext.create('Ext.data.Store', {
						fields: CBDataLib.getFields(),
						data: CBDataLib.get(_, false, {}),
						proxy: 'memory'
					}),

					listeners: {
						change: function (th, newValue) {
							if (me.isLoaded) return;
							me.setReadOnlyByStatus(true);
						}
					},
				})),
			];

		me.isDHEdit = true;

		return me.callParent([items]);
	},

	dataCollector: function () {
		const me = this;
		const data = me.callParent(arguments);
		data.NOTE = me.gksc('NOTE').getValue();
		data.S_STATUS = me.gksc('S_STATUS').getValue();

		if (!me.getLink()) {
			data.files = me.gksd('files');
			data.fileName = me.gksc('FILE').getValue();

			let objVar = me.gksc('OBJECT_VAR').getValue();
			objVar = objVar?.length ? (objVar[0].data || objVar[0]) : null;
			data.OBJECT_VAR = objVar ? objVar.LINK : 0;
			data.OBJCODE = objVar ? objVar.OBJCODE : null;
		}
		return data;
	},
	isFilled: function () {
		const me = this;
		let res = me.callParent(arguments);
		if (!me.gksc('FILE').getValue()) {
			me.addToInvalidControls(me.gksc('FILE'));
			res = false;
		}
		if (me.gksc('OBJECT_VAR').isEmpty()) {
			me.addToInvalidControls(me.gksc('OBJECT_VAR'));
			res = false;
		}
		return res;
	},
	getExtra: function (endFunc, link) {
		const me = this;
		me.baseGetExtra({link: link}, function (value) {
			me.gksc('DH').setValue(value.row.DATE1, value.row.DATE2)
			me.gksc('FILE').setValue(value.row.FILENAME);
			me.gksc('OBJECT_VAR').setValue(value.OBJECT_VAR);
			me.gksc('NOTE').setValue(value.row.NOTE);
			if (me.getLink()) {
				me.gksc('DH').setReadOnly(true);
				me.gksc('FILE').setReadOnly(true);
				me.gksc('OBJECT_VAR').setReadOnly(true);
			}

			me.sksd('readOnlyStatuses', value.readOnlyStatuses);
			if (value.statuses) {
				me.gksc('S_STATUS').store.loadData(CBDataLib.get(_, value.row.S_STATUS === null, value.statuses, -1), false);
				me.gksc('S_STATUS').setValue(value.row.S_STATUS ?? -1);
			} else {
				me.gksc('S_STATUS').store.loadData([], false);
				me.gksc('S_STATUS').setDisabled(true);
			}
			if (endFunc) endFunc();
		});
	},
	setReadOnly: function (v, reason, fake) {
		const me = this;
		me.callParent(arguments);
		if (fake) me.gksc('S_STATUS').setKsReadOnly(false);
	},

	/**
	 * Выставить доступ по статусу
	 * @param {boolean} fake не блокировать кнопку Сохранить
	 */
	setReadOnlyByStatus: function (fake) {
		const me = this;
		const status = me.gksc('S_STATUS').getValue();
		if (me.gksd('readOnlyStatuses').indexOf(status) !== -1) {
			const statusName = me.gksc('S_STATUS').store.getDataExt().filter(r => r.index === status)[0]?.value;
			me.setReadOnly(true, _, fake);
			me.setStatusReadOnly(true, Ext.String.format(KS.L10n.ReportSignUpdController_Запись_со_статусом___0___запрещена_к_редактированию, statusName));
		} else {
			me.setReadOnly(false);
		}
	},
	addFile: function (link, ext, callback, file) {
		const me = this;
		me.sksd('files', link);
		me.gksc('FILE').setValue(file.name);
	},
	saveData: function (endFunc, inputParams) {
		const me = this;
		if (!inputParams) inputParams = me.dataCollector();
		me.baseSaveData(inputParams, async function (response) {
			if (response.state === 1) {
				await me.afterSave(response);
			}
			if (endFunc) endFunc(result);
		});
	},
	afterSave: async function (response) {
		const me = this;
		if (response.status && response.statuses) {
			me.gksc('S_STATUS').store.loadData(CBDataLib.get(_, false, response.statuses), false);
			me.gksc('S_STATUS').setValue(response.status);
			me.setReadOnlyByStatus(false);
		}
		if (response.signOnSave) {
			const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
				target: me.getLoadMaskTarget(),
				code: "DOC_REPORT_EDS",
				links: [response.SavedLink],
				mode: 'EDS_SET'
			});
			await serviceModule.executeAsync();
		}
	},
	/**
	 * Проверка данных на сервере. Вызовет CheckSave модели.
	 * @param inputParams
	 * @returns {void} Отобразит протокол с результатами проверки.
	 */
	checkData: function (inputParams) {
		const me = this;
		me.parseCheckSaveResult({State: 0, Message: 'Контроль пройден успешно'});
	},
});