﻿Ext.define('Revizor.ReportView', {
	extend: 'Ext.container.Container',
	mixins: ['Keysystems.Base.Abstract'],
	alias: 'widget.ReportView',

	requires: ['Ext.toolbar.Toolbar', 'Ext.button.Button'],

	objs: {},
	closable: true,
	tabMode: false,
	viewMode: 'viewShow',
	parentView: null,
	iconCls: 'x_btn_report_query',
	
	code: '',
	link_var: '',
	variant: -100, //Линк на вариант отчета (-1 стандартный отчет)
	//Пробегаемся по всем и пробуем модифицировать значения
	taskId: '',
	defaultParams: [],
	labelWidth: 400,
	saveChanges: true, //вызов функции подтверждения закрытия окна
	mode: KsLib.getKeyByValue(miscTypes.ReportPrintMode, 'Complex'),

	config : {
		sysDicts: [],
		dyn_component: {}, //array with auto generation elements
	},

	initConfig: function(cfg) {
		var me = this;
		me.callParent(arguments);
		
		me.objs = {};

		Ext.apply(me, cfg);

		me.viewMode = (me.tabMode && me.parentView) ? 'tabShow' : 'viewShow';
		if (me.viewMode === "viewShow") me.labelWidth = 200;
		me.beforeInitComponent();
	},

	constructor: function(cfg) {
		var me = this;
		Ext.apply(me, cfg);
		me.callParent(arguments);
		
		
		me.taskId = me.generateUUID();
		
		me.createToolBar();
		me.createItems();
		me.createListeners();
		me.createView();

		me.on('indicate', me.IndicateElements, me);
		me.on('ActivateSave', me.ActivateSave, me);
		me.GetFormParameters();

		me.show();
	},
	viewCfg: function() {
		var me = this,
			objs = me.objs;
		objs.viewCfg = {
			title: me.title,
			iconCls: me.iconCls,
			closable: me.closable,
			layout: { type: 'hbox', align: 'stretch' },
			anchor: '100% 100%',
			flex: 1,
			height: 400,
			minHeight: 400,
			minWidth: 600,
			items: objs.items,
			listeners: objs.listeners,
			dict: me,
		};
		return objs.viewCfg;
	},
	createView: function() {
		var me = this,
			cfg = me.viewCfg();
		if (me.tabMode) {
			cfg.border = 0;
			me.objs.view = Ext.create('Ext.panel.Panel', cfg);
		} else {
			cfg.modal = true;
			cfg.width = 800;
			cfg.height = 600;
			cfg.maximizable = true;
			cfg.autoRender = true;
			cfg.constrain = true;
			me.objs.view = Ext.create('Ext.window.Window', cfg);
		}
	},
	createItems: function() {
		var me = this,
			objs = me.objs;
		
		return me.objs.items = [
			Ext.create('Ext.form.FieldContainer', {
				width: 200,
				layout: { type: 'vbox', align: 'stretch' },
				items: [
					me.sksc('SVARPARAM', Ext.create('widget.dictnameedit', {
						scope: this,
						Code: "DICTIONARY_SVARPARAM",
						Action: "SINGLE",
						cleaningKey: false,
						listeners: {
							scope: this,
							variantselect: this.onVariantSelect
						},
						handler: function() {
							let SVARPARAM = me.gksc('SVARPARAM'),
								oldLink = SVARPARAM.value[0]?.data.LINK,
								settings = {
									'mode': 'SINGLE',
									'parentView': objs['view'],
									'code': this.Code,
									'whereArgs': {
										'FormName': {
											value: me.FormParamName,
											type: 'string'
										}
									},
									'inputDicts': [
										Ext.create('InputEditDict', {
											'name': 'FORMNAME',
											'data': me.FormParamName
										})
									],
									'checkList': SVARPARAM.getValue()
								};
							var functions = {
								scope: null,
								'ok': function(value) {
									var sc = this.scope;
									var callBack = function() {
										me.isBaseVariant = !!value.length && value[0].get('BASE');
										me.hideSysDicts();
										sc.setValue(value);
										if (value.length)
											sc.fireEvent('variantselect', value[0].data.LINK);
									};
									var newData = me.saveChangesFn();
									if (newData && oldLink) {
										me.changeMsgShow({
											buttons: Ext.MessageBox.YESNO,
											yes: function () {
												me.SaveVariant(oldLink, function() {
													callBack();
												});
											},
											no: function () {
												callBack();
											}
										});
									} else {
										callBack();
									}
								}
							};
							// из-за тригера! просто на 1 уровень выше будет сам элемент
							functions.scope = this.up();
							dictFunc(settings, functions);
						}
					})),
					me.sksc('feedPanel', Ext.create('widget.listitemspanel', {
						title: '',
						feedsDef: [{ title: 'Все параметры', url: 'all' }],
						feeds: [{ title: 'Все параметры', url: 'all' }],
						listeners: {
							scope: this,
							itemselect: this.onItemSelect
						}
					}))
			]}),
			Ext.create('Ext.resizer.Splitter'),
			me.sksc('paramsPanel', Ext.create('Ext.panel.Panel', {
				bodyStyle: 'padding: 10px;',
				flex: 1,
				scrollable: true
			}))
		];
	},	
	createListeners: function() {
		var me = this;
		me.objs.listeners = {
			beforeclose: function() {
				if (me.saveChanges) {
					var newData = me.saveChangesFn();
					if (newData) {
						//Параметр указывающий что идёт закрытие формы
						newData.isClosed = true;
						me.changeMsgShow({
							buttons: Ext.MessageBox.YESNOCANCEL,
							yes: function() {
								me.SaveVariant(_, function() {
									me.saveChanges = false;
									me.objs.view.close();
								});
							},
							no: function() {
								me.saveChanges = false;
								me.objs.view.close();
							}
						});
						return false;
					}
				}
				return true;
			}
		};
	},
	show: function() {
		var me = this,
			view = me.objs.view,
			viewShow = function() {
				view.show(me.parentView,
					function() {
						Log.sendLog(wmc.get('showForm', me.title, me.code));
						if (view.getX() < 0) view.setX(0);
						if (view.getY() < 0) view.setY(0);
					});
			},
			tabShow = function() {
				if ((me.tabMode) && (me.parentView)) {
					var tab = me.parentView.add(view);
					if (tab && me.parentView.setActiveTab) {
						me.parentView.setActiveTab(tab);
					}
						
					viewShow();

					//ререндер вьюхи
					view.updateLayout();
				}
			};
		if (me.toolbar) me.objs.view.addDocked(me.toolbar);
		me.viewMode === 'tabShow' ? tabShow() : viewShow();
	},
	
	saveChangesFn: function() {
		var me = this,
			newData = me.GetParametrs();

		return (me.saveChanges && (me.oldData !== JSON.stringify(newData))) ? newData : _;
	},

	//сообщение о наличии несохраненных данных
	changeMsgShow: function(cfg) {
		Ext.Msg.show({
			title: wmc.get('Attention'),
			msg: wmc.get('SaveChanges'),
			buttons: cfg.buttons,
			fn: function(buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.QUESTION
		});
	},

	generateUUID: function() {
		var d = new Date().getTime();
		var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
			var r = (d + Math.random() * 16) % 16 | 0;
			d = Math.floor(d / 16);
			return (c == 'x' ? r : (r & 0x7 | 0x8)).toString(16);
		});
		return uuid;
	},

	/**
	 * Сохранить отчет на сервер и подписать
	 * @param guid
	 * @param code
	 */
	saveReportToServer: function(guid){
		const me = this;
		const period = me.getReportPeriod();
		
		const loadMask = new Ext.LoadMask({
			msg: "Сохранение отчета на сервер...",
			target: me.objs.view,
			autoShow: true,
			rid: ajaxRequest({
				url: 'Report/SaveReportToServer_A',
				params: {
					guid,
					code : me.code,
					object_var: me.link_var,
					dBegin: period.dh1.toDateString(),
					dEnd: period.dh2.toDateString(),
				},
				success: async function(res) {
					if (res.state !== 1) return;
					if (res.signOnSave) {
						const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
							target: me.objs.view,
							code: "DOC_REPORT_EDS",
							links: [res.SavedLink],
							mode: 'EDS_SET'
						});
						//todo по текущей реализации не отловить закрытие окна сертификатов (если отказались подписывать), чтоб вывести протокол, что отчет сохранен (не подписан)						
						await serviceModule.executeAsync();
					} else if (res.htmlProtocol){
						const htmlCfg = {
							text: res.htmlProtocol,
							title: KS.L10n["BaseRevizorPresenter_OnSignCompleted_Протокол_выполнения"],
							hasIgnoreButton: false,
							noPreStyle: true,
							width: 800,
							height: 600
						};
						ChooseBox.ShowHTMLLog(htmlCfg);
					}
				},
				callback: function() {
					loadMask.destroy();
				}
			})			
		});		
	},

	/**Отобразить список сохраненных отчетов 
	 */
	showReportSignList: function () {
		const me = this;
		const dict = dictListController["DOC_REPORT_EDS"];
		const cfg =
			{
				code: "DOC_REPORT_EDS",
				GateCode: "DOC_REPORT_EDS",
				title: dict.title,
				tabMode: true,
				parentView: window.tabView,
				checkModel: false,
				handler: dict.handler,
				linkCode: dict.linkCode,
				getWhereArgs: function () {
					return {
						Reports: {value: JSON.stringify([me.link_var]), type: 'List_int'},
						ReportsPreset: {value: true, type: 'boolean'}
					}
				},
			};
		dictFunc(cfg);
	},

	/**
	 * Получить период, за который получаем отчет (для режима Сохраненные отчеты)
	 * Код аналогичен серверной реализации ReportModel.DBegin, ReportModel.DEnd
	 * @returns {{dh1: null, dh2: null}}
	 */
	getReportPeriod: function() {
		const me = this;

		const pars = me.GetParametrs();
		const dtNastrCodesArr = ['@dDateR1', '@dDateR2', '@dPlanR1', '@dPlanR2', '@dDate1', '@dDate1', '@dDateF1', '@dDateF2', '@dDateM1', '@dDateM2'];
		let dBegin = null;
		let dEnd = null;
		const keys = Object.keys(pars);
		for (let i = 0; i < keys.length; i++) {
			const key = keys[i];
			const nastrCode = me.dyn_component[key].nastrCode;
			if (!nastrCode || !dtNastrCodesArr.indexOf(nastrCode)) return;

			const par = pars[key];
			switch (par.Type) {
				case "Period":
					const period = JSON.parse(par.Value);
					dBegin = new Date(period.dh1);
					dEnd = new Date(period.dh2);
					break;
				case "Date":
					if (Ext.string.endsWith("1", nastrCode.end)) {
						dBegin = new Date(par.Value);
					} else {
						dEnd = new Date(par.Value);
					}
					break;
			}
			if (dBegin && dEnd) break;
		}
		if (!dBegin) dBegin = new Date(1900, 0, 1);
		if (!dEnd) dEnd = new Date(2100, 11, 31);

		return {dh1: dBegin, dh2: dEnd};
	},
	
	onPrintClickAsync: function() {
		const me = this;

		if (!this.CheckValidParametrs()) return;

		const pars = me.GetParametrs();
		/* Из-за того, что submit любит вылетать с ошибкой 'Ajax communication failed', при этом формирование отчета продолжается, 
		пришлось разбить процесс на два этапа: 1 запрос - формирование отчета, 2 запрос - получение файла. */
		// Долгая команда 										
		me.showLoadMaskLong({
			msg: `${KS.L10n.report_generate}...`,
			url: 'Report/CreateReportWeb_A',
			target: me.objs.view,
			params: {
				code: me.code,
				link_var: me.link_var,
				title: me.title,
				sysCode: me.sysCode,
				mode: me.mode,
				parentLink: me.parentLink ?? (me.parentData ? me.parentData.link : 0),
				parametrs: JSON.stringify(pars),
				paramsOtbor: me.parentData ? JSON.stringify(me.parentData.paramsOtbor) : '',
				paramsNastr:  me.parentData ? JSON.stringify(me.parentData.paramsNastr) : ''
			},
			success: function(res) {
				if (!res.error.length) {
					if (!pars.SAVE_REPORT?.Value) {
						getReportFile.call(me, res.guid, me.code);
					}
					else{
						me.saveReportToServer(res.guid);
					}
				}
			}
		});
	},

	/* Проверка на коректность заполенения параметров*/
	CheckValidParametrs: function() {
		var me = this;
		var local_parametrs = this.defaultParams.slice();
		for (var i = 0; i < local_parametrs.length; i++) {
			var cmp = this.dyn_component[local_parametrs[i].Suffix];
			if (cmp == null) continue;

			//Заполнен ли обязательный параметр
			if (Ext.String.endsWith(local_parametrs[i].Caption, '*', true)) {
				if (cmp.value.length == 0) {
					Ext.MessageBox.alert("Не заполнен обязательный параметр!", "Введите " + local_parametrs[i].Caption);
					me.fireEvent('indicate', true);
					return false;
				}
			}

			switch (local_parametrs[i].ControlType) {
			case 3: //"DATEBOX"
			case 15: //"DatePeriod"
				var val = cmp.isValid();
				if (val == false) {
					Ext.MessageBox.alert("Error", wmc.get('InputRightParams'));
					me.fireEvent('indicate', true);
					return false;
				}
				break;
			}
		}
		return true;
	},
	
	GetParametrs: function() {
		var me = this;
		//Берем по умолчанию
		var local_parametrs = this.defaultParams.slice();
		var exp_param = {};

		Ext.each(local_parametrs, function(lp) {
			var cmp = me.dyn_component[lp.Suffix];
			if (!cmp) return;

			var ep;

			switch (lp.ControlType) {
			case 1: //"NumericBox":
				ep = { Value: cmp.getValue(), Type: 'int' };

				break;
			case 2: //"CurrencyBox":
				ep = { Value: cmp.getValue(), Type: 'float' };

				break;
			case 3: //"DATEBOX":
				if (cmp.getValue() != null)
					ep = { Value: cmp.getValue().toDateString(), Type: 'Date' };
				break;
			case 4: //"CheckBox"
				ep = { Value: cmp.getValue(), Type: 'bool' };

				break;
			case 5: //"EditBox"

				if (cmp.items == null) return;

				var combo = cmp.items.getAt(0);
				if (combo.getValue() == null || combo.getValue() == -1) return; //не выбрано, то выход

				var text = cmp.items.getAt(1);

				if (text.getValue() == null) return;

				// check if params in field
				ep = { Condition: combo.getValue(), Value: text.getValue(), Type: 'EditBox' };

				break;
			case 6: //"Dictionary"
				ep = {
					Value: JSON.stringify(cmp.getLinks()),
					Type: 'List_int',
					Name: cmp.fieldCode ? cmp.fieldCode.getValue() : '' + ' ' + cmp.fieldName ? cmp.fieldName.getValue() : ''
				};

				break;
			case 7: //"ComboBox":
				let Value = null,
					Name = null,
					val = cmp.getValue();
				if (val != null) {
					if (Ext.isArray(val)) {
						let name = [];
						Value = '[]';
						Ext.each(cmp.store.getDataExt(), d => {
							if (val.indexOf(d[lp.PropertyValue.ValueMember]) !== -1) {
								name.push(d[lp.PropertyValue.DisplayMember]);
							}
						});
						if (name.length) {
							Value = JSON.stringify(val);
							Name = name.join(', ');
						}
					} else {
						let items = cmp.store.getDataExt().filter(d => {
							return d[lp.PropertyValue.ValueMember] === val;
						});
						if (items.length) {
							Value = val;
							Name = items[0][lp.PropertyValue.DisplayMember];
						}
					}
				} else {

					var dispalyValue = '-1';
					if (lp.PropertyValue.SelectedIndex != null) {
						dispalyValue = store.getAt(lp.PropertyValue.SelectedIndex == -1 
							? 0 
							: lp.PropertyValue.SelectedIndex).data[local_parametrs[i].PropertyValue.ValueMember];
					}
					if (lp.PropertyValue.UseCheckBoxStyle && lp.PropertyValue.Value != null)
						dispalyValue = lp.PropertyValue.Value;

					Value = dispalyValue;
				}

				ep = { Value: Value, Name: Name, Type: Ext.isArray(val) ? 'List_int' : 'int' };
				break;
			case 15: // "DatePeriod"
				ep = { Value: cmp.getValue(true), Type: 'Period' };

				break;
			default:
				Log.sendLog("Не обработан параметр" + ep.ControlType);
				break;
			}

			exp_param[lp.Suffix] = ep;
		});

		return exp_param;
	},

	/**
	* onClearClick event
	* @private
	* 
	*/
	onClearClick: function() {

		this.defaultParams = null; // remove old items
		this.defaultParams = this.standartParams.slice(); //copy standart params to def;
		this.SetToDefaultElements();
	},
	/**
	* onExportStructClick event
	* @private
	* 
	*/
	onExportStructClick: function() {
		alert(wmc.get('DisabledFunc'));
	},

	onOpenTab: function() {
		var reportpanel = this.getReportPanel();
		var reportpanel_ext = Ext.create('widget.reportpost', {
			inTab: true,
			closable: true,
			title: reportpanel.title,
			url: reportpanel.url,
			taksid: reportpanel.taksid
		});

		if (reportpanel_ext) {
			reportpanel_ext.add(reportpanel.getFrame());
			window.tabView.add(reportpanel_ext).show();
		}
	},

	ActivateSave: function(Link) {
		let me = this;
		
		if (this.standartParamsLink == null) return;
		if (Link == null) return;
		if (this.standartParamsLink != Link) {
			me.gksc('saveBtn').enable();
		} else {
			me.gksc('saveBtn').disable();
		}
	},

	getReportPanel: function() {
		if (this.reportPanel == null)
			this.reportPanel = Ext.create('widget.reportpost', {
				title: 'Сформированный отчет: ' + (this.reportTitle || this.title),
				url: '',
				region: 'south',
				hidden: true,
				collapsible: true,
				split: true,
				flex: 2,

				minHeight: 150,
				listeners: {
					scope: this,
					opentab: this.onOpenTab
				}
			});
		return this.reportPanel;
	},

	createToolBar: function() {
		let me = this;
		
		me.toolbar = new Ext.Toolbar({
			items: [
				Ext.create('Ext.Button', {
					tooltip: 'Печать',
					tooltipType: 'title',
					iconCls: 'x_btn_print',
					handler: function() {
						me.onPrintClickAsync();
					}
				}),
				me.sksc('saveBtn', Ext.create('Ext.Button', {
					disabled: true,
					tooltip: 'Сохранить',
					tooltipType: 'title',
					iconCls: 'x_btn_save_settings',
					scope: this,
					handler: function() {
						me.SaveVariant.call(me);
					}
				})),
				me.sksc('reportSignBtn', Ext.create('Ext.Button', {
					tooltip: 'Сохраненные отчеты',
					tooltipType: 'title',
					iconCls: 'x_btn_reports_sign',
					hidden: true,
					handler: function() {
						me.showReportSignList();
					}
				})),
				{ xtype: 'tbseparator' },
				me.sksc('aboutBtn', Ext.create('Ext.Button', {
					tooltip: 'Выгрузка структуры настроек и отборов отчета',
					tooltipType: 'title',
					iconCls: 'x_btn_about',
					handler: function() {
						me.getTextNastr();
					}
				})),
				me.sksc('infoBtn', Ext.create('Ext.Button', {
					tooltip: 'Описание отчета',
					tooltipType: 'title',
					iconCls: 'x_btn_info',
					handler: function() {
						me.fileEdit();
					}
				})),
				new Ext.Button({
					tooltip: 'Выход',
					tooltipType: 'title',
					iconCls: 'x_btn_exit',
					scope: this,
					handler: function() {
						me.objs.view.close();
					}
				})
			]
		});
	},
	
	/**
	* Reacts to a feed being selected
	* @private
	*/
	onItemSelect: function(feed, title, url) {
		let me = this,
			paramsPanel = me.gksc('paramsPanel');

		if (!paramsPanel.disabled) {
			paramsPanel.setLoading(true, true);
		}
		paramsPanel.items.each(function(item2) {
			if (title == 'all') {
				item2.show();
			} else if (item2.title != title) {
				item2.hide();
			} else {
				item2.show();
			}
		});
		if (!paramsPanel.disabled) {
			paramsPanel.setLoading(false);
		}
	},
	
	/**
	* Event fire  Get GetFormParameters
	* @private
	*/
	GetFormParameters: function() {
		// get standart variant
		this.getParams(this.variant);
	},

	onVariantSelect: function(Link) {
		// get selected variant
		this.getParams(Link);
	},

	/*Старая версия на запрос POST, не работает при генерации более 30 сек*/
	getParams: function(Link) {
		// Show a waiting message box
		var me = this;
		this.fireEvent('indicate', false);
		this.fireEvent('ActivateSave', Link);

		Ext.override(Ext.data.proxy.Ajax, { timeout: 1800000 });

		ajaxRequest({
			loadingMessage: wmc.getMask('SettsReading'),
			url: '/Report/GetVariantFormParameters_A',
			params: {
				tskid: me.taskId,
				code: me.code,
				link_var: me.link_var,
				variant: Link,
				callback: me.id
			},
			success: me.validateMessage.bind(me),
			failure: function(response) {
				Log.sendLog("Ошибка! GetVariantFormParameters не отработал");
				me.fireEvent('indicate', true);
				Ext.MessageBox.alert("Error", response.responseText);
			}
		});
	},
	//Если отчет заполнен то меняет его цвет фида на зеленый
	changeReportStyle: function() {
		let me = this,
			groups = me.gksc('paramsPanel').items.items,
			feeds = me.gksc('feedPanel').view.store.data.items,
			filled = 0,
			j,
			p;

		groups[0].title === 'Общие' ? groups[0].filled = true : false;

		for (j = 0; j < groups.length; j++) {
			groups[j].filled = false;
			for (p = 0; p < groups[j].items.items.length; p++) {
				if (Ext.getClassName(groups[j].items.items[p]) === 'Ext.form.FieldContainer') {
					groups[j].filled = true;
					break;
				}

				if (!Ext.isEmpty(groups[j].items.items[p].getValue())) {
					groups[j].filled = true; //Если найдено хоть одно значение то группа считается полной
					break;
				}
			}

			let feed = feeds.filter(f => { return f.data.title === groups[j].title; });
			if (feed.length) {
				if (groups[j].filled) {
					feed[0].set('cls', 'ks-report-full');
					filled++;
				} else {
					feed[0].set('cls', 'feed-list-item');
				}
			}
		}

		//filled === groups.length ? feeds[0].set('cls', 'ks-report-all-param-full') : feeds[0].set('cls', 'ks-report-all-param');
	},
	
	/**
	* React to the add button being clicked.
	* @private
	*/
	onAddClick: function() {
		var val = this.form.getComponent('feed').getValue();
		this.form.setLoading({
			msg: wmc.getMask('SendValues')
		});

		Ext.MessageBox.show({
			msg: wmc.getMask('SaveData'),
			progressText: wmc.getMask('Saving'),
			width: 300,
			wait: true,
			waitConfig: { interval: 200 }
		});
	},

	/**
	* React to the feed validation passing
	* @private
	* @param {Object} response The response object
	*/
	validateMessage: function(response) {
		let me = this;
		
		try {
			Log.sendLog("Пришли новые параметры:" + response.responseText);
			// parse json to  object
			var Elements = (response.success) ? response : Ext.decode(response.responseText);
			if (!Elements.success) alert(Elements.error);
			// generation elements
			//Ext.ux.Cache.set("/Report/GetFormParameters" + response.request.options.jsonData.code + response.request.options.jsonData.link_var, Elements, 300);
			this.defaultParams = null;
			this.defaultParams = Elements.parametrs;
			this.FormParamName = Elements.FormParamName + Elements.Code;
			this.sysCode = Elements.Code;
			this.isBaseVariant = Elements.isBaseVariant;
			this.decimalData = response.decimalData;
			this.description = response.Description;
			this.descriptionFile = response.DescriptionFile;
			this.fileName = response.fileName;
			this.fileExt = response.fileExt;
			this.otborWA = response.otborWA;
			if (Elements.variant != '') // show variant if def
			{
				var variant = Ext.decode(Elements.variant);
				me.gksc('SVARPARAM').setValue(variant);
				//даем или не даем сохранять параметры
				if (variant.data.NAME.toLowerCase().indexOf('стандартный') !== -1) {
					if (user.isAdmin)
						me.gksc('saveBtn').enable();
					else
						me.gksc('saveBtn').disable();
				} else
					me.gksc('saveBtn').enable();

				// copy to standartparams
				this.standartParamsLink = variant.data.LINK;
				this.standartParams = this.defaultParams.slice();
			}
			if (Elements.UseSaveReport){
				me.gksc('reportSignBtn')?.setVisible(true);
			}
			if (me.gksc('paramsPanel').items.getCount() == 0)
				this.GenerationElements(Elements.parametrs, false);
			else {
				// update paramas
				this.SetToDefaultElements();
			}
			
			this.oldData = JSON.stringify(this.GetParametrs());
			// текущее состояние формы, чтобы не лезть на базу лишний раз при вызове списка выбора из справочника
			this.tempData = JSON.stringify(this.GetParametrs());
			
			this.changeReportStyle();
			this.fireEvent('indicate', true);
			return;

		} catch (e) {
			Log.sendLog("Ошибка! " + e.message);
		}
	},

	IndicateElements: function(val) {
		let me = this;
		
		if (!val) {
			this.fireEvent('errormessage', '', '');
		}
		me.gksc('feedPanel').setDisabled(!val);
		me.gksc('paramsPanel').setDisabled(!val);
		me.toolbar.setDisabled(!val);
		me.gksc('SVARPARAM').setDisabled(!val);
	},

	SetToDefaultElements: function() {
		Ext.suspendLayouts();
		for (var i = 0; i < this.defaultParams.length; i++) {
			var cmp = this.dyn_component[this.defaultParams[i].Suffix];
			if (cmp == null) continue;
			Log.sendLog("Парсинг параметра:" + this.defaultParams[i].ControlType);
			switch (this.defaultParams[i].ControlType) {
			case 1: //"NumericBox"
			case 2: //"CurrencyBox":
				var displayValue = this.defaultParams[i].PropertyValue.Value == "null" ? (new Date).getFullYear() : this.defaultParams[i].PropertyValue.Value;
				if (this.defaultParams[i].Value != null) {
					displayValue = this.defaultParams[i].Value[0];
				}
				if (displayValue != null)
					cmp.setValue(parseInt(displayValue));
				break;

			case 3: //"DateBox"
				var displayValue = this.defaultParams[i].PropertyValue.Value;
				if (this.defaultParams[i].Value != null)
					displayValue = this.defaultParams[i].Value[0];
				if (displayValue != null)
					cmp.value = new Date(displayValue);
				break;

			case 4: //"CheckBox"
				cmp.setValue(String(this.defaultParams[i].PropertyValue.Checked) == "true");
				break;

			case 6: // "Dictionary"
				cmp.setValue(this.defaultParams[i].Value != null && this.defaultParams[i].Value.hasOwnProperty('0') 
					? Ext.decode(this.defaultParams[i].Value[0]) 
					: {});
				break;

			case 7: //"ComboBox"
				var displayValue = null;
				if (this.defaultParams[i].PropertyValue.SelectedIndex != null)
					displayValue = cmp.store.getAt(this.defaultParams[i].PropertyValue.SelectedIndex = -1 
						? 0 
						: this.defaultParams[i].PropertyValue.SelectedIndex).data[this.defaultParams[i].PropertyValue.ValueMember];
				if (this.defaultParams[i].PropertyValue.Value != null)
					displayValue = this.defaultParams[i].PropertyValue.Value;
				if (this.defaultParams[i].Value != null)
					displayValue = this.defaultParams[i].Value[0];
				if (displayValue != null)
					cmp.setValue(displayValue);
				break;

			case 15: //"DatePeriod":
				if (this.defaultParams[i].Value != null) {
					cmp.setValue(new Date(this.defaultParams[i].Value[0]), new Date(this.defaultParams[i].Value[1]));
				}
				break;
			default:
				break;
			}
		}

		Ext.resumeLayouts(true);
	},
	
	/*
	**    Generation Elements
	*/
	GenerationElements: function(Elements, refresh) {
		let me = this,
			feedPanel = me.gksc('feedPanel'),
			paramsPanel = me.gksc('paramsPanel');
		
		Ext.suspendLayouts();
		//clear items
		feedPanel.feeds = feedPanel.feedsDef;
		feedPanel.view.refresh();
		paramsPanel.removeAll();
		this.dyn_component = {}; //clear all elements
		var groups = [];

		Elements.forEach(function(entry) {
			groups[entry.GroupName] = entry.GroupName;
		});

		for (var property in groups) {
			if (property != 'insert' && property != 'find' && property != 'filter' && property != 'copy' && property != 'itemReplace' && property != 'diffArrays') {
				if (!refresh) {
					feedPanel.onFeedValid(this, property, property);
				}
			}
		}
		
		var group = null;
		for (var i = 0; i < Elements.length; i++) {
			Log.sendLog("Разбираем " + Elements[i].ControlType);
			
			if (group != null && group.title != Elements[i].GroupName) {
				group = null;
			}
			if (group == null) { //search group
				for (var tt = 0; tt < paramsPanel.items.length; tt++) {
					if (paramsPanel.items.getAt(tt).title == Elements[i].GroupName) {
						group = paramsPanel.items.getAt(tt);
						break;
					}
				}
			}
			if (group == null /*&& Elements[i].ControlType != "CheckBox"*/) {
				group = Ext.create('Ext.form.FieldSet', {
					title: Elements[i].GroupName,
					defaultType: 'textfield',
					layout: {type: 'vbox', align: 'stretch'},
					checkboxToggle: false,
					collapsible: false,
					defaults: {
						hideEmptyLabel: false
					},
					listeners: {
						resize: function() {
							this.updateLayout();
						}
					}
				});
				paramsPanel.add(group);
			}

			var paramReadOnly = false;
			if (Elements[i].ReadOnly != null) {
				paramReadOnly = Elements[i].ReadOnly;
			}

			//Если есть значения то отчёт становиться заполненным
			if (Elements[i].Value && Elements[i].Value[0]) {
				group.filled = true;
			}

			switch (Elements[i].ControlType) {
			case 1: //"CurrencyBox"
				var temp_width = 250;
				if (Elements[i].PropertyValue != null && Elements[i].PropertyValue.Value != null && Elements[i].PropertyValue.Value.length != null)
					switch (Elements[i].PropertyValue.Value.length) {
						/*case 1:
							temp_width = 200; break;
							case 2:
							temp_width = 200; break;
							case 3:
							temp_width = 250; break; */
					case 4:
						temp_width = 260;
						break;
					default:
						temp_width = 250;
					}
				var displayValue = 0;
				displayValue = Elements[i].PropertyValue.Value == "null" ? (new Date).getFullYear() : Elements[i].PropertyValue.Value;
				if (Elements[i].Value != null) {
					displayValue = Elements[i].Value[0];
				}
				var cb = Ext.create('Ext.form.NumberField', {
					width: temp_width,
					fieldLabel: Elements[i].Caption,
					labelStyle: Elements[i].Sys ? 'font-weight: bold' : '',
					labelWidth: this.labelWidth,
					value: parseInt(displayValue),
					minValue: 0
				});
				if (paramReadOnly) cb.setReadOnly(true);
				this.dyn_component[Elements[i].Suffix] = cb;
				group.items.add(cb);
				break;
			case 2: //"NumericBox"
				var temp_width = 250;
				if (Elements[i].PropertyValue != null && Elements[i].PropertyValue.Value != null && Elements[i].PropertyValue.Value.length != null)
					switch (Elements[i].PropertyValue.Value.length) {
						/*case 1:
							temp_width = 200; break;
							case 2:
							temp_width = 200; break;
							case 3:
							temp_width = 250; break; */
					case 4:
						temp_width = 260;
						break;
					default:
						temp_width = 250;
					}
				var displayValue = 0;
				displayValue = Elements[i].PropertyValue.Value == "null" ? (new Date).getFullYear() : Elements[i].PropertyValue.Value;
				if (Elements[i].Value != null) {
					displayValue = Elements[i].Value[0];
				}
				var nb = Ext.create('Keysystems.Controls.CalcField', {
					//Ext.create('Ext.form.NumberField', {
					width: temp_width,
					fieldLabel: Elements[i].Caption,
					labelStyle: Elements[i].Sys ? 'font-weight: bold' : '',
					labelWidth: this.labelWidth,
					value: parseInt(displayValue),
					minValue: 0,
					decimalData: this.decimalData
				});
				if (paramReadOnly) nb.setReadOnly(true);
				this.dyn_component[Elements[i].Suffix] = nb;
				group.items.add(nb);
				break;
			case 3: // "DATEBOX"
				var displayValue = null;

				if (Elements[i].PropertyValue != null && Elements[i].PropertyValue.Value != null)
					displayValue = Elements[i].PropertyValue.Value;

				if (Elements[i].Value != null)
					displayValue = Elements[i].Value[0];

				var ui = Ext.create('Ext.form.field.Date', {
					fieldLabel: Elements[i].Caption,
					labelStyle: Elements[i].Sys ? 'font-weight: bold' : '',
					labelWidth: this.labelWidth,
					isDate: true
				});

				if (displayValue != null) ui.setValue(new Date(displayValue));

				if (paramReadOnly) ui.setReadOnly(true);
				this.dyn_component[Elements[i].Suffix] = ui;
				group.items.add(ui);
				break;
			case 4: //"CheckBox"
				var displayValue = null;

				if (Elements[i].PropertyValue != null && Elements[i].PropertyValue.Checked != null)
					displayValue = $.parseJSON(Elements[i].PropertyValue.Checked.toLowerCase());

				if (Elements[i].Value != null)
					displayValue = $.parseJSON(Elements[i].Value[0].toLowerCase());
				var ui = Ext.create( /*'Ext.form.CheckboxGroup'*/'Ext.form.field.Checkbox', {
					title: Elements[i].GroupName,
					boxLabel: Elements[i].Caption,
					labelWidth: this.labelWidth,
					value: displayValue
				});
				if (paramReadOnly) ui.setReadOnly(true);
				this.dyn_component[Elements[i].Suffix] = ui;
				group.items.add(ui);
				break;

			case 5: //"EditBox":

				var dec = Ext.decode(Elements[i].PropertyValue.AllowedConditions);
				var src = [];

				var displayValue = null;
				var cnt = 0;

				src[cnt] = [-1, "Выберите..."]; //для выбора пустого значения
				cnt++;
				for (j = 0; j < dec.length; j++) {

					switch (dec[j]) {
					case -1:
						src[cnt] = [-1, "Ничего"];
						break;
					case 0:
						src[cnt] = [0, "Равно"];
						break;
					case 1:
						src[cnt] = [1, "Не равно"];
						break;
					case 2:
						src[cnt] = [2, "Больше"];
						break;
					case 3:
						src[cnt] = [3, "Больше или равно"];
						break;
					case 4:
						src[cnt] = [4, "Меньше"];
						break;
					case 5:
						src[cnt] = [5, "Меньше или равно"];
						break;
					case 6:
						src[cnt] = [6, "Содержит"];
						break;
					case 7:
						src[cnt] = [7, "Не содержит"];
						break;
					case 8:
						src[cnt] = [8, "Начинается с"];
						break;
					case 9:
						src[cnt] = [9, "Заканчивается на"];
						break;

					default:
						Log.sendLog("Ошибка! EditBox содержит не обработанный элемент" + dec[j]);
						break;
					}
					cnt++;
				}


				var store = new Ext.data.ArrayStore({
					fields: ['ID', 'Name'],
					data: src
					// or even better data : [['1', 'hello'],['2', 'hi'],['3', 'bye']]
					// next to change: combo.getStore().loadData( new_table );
				});

				if (Elements[i].PropertyValue.SelectedIndex != null) {

					displayValue = store.getAt(Elements[i].PropertyValue.SelectedIndex == -1 ? 0 : Elements[i].PropertyValue.SelectedIndex).data[Elements[i].PropertyValue.ValueMember];
				}
				if (Elements[i].PropertyValue.Value != null)
					displayValue = Elements[i].PropertyValue.Value;
				if (Elements[i].Value != null)
					displayValue = Elements[i].Value[0];

				var combo = Ext.create('Ext.form.field.ComboBox', {
					store: store,
					fieldLabel: Elements[i].Caption,
					labelStyle: Elements[i].Sys ? 'font-weight: bold' : '',
					labelWidth: this.labelWidth,
					displayField: 'Name',
					valueField: "ID",
					typeAhead: true,
					mode: 'local',
					forceSelection: true,
					triggerAction: 'all',
					emptyText: 'Выберите...',
					selectOnFocus: true,
					applyTo: 'local-states'
				});
				if (displayValue != null)
					combo.setValue(displayValue);

				if (paramReadOnly) combo.setReadOnly(true);

				var textbox = Ext.create('Ext.form.field.Text', {
					fieldLabel: '',
					labelStyle: Elements[i].Sys ? 'font-weight: bold' : '',
					flex: 1,
					itemId: 'textbox_' + Elements[i].Suffix,
				});
				if (paramReadOnly) textbox.setReadOnly(true);

				var param_hidden = false;
				if (Elements[i].PropertyValue.AllowedConditionsHidden != null) {
					param_hidden = $.parseJSON(Elements[i].PropertyValue.AllowedConditionsHidden.toLowerCase());

				}

				var fields = Ext.create('Ext.form.FieldContainer', {
					fieldLabel: '',
					labelStyle: Elements[i].Sys ? 'font-weight: bold' : '',
					hidden: param_hidden,
					layout: 'hbox',
					items: [combo, textbox]
				});

				var AllowedConditionDisabled = false;
				if (Elements[i].PropertyValue.AllowedConditionDisabled != null)
					AllowedConditionDisabled = $.parseJSON(Elements[i].PropertyValue.AllowedConditionDisabled.toLowerCase());

				if (AllowedConditionDisabled)
					fields.setDisabled(true);

				this.dyn_component[Elements[i].Suffix] = fields;
				group.items.add(fields);

				this.items.getAt(2).add(group);
				break;

			case 6: //"Dictionary"
				if (Elements[i].PropertyValue.Hidden != null) {
					// Если элемент скрыт
					var hidden = $.parseJSON(Elements[i].PropertyValue.Hidden.toLowerCase());
					if (hidden) continue;
				}

				// SelectOnly в вине, в вэба 2 разных контрола
				var dictctrl = Elements[i].PropertyValue.SelectOnly != null ? $.parseJSON(Elements[i].PropertyValue.SelectOnly.toLowerCase()) : false;

				var dictEditor = Ext.create(dictctrl ? 'widget.dictnameedit' : 'widget.dictedit', {
					labelWidth: this.labelWidth,
					height: Elements[i].Caption.length > 110 ? 72 : Elements[i].Caption.length > 54 ? 38 : 24,
					fieldLabel: Elements[i].Caption,
					labelStyle: Elements[i].Sys ? 'font-weight: bold' : '',
					layout: 'hbox',
					flex: 1,
					scope: this,
					Code: Elements[i].PropertyValue.Code,
					Action: Elements[i].PropertyValue.Action,
					ParentID: Elements[i].Name,
					clear: function() {
						this.scope.changeReportStyle();
					},
					fill: function() {
						this.scope.changeReportStyle();
					},
					whereArgs : Elements[i].WhereArgs ?? '',
					handler: function(dict) {
						let dictEl = dict.up() || dict,
							settings = {
								'mode': dict.Action == "MultiSelect" ? 'MULTI' : 'SINGLE',
								'checkList': dictEl.getValue(),
								'parentView': objs['view'],
								'code': dict.Code,
								'whereArgs' : dictEl.whereArgs,
								'control': dict,
								'contextSearch': dict.contextSearch,
								'controlName' : dict.ParentID + '_' + dict.id
							},
							functions = {
								scope: null,
								'ok': function(value) {
									dictEl.setValue(value);
								}
							};

						// из-за тригера! просто на 1 уровень выше будет сам элемент
						functions.scope = dictEl;
						
						if (me.otborWA.indexOf(dictEl.ParentID) !== -1 && me.tempData !== JSON.stringify(me.GetParametrs())) {
							ajaxRequest({
								url: 'Report/GetOtborWhereArgs_A',
								params: {
									code: me.code,
									link_var: me.link_var,
									otborName: dictEl.ParentID,
									parametrs: JSON.stringify(me.GetParametrs())
								},
								success: function(res) {
									if (res.error) {
										showError(wmc.get('ReportGetWhereArgsError'));
									} else {
										me.tempData = JSON.stringify(me.GetParametrs());
										if (res.whereArgs) {
											dictEl.whereArgs = settings.whereArgs = res.whereArgs;
										}
										dictFunc(settings, functions);
									}
								},
								failure: function() {
									showError(wmc.get('ReportGetWhereArgsError'));
								}
							});
						} else {
							dictFunc(settings, functions);
						}
					}
				});
				if (Elements[i].Value != null && Elements[i].Value.hasOwnProperty('0')) {
					var obj = Ext.decode(Elements[i].Value[0]);
					dictEditor.setValue(obj);
				}
				if (paramReadOnly) dictEditor.setReadOnly(true);
				
				this.dyn_component[Elements[i].Suffix] = dictEditor;
				group.items.add(dictEditor);
				break;
			case 7: //"ComboBox"
				var dec = Ext.decode(Elements[i].PropertyValue.DataSource);
				var src = [];
				var fields = [];

				var col = dec[0].Columns.split(",");
				for (j = 0; j < col.length; j++) {
					if (col[j] != "")
						fields[j] = [col[j]];
				}

				var displayValue = null;

				// if nullable flase then generate row with -1
				var startpos = 1, cnt = 0;
				if (Elements[i].PropertyValue.Nullable != null) {
					var nullable = Elements[i].PropertyValue.Nullable == "False";
					if (nullable) {
						src[startpos - 1] = ["0", "..."];
						cnt++;
						displayValue = "0";
					}
				}
				startpos++; // Лежит в массиве  dec[0] id name (пропускаем)

				for (j = startpos; j <= dec.length; j++) {
					src[cnt] = [String(dec[j - 1].ID), String(dec[j - 1].NAME)];
					cnt++;
				}

				var store = new Ext.data.ArrayStore({
					fields: ['ID', 'Name'],
					data: src
					// or even better data : [['1', 'hello'],['2', 'hi'],['3', 'bye']]
					// next to change: combo.getStore().loadData( new_table );
				});

				if (Elements[i].PropertyValue.SelectedIndex != null) {
					displayValue = store.getAt(Elements[i].PropertyValue.SelectedIndex == -1 
						? 0
						: Elements[i].PropertyValue.SelectedIndex).data[Elements[i].PropertyValue.ValueMember];
				}
				if (Elements[i].PropertyValue.Value != null)
					displayValue = Elements[i].PropertyValue.Value;
				if (Elements[i].Value != null)
					displayValue = Elements[i].Value[0];

				// Elements[i].Value.SelectedIndex
				var combo = Ext.create('Keysystems.Controls.ComboBoxExtra', {
					multiSelect: Elements[i].PropertyValue.UseCheckBoxStyle,
					store: store,
					fieldLabel: Elements[i].Caption,
					labelStyle: Elements[i].Sys ? 'font-weight: bold' : '',
					labelWidth: this.labelWidth,
					displayField: Elements[i].PropertyValue.DisplayMember,
					valueField: Elements[i].PropertyValue.ValueMember,
					typeAhead: !Elements[i].PropertyValue.UseCheckBoxStyle,
					queryMode: 'local',
					forceSelection: true,
					triggerAction: 'all',
					emptyText: 'Выберите...',
					//selectOnFocus: true
				});
				
				combo.setValue(displayValue);
				if (paramReadOnly) combo.setReadOnly(true);
				this.dyn_component[Elements[i].Suffix] = combo;
				group.items.add(combo);
				break;

			case 15: // "DatePeriod"
				var ui = Ext.create('widget.PeriodEdit', {
					labelWidth: this.labelWidth,
					fieldLabel: Elements[i].Caption,
					labelStyle: Elements[i].Sys ? 'font-weight: bold' : '',
					ignoreColorize: true,
				});
				if (Elements[i].Value != null) {
					ui.setValue(new Date(Elements[i].Value[0]), new Date(Elements[i].Value[1]));
				}

				if (paramReadOnly) ui.setReadOnly(true);

				this.dyn_component[Elements[i].Suffix] = ui;
				group.items.add(ui);
				break;

			default:
				Log.sendLog("Новый контрол! " + Elements[i].ControlType);
				alert(Elements[i].ControlType);
				break;
			}

			if (Elements[i].Sys) {
				this.sysDicts.push(Elements[i].Suffix);
			}
			group.items.items[group.items.items.length - 1].nastrCode = Elements[i].NastrCode;
		}
		
		me.hideSysDicts();
        me.hideByParentData();
		
		Ext.resumeLayouts(true);
		return;
	},

	hideSysDicts: function() {
		let me = this,
			sysDicts = me.sysDicts;
		
		// скрытие элементов
		for (var key in sysDicts) {
			me.dyn_component[sysDicts[key]].setHidden(!me.isBaseVariant || !window.user.isAdmin);
		}
		me.hideEmptyGroups();
	},
	hideEmptyGroups: function() {
		let me = this,
			groups = me.gksc('paramsPanel').items.items,
			feedPanel = me.gksc('feedPanel'),
			titles = [],
			title = 'all',
			selected = me.gksc('feedPanel').view.selModel.getSelected();
		
		if (selected.length) {
			title = selected.items[0].get('url');
		}

		// скрытие пустых групп
		for(let j = 0; j < groups.length; j++)
		{
			let items = groups[j].items.items,
				hidden = true;

			for (var i in items) {
				hidden &= items[i].isHidden();
			}

			if (title === 'all') {
				groups[j].setHidden(hidden);
			} else {
				groups[j].setHidden(groups[j].title !== title);
			}
			if (hidden) {
				titles.push(groups[j].title);
			}
		}

		// скрытие записей Группировки
		feedPanel.view.store.clearFilter();
		if (titles.length) {
			feedPanel.view.store.filterBy(rec => {
				return titles.indexOf(rec.get('title')) === -1;
			});
		}
	},
	
	/* Сохранить вариант */
	SaveVariant: function(variant, callBack) {
		var me = this;

		if (!this.CheckValidParametrs()) return;

		me.fireEvent('indicate', false);
		ajaxRequest({
			url: 'Report/SaveVariant_A',
			params: {
				tskid: me.taskId,
				code: me.id,
				link_var: me.link_var,
				variant: variant ?? me.gksc('SVARPARAM').value[0].data.LINK,
				parametrs: JSON.stringify(me.GetParametrs()),
				callback: me.code
			},
			success: function() {
				me.oldData = JSON.stringify(me.GetParametrs());
				me.tempData = JSON.stringify(me.GetParametrs());
				QuickMsgs.save();
			},
			failure: function(response) { Ext.MessageBox.alert("Error", response.responseText); },
			callback: function() {
				if (callBack) {
					callBack();
				} else {
					me.fireEvent('indicate', true);
				}
			}
		});
	},
    hideByParentData: function() {
	    let me = this,
            parentData = me.parentData,
			objs = me.dyn_component,
			otbor = null,
			groups = me.gksc('paramsPanel').items.items,
			feedPanel = me.gksc('feedPanel'),
			titles = [];
	    
	    if (!parentData) return;
	    
		for (let key in objs) {
			let obj = objs[key];
			if (obj.hasOwnProperty('Code') && obj.Code == parentData.code) {
				otbor = obj;
				break;
			}

			// скрытие дат
			if ((parentData.code === "DOCUMENT_REVIZ" || parentData.code === "DOCUMENT_IFC_RECORD")
				&& obj.id.startsWith('PeriodEdit')) {
				obj.setValue(new Date('01/01/1900'), new Date('12/31/2100'));
				obj.setHidden(true);
			}

			// контролы, в которые необходиимо проставить значение и скрыть
			if (parentData.paramsOtbor && (obj.hasOwnProperty('boxLabel') || obj.hasOwnProperty('fieldLabel'))) {
				for (let name in parentData.paramsOtbor) {
					if (name === obj.boxLabel || name === obj.fieldLabel) {
						obj.setValue(parentData.paramsOtbor[name].value);
						obj.setHidden(!parentData.paramsOtbor[name].visible);
					}
				}
			}
		}
		
		// скрытие отбора по коду
		if (otbor && parentData.data && parentData.data.LINK > 0) {
			otbor.setValue(parentData.data);
			otbor.setHidden(true);
		}

		me.hideEmptyGroups();
    },

	// #region Тулбар

	getTextNastr: function() {
		let me = this,
			pars = me.GetParametrs();

		const loadMask = new Ext.LoadMask({
			msg: "Выгрузка структуры настроек и отборов отчета...",
			target: me.objs.view,
			autoShow: true,
			rid: ajaxRequest({
				url: 'Report/GetTextNastr_A',
				params: {
					sysCode: me.sysCode,
					code: me.code,
					link_var: me.link_var,
					title: me.title,
					mode: me.mode,
					parentLink: me.parentLink || me.parentData?.link || 0,
					parametrs: JSON.stringify(pars),
					paramsOtbor: me.parentData ? JSON.stringify(me.parentData.paramsOtbor) : '',
					paramsNastr: me.parentData ? JSON.stringify(me.parentData.paramsNastr) : ''
				},
				success: function(res) {
					if (res.errorMsg) {
						window.failureShow({
							statusText: res.ErrorMsg,
							messageText: 'Ошибка при выгрузке структуры настроек и отборов отчета'
						}, "Внимание");
					} else {
						Ext.MessageBox.show({
							title: 'Структура настроек и отборов отчета',
							msg: res.res.replaceAll('\r\n', '<br />'),
							buttons: Ext.MessageBox.OK
						});
					}
				},
				callback: function() {
					loadMask.destroy();
				}
			})
		});
	},

	fileEdit: function() {
		let me = this;

		me.sksc('fileView', Ext.create('Keysystems.File', {
			iconCls: getExtStyle(me.fileExt),
			checkRewriteFile: true,
			createFile: function(callback) { me.createFile(me.descriptionFile, callback); },
			updRecord: function(fileObj, isMain) { me.updFileRecord(fileObj, isMain); },
			downloadFile: function() { me.downloadFile(); },
			fileExists: function(exist, noExist) { me.fileExists(exist,noExist); },
			clearFile: function() { me.clearFile(); }
		}));
	},

	createFile: async function(link, callback) {
		UploaderLib.newFile(this.code, link, 0, this.description, this.link_var, this.getLoadMaskTarget(), callback);
	},

	updFileRecord: function(fileObj, isMain) {
		let me = this;

		if (fileObj.descrLink) {
			// файл создан и сохранен ранее. Здесь сохранение уже не требуется
			me.description = fileObj.descrLink;
			me.descriptionFile = fileObj.fileLink;
			me.fileName = fileObj.name;
			me.fileExt = fileObj.ext;

			return;
		}

		// сохраним загруженный файл
		const loadMask = new Ext.LoadMask({
			msg: "Сохранение выбранного описания отчета...",
			target: me.objs.view,
			autoShow: true,
			rid: ajaxRequest({
				url: 'Report/ReportSaveFile_A',
				params: {
					code: me.code,
					link_var: me.link_var,
					fileKey: fileObj.id,
					fileName: fileObj.name,
					descrLink: me.description,
					fileLink: me.descriptionFile
				},
				success: function(res) {
					if (res.errorMsg) {
						window.failureShow({
							statusText: res.ErrorMsg,
							messageText: 'Ошибка при сохранении выбранного описания отчета'
						}, "Внимание");
					} else {
						me.description = res.descrLink;
						me.descriptionFile = res.fileLink;
						me.fileName = fileObj.name;
						me.fileExt = fileObj.ext;
					}
				},
				callback: function() {
					loadMask.destroy();
				}
			})
		});
	},

	downloadFile: function() {
		UploaderLib.getFile(this.descriptionFile, this.fileName);
	},

	clearFile: function() {
		let me = this;

		const loadMask = new Ext.LoadMask({
			msg: "Удаление описания отчета...",
			target: me.objs.view,
			autoShow: true,
			rid: ajaxRequest({
				url: 'Report/ReportClearFile_A',
				params: {
					code: me.code,
					link_var: me.link_var,
					descrLink: me.description,
					fileLink: me.descriptionFile
				},
				success: function(res) {
					if (res.errorMsg) {
						window.failureShow({
							statusText: res.ErrorMsg,
							messageText: 'Ошибка при удалении описания отчета'
						}, "Внимание");
					} else {
						me.description = 0;
						me.descriptionFile = 0;
						me.fileName = '';
						me.fileExt = '';
					}
				},
				callback: function() {
					loadMask.destroy();
				}
			})
		});
	},

	fileExists: function (exists, notExists) {
		(this.description? exists : notExists)();
	},

	// #endregion Тулбар
});