﻿Ext.define('RevizorRelationsView', {
	extend: 'Keysystems.Base.List',
	dictCode: '',
	links: [],
	viewMode: 'tabShow',
	functions: {},

	constructor: function (cfg) {
		var me = this;
		me.objs = {};
		me.initConfig(cfg);
		me.dictCode = cfg.code;
		me.code = '';
		me.createItems();
		me.createView();
		me.objs.view.on('afterrender',() => {
			me.getData();
		});
		me.show();
	},
	createItems: function () {
		var me = this,
			objs = me.objs;

		objs.items = [
			me.Grid = objs.Grid = Ext.create('Keysystems.Controls.GroupingGrid', {
				flex: 1,
				autoRender: true,
				border: 0,
				columnLines: true,
				columns: [],
				contextMenuHidden: true
			})
		];
	},
	getData: function (reload) {
		let me = this;
		if (!(me.dictCode && me.links && me.links.length)) return;

		me.showLoadMask({
			msg: reload ? KS.L10n.updating_data : KS.L10n.loading_data,
			opaque: !reload,
			rid: ajaxRequest({
				params: { code: me.dictCode, links: me.links, limitLinks: me.limitLinks ? JSON.stringify(me.limitLinks) : ''},
				url: 'data/GetRelations_A',
				success: function (value) {
					if (!reload) {
						me.buildToolbar(value);
					}
					me.setData(value);
				},
				callback: me.hideLoadMask.bind(me)
			}),
			cancelFn: function () {
				if (!reload) me.objs.view.close();
			}
		});
	},
	setData: function (value, endFunc) {
		let me = this,
			data = [];

		Ext.each(value.relations, function (relation) {
			//фиктивная запись для корректного выделения группы
			let recGroup = {};
			Object.assign(recGroup, relation);
			delete recGroup.data;
			recGroup.LINK = 0;
			recGroup.group = relation.NAME;
			data.push(recGroup);

			//все записи из связи 
			Ext.each(relation.data, function (d) {
				d.group = relation.NAME;
				data.push(d);
			});
		});
		value.data = data;
		value.fields.push({name: 'group', type: 'string'});
		
		//отступ первой колонки
		const firstCol = value.columns.filter(col => col.dataIndex === "OBJNAME")[0];
		if (firstCol) firstCol.tdCls = 'ks-group-indent';
		
		me.Grid.setMetaDate(value, {
			profileCode: me.code,
			profileKey: 'gridRelation',
			gateCode: me.keyEdit
		});

		me.setSBText(data.length, 1, data.length);		
		me.afterSetData();
		if (endFunc) endFunc();
	},

	//#region Тулбар

	/**
	 * Task Revizor.Show.InList
	 */
	async showInList() {
		let me = this,
			sel = me.Grid.getFrstSelect();
		if (!sel) return _;

		let code = sel.get('OBJCODE'),
			links = [sel.get('LINK_DOC')];

		//response.whereArgs - аргументы условий для открытия списка
		//response.extData - данные по InLinks (для заполнения параметра фильтрации Записи)

		const response = await ajaxRequestAsync({
			params: {code: code, links: links},
			url: 'data/GetWhereArgsByLinks_A'
		});

		dictFunc({
			code: sel.get('OBJCODE'),
			tabMode: true,
			parentView: me.parentView,
			initWhereArgs: function () {
				//после получения аргументов условий с сервера, заполним параметр фильтрации Записи
				let whereArgs = response.whereArgs;
				if (response.extData) {
					let parLink = this.filter?.filter(p => p.Name === code)[0];
					if (parLink) {
						parLink.Value = response.extData;
						parLink.Condition = 0;
						delete whereArgs.InLinks;
						delete whereArgs.InLinksOnly;
					}
				}
				return whereArgs;
			}
		})
	},

	/**
	 * Task Revizor.Edit
	 */
	editWithoutList: function () {
		let me = this,
			sel = me.Grid.getFrstSelect();
		if (!sel) return _;

		let cfg = {
			f: 'edit',
			data: {data: {LINK: sel.data.LINK_DOC}},
			code: sel.data.OBJCODE,
			parentView: me.objs.view,
			group: sel.data.group
		};
		Ext.apply(cfg, dictListController[sel.data.OBJCODE]);
		Ext.create(cfg.editClass, cfg);
	},
	expandAll: function () {
		let me = this,
			feature = me.Grid.view.features[0];
		feature.expandAll();
	},
	collapseAll: function () {
		let me = this,
			feature = me.Grid.view.features[0];
		feature.collapseAll();
	},
	refresh: function () {
		let me = this;
		me.getData(true);
	}

	//#endregion Тулбар
});