﻿Ext.define('Keysystems.RiskInfo.List', {
	extend: 'Keysystems.Base.List.Tree',
	bodyPadding: 10,
	startYear: (new Date()).getFullYear(),
	riskColors: {},
	lastSelectedOrg: null,
	profileListeners: [
		{name: 'DT', method: 'ksCheckBoxChange'},
		{name: 'showCalcs', method: 'ksCheckBoxChange'},
		{name: 'footerPanel', method: 'resizeH_expandCollapse'},
		{name: 'infoTabs', method: 'tabchange'},
	],
	functions: {
		'edit': (cfg) => {
			cfg.code = 'DICTIONARY_SORG';
			cfg.linkCode = dictListController.DICTIONARY_SORG.linkCode;
			cfg.title = dictListController.DICTIONARY_SORG.title;
			cfg.iconCls = 'x_btn_dict';
			Ext.create('Keysystems.SOrg.Edit', cfg);
		}
	},
	loadProfile: function (v) {
		if (v) {
			let me = this,
				profileValues = JSON.parse(v);
			if (profileValues.rangVariant) {
				if (me.gksd('rangVariant') !== profileValues.rangVariant) {
					me.sksd('rangVariant', profileValues.rangVariant);
					me.gksc('showCalcs').setVisible(profileValues.rangVariant);
					console.log('Загрузка из профиля, вариант = ' + profileValues.rangVariant);
				}
			}
		}
		return this.callParent(arguments);
	},

	baseGetData: function (endFunc, params) {
		let me = this;
		me.callParent([
			function (data) {
				let tabsToRemove = [];
				me.objs.infoTabs.items.items.forEach(tab => {
					let accessKey = "access" + tab.itemId;
					if ((data[accessKey] & 1) === 0)
						tabsToRemove.push(tab.itemId);
					else if ((data[accessKey] & 4) === 0)
						tab.readOnly = true;
				});

				tabsToRemove.forEach(itemId => {
					let tab = me.objs.infoTabs.items.items.filter(tab => tab.itemId === itemId)[0];
					if (tab) tab.destroy();
				})

				if (endFunc) endFunc(data);
			}, params
		]);
	},
	
	setWhereArgs: function () {
		let me = this,
			year = me.gksc('DT').getValue(),

			whereArgs = {
				DH1: {value: new Date(year, 0, 1), type: 'Date'},
				DH2: {value: new Date(year, 11, 31), type: 'Date'},
				showCalcs: {value: me.gksc('showCalcs').getValue(), type: 'bool'},
				RangVariant: {value: me.gksd('rangVariant'), type: 'int'}
			};

		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},

	createItems: function () {
		let me = this,
			objs = me.objs,
			items = me.callParent(arguments);

		me.isLoading = true;
		items.unshift(Ext.create('Ext.panel.Panel',
			{
				region: 'north',
				overflowX: 'auto',
				collapsible: true,
				header: false,
				layout: 'anchor',
				bodyPadding: me.bodyPadding,
				width: '100%',
				border: 0,
				userCls: 'rks-panel-border-bottom',
				items: [
					Ext.create('Ext.form.FieldContainer',
						{
							layout: 'hbox',
							anchor: '100%',
							items: [
								me.sksc('DT', Ext.create('Ext.form.field.Number', {
									labelWidth: 60,
									fieldLabel: 'Год',
									minValue: 1900,
									maxValue: 2100,
									width: 150,
									allowDecimals: false,
									allowExponential: false,
									maxLength: 7,
									listeners: {
										change: function () {
											if (me.isLoading) return;
											me.refreshData();
										}
									}
								})),
								me.sksc('showCalcs', Ext.create('Ext.form.field.Checkbox',
									{
										boxLabel: 'в разрезе показателей',
										padding: '0 0 0 10',
										hidden: !me.gksd('rangVariant'),
										handler: function () {
											if (me.isLoading) return;
											me.refreshData(true);
										}
									})
								)
							]
						})
				]
			}));

		items.push({xtype: 'splitter'});
		items.push(objs.footerPanel = Ext.create('Ext.panel.Panel', {
			collapsible: true,
			collapseDirection: 'bottom',
			collapsed: true,
			header: false,
			hideCollapseTool: true,
			bodyPadding: 0,
			border: 0,
			height: 200,
			layout: {type: 'vbox', align: 'stretch'},
			items: [
				me.createTabs()
			],
			listeners: {
				expand: function () {
					if (!objs.infoTabs.activeTab) return;
					me.refreshInfoTab();
				}
			}
		}));

		me.gksc('DT').setValue(me.startYear);
		return items;
	},

	createTabs: function () {
		let me = this,
			objs = me.objs,
			cfg = {
				layout: {type: 'vbox', align: 'stretch'},
				bodyPadding: 0,
				border: 0,
				bodyBorder: 0,
				scrollable: true,
				flex: 1,
				padding: 0,

				items: []
			};


		return objs.infoTabs = Ext.create('Ext.tab.Panel', {
			border: 0,
			bodyBorder: 0,
			userCls: 'rks-panel-edit',
			bodyCls: 'rks-panel-edit-body',
			padding: 0,
			flex: 1,
			items: [
				objs.tabREVIZ = Ext.create('Ext.panel.Panel', {
					itemId: 'REVIZ',
					title: 'Мероприятия',
					layout: {type: 'vbox', align: 'stretch'},
					border: 0,
					cfg
				}),
				objs.tabFACTNAR = Ext.create('Ext.panel.Panel', {
					itemId: 'FACTNAR',
					title: 'Нарушения',
					layout: {type: 'vbox', align: 'stretch'},
					border: 0,
					cfg
				}),

				objs.tabFINANC = Ext.create('Ext.panel.Panel', {
					itemId: 'FINANC',
					title: 'Финансирование',
					layout: {type: 'vbox', align: 'stretch'},
					border: 0,
					cfg
				}),
				objs.tabAppeals = Ext.create('Ext.panel.Panel', {
					itemId: 'APPEALS',
					title: 'Обращения',
					layout: {type: 'vbox', align: 'stretch'},
					border: 0,
					cfg
				}),
				objs.tabOrders = Ext.create('Ext.panel.Panel', {
					itemId: 'ORDERS',
					title: 'Поручения',
					layout: {type: 'vbox', align: 'stretch'},
					border: 0,
					cfg
				}),

				objs.tabOrgActivity = Ext.create('Ext.panel.Panel', {
					itemId: 'ORG_ACTIVITY',
					title: 'Показатели деятельности',
					layout: {type: 'vbox', align: 'stretch'},
					border: 0,
					cfg
				}),
				objs.tabOuterReviz = Ext.create('Ext.panel.Panel', {
					itemId: 'OUTER_REVIZ',
					title: 'Внешние проверки',
					layout: {type: 'vbox', align: 'stretch'},
					border: 0,
					cfg
				})

			],
			listeners: {
				tabchange: function (th, tab) {
					//при первой загрузке таб обновляем через событие раскрытия панели
					if (me.isLoading) return;
					me.refreshInfoTab(tab, true);
				}
			}
		});
	},

	refreshInfoTab: function (tab, force) {
		let me = this,
			objs = me.objs;

		if (!tab) tab = objs.infoTabs.activeTab;
		if (!tab) return;

		let gridName = tab.itemId.toLowerCase() + "List",
			grid = objs[gridName],
			firstLoad = grid == null;

		if (!grid) {
			let defCfg = {
					head: false,
					closable: false,
					tabMode: true,
					checkModel: false,
					hideBottomPanel: true,
					hideTBar: true,
					accessReadOnly: tab.readOnly,
					controlName: Ext.String.format('{0}_tab{1}', me.code, tab.itemId),
					parentView: tab,
					afterSetWhereArgs: (whereArgs) => {
						me.setLimitByOrg(tab.itemId, whereArgs);
					}
				},
				cfg;
			switch (tab.itemId) {
				case "REVIZ":
					cfg = dictListController.DOCUMENT_REVIZ;
					cfg.code = dnl.REVIZ;
					break;
				case "FACTNAR":
					cfg = dictListController.DOCUMENT_FACTNAR;
					cfg.code = dnl.FACTNAR;
					break;
				case "FINANC":
					cfg = dictListController.DOCUMENT_FINANC;
					cfg.code = dnl.FINANC;
					break;
				case "APPEALS":
					cfg = dictListController.DOCUMENT_APPEALS;
					cfg.code = dnl.APPEALS;
					break;
				case "ORDERS":
					cfg = dictListController.DOCUMENT_ORDERS;
					cfg.code = dnl.ORDERS;
					break;
				case "OUTER_REVIZ":
					cfg = dictListController.DOCUMENT_OUTER_REVIZ;
					cfg.code = dnl.OUTERREVIZ;
					break;
				case "ORG_ACTIVITY":
					cfg =
						{
							collapsible: false,
							layout: 'fit',
							height: '100%',
							border: 0,
							code: dnl.OBJECTACTIVITY,
							profileKey: Ext.String.format('{0}_tab{1}_activityGrid', me.code, tab.itemId),
							store: Ext.create('Ext.data.Store',
								{
									fields: [],
									data: [],
									proxy: 'memory'
								}),
							columns: [],
							columnLines: true,
							listeners: {
								itemdblclick: function (_, record) {
									Keysystems.OrgActivity.List.prototype.editActivity('edit', record);
								}
							}
						};
					cfg.handler = 'Ext.grid.Panel';
					cfg.plugins = ['gridclipboard'];
					break;
			}

			if (cfg) {
				Ext.apply(cfg, defCfg);
				grid = Ext.create(cfg.handler, cfg);
				if (grid) objs[gridName] = grid;

				if (tab.itemId === "ORG_ACTIVITY") {
					tab.add(grid);
				}
			}
		}

		if (grid) {
			let sel = me.Grid.getFrstSelect();
			objs.infoTabs.setDisabled(!sel);
			if (!sel) return;

			let org = sel.data.LINK;
			if (force || org !== me.lastSelectedOrg) {
				switch (tab.itemId) {
					case "ORG_ACTIVITY":
						me.showLoadMaskInContainer(tab);
						ajaxRequest({
							url: 'SOrgActivity/GetActivityByOrg_A',
							params: {link: org, includeColumns: firstLoad},
							success: function (res) {
								me.hideLoadMaskInContainer(tab);
								if (res.activityColumns) {
									Keysystems.OrgActivity.List.prototype.adaptOrgActivityData(grid, res);
								}
								me.objs[gridName].store.loadData(res.data);
							}
						});
						break;
					default:
						if (!grid.whereArgs) grid.whereArgs = {};
						me.setLimitByOrg(tab.itemId, grid.whereArgs);
						grid.getData();
						break;
				}
				me.lastSelectedOrg = org;
			}
		}
	},

	setLimitByOrg: function (key, whereArgs) {
		let me = this,
			sel = me.Grid.getFrstSelect();
		if (!sel) return;
		let org = sel.data.LINK;

		switch (key) {
			case "REVIZ":
				whereArgs.Objects = {
					value: JSON.stringify([{link: org, objType: 1}]),
					type: 'Reviz_Objects'
				};
				break;
			case "FACTNAR":
			case "APPEALS":
			case "ORDERS":
				whereArgs.OrgLinks = {
					value: JSON.stringify([org]),
					type: 'List_int'
				};
				break;
			case "FINANC":
				whereArgs.ObjLinks = {
					value: JSON.stringify([org]),
					type: 'List_int'
				};
				break;
			case "OUTER_REVIZ":
				whereArgs.SOrgc = {
					value: JSON.stringify([org]),
					type: 'List_int'
				};
				break;
		}
	},

	showLoadMaskInContainer: function (container) {
		container.setLoading(KS.L10n.loading_data);
	},
	hideLoadMaskInContainer: function (container) {
			container.setLoading(false);
	},

	createGridListeners: function () {
		let me = this,
			objs = me.objs;

		me.functions.select = function (dv, sels) {
			let rec = Array.isArray(sels) ? sels[0] : sels;
			if (!rec) return;

			if (!objs || !objs.footerPanel || objs.footerPanel.collapsed.toString() !== 'false' || !objs.infoTabs || !objs.infoTabs.activeTab) {
				return;
			}

			me.refreshInfoTab();
		};
		return me.callParent(arguments);
	},

	beforeSetData: function (data, p) {
		let me = this;
		me.callParent(arguments);
		me.riskColors = data.riskColors;
		if (window.riskColors !== me.riskColors) {
			window.riskColors = me.riskColors;
			let cssBlock = $('#risk-rows-styles');
			let text = cssBlock.text();
			for (let name in me.riskColors) {
				let color = me.riskColors[name].color;
				let what = new RegExp(`\\/\\*${name}\\*\\/.*\\/\\*${name}\\*\\/`, "gm");
				let replacement = `/*${name}*/${color}/*${name}*/`;
				text = text.replace(what, replacement);
			}
			cssBlock.text(text);
		}
		me.Grid.store.sort('RISK_BALL_TOTAL', 'DESC');

	},

	getRowClass: function (rec) {
		let me = this,
			ball = rec.get('RISK_BALL_TOTAL');
		if (!me.riskColors || ball == null) return;

		let cls = ball >= me.riskColors["RiskMinColor"].begin && ball <= me.riskColors["RiskMinColor"].end
			? "risk-min"
			: ball >= me.riskColors["RiskMidColor"].begin && ball <= me.riskColors["RiskMidColor"].end
				? "risk-mid"
				: ball >= me.riskColors["RiskMaxColor"].begin && ball <= me.riskColors["RiskMaxColor"].end
					? "risk-max"
					: "";
		return cls;
	},

	refreshData: function (rebuild) {
		let me = this;
		me.setWhereArgs();

		if (rebuild) {
			PageDataLib.clearByParams({
				linkCode: 'SRiskInfo',
				GateCode: 'DOCUMENT_RISKINFO'
			});
			me.getData(true, true);
		} else
			me.refresh();

	},

	columnsAdapted: function (columns) {
		let me = this;
		let groupColumns = columns.filter(col => col.text.indexOf('Риски по критерию') >= 0);
		if (!me.gksc('showCalcs').getValue()) {
			groupColumns.forEach(col => {
				let idx = columns.indexOf(col);
				columns.splice(idx, 1);
			});
		}
		return me.callParent([columns]);
	},

	recalc: function (refreshOnNo) {
		let me = this,
			variant = me.gksd('rangVariant');
		if (!variant) {
			me.refreshData(true);
			return;
		}

		selectDialogShow(wmc.get('RangsTitle'),
			wmc.get('ReCalcRangs', this.title),
			function () {
				let params = {variant: variant}
				me.showLoadMask({
					msg: wmc.getMask('RangCalcReCalcing'),
					rid: ajaxRequest({
						url: 'SRiskInfo/ReCalc_A',
						params: params,
						success: function () {
							me.hideLoadMask();
							me.refreshData(true);
						},
						failure: function (response) {
							me.hideLoadMask();
							console.error("Error", response.responseText);
						}
					})
				});
			},
			() => {
				if (refreshOnNo) me.refreshData(true);
			});
	},

	/** Task Revizor.List.Rang */
	showRangForm: function () {
		let me = this,
			funcShowRangForm = function () {
				me.rangForm = Ext.create('Revizor.RangView',
					{
						title: 'Ранжирование',
						closeAction: 'hide',
						variant: me.gksd('rangVariant'),
						rangCalcs: me.gksd('calcs'),
						ok: function (variant) {
							console.log('Сохранение в профиль, вариант = ' + variant);
							me.profileManager.set('rangVariant', variant);
							me.sksd('rangVariant', variant);
							me.gksc('showCalcs').setVisible(variant);

							let profile = JSON.stringify(me.profileManager.getProfile());
							ajaxRequest({
								url: 'SRiskInfo/SaveListProfile_A',
								params: {profile: profile},
								success: function () {
									me.recalc(true);
								}
							});

						}
					});
				me.rangForm.show();
			}

		if (!window.systemCalcs) {
			ajaxRequest({
				url: 'SRiskInfo/GetSystemCalcs_A',
				success: function (res) {
					if (res.length) window.systemCalcs = res;
					funcShowRangForm();
				}
			});
		} else {
			funcShowRangForm();
		}
	}

});