﻿Ext.define('Keysystems.OrgActivity.List', {
	extend: 'Keysystems.Base.List.Tree',
	isItemDblClick: false,
	createItems: function () {
		var me = this,
			objs = me.objs,
			items = me.callParent(arguments);

		items.push(
			{xtype: 'splitter'},
			objs.activityGrid = Ext.create('Ext.grid.Panel',
				{
					collapsible: false,
					flex: 2,
					objs: me.objs,
					border: 0,
					allowDeselect: false,
					tbar: [
						me.createBtn = Ext.create('Ext.Button',
							{
								tooltip: 'Создать',
								tooltipType: 'title',
								iconCls: 'x_btn_new',
								handler: function () {
									let sel = me.Grid.getSelectionModel().getSelection();
									if (!sel.length) return;
									me.editActivity('new', null, {S_ORG: sel[0].get('LINK')});
								}
							}),
						me.editBtn = Ext.create('Ext.Button',
							{
								tooltip: 'Редактировать',
								tooltipType: 'title',
								iconCls: 'x_btn_edit',
								handler: function () {
									let selActivity = objs.activityGrid.getSelectionModel().getSelection()[0];
									if (!selActivity) return;

									me.editActivity('edit', selActivity);
								}
							}),
						me.delBtn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_delete',
								tooltip: 'Удалить',
								tooltipType: 'title',
								handler: function () {
									var sel = objs.activityGrid.getSelectionModel().getSelection();
									if (!sel.length) return;

									selectDialogShow(wmc.getQuestion('Delete'), wmc.get('DeleteMessage', 1), function () {
										//me.docDel(sel[0]);
										let links = sel.map(r => r.data.LINK);

										const loadMask = new Ext.LoadMask({
											msg: wmc.getMask('Deleting'),
											view: objs.activityGrid,
											autoShow: true,
											rid: ajaxRequest({
												params: {
													code: "DOCUMENT_ORG_ACTIVITY",
													links: links,
													recursive: false
												},
												url: 'data/DelSDictionary_A',
												success: function (value) {
													loadMask.destroy();
													var notDel = value.notDel;
													if (notDel && notDel.length)
														relationsMsg(me.code, notDel, value.notDelLinks, me.tabMode, me.parentView);

													let sel = me.Grid.getSelectionModel().getSelection();
													if (sel.length) me.refreshActivityGrid(sel[0]);
												},
												failure: function () {
													loadMask.destroy();
												}
											}),
											cancelFn: function () {
												me.stopDel = true;
											}
										});
									});
								}
							}),
						// me.importBtn = Ext.create('Ext.Button',
						// 	{
						// 		iconCls: 'x_btn_import',
						// 		disabled: true,
						// 		tooltip: 'Загрузить',
						// 		tooltipType: 'title',
						// 		handler: function() {
						//
						// 		}
						// 	})
					],
					store: Ext.create('Ext.data.Store',
						{
							fields: [],
							data: [],
							proxy: 'memory'
						}),
					columns: [],
					columnLines: true,
					listeners: {
						itemdblclick: function (th1, record) {
							me.editActivity('edit', record);
						}
					},
					plugins: ['gridclipboard']
				})
		);

		me.functions.edit = function (cfg) {
			cfg.code = 'DICTIONARY_SORG';
			cfg.linkCode = 'SOrg';
			Ext.create('Keysystems.SOrg.Edit', cfg);
		}
	},

	refresh: function (reload, hideMsg) {
		let me = this;
		me.linkCode = 'SOrg';
		me.callParent(arguments);
	},
	baseGetData: function (endFunc, params) {
		let me = this,
			objs = me.objs;

		me.callParent([
			function (data) {
				me.adaptOrgActivityData(objs.activityGrid, data);
				if (data.readOnly) me.enableActivityTools();
				if (endFunc) endFunc(data);
			}, params
		]);
	},

	adaptOrgActivityData: function (grid, data) {
		let me = this;
		grid.store.setFields(data.activityFields);
		let cols = data.activityColumns,
			colValue = ArrayLib.filter(cols, ['dataIndex'], 'VAL'),
			colMethod = ArrayLib.filter(cols, ['dataIndex'], 'METHOD'),
			colType = ArrayLib.filter(cols, ['dataIndex'], 'TYPE');
		if (colValue && colValue.length) {
			colValue[0].defaultRenderer = function (v, m, rec) {
				let me = this,
					type = miscTypes.SActivityIndexType[rec.get('TYPE')];
				if (m) m.align = 'center';
				if (type === 'Флаг') {
					return Ext.grid.column.Check.prototype.defaultRenderer(v?.toString().toLowerCase() === 'true' || v === true, m);
				}
				return v;
			}
		}
		if (colMethod && colMethod.length) {
			colMethod[0].renderer = (val) => val === 0 ? 'Ручной' : (val === 1 ? 'Прием' : '');
		}
		if (colType && colType.length) {
			colType[0].renderer = (val) => miscTypes.SActivityIndexType[val];
		}
		grid.reconfigure(grid.store, cols);
		Ext.create('Keysystems.Controls.Grid.ColumnManager',
			{
				inputColumns: cols,
				code: me.сode ?? grid.code,
				profileKey: me.code ? me.code + 'activityGrid' : grid.profileKey,
				grid: grid,
				gateCode: me.GateCode,

			});
	},

	afterRefresh: function () {
		var me = this;
		let sel = me.Grid.getSelectionModel().getSelection();
		if (sel && sel.length) me.refreshActivityGrid(sel[0]);
	},

	createGridListeners: function () {
		var me = this;

		me.functions.select = function (dv, sels) {
			me.enableActivityTools();
			var rec = Array.isArray(sels) ? sels[0] : sels;
			if (Array.isArray(sels) && !sels.length) return;

			me.refreshActivityGrid(rec)
		};
		return me.callParent(arguments);
	},

	refreshActivityGrid: function (rec) {
		let me = this;
		ajaxRequest({
			url: 'SOrgActivity/GetActivityByOrg_A',
			params: {
				link: rec.data.LINK,
				includeColumns: false
			},
			success: function (res) {
				me.objs.activityGrid.store.loadData(res.data);
			}
		});
	},

	editActivity: function (f, rec, defCfg) {

		let me = this,
			objs = me.objs,
			selOrg = me.Grid ? me.Grid.getFrstSelect() : rec.data.S_ORG;
		if (!selOrg) return;

		let cfg = {
			code: dnl.OBJECTACTIVITY,
			data: rec,
			f: f,
			iconCls: f === 'new' ? 'x_btn_new' : 'x_btn_edit',
			linkCode: 'SOrgActivity',
			title: me.Grid ? selOrg.get('NAME') : window.dictListController.DOCUMENT_OBJECTACTIVITY.title,
			readOnly: me.accessReadOnly,
			addRecord: function (row) {
				let grid = objs.activityGrid,
					rec = grid.store.createModel(row);
				grid.loadData([rec], true);
				return rec;
			},
			setRecord: function (row, cmp) {
				cmp.data.set(row);
			},
		};
		if (defCfg) {
			Ext.apply(cfg, defCfg);
		}

		Ext.create('Keysystems.OrgActivity.Edit', cfg);
	},

	enableActivityTools: function () {
		let me = this;
		if (me.accessReadOnly) {
			me.createBtn.setDisabled(true);
			me.editBtn.setDisabled(true);
			me.delBtn.setDisabled(true);
			return;
		}
		if (!me.Grid.getFrstSelect()) {
			me.editBtn.setDisabled(false);
			me.delBtn.setDisabled(false);
		}
	}
});