Ext.define('Keysystems.OrgActivity.Edit', {
	extend: 'Keysystems.Base.Edit',
	isCodeEdit: false,
	isNameEdit: false,
	isDHEdit: false,
	sOrg: null,
	disabledLinks: null,
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
		if (cfg.S_ORG) this.sOrg = cfg.S_ORG;
		this.code = 'DOCUMENT_ORG_ACTIVITY';
	},
	createItems: function () {
		var me = this,
			objs = me.objs;
		return [
			objs.S_ACTIVITY_INDEX = me.createDictEdit({
				key: 'S_ACTIVITY_INDEX',
				mode: 'SINGL',
				code: dnl.S_ACTIVITY_INDEX,
				fieldLabel: 'Показатель',
				ksAllowEmpty: true,
				whereArgs: {'ObjType': { value: 2, type: 'int' }},
				checkRenderer: function(val, meta, rec) {
					if (me.disabledLinks && me.disabledLinks.indexOf(rec.data.LINK) >= 0) {
						meta.tdCls += ' ' + this.disabledCls;
					}
					dictListController.DICTIONARY_SACTIVITY_INDEX.checkRenderer.call(me, val, meta, rec);
				},
				ksSetValue: function (v) {
					this.setValue(v);
					let typeText = v.length ? miscTypes.SActivityIndexType[v[0].data.TYPE] : '';
					objs.TYPE.setValue(typeText);
					if (typeText === "Список"){
						me.refreshListCombo(v[0].data.LIST);
					}
					me.showHideValueControl();
				}
			}),
			Ext.create('Ext.form.FieldContainer', {
				layout: 'hbox',
				width: me.width,
				items: [
					objs.TYPE = Ext.create('Ext.form.field.Text', {
						fieldLabel: 'Тип',
						readOnly: true,
						labelWidth: me.labelWidth,
						width: 120 + me.labelWidth,
						padding: '0 5 0 0'
					}),
					objs.NUM_VAL = Ext.create('Keysystems.Controls.CalcField', {
						labelWidth: me.labelWidth,
						fieldLabel: 'Значение',
						padding: '0 0 0 10',
						flex: 1,
						hidden: true
					}),
					objs.BOOL_VAL = Ext.create('Ext.form.field.Checkbox', {
						fieldLabel: 'Значение',
						padding: '0 0 0 10',
						labelWidth: me.labelWidth,
						hidden: true
					}),
					objs.LIST_VAL = Ext.create('Ext.form.field.ComboBox', {						
						flex: 1,
						hidden: true,
						store: objs.listStore = Ext.create('Ext.data.Store', {
							fields: CBDataLib.getFields(),
							data: [],
							proxy: 'memory'
						}),
						displayField: 'value',
						valueField: 'index',
						value: 0,
						editable: false,
					})
				]
			}),
			objs.COMMENT = Ext.create('Ext.form.field.TextArea', {
				fieldLabel: 'Примечание',
				labelWidth: me.labelWidth,
			})
		]
	},

	dataCollector: function () {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);
		data.S_ORG = me.sOrg;
		data.S_ACTIVITY_INDEX = objs.S_ACTIVITY_INDEX.getLink();

		let typeText = objs.TYPE.getValue();
		var ctrl = ['Количество', 'Сумма', 'Процент', '%'].indexOf(typeText) !== -1
			? objs.NUM_VAL
			: (typeText === 'Флаг'
				? objs.BOOL_VAL
				: (typeText === 'Список' ? objs.LIST_VAL : null));

		data.VAL = ctrl 
			? ctrl instanceof Keysystems.Controls.CalcField ?  ctrl.getNumValue() : ctrl.getValue() 
			: null;
		
		data.COMMENT = objs.COMMENT.getValue();
		return data;
	},

	isFilled: function () {
		const me = this;

		let res = true;
		if (me.objs.S_ACTIVITY_INDEX.isEmpty()) {
			me.addToInvalidControls(me.objs.S_ACTIVITY_INDEX);
			res = false;
		}
		return res;
	},

	getExtra: function (callBack, link) {
		var me = this,
			objs = me.objs;
		me.baseGetExtra({link: link, sOrg: me.S_ORG}, function (value) {
			if (value.row.S_ORG) me.sOrg = value.row.S_ORG;
			me.disabledLinks = value.ACTIVITY_INDEX_LINKS; 

			objs.S_ACTIVITY_INDEX.setValue(value.S_ACTIVITY_INDEX);
			if (link) {
				objs.TYPE.setValue(value.TYPE_TEXT);
			}
			objs.COMMENT.setValue(value.row.COMMENT);

			let typeText = value.TYPE_TEXT;
			if (typeText === "Список") me.refreshListCombo(value.TYPE_LIST);
			
			let ctrl = ['Количество', 'Сумма', 'Процент', '%'].indexOf(typeText) !== -1
				? objs.NUM_VAL
				: (typeText === 'Флаг'
					? objs.BOOL_VAL
					: (typeText === 'Список' ? objs.LIST_VAL : null));
			if (ctrl) ctrl.setValue(typeText === 'Флаг' ? value.row.VAL.toString().toLowerCase() === 'true' : value.row.VAL );
			me.showHideValueControl();

			if (callBack) callBack();
		});
	},

	showHideValueControl: function () {
		let objs = this.objs,
			typeText = objs.TYPE.getValue();
		objs.NUM_VAL.setVisible(typeText === 'Количество' || typeText === 'Сумма' || typeText === '%');
		objs.BOOL_VAL.setVisible(typeText === 'Флаг');
		objs.LIST_VAL.setVisible(typeText === 'Список');
	},
	
	refreshListCombo: function (values){
		let me = this,
			arrValues = values.split('\r\n')
			.map((r, index) => ({value: r, index: index}));
		me.objs.LIST_VAL.loadData(arrValues, false);
	}
})
	