﻿Ext.define('Keysystems.PlanProj.List', {
	extend: 'Keysystems.Base.List',
	startYear: (new Date()).getFullYear(),
	title: 'Планы',
	profileCode: 'DICTIONARY_SPLANPROJ',
	profileListeners: [
		{ name: 'DT', method: 'ksCheckBoxChange' },
		{ name: 'S_ORG', method: 'ksDictChange' }
	],

	viewCfg: function() {
		var cfg = this.callParent(arguments);
		cfg.layout = { type: 'vbox', align: 'stretch' };
		return cfg;
	},

	setWhereArgs: function() {
		var me = this,
			whereArgs = {
				Year: { value: me.gksc('DT').getValue(), type: 'int' },
				SOrgs: { value: me.gksc('S_ORG').getLinks(1), type: 'List_int' }
			};

		if (me.isVfa)
			whereArgs.SWorks = {
				value: JSON.stringify(me.SWorks || []),
				type: 'List_int'
			};

		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},

	createItems: function() {
		var me = this,
			items = me.callParent(arguments);

		me.isCreate = true;

		items.unshift(Ext.create('Ext.panel.Panel', {
			collapsible: true,
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			border: 0,
			bodyBorder: 0,
			userCls: 'rks-filter-panel',
			header: {
				title: 'Фильтр по Планам',
			},
			animCollapse: false,
			items: [
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						me.sksc('DT', Ext.create('Ext.form.field.Number', {
							labelWidth: 60,
							fieldLabel: 'План на',
							minValue: 1900,
							maxValue: 2100,
							width: 150,
							allowDecimals: false,
							allowExponential: false,
							maxLength: 7,	
							readOnly: me.readOnly,
							listeners: {
								change: function() {
									me.setWhereArgs();
									me.refresh();
								}
							}
						})),
						me.createDictEdit({
							labelWidth: 100,
							padding: '0 0 0 20',
							flex: 1,
							key: 'S_ORG',
							mode: 'SINGL',
							cleaningKey: false,
							code: dnl.S_ORG,
							fieldLabel: 'Проверяющая',
							codeWidth: 125,
							readOnly: me.readOnly,
							initWhereArgs: function() {
								return {
									SType: { value: JSON.stringify([KsLib.getKeyByValue(miscTypes.TypeOrg, 'Проверяющая') * 1]), type: 'List_int' },
									LinkMaster: { value: user.org.data.LINK, type: 'int' }
								};
							},
							ksSetValue: function(v) {
								//if (!v.length) return _;
								this.setValue(v);
								me.setWhereArgs();
								me.refresh();
							}
						})
					]
				})
			]
		}));

		me.gksc('DT').setValue(me.startYear);
		me.gksc('S_ORG').setValue(user.org);

		me.isCreate = false;
		return items;
	},

	getGridCfg: function() {
		var res = this.callParent(arguments);
		res.flex = 1;
		res.userCls = 'rks-grid-with-filter-panel';
		return res;
	}
});