﻿Ext.define('Keysystems.PlanProj.Edit', {
	extend: 'Keysystems.Base.Edit',	
	layout: { type: 'vbox', align: 'stretch' },
	title: 'Проекты плана',
	linkCode: 'SPlanproj',
	isWindow: true,
	flex: 1,
	autoRender: true,
	bodyPadding: 0,
	viewMinSize: [850, 600],
	_arrGeneralRow: ['NUMBER', 'CODE', 'NAME', 'DT', 'DT_AGREED'],
	_arrGeneralSingl: ['S_PERSON', 'S_ORG', 'S_PERSON_AGREED'],
	profileListeners: [
		{ name: 'view', method: 'FormParam' },
		{ name: 'planContainer', method: 'resizeH' }
	],
	planContainerVsbl: true,
	taskGridVsbl: true,
	isFromToolBar: false,
	hidePrintBtn: false,
	userCls: 'rks-panel-edit',
	viewCfg: function () {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		return result;
	},
	initComponent: function() {
		//todo оно надо? уже наследуемся от Keysystems.Base.Edit
		var me = this;
		me.beforeInitComponent();
		me.baseInitComponent();
		me.callParent(arguments);
		me.afterInitComponent();
	},

	createPlanPanel: function(status) {
		var me = this,
			titleName = '',
			controlName = '';

		switch (status) {
		case 'isOffer':
			titleName = 'Предложение';
			controlName = 'offerGrid'
			break;
		case 'isProject':
			titleName = 'Проект';
			controlName = 'projectGrid'
			break;
		case 'isApprove':
			titleName = 'Утверждено';
			controlName = 'approveGrid'
			break;
		case 'isDecline':
			titleName = 'Отклонено';
			controlName = 'declineGrid'
			break;
		}

		var statusName = status.replace('is', 'status');

		return me.sksc(controlName, Ext.create('Keysystems.Plan.List.Simple', {
			//startYear: (new Date()).getFullYear(),
			GateCode: me.isVfa ? dnl.PLANREVIZ_VFA : dnl.PLANREVIZ,
			linkCode: 'SPlanSimple',
			isVfa: me.isVfa,
			head: false,
			title: titleName,
			iconCls: '',
			tabMode: true,
			closable: false,
			hidePagging: true,
			parentView: me.gksc('planContainer'),
			ignoreAlreadyOpen: true,
			viewCfg: function() {
				var cfg = this.callParent(arguments);
				cfg.title = titleName;
				cfg.minHeight = 100;
				return cfg;
			},
			btnsHide: {
				same: true,
				print: true,
				search: true,
				reset: true,
				settings: true,
				profile: true,
				show_actual: true,
				relations: true,
				journal: true,
				autofilter: true,
				wrap: true,
				status: true,
				plan_info: true,
				batch_change: true,
				sendEsgfk: true,
				showEsgfkEventLog: true
			},
			getWhereArgs: function() {
				var whereArgs = this.whereArgs || {};

				//whereArgs.DTOrder = {
				//	value: me.gksc('DT').getValue().toDateString(),
				//	type: 'Date'
				//};
				whereArgs.Statuses = {
					value: JSON.stringify([me.gksd(statusName)]),
					type: 'List_int'
				};
				whereArgs.DT1 = {
					value: me.gksd('DH1').toDateString(),
					type: 'Date'
				};
				whereArgs.DT2 = {
					value: me.gksd('DH2').toDateString(),
					type: 'Date'
				};
				whereArgs.OrgsR = {
					value: me.gksc('S_ORG').getLinks(1),
					type: 'List_int'
				};

				if (this.isVfa)
					whereArgs.SWorks = {
						value: JSON.stringify(me.SWorks || []),
						type: 'List_int'
					};

				return whereArgs;
			},
			createTBar: function() {
				var th = this,
					nextStatuses = me.gksd('nextStatuses'),
					status = me.gksd(statusName),
					controlName = '';

				th.objs.tbar = th.callParent(arguments);
				th.objs.tbar = th.objs.tbar.filter(b => { return b.code !== 'status'; })
				if (this.f) return th.objs.tbar;
				
				Ext.each(nextStatuses[status], function(nextStatus) {
					
					var btnName = nextStatus;
						btnIcon = 'x_btn_';

					var status = Object.keys(miscTypes.PlanProjStatus).find(key => miscTypes.PlanProjStatus[key] === nextStatus);
					switch (parseInt(status)) {
					case 0:
						btnIcon += 'status_blue';
						controlName = 'projectGrid';
						break;
					case 3:
					case 6:
						btnIcon += 'status_green';
						controlName = 'approveGrid';
						break;
					case 4:
					case 5:
						btnIcon += 'status_gray';
						controlName = 'declineGrid';
						break;
					default:
					}

					th.objs.tbar.push(
						Ext.create('Ext.Button', {
							iconCls: btnIcon,
							tooltip: btnName,
							nextStatus: status,
							tooltipType: 'title',
							text: btnName,
							controlName: controlName,
							handler: function() {
								let th1 = this;
								if (!th.checkList.length) return info('Выберите запланированные мероприятия!');

								me.changePlanStatus(ArrayLib.getLinks(th.checkList), this.nextStatus, function(v) {
									if (v.result) {
										th.nextGrid = th1.controlName;
										th.refresh();
									} else if (v.msg) {
										warning(v.msg);
									}
								});
							}
						})
					);
				});
				return th.objs.tbar;
			},
			afterRefresh: function() {
				let th = this;
				th.callParent(arguments);
				if (th.nextGrid) {
					me.gksc(th.nextGrid).refresh();
					th.nextGrid = _;
				}
			}
		}));
	},

	changePlanStatus: function(planLinks, newStatus, endFunc) {
		if (!planLinks) return;

		var me = this;
		me.showLoadMask({
			msg: KS.L10n.updating_data,
			rid: ajaxRequest({
				url: 'SDocPlan/ChangePlanStatus_A',
				params: {
					planLinks: planLinks,
					newStatus: newStatus
				},
				success: function(value) {
					if (value) endFunc && endFunc(value);
				},
				callback: function() { me.hideLoadMask(); }
			})
		});
	},

	createItems: function() {
		var me = this,
			items = [
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					padding: '10 10 0 10',
					items: [
							me.sksc('NUMBER', Ext.create('Ext.form.field.Text', {
								fieldLabel: '№',
								padding: '0 20 0 0',
								labelWidth: me.labelWidth,
								enforceMaxLength: true,
								maxLength: 25,
								width: 285,
								cls: 'ks-readOnly',
								readOnly: true
							})),
							me.sksc('CODE', Ext.create('Ext.form.field.Number', {
								labelWidth: 100,
								fieldLabel: 'Наименование',
								minValue: 1900,
								maxValue: 2100,
								width: 205,
								allowDecimals: false,
								allowExponential: false,
								maxLength: 7,
								cls: me.f !== 'new' ? 'ks-readOnly' : '',
								readOnly: me.f !== 'new',
								listeners: {
									change: function(th, newValue) {
										me.gksc('NAME').setValue('План на ' + newValue + ' год');
									}
								}
							})),
							me.sksc('NAME', Ext.create('Ext.form.field.Text', {
								labelWidth: 0,
								padding: '0 0 0 5',
								enforceMaxLength: true,
								maxLength: 30,
								flex: 1
							}))
						]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					padding: '0 10 0 10',
					items: [
						me.sksc('DT_AGREED', Ext.create('Ext.form.field.Date', {
							fieldLabel: 'Дата согласования',
							labelWidth: me.labelWidth,
							width: 285,
							padding: '0 20 0 0',
							listeners: {
								blur: function() {
									if (me.gksc('DT').getValue() < this.getValue()) {
										warning('Дата согласования не может быть больше даты утверждения');
									}
								}
							}
						})),
						me.createDictEdit({
							key: 'S_PERSON_AGREED',
							mode: 'SINGL',
							codeWidth: 100,
							initWhereArgs: function() {
								var sOrg = me.gksc('S_ORG').getValue(),
									linkSelf = sOrg[0] && sOrg[0].LINK_SELF,
									wa = {};

								if (linkSelf) {
									wa.SDolg = { value: JSON.stringify(me.gksd('personsDolgs')), type: 'List_int' };
									wa.SOrgs = { value: JSON.stringify([linkSelf]), type: 'List_int' };
								}
								return wa;
							},
							code: dnl.S_PERSON,
							labelWidth: me.labelWidth,
							flex: 1,
							fieldLabel: 'Согласовано'
						})
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					padding: '0 10 0 10',
					items: [
						me.sksc('DT', Ext.create('Ext.form.field.Date', {
							fieldLabel: 'Дата утверждения',
							labelWidth: me.labelWidth,							
							width: 285,
								padding: '0 20 0 0',
							listeners: {
								blur: function () {
									if (this.getValue() > new Date()) {
										warning('Дата утверждения больше текущей даты!');
									}
								}
							}
						})),
						me.createDictEdit({
							key: 'S_PERSON',
							labelWidth: me.labelWidth,
							codeWidth: 100,
							mode: 'SINGL',
							initWhereArgs: function() {
								return {
									SDolg: {
										value: JSON.stringify(me.gksd('personsDolgs') || []),
										type: 'List_int'
									},
									SOrgs: {
										value: JSON.stringify([me.gksc('S_ORG').getLink()]),
										type: 'List_int'
									},
									STypeOrgs: {
										value: JSON.stringify([1]),
										type: 'List_int'
									}
								};
							},
							code: dnl.S_PERSON,
							flex: 1,
							fieldLabel: 'Утверждено'
						})
					]
				}),
				me.createDictEdit({
					key: 'S_ORG',
					mode: 'SINGL',
					codeWidth: 130,
						cls: me.f !== 'new' ? 'ks-readOnly' : '',
						readOnly: me.f !== 'new',
					code: dnl.S_ORG,
					fieldLabel: 'Организация',
					padding: '0 10 10 10',
					initWhereArgs: function() {
						return {
							LinkMaster: { value: user.org.data.LINK, type: 'int' }
						};
					}
				})
			];
		if (me.planContainerVsbl) {
			items.push(me.sksc('planContainer',
				Ext.create('Ext.tab.Panel',
					{
						border: 0,
						flex: 1,
						userCls: 'rks-panel-edit',
						bodyCls: 'rks-panel-edit-body',
						items: []
					})));
		}
		if (me.taskGridVsbl) {
			items.push(me.sksc('taskGrid',
				Ext.create('Keysystems.Controls.TaskGrid',
					{
						flex: 1,
						split : true,
						resizable: true,
						collapsible: true,
						hideCollapseTool: window.Theme === 'crisp',
						header: false,
						hideJournalBtn: true,
						owner: me,
						edit: function(cfg, data) {
							
							data.data.sPlanProj = me.getLink();
							data.readOnly = me.readOnly;

							cfg.addRecord = function(row) {
								row.children = [];
								row.leaf = true;
								data.set('leaf', false);
		 						return data.appendChild(row);
		 						
							}
							cfg.saveData = function (endFunc, params) {
								this.callParent([
									function (result) {	
										if (result.SavedStampMUC) {
											me.sksd('STAMP', result.SavedStampMUC);
											const oldData =  JSON.parse(me.oldData);
											oldData.STAMP = result.SavedStampMUC;
											me.oldData = JSON.stringify(oldData);
											me.updateStamp(me.getLink(), result.SavedStampMUC);
										}
										if (endFunc) endFunc(result);
									}, params
								]);
							}
							if (cfg.f === 'new' && !me.getLink()){
								const caller = this;
								me.saveMessageShow("Для продолжения необходимо сохранить проект плана.", ()=>{
									data.data.sPlanProj = me.getLink();
									//после сохранения данные в таскгриде обновляются и нужно заново найти запись
									const rec = caller.store.findNode('LINK', data.data.LINK);
									caller.edit(cfg, rec)
								})
							}
							else {
								this.callParent(arguments);
							}
						},
						
						getRowClass: function(record) {
							return record.parentNode.isRoot()
								? 'ks-reglament'
								: Keysystems.Documents.List.prototype.getRowClass(record);
						},
						rowDelete: function(nodes) {
							var th = this;

							me.showLoadMask({
								msg: `${KS.L10n.delete}...`,
								rid: ajaxRequest({
									url: 'SDocuments/Delete_A',
									params: { code: 'DOCUMENTS', links: ArrayLib.getLinks(nodes), recursive: true, reviz: 0 },
									success: function (val) {
										me.hideLoadMask();
										let value = val.delInfo,
											notDel = value.notDel;
										if (notDel && notDel.length) {
											relationsMsg(me.code, notDel, value.notDelLinks, me.tabMode, me);
										}

										Ext.each(nodes, function (el) { 
											value.notDelLinks.indexOf(el.data.LINK) === -1 && el.remove(); 
										});
										
										th.view.refresh();
									},
									failure: function() { me.hideLoadMask(); }
								})
							});
						}
					})));
		}		
		return items;		
	},

	//#region Загрузка данных 
	getExtra: function(callBack, link) {
		var me = this;
		me.baseGetExtra({
			link: link,
			whereArgs: JSON.stringify(me.whereArgs),
			isFromToolBar: me.isFromToolBar
		}, function(value) {
			me.setExtra(value, link, callBack);
		});
	},

	setExtra: function(value, link, endFunc) {
		var me = this;

		me.sksd('personsDolgs', value.personsDolgs);
		me.sksd('DH1', new Date(value.DH1));
		me.sksd('DH2', new Date(value.DH2));
		me.sksd('sWork', -1);
		me.access = value.row._Access;
		me.setObjsValues(value.row, me._arrGeneralRow);
		me.setObjsValues(value, ['S_PERSON', 'S_PERSON_AGREED', 'S_ORG']);
		me.setFullObjsAccess(me.access, ["NUMBER", "CODE", "NAME", "DT_AGREED", "S_PERSON_AGREED", "DT", "S_PERSON", "S_ORG"]);

		if (!(me.access.NUMBER & 1)) me.gksc('CODE').labelWidth = me.labelWidth;
		if (me.access.DT_AGREED & 1) me.gksc('S_PERSON_AGREED').labelWidth = 100;
		if (me.access.DT & 1) me.gksc('S_PERSON').labelWidth = 100;

		me.gksc('S_ORG').setValue(value.S_ORG.LINK ? value.S_ORG : user.org);
		if (me.gksc('taskGrid')) me.gksc('taskGrid').loadData(value.tasks);
		me.sksd('nextStatuses', value.nextStatuses);
		if (me.gksc('planContainer')) me.gksc('planContainer').setVisible(link > 0);

		me.MODIFICATION = value.row.MODIFICATION;

		if (link > 0) {
			if (me.gksc('planContainer')) {
				if (value.isOffer && !me.gksd('statusOffer')) {
					me.sksd('statusOffer', value.statusOffer);
					me.createPlanPanel('isOffer');
				}
				if (value.isProject && !me.gksd('statusProject')) {
					me.sksd('statusProject', value.statusProject);
					me.createPlanPanel('isProject');
				}
				if (value.isApprove && !me.gksd('statusApprove')) {
					me.sksd('statusApprove', value.statusApprove);
					me.createPlanPanel('isApprove');
				}
				if (value.isDecline && !me.gksd('statusDecline')) {
					me.sksd('statusDecline', value.statusDecline);
					me.createPlanPanel('isDecline');
				}
			}
		} else {
			var year = me.gksc('DT').getValue().getFullYear();
			if (me.gksc('CODE').getValue() !== year) {
				me.gksc('CODE').setValue(year);
				me.gksc('NAME').setValue('План на ' + year + ' год');
			}
		}
		
		let print = me.gksc('printBtn');
		if (value.isPrint) {
			let itms = [],
				mode = KsLib.getKeyByValue(miscTypes.ReportPrintMode, 'SplanProj');
			
			for (let key in value.reports) {
				itms.push({
					link: key,
					code: value.reports[key].objectCode,
					text: value.reports[key].name,
					sysCode: value.reports[key].code,
					noNeedForm: value.reports[key].noNeedForm,
					mode: mode
				});
			}

			print.setMenu(Ext.create('Ext.menu.Menu', {
				items: itms,
				listeners: {
					click: function(menu, item) {
						print.defReport = item.link;
						me.openReport(item);
					}
				}
			}));
		} else {
			print.setVisible(false);
		}

		if (endFunc) endFunc();
	},

	//#endregion Загрузка данны

	//#region Сохранение данных
	dataCollector: function() {
		var me = this,
			ksControls = me.ksControls,
			res = me.callParent(arguments);

		//res.link = objs.link;
		Ext.each(me._arrGeneralRow, function(key) {
			var c = ksControls[key];
			res[key] = (key === 'DT' || key === 'DT_AGREED'
				? c.getValue()?.toDateString()
				: c.getValue())
				|| '';

		});

		Ext.each(me._arrGeneralSingl, function(key) {
			var c = ksControls[key];
			res[key] = c.getLink();
		});

		res.MODIFICATION = me.MODIFICATION;

		return res;
	},

	saveData: function(endFunc, inputParams) {
		var me = this;
		me.baseSaveData(inputParams || me.dataCollector(), function(result) {
			if (result.extra) {
				me.setExtra(result.extra, result.SavedLink, endFunc);
			}
		});
	},

	isFilled: function() {
		const me = this;		
		if (me.gksc('DT_AGREED').isVisible()) {
			if (!me.gksc('DT_AGREED').isEmpty() && me.gksc('DT').getValue() < me.gksc('DT_AGREED').getValue()) {
				me.errorMessages.push('Дата согласования не может быть больше даты утверждения');
			}
		}

		return true;
	},

	
	//#endregion Сохранение данных
});