﻿Ext.define('Keysystems.Plan.List', {
	constructor: function(args) {
		var tab = window.tabView.items.getByKey(args.code);

		if (tab != null) { // add new form
			window.tabView.setActiveTab(args.code);
		} else {

			var planListView = Ext.create('Revizor.PlanListView', {
				title: args.title,
				code: args.code,
				itemId: args.code
			});
			window.tabView.add(planListView).show();
		}
	}
});


Ext.define('Revizor.PlanListView', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.PlanListView',
	requires: ['Ext.toolbar.Toolbar', 'Ext.button.Button'],
	title: 'Планирование',
	iconCls: 'x_btn_plan',
	layout: 'border',
	closable: true,
	dy: 10,
	dx: 10,
	objs: {},
	defaults: {
		split: true
	},
	initComponent: function() {

		objs.resColumn = {
			0: {
				displayName: 'Численность служащих, чел',
				editor: new Ext.form.field.Text({ readOnly: true }),
				renderer: function(v) {
					return Ext.String.format('<span style="color: gray;">{0}</span>', v);
				}
			},
			1: {
				displayName: 'Численность участвующих в контрольных мероприятиях, чел',
				editor: new Ext.form.field.Text({ readOnly: true }),
				renderer: function(v) {
					return Ext.String.format('<span style="color: gray;">{0}</span>', v);
				}
			},
			2: {
				displayName: 'Из них в валютных, чел',
				editor: new Ext.form.field.Text({ readOnly: true }),
				renderer: function(v) {
					return Ext.String.format('<span style="color: gray;">{0}</span>', v);
				}
			},
			3: {
				displayName: 'Количество рабочих дней',
				editor: new Ext.form.field.Text({ readOnly: true }),
				renderer: function(v) {
					return Ext.String.format('<span style="color: gray;">{0}</span>', v);
				}
			},
			4: {
				displayName: 'Основной оплачиваемый отпуск для 1 чел, раб. дн/год'
			},
			5: {
				displayName: 'Дополнительный оплачиваемый отпуск для 1 чел, раб. дн/год'
			},
			6: {
				displayName: 'Резерв нетрудоспособности для 1 чел, раб. дн/год'
			},
			7: {
				displayName: 'Общий фонд рабочего времени, чел. дн',
				editor: new Ext.form.field.Text({ readOnly: true }),
				renderer: function(v) {
					return Ext.String.format('<span style="color: gray;">{0}</span>', v);
				}
			},
			8: {
				displayName: 'Фонд рабочего времени для конт-ных мероприятий, чел. дн',
				editor: new Ext.form.field.Text({ readOnly: true }),
				renderer: function(v) {
					return Ext.String.format('<span style="color: gray;">{0}</span>', v);
				}
			},
			9: {
				displayName: 'Запланировано, чел. дн',
				editor: new Ext.form.field.Text({ readOnly: true }),
				renderer: function(v) {
					return Ext.String.format('<span style="color: gray;">{0}</span>', v);
				}
			}
		};


		Ext.apply(this, {
			tbar: this.createToolBar(),
			items: this.Items()
		});

		this.callParent(arguments);


		objs.GetData = function() {
			ajaxRequest({
				loadMask: true,
				url: 'data/GetPlanList_A',
				success: function(data) {
					var fields = data.sOrg.fields;
					var f1 = true;
					Ext.each(fields, function(field) {
						if (field.name == 'id') {
							f1 = false;
							return false;
						}
// ReSharper disable NotAllPathsReturnValue
					});
// ReSharper restore NotAllPathsReturnValue
					if (f1) {
						fields.push({
							name: 'id',
							type: 'string'
						});
					}
					objs.orgTreeGrid.store.setFields(fields);

					var columns = data.sOrg.columns;
					f1 = true;
					Ext.each(columns, function(column) {
						if (column.dataIndex == 'tree') {
							if (column.xtype != 'treecolumn')
								column.xtype = 'treecolumn';
							f1 = false;
							return false;
						}
// ReSharper disable NotAllPathsReturnValue
					});
// ReSharper restore NotAllPathsReturnValue
					if (f1) {
						columns.unshift({
							dataIndex: 'tree',
							locked: true,
							width: 75,
							iconCls: 'x-tree-noicon',
							xtype: 'treecolumn'
						});
					}
					objs.orgTreeGrid.reconfigure(objs.orgTreeGrid.store, columns);

					objs.SetSOrgData(data.sOrg.data);
				}
			});
		};

		objs.SetSOrgData = function(data) {
			objs.orgTreeGrid.store.setRootNode({
				expanded: true,
				children: data
			});
		};

		objs.GetData();

		objs.gantchart.toggle(true);
		objs.resGrid.columns[0].text = 'Ресурсы';
		objs.resGrid.columns[1].text = 'Значение';
		objs.resGrid.setSource({
			0: 0,
			1: 0,
			2: 0,
			3: 0,
			4: 0,
			5: 0,
			6: 0,
			7: 0,
			8: 0,
			9: 0
		}, objs.resColumn);
	},

	// private
	onDestroy: function() {
	},

	createToolBar: function() {
		this.ToolBar = new Ext.Toolbar({
			tbar: [
				new Ext.Button({
					iconCls: 'x_btn_new',
					handler: function() {
					}
				}),
				new Ext.Button({
					disabled: true,
					iconCls: 'x_btn_edit',
					handler: function() {
					}
				}),
				new Ext.Button({
					disabled: true,
					iconCls: 'x_btn_delete'
				}),
				new Ext.Button({
					//disabled: true,
					iconCls: 'x_btn_print',
					handler: function() {
					}
				}),
				new Ext.Button({
					//disabled: true,
					iconCls: 'x_btn_search',
					menu: [
						{ text: 'Фильтр' },
						{
							text: 'Найти',
							handler: function() {
								window.frame.show();
							}
						}
					]
				}),
				new Ext.Button({
					iconCls: 'x_btn_undo',
					handler: function() {
					}
				}),
				new Ext.Button({
					iconCls: 'x_btn_settings'
				}),
				new Ext.Button({
					disabled: true,
					iconCls: 'x_btn_refresh'
				}),
				{ xtype: 'tbseparator' },
				objs.gantchart = new Ext.Button({
					iconCls: 'x_btn_gantchart',
					toggleGroup: 'group1',
					handler: function() {
						objs.p32.setVisible(false);
						objs.p31.setVisible(true);
					}
				}),
				new Ext.Button({
					iconCls: 'x_btn_plan',
					toggleGroup: 'group1',
					handler: function() {
						objs.p31.setVisible(false);
						objs.p32.setVisible(true);
					}
				}),
				{ xtype: 'tbseparator' },
				new Ext.Button({
					iconCls: 'x_btn_ZoomIn',
					handler: function() {
					}
				}),
				new Ext.Button({
					iconCls: 'x_btn_ZoomOut',
					handler: function() {
					}
				}),
				new Ext.Button({
					iconCls: 'x_btn_ZoomToFit',
					handler: function() {
					}
				}),
				{ xtype: 'tbseparator' },
				new Ext.Button({
					iconCls: 'x_btn_planauto',
					handler: function() {
					}
				}),
				new Ext.Button({
					iconCls: 'x_btn_planautoview',
					handler: function() {
					}
				}),
				new Ext.Button({
					iconCls: 'x_btn_planautoclean',
					handler: function() {
					}
				}),
				new Ext.Button({
					iconCls: 'x_btn_report_query',
					handler: function() {
					}
				}),
				new Ext.Button({
					iconCls: 'x_btn_journal',
					menu: [
						{ text: 'По записи' },
						{ text: 'Все' }
					]
				}),
				new Ext.Button({
					iconCls: 'x_btn_exit',
					handler: function() {
						window.planListView.close();
					}
				})
			]
		});
		return this.ToolBar;
	},
	Items: function() {

		var states = new Ext.data.Store({
			fields: ['abbr', 'name'],
			data: [
				{ abbr: 'q1', name: '1 квартал' },
				{ abbr: 'q2', name: '2 квартал' },
				{ abbr: 'q3', name: '3 квартал' },
				{ abbr: 'q4', name: '4 квартал' },
				{ abbr: 'hy1', name: '1 полугодие' },
				{ abbr: 'hy2', name: '2 полугодие' },
				{ abbr: 'm9', name: '9 месяцев' },
				{ abbr: 'ally', name: 'Весь год' }
			]
		});
		this.Items = [
			objs.p1 = new Ext.panel.Panel({
				region: 'north',
				autoScroll: true,
				collapsible: true,
				collapsed: true,
				layout: 'absolute',
				width: '100%',
				height: 2 * this.dy + 80,
				minHeight: 2 * this.dy + 80,
				maxHeight: 2 * this.dy + 80,
				items: [
					new Ext.form.Label({
						x: this.dx,
						y: this.dy + 4,
						text: 'План на'
					}),
					new Ext.Button({
						x: this.dx + 100,
						y: this.dy,
						iconCls: 'x_btn_plan',
						handler: function() {
						}
					}),
					new Ext.form.field.Number({
						x: this.dx + 130,
						y: this.dy,
						width: 100,
						value: new Date().getFullYear(),
						maxValue: 2100,
						minValue: 1900
					}),
					new Ext.form.ComboBox({
						x: this.dx + 250,
						y: this.dy,
						width: 100,
						store: states,
						editable: false,
						queryMode: 'local',
						displayField: 'name',
						valueField: 'abbr',
						value: 'ally'
					}),
					new Ext.form.Label({
						x: this.dx + 370,
						y: this.dy + 4,
						text: 'Раздел плана'
					}),
					objs.S_PLAN_CODE = new Ext.form.field.Text({
						x: this.dx + 450,
						y: this.dy,
						readOnly: true,
						width: 100
					}),
					new Ext.Button({
						x: this.dx + 528,
						y: this.dy,
						iconCls: 'x_btn_dict',
						handler: function() {
						}
					}),
					objs.S_PLAN_NAME = new Ext.form.field.Text({
						x: this.dx + 555,
						y: this.dy,
						readOnly: true,
						width: 250
					}),
					new Ext.form.Label({
						x: this.dx + 820,
						y: this.dy + 4,
						text: 'Подразделения'
					}),
					new Ext.form.field.Text({
						x: this.dx + 910,
						y: this.dy,
						readOnly: true,
						width: 100
					}),
					new Ext.Button({
						x: this.dx + 988,
						y: this.dy,
						iconCls: 'x_btn_dict',
						handler: function() {
						}
					}),
					new Ext.form.field.Text({
						x: this.dx + 1015,
						y: this.dy,
						readOnly: true,
						width: 250
					}),
					new Ext.form.Label({
						x: this.dx,
						y: this.dy + 34,
						text: 'Периодичность'
					}),
					new Ext.form.ComboBox({
						x: this.dx + 130,
						y: this.dy + 30,
						store: ['лет', 'мес', 'дн'],
						width: 45,
						editable: false,
						queryMode: 'local'
					}),
					new Ext.form.field.Number({
						x: this.dx + 190,
						y: this.dy + 30,
						width: 50,
						minValue: 0
					}),
					new Ext.form.field.Checkbox({
						x: this.dx + 250,
						y: this.dy + 30,
						boxLabel: 'с финансированием'
					}),
					new Ext.form.field.Checkbox({
						x: this.dx + 400,
						y: this.dy + 30,
						boxLabel: 'скрыть моложе'
					}),
					new Ext.form.Label({
						x: this.dx + 520,
						y: this.dy + 34,
						text: 'Проверяющая'
					}),
					new Ext.form.field.Text({
						x: this.dx + 610,
						y: this.dy + 30,
						readOnly: true,
						width: 100
					}),
					new Ext.Button({
						x: this.dx + 688,
						y: this.dy + 30,
						iconCls: 'x_btn_dict',
						handler: function() {
						}
					}),
					new Ext.form.field.Text({
						x: this.dx + 715,
						y: this.dy + 30,
						readOnly: true,
						width: 250
					})
				]
			}),
			objs.orgTreeGrid = new Ext.tree.Panel({
				//height: 300,
				//width: '50%',
				region: 'center',
				autoScroll: true,
				//rootVisible: false,
				multiSelect: true,
				border: 0,
				selModel: new Ext.selection.CheckboxModel({
					allowDeselect: true,
					mode: 'MULTI'
				}),
				store: new Ext.data.TreeStore({
					fields: [],
					data: [],
					proxy: 'memory',
					defaultRootText: ''
				}),
				columns: [],
				columnLines: true
			}),
			objs.p2 = new Ext.tab.Panel({
				region: 'east',
				autoScroll: true,
				border: 0,
				width: '50%',
				items: [
					new Ext.panel.Panel({
						autoScroll: true,
						title: 'Общие',
						layout: 'absolute',
						border: 0,
						items: [
							new Ext.form.Label({
								x: this.dx,
								y: this.dy + 4,
								text: 'Проверяемый период'
							}),
							new Ext.form.field.Number({
								x: this.dx + 130,
								y: this.dy,
								width: 100,
								value: new Date().getFullYear(),
								maxValue: 2100,
								minValue: 1900
							}),
							new Ext.form.Label({
								x: this.dx + 239,
								y: this.dy + 4,
								text: '-'
							}),
							new Ext.form.field.Number({
								x: this.dx + 250,
								y: this.dy,
								width: 100,
								value: new Date().getFullYear(),
								maxValue: 2100,
								minValue: 1900
							}),
							new Ext.grid.Panel({
								y: this.dy + 30,
								columnLines: true,
								store: new Ext.data.ArrayStore({
									fields: ['name', 'summ', 'pr1', 'kol', 'pr2'],
									data: [
										['Профинансировано', '', '', '', ''],
										['Запланировано', '', '', '', ''],
										['Проверено', '', '', '', ''],
										['плановых', '', '', '', ''],
										['внеплановых', '', '', '', ''],
										['Не проверено', '', '', '', ''],
										['Выбрано', '', '', '', '']
									]
								}),
								columns: [
									{
										text: 'Показатель',
										dataIndex: 'name',
										draggable: false,
										width: '20%'
									}, {
										text: 'Сумма',
										dataIndex: 'summ',
										draggable: false,
										width: '20%'
									}, {
										text: '%',
										dataIndex: 'pr1',
										draggable: false,
										width: '20%'
									}, {
										text: 'Кол-во объектов',
										dataIndex: 'kol',
										draggable: false,
										width: '20%'
									}, {
										text: '%',
										dataIndex: 'pr2',
										draggable: false,
										width: '20%'
									}
								],
								plugins: ['gridclipboard']
							})
						]
					}),
					new Ext.panel.Panel({
						autoScroll: true,
						title: 'Ресурсы',
						border: 0,
						items: [
							objs.resGrid = new Ext.grid.property.Grid({
								nameColumnWidth: '50%'
							})
						]
					}),
					new Ext.tab.Panel({
						autoScroll: true,
						title: 'Объект',
						border: 0,
						items: [
							new Ext.panel.Panel({
								autoScroll: true,
								title: 'Мероприятия',
								border: 0,
								items: [
									new Ext.grid.Panel({
										//width: '100%',
										columnLines: true,
										plugins: [
											new Ext.grid.plugin.CellEditing({
												clicksToEdit: 1
											}),
											'gridclipboard'
										],
										columns: [
											{
												text: 'Код',
												dataIndex: 'cod',
												width: '25%'
											}, {
												text: 'Наименование',
												dataIndex: 'name',
												width: '25%',
												buffer: 500
											}, {
												text: 'Период действия',
												width: '50%',
												columns: [
													{
														header: 'с',
														dataIndex: 'begin',
														xtype: "datecolumn",
														format: "d.m.Y",
														editor: {
															xtype: 'datefield',
															format: 'd.m.Y'
														}
														//    width: '50%'
													}, {
														text: 'по',
														dataIndex: 'end'
														//width: '50%'
													}
												]
											}
										]
									})
								]
							}),
							new Ext.panel.Panel({
								autoScroll: true,
								title: 'Финансирование',
								layout: 'absolute',
								border: 0,
								items: [
									new Ext.form.Label({
										x: this.dx,
										y: this.dy + 4,
										text: 'Проверяемый период'
									}),
									new Ext.form.field.Number({
										x: this.dx + 130,
										y: this.dy,
										width: 50,
										value: new Date().getFullYear(),
										maxValue: 2100,
										minValue: 1900
									}),
									new Ext.form.ComboBox({
										x: this.dx + 200,
										y: this.dy,
										width: 100,
										editable: false,
										value: 'Весь год'
									}),
									new Ext.grid.Panel({
										y: this.dy + 30,
										columnLines: true,
										plugins: [
											new Ext.grid.plugin.CellEditing({
												clicksToEdit: 1
											}),
											'gridclipboard'
										],
										columns: [
											{
												text: 'Код',
												dataIndex: 'cod',
												width: '25%'
											}, {
												text: 'Наименование',
												dataIndex: 'name',
												width: '25%'
											}, {
												text: 'Период действия',
												width: '50%',
												columns: [
													{
														header: 'с',
														dataIndex: 'begin',
														xtype: "datecolumn",
														format: "d.m.Y",
														editor: {
															xtype: 'datefield',
															format: 'd.m.Y'
														}
														//    width: '50%'
													}, {
														text: 'по',
														dataIndex: 'end'
														//width: '50%'
													}
												]
											}
										]
									})
								]
							})
						]
					})
				]
			}),
			objs.p3 = new Ext.panel.Panel({
				region: 'south',
				autoScroll: true,
				border: 0,
				width: '100%',
				height: 115,
				listeners: {
					resize: function(th1, width, height, oldWidth, oldHeight) {
						if (oldWidth && oldHeight) {
							objs.p31.setHeight(height);
							objs.p31.setWidth(width);
							objs.p32.setHeight(height);
							objs.p32.setWidth(width);
						}
					}
				},
				items: [
					objs.p31 = new Ext.panel.Panel({
						autoScroll: true,
						layout: 'border',
						border: 0,
						height: 115,
						width: '100%',
						defaults: {
							split: true
						},
						items: [
							objs.p311 = new Ext.panel.Panel({
								region: 'center',
								autoScroll: true,
								layout: 'absolute',
								border: 0,
								width: '50%',
								height: 115,
								items: [
									new Ext.grid.Panel({
										//width: '100%',
										columnLines: true,
										plugins: [
											new Ext.grid.plugin.CellEditing({
												clicksToEdit: 1
											}),
											'gridclipboard'
										],
										columns: [
											{
												text: 'Код',
												dataIndex: 'cod',
												width: '25%'
											}, {
												text: 'Наименование',
												dataIndex: 'name',
												width: '25%',
												buffer: 500
											}, {
												text: 'Период действия',
												width: '50%',
												columns: [
													{
														header: 'с',
														dataIndex: 'begin',
														xtype: "datecolumn",
														format: "d.m.Y",
														editor: {
															xtype: 'datefield',
															format: 'd.m.Y'
														}
													}, {
														text: 'по',
														dataIndex: 'end'
													}
												]
											}
										]
									})
								]
							}),
							objs.p312 = new Ext.panel.Panel({
								region: 'east',
								autoScroll: true,
								layout: 'absolute',
								border: 0,
								width: '50%',
								height: 115,
								items: [
									new Ext.grid.Panel({
										//width: '100%',
										columnLines: true,
										plugins: [
											new Ext.grid.plugin.CellEditing({
												clicksToEdit: 1
											}),
											'gridclipboard'
										],
										columns: [
											{
												text: 'Код',
												dataIndex: 'cod',
												width: '25%'
											}, {
												text: 'Наименование',
												dataIndex: 'name',
												width: '25%',
												buffer: 500
											}, {
												text: 'Период действия',
												width: '50%',
												columns: [
													{
														header: 'с',
														dataIndex: 'begin',
														xtype: "datecolumn",
														format: "d.m.Y",
														editor: {
															xtype: 'datefield',
															format: 'd.m.Y'
														}
														//    width: '50%'
													}, {
														text: 'по',
														dataIndex: 'end'
														//width: '50%'
													}
												]
											}
										]
									})
								]
							})
						]
					}),
					objs.p32 = new Ext.panel.Panel({
						autoScroll: true,
						autoRender: true,
						layout: 'border',
						border: 0,
						height: 115,
						hidden: true,
						width: '100%',
						defaults: {
							split: true
						},
						items: [
							objs.p321 = new Ext.panel.Panel({
								region: 'center',
								autoScroll: true,
								layout: 'border',
								border: 0,
								width: 500, //'100%',
								height: 50, //'50%',
								defaults: {
									split: true
								},
								items: [
									objs.p3211 = new Ext.panel.Panel({
										region: 'center',
										autoScroll: true,
										layout: 'absolute',
										border: 0,
										width: '50%',
										height: '100%',
										items: [
											new Ext.grid.Panel({
												//width: '100%',
												columnLines: true,
												plugins: [
													new Ext.grid.plugin.CellEditing({
														clicksToEdit: 1
													}),
													'gridclipboard'
												],
												columns: [
													{
														text: 'Код',
														dataIndex: 'cod',
														width: '25%'
													}, {
														text: 'Наименование',
														dataIndex: 'name',
														width: '25%',
														buffer: 500
													}, {
														text: 'Период действия',
														width: '50%',
														columns: [
															{
																header: 'с',
																dataIndex: 'begin',
																xtype: "datecolumn",
																format: "d.m.Y",
																editor: {
																	xtype: 'datefield',
																	format: 'd.m.Y'
																}
																//    width: '50%'
															}, {
																text: 'по',
																dataIndex: 'end'
																//width: '50%'
															}
														]
													}
												]
											})
										]
									}),
									objs.p3212 = new Ext.panel.Panel({
										region: 'east',
										autoScroll: true,
										layout: 'absolute',
										border: 0,
										width: '50%',
										height: '100%',
										items: [
											new Ext.grid.Panel({
												//width: '100%',
												columnLines: true,
												plugins: [
													new Ext.grid.plugin.CellEditing({
														clicksToEdit: 1
													}),
													'gridclipboard'
												],
												columns: [
													{
														text: 'Код',
														dataIndex: 'cod',
														width: '25%'
													}, {
														text: 'Наименование',
														dataIndex: 'name',
														width: '25%',
														buffer: 500
													}, {
														text: 'Период действия',
														width: '50%',
														columns: [
															{
																header: 'с',
																dataIndex: 'begin',
																xtype: "datecolumn",
																format: "d.m.Y",
																editor: {
																	xtype: 'datefield',
																	format: 'd.m.Y'
																}
																//    width: '50%'
															}, {
																text: 'по',
																dataIndex: 'end'
																//width: '50%'
															}
														]
													}
												]
											})
										]
									})
								]
							}),
							objs.p322 = new Ext.panel.Panel({
								region: 'south',
								autoScroll: true,
								layout: 'absolute',
								border: 0,
								width: '100%',
								height: '50%',
								items: []
							})
						]
					})
				]
			})
		];
		return this.Items;
	}
});