﻿Ext.define('Keysystems.Plan.List.Simple', {
	extend: 'Keysystems.Base.List',
	startYear: (new Date()).getFullYear(),
	title: 'Планирование',
	iconCls: 'x_btn_plan',
	deleteCode: 'DOCUMENT_PLANREVIZ',
	profileCode: 'DOCUMENT_PLANREVIZ',
	profileListeners: [
		{ name: 'DT', method: 'KsPeriodChange' },
		{ name: 'S_ORG', method: 'ksDictChange' },
		{ name: 'S_OTDEL', method: 'ksDictChange' },
		{ name: 'S_PLAN', method: 'ksDictChange' }
	],	
	_arrReadTBarBtns: [],
	delByChecked: true,
	canBold: false,

	/*viewCfg: function() {
		var cfg = this.callParent(arguments);
		cfg.layout = { type: 'vbox', align: 'stretch' };
		return cfg;
	},*/

	initConfig: function (cfg) {
		// когда открываем Планирование в других формах
		if (!cfg.code) {
			cfg.code = cfg.isVfa ? dnl.PLANREVIZ_VFA : dnl.PLANREVIZ;
		}
		this._arrEditTBarBtns.push('status');
		return this.callParent(arguments);
	},

	setWhereArgs: function() {
		var me = this,
			dh = me.gksc('DT').getValue(),
			whereArgs = {
				DT1: { value: dh.dh1.toDateString(), type: 'Date' },
				DT2: { value: dh.dh2.toDateString(), type: 'Date' },
				OrgsR: { value: me.gksc('S_ORG').getLinks(1), type: 'List_int' },
				RazdelPlan: { value: me.gksc('S_PLAN').getLinks(1), type: 'List_int' },
				Otdels: { value: me.gksc('S_OTDEL').getLinks(1), type: 'List_int' },
				Action: { value: 'MultiSelectHideButtons', type: 'SelectListAction' },
				Modification: { value: 'False', type: 'KSBoolean' }
			};

		if (me.SORGPNodeId) {
			whereArgs.OrgsR.value = JSON.stringify([me.SORGPNodeId]);
		}

		if (me.isVfa) {
			whereArgs.SWorks = {
				value: JSON.stringify(me.SWorks || []),
				type: 'List_int'
			};
			whereArgs.NotSWorks = {
				value: JSON.stringify([]),
				type: 'List_int'
			};
		}

		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},
	initializeFilter: function () {
		let me = this;
		if (!me.whereArgs) return;

		me.updateDateFromWhereArg(me.whereArgs.DT1.value, me.whereArgs.DT2.value, me.gksc('DT'));
	},
	createItems: function() {
		var me = this,
			objs = me.objs,
			d1 = new Date(me.startYear + '/01/01'),
			d2 = new Date(me.startYear + '/12/31'),
			setV = function(v) {
				this.setValue(v);
				me.setWhereArgs();
				me.refresh();
			},
			items = me.callParent(arguments);

		me.isCreate = true;
		items.unshift(objs.filterPanel = Ext.create('Ext.panel.Panel', {
			collapsible: true,
			title: 'Фильтр по Планированию',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			border: 0,
			bodyBorder: 0,
			userCls: 'rks-filter-panel',
			animCollapse: false,
			items: [
				Ext.create('Ext.form.FieldContainer',
					{
						layout: { type: 'hbox', align: 'stretch' },
						items: [
							me.sksc('DT',
								Ext.create('Keysystems.Controls.KsPeriod',
									{
										width: 330,
										state: 4,
										labelWidth: 100,
										fieldLabel: 'План на',
										allStates: 12,
										listeners: {
											ksChange: function() {
												if (me.isLoading) return;
												
												if (!me.isCreate) {
													me.setWhereArgs();
													// скидываем тулбар, т.к. в гриде может не быть записей
													me.changeBtnsByProj(false);
													me.refresh();
												}
											}
										}
									})),
							me.createDictEdit({
								padding: '0 0 0 20',
								key: 'S_PLAN',
								labelWidth: 60,
								minWidth: 150,
								flex: 1,
								code: dnl.S_PLAN,
								fieldLabel: 'Разделы',
								codeWidth: 125,
								ksSetValue: function(v) {
									setV.call(this, v);
								}
							}),
							me.createDictEdit({
								padding: window.isRfn ? '-6 0 7 20' :  '0 0 7 20',
								key: 'S_OTDEL',
								labelWidth: 100,
								flex: 1,
								code: dnl.S_OTDEL,
								fieldLabel: 'Подразделения',
								initWhereArgs: function () {
									return {
										SOrgs: { value: JSON.stringify(me.gksc('S_ORG').getLinks()), type: 'List_int' }
									};
								},
								codeWidth: 125,
								ksSetValue: function(v) {
									setV.call(this, v);
								},
								getSOrg: function() {
									return me.objs.S_ORG.getLink();
								}
							})
						]
					}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						me.sksc('chkRashDate', Ext.create('Ext.form.field.Checkbox', {
							boxLabel: 'с учетом изменений на расчетную дату',
							padding: '0 30 0 0',
							hidden: me.isVfa,
							handler: function (th, check) {
								me.whereArgs.ByRashDate = { value: check.toString(), type: 'bool' };
								me.showLoadMask({
									msg: KS.L10n.loading_data,
									rid: ajaxRequest({
										url: 'SDocPlan/ReloadByRashDate_A',
										params: {
											whereArgs: JSON.stringify(me.whereArgs)
										},
										success: function (res) {
											if (res.newWA) {
												for (var key in res.newWA) {
													me.whereArgs[key] = res.newWA[key];
												}

												// скрытие/показывание колонок
												var cols = me.objs.Grid.columnManager.getColumns(),
													typeCol = ArrayLib.filter(cols, ['dataIndex'], 'MOD_TYPE'),
													typeImageCol = ArrayLib.filter(cols, ['dataIndex'], 'MOD_TYPE_IMG'),
													osnovCol = ArrayLib.filter(cols, ['dataIndex'], 'MOSNOV_NAME'),
													numChangeCol = ArrayLib.filter(cols, ['dataIndex'], 'S_PLANPROJ_NUMBER');

												if (typeCol && typeCol[0]) {
													typeCol[0].setVisible(check);
												}
												if (typeImageCol && typeImageCol[0]) {
													typeImageCol[0].setVisible(check);
												}
												if (osnovCol && osnovCol[0]) {
													osnovCol[0].setVisible(check);
												}
												if (numChangeCol && numChangeCol[0]) {
													numChangeCol[0].setVisible(check);
												}

												me.refresh(true, 1);
											}
										},
										callback: me.hideLoadMask.bind(me)
									})
								});
							}
						})),
						me.createDictEdit({
							labelWidth: 100,
							key: 'S_ORG',
							mode: 'MULTI',
							flex: 1,
							code: dnl.S_ORG,
							fieldLabel: 'Проверяющая',
							codeWidth: 125,
							cleaningKey: false,
							initWhereArgs: function() {
								var res = { SType: { value: JSON.stringify([KsLib.getKeyByValue(miscTypes.TypeOrg, 'Проверяющая') * 1]), type: 'List_int' } };
								if (miscTypes.ShowPlan[me.ShowPlan] === 'OwnChild') res.LinkMaster = { value: user.org.data.LINK, type: 'int' };
								return res;
							},
							ksSetValue: function(v) {
								setV.call(this, v);
							}
						})
					]
				})
			]
		}));
		me.gksc('DT').setValue(d1, d2);
		me.gksc('S_ORG').setValue(user.org);

		if (me.head === false || me.hideFilterPnl) objs.filterPanel.hide();
		me.isCreate = false;
		return items;
	},	

	setSBText: function(allCount, selCount, checkCount) {
		let me = this,
			tbarBtns = me.objs.tbarBtns;
		me.callParent(arguments);
		tbarBtns && tbarBtns.plan_info && tbarBtns.plan_info.setDisabled(!selCount);

		let sel = me.objs.Grid.getFrstSelect();
		me.objs.tbarBtns.new && me.objs.tbarBtns.new.setDisabled(sel ? !this.canEdit(sel) : false);
	},

	canEdit: function(rec){
		// S_PLANPROJ_DT для режима "с учетом изменений на расчетную дату"
		let closed = this.whereArgs.Modification.value !== 'True' && !!rec.get('S_PLANPROJ_DT') ||
			this.getProjDT(rec.get('S_PLANPROJ'));
		if (closed) return false;
		
		return this.callParent(arguments);
	},

	baseGetData: function(endFunc, params) {
		let me = this;
		params.code = me.code;
		me.callParent(arguments);
	},
	beforeSetData: function(data, params) {
		let me = this;
		
		const pplan = ArrayLib.filter(data.fields, ['name'], 'PPLAN')[0];
		if (pplan) pplan.sortType = "asNatural";
		
		me.callParent(arguments);

		me.ShowPlan = data.ShowPlan;
		me.gksc('S_OTDEL').setFieldLabel(window.isRfn ? 'Ответственный исполнитель' : 'Подразделение');
		if (data.hideOtdel) me.gksc('S_OTDEL').setVisible(false);
		if (data.byRashDate) {
			me.whereArgs.ByRashDate = {value: data.byRashDate.toString(), type: 'bool'};
			me.gksc('chkRashDate').setValue(data.byRashDate);
		}

		if (data.PrintReport) {
			me.sksd('printReport', data.PrintReport);
		}
		if (miscTypes.ShowPlan[data.ShowPlan] === 'OwnOnly') me.gksc('S_ORG').hide();		
		me.closedProj = data.closedProj;
	},
	changeBtnsByProj: function(closed) {
		let me = this;

		if (me.whereArgs.Modification.value !== 'True') {
			me.objs.tbarBtns.edit.setIconCls(closed ? 'x_btn_open' : 'x_btn_edit');
			me.objs.tbarBtns.edit.setTooltip(closed ? 'Открыть' : 'Редактировать');
		}
		me.objs.tbarBtns.new.setDisabled(closed);
		Ext.each(me._arrEditTBarBtns, (n) => me.objs.tbarBtns[n] && me.objs.tbarBtns[n].setDisabled(closed));
	},
	
	getProjDT: function (projLink) {
		var me = this;
		if (!me.closedProj) return false;

		var rec = ArrayLib.filter(me.closedProj, ['LINK'], projLink)[0];

		return !!(rec && rec.CLOSED_PROJ);
	},
	setProjDT: function(projLink, val) {
		var me = this;
		if (!me.closedProj) return;

		var rec = ArrayLib.filter(me.closedProj, ['LINK'], projLink)[0];
		if (rec) rec.CLOSED_PROJ = val;
	},
	getRowClass: function (rec) {
		return this.canBold && rec.get('S_PLANPROJ_DT') !== null ? 'x-bold' : '';
	},	
	columnsAdapted: function () {
		var me = this,
			cols = this.callParent(arguments),
			typeCol = ArrayLib.filter(cols, ['dataIndex'], 'MOD_TYPE'),
			statusImageCol = ArrayLib.filter(cols, ['dataIndex'], 'TEMP_STATUS_IMAGE'),
			typeImageCol = ArrayLib.filter(cols, ['dataIndex'], 'MOD_TYPE_IMG'),
			osnovCol = ArrayLib.filter(cols, ['dataIndex'], 'MOSNOV_NAME'),
			numChangeCol = ArrayLib.filter(cols, ['dataIndex'], 'S_PLANPROJ_NUMBER');

		if (me.whereArgs.Modification.value === 'False') {
			if (typeCol && typeCol[0]) {
				typeCol[0].hidden = true;
			}
			if (typeImageCol && typeImageCol[0]) {
				typeImageCol[0].hidden = true;
			}
			if (osnovCol && osnovCol[0]) {
				osnovCol[0].hidden = true;
			}
			if (numChangeCol && numChangeCol[0]) {
				numChangeCol[0].hidden = true;
			}
		}

		if (typeCol && typeCol[0] && !typeCol[0].hidden) {
			typeCol[0].renderer = function(val, metaData, rec, rowIndex, colIndex, store, view) {
				switch (val) {
				case 1:
					return 'Добавление';
				case 2:
					return 'Изменение';
				case 3:
					return 'Исключение';
				default:
					return '';
				}
			}
		}
		if (statusImageCol && statusImageCol[0]) {
			statusImageCol[0].header = statusImageCol[0].text;
			statusImageCol[0].sortable = false;
			statusImageCol[0].align = 'center';
			statusImageCol[0].renderer = function (val, metaData, rec, rowIndex, colIndex, store, view) {
				var icon = '';
				switch (rec.data.STATUSNAME) {
				case "На доработку":
					icon = 'status_red';
					break;
				case "На согласование":
					icon = 'status_yellow';
					break;
				case "Отклонено":
					icon = 'status_gray';
					break;
				case "Предложение":
					icon = 'status_pink';
					break;
				case "Проект":
					icon = 'status_blue';
					break;
				case "Согласовано":
					icon = 'status_light_blue';
					break;
				case "Утверждено":
					icon = 'status_green';
					break;
				case "Проверено":
					icon = 'status_lilac';
					break;
				default:
					icon = '';
					break;
				}
				metaData.tdCls = 'ks-cell-icon';
				return '<div class="ks-column-header-icon x_btn_' + icon + '"></div>';
			}
		}
		if (typeImageCol && typeImageCol[0]) {
			typeImageCol[0].sortable = false;
			typeImageCol[0].align = 'center';
			typeImageCol[0].renderer = function (val, metaData, rec, rowIndex, colIndex, store, view) {
				var icon = '';
				switch (rec.data.MOD_TYPE) {
				case 1:
					icon = 'treeadd';
					break;
				case 2:
					icon = 'tree_edit';
					break;
				case 3:
					icon = 'treedel';
					break;
				default:
					icon = '';
					break;
				}
				return icon ? '<img class="ks-column-header-icon x_btn_' + icon + '"/>' : '';
			}
		}
		
		return cols;
	},
	/** Task Revizor.PlanCentral.ChangeStatus	  
	 * @param value {object}
	 */
	batchChangeStatus: function(value)
	{
		if (!value || !value.statuses) return;
		
		let me = this,
			statuses = value.statuses.split(','),
			links = me.objs.Grid.store.getDataExt().filter(r => r.M).map(r => r.LINK);
		if (!links.length || !statuses.length) return;

		Ext.create('Keysystems.Comment',
			{
				title: 'Изменение статуса',
				labelText: 'Комментарий',
				initText: '',
				okFn: function () {
					var comment = this.textArea.getValue();
					me.showLoadMask({
						msg: wmc.getMask('StatusBatchChange'),
						rid: ajaxRequest({
							url: 'SDocPlan/StatusBatchChange_A',
							params: {
								statuses: JSON.stringify(statuses),
								links: JSON.stringify(links),
								comment: comment,
								mod: me.whereArgs.Modification.value === 'True'
							},
							success: function (res) {
								me.hideLoadMask();
								if (res) {
									if (res.error) {
										showError(res.error);
									} else {
										me.refresh(true, 1);
										ChooseBox.ShowHTML({
											text: res.text,
											hasIgnoreButton: false,
											info: true
										});
									}
								}
							},
							failure: function (){ me.hideLoadMask(); }
						})
					});
				}
			}).show();

	},

	/** Task Revizor.Plan.List.PrintReport	 
	 */	
	planPrintReport: function() {
		let me = this,
			printReport = me.gksd('printReport'),
			report = printReport.report,
			sel = me.Grid.getFrstSelect();

		let paramsOtbor = {},
			paramsNastr = {};
		
		paramsOtbor[printReport.reportNameSOrgP] = {
			value: me.objs.S_ORG.getLinks(),
			visible: true
		};
		paramsOtbor[printReport.reportNameSOrgP2] = {
			value: me.objs.S_ORG.getLinks()
		};
		paramsOtbor[printReport.reportNameSOtdel] = {
			value: me.objs.S_OTDEL.getLinks(),
			visible: true
		};

		paramsNastr[printReport.reportNamePlanProjYear] = {
			value: me.gksc("DT").getYear(),
			type: 'int'
		};
		paramsNastr[printReport.reportNameByRashDate] = {
			value: me.gksc('chkRashDate').getValue(),
			type: 'bool'
		};
		
		let func = function(mod) {
			for (let name in paramsOtbor) {
				paramsOtbor[name] = paramsOtbor[name].value;
			}
				if (report.noNeedForm) {
					const loadMask = new Ext.LoadMask({
						msg: `${KS.L10n.report_generate}...`,
						target: me.objs.view,
						autoShow: true,
						rid: ajaxRequest({
							url: 'Report/CreateReportWeb_A',
							params: {
								code: report.objectCode,
								link_var: report.id,
								title: report.name,
								sysCode: report.code,
								mode: KsLib.getKeyByValue(miscTypes.ReportPrintMode, mod ? 'PlanrevizSimpleMod' : 'PlanrevizSimple'),
								parentLink: 0,
								parametrs: '',
								paramsOtbor: JSON.stringify(paramsOtbor),
								paramsNastr: JSON.stringify(paramsNastr),
								noNeedForm: true
								
							},
							success: function(res) {
								if (!res.error.length) {
									getReportFile.call(me, res.guid, report.objectCode);
								}
							},
							callback: function() {
								loadMask.destroy();
							}
						})
					});
				} else {
					Ext.create('Revizor.ReportView', {
						parentView: me,
						tabMode: false,
						title: report.name,
						link_var: report.id,
						code: report.objectCode,
						id: report.code + '-' + Ext.id(),
						mode: KsLib.getKeyByValue(miscTypes.ReportPrintMode, 'PlanrevizSimple'),
						parentData: {
							code: me.code,
							data: {
								LINK: sel ? sel.get('LINK') : -1
							},
							paramsOtbor
						}
					});
				}
			};

		if (me.whereArgs.Modification.value === 'True') {
			let projLinks = [];
			Ext.each(me.checkList, rec => {
				projLinks.push(rec.get('S_PLANPROJ'));
			});
			me.showLoadMask({
				msg: wmc.getMask('ReportGetData'),
				rid: ajaxRequest({
					url: 'SDocPlan/GetReportData_A',
					params: {
						links: JSON.stringify(projLinks)
					},
					success: function (res) {
						me.hideLoadMask();
						if (res.error) {							
							showError(wmc.get('ReportGetDataError'));
						} else {
							paramsNastr[printReport.reportNameNumMod1] = {
								value: res.numModif1,
								type: 'int'
							};
							paramsNastr[printReport.reportNameNumMod2] = {
								value: res.numModif2,
								type: 'int'
							};
							func(true);
						}
					},
					failure: function () {
						me.hideLoadMask();
						showError(wmc.get('ReportGetDataError'));
					}										
				})
			});			
		} else {
			func();
		}		
	},

	/** Task 'Revizor.PlanProj.Info'
	 */
	planProjInfo: function(){
		let me = this,
			sel = me.objs.Grid.getFrstSelect();
		if (!sel) return;

		let projLink = sel.data.S_PLANPROJ;
		ajaxRequest({
			url: 'SPLANPROJ/GetEditRow_A',
			params: { 
				link: projLink,
				isGetRow: true
			},
			success: function (row) {
				var minHeight = window.isRfn ? 200 : 600;
				var planProjForm = Ext.create('Keysystems.PlanProj.Edit',
					{
						f: me.readOnlyPlanInfo ? 'readOnly' : 'edit',
						data: { data: row },
						viewMinSize: [850, minHeight],
						planContainerVsbl: false,
						taskGridVsbl: !window.isRfn,
						isVfa: me.isVfa,
						isFromToolBar: true
					});

				var ssf = planProjForm.successSaveFunc;
				planProjForm.successSaveFunc = function (result, endFunc, params) {
					ssf.call(this, result, endFunc, params);

					if (!result.ErrorMsg) {
						var dt = params.DT;
						me.setProjDT(projLink, dt ? 1 : null);
						me.changeBtnsByProj(!!dt);
						// обновление даты у пунктов плана
						Ext.each(me.objs.Grid.store.data.items,
							function(i) {
								if (i.data.S_PLANPROJ === params.link)
									i.data.S_PLANPROJ_DT = dt;
							});
						if (me.canBold) me.objs.Grid.getView().refresh();
					}
				};
			}
		});
	},

	getGridCfg: function(){
		let res = this.callParent(arguments);
		res.userCls = 'rks-grid-with-filter-panel';
		return res;
	}
});