﻿Ext.define('Keysystems.Plan.List.Mod', {
	extend: 'Keysystems.Plan.List.Simple',
	startYear: (new Date()).getFullYear(),
	title: 'Планирование',
	iconCls: 'x_btn_plan',
	deleteCode: 'DOCUMENT_PLANREVIZ_MOD',
	profileCode: 'DOCUMENT_PLANREVIZ_MOD',
	profileListeners: [
		{ name: 'DT', method: 'KsPeriodChange' },
		{ name: 'S_ORG', method: 'ksDictChange' },
		{ name: 'S_OTDEL', method: 'ksDictChange' },
		{ name: 'S_PLAN', method: 'ksDictChange' }
	],	
	canBold: true,

	initConfig: function(cfg) {
		cfg.code = dnl.PLANREVIZ_MOD;
		return this.callParent(arguments);
	},

	setWhereArgs: function() {
		let me = this,
			whereArgs = me.callParent(arguments);

		whereArgs.Modification = { value: 'True', type: 'KSBoolean' };
		
		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},
	
	createItems: function () {
		var me = this,
			items = me.callParent(arguments);
		me.gksc('chkRashDate').setVisible(false);

		me.title = 'Изменения в Планирование';
		return items;
	},

	

	createTBar: function() {
		var me = this,
			objs = me.objs;

		me.callParent(arguments);
		var tbar = objs.tbar,
			tbarBtns = objs.tbarBtns;
		
		var i = tbar.indexOf(tbarBtns.new);
		tbar.splice(i, 1);		

		return tbar;
	},

	/** Task.Revizor.PlanMod.TreeAdd
	 */
	modTreeAdd: function () {
		var me = this,
			dtValue = me.gksc('DT').getValue();
		ajaxRequest({
			url: 'SPlanMod/ModTreeAdd_A',
			params: {
				year: dtValue.dh1.getFullYear()
			},
			success: function (res) {
				if (res.errMsg) {
					showError(res.errMsg);
				} else {
					Ext.create('Keysystems.Plan.Edit',
					{
						f: 'new',
						whereArgs: {
							DT1: { value: dtValue.dh1.toDateString(), type: 'Date' },
							DT2: { value: dtValue.dh2.toDateString(), type: 'Date' }
						},
						modification: true,
						modType: 'add',
						updRecord: function() { me.refresh(); }
					});
				}
			}
		});
	},

	/** Task.Revizor.PlanMod.TreeEdit	 
	 */
	modTreeEdit:function(){
		this.modTreeEditDel(true);
	},
	/** Task.Revizor.PlanMod.TreeDel
	 */
	modTreeDelete:function(){
		this.modTreeEditDel(true);
	},

	modTreeEditDel: function (editOrDel) {
		var me = this,
			dtValue = me.gksc('DT').getValue();
		ajaxRequest({
			url: 'SPlanMod/ModTreeEditDelete_A',
			params: {
				year: dtValue.dh1.getFullYear()
			},
			success: function (res) {
				if (res.errMsg) {
					showError(res.errMsg);
				} else {
					var newProj = res.proj,
						isSelect = false,
						wa = res.whereArgs;
					wa.DT1 = { value: dtValue.dh1.toDateString(), type: 'Date' },
					wa.DT2 = { value: dtValue.dh2.toDateString(), type: 'Date' },
					wa.RazdelPlan = { value: JSON.stringify(me.gksc('S_PLAN').getLinks()), type: 'List_int' };
					wa.Otdels = { value: JSON.stringify(me.gksc('S_OTDEL').getLinks()), type: 'List_int' };

					dictFunc({
							parentView: tabView,
							mode: 'MULTI',
							code: dnl.PLANREVIZ,
							title: "Запланированные мероприятия",
							whereArgs: wa,
							hideFilterPnl: true,
							canBold: true,
							readOnlyPlanInfo: true,
							btnsHide: { status: true, new: true, same: true, edit: true, delete: true, settings: true, autofilter: true },
							setWhereArgs: function () { return wa; },
							checkRenderer: function (val, meta, rec) {
								if (rec.data.S_PLANPROJ_DT === null) meta.tdCls += ' ' + this.disabledCls;
							},
							checkListeners: { beforecheckchange: function(th, inx, check, rec) {
								return rec.data.S_PLANPROJ_DT !== null;
							}}
						},
						{
							ok: function (value) {
								if (value.length) {
									isSelect = true;
									var selLinks = [];
									Ext.each(value, function (rec) { selLinks.push(rec.data.LINK) });
									me.showLoadMask({
										msg: wmc.getMask('PlanModAddChanges'),
										rid: ajaxRequest({
											url: 'SPlanMod/PlanModEditDelete_A',
											params: {
												planLinks: JSON.stringify(selLinks),
												editOrDel: editOrDel,
												year: me.gksc('DT').getValue().dh1.getFullYear()
											},
											success: function(res) {
												me.hideLoadMask();
												if (res) {
													me.refresh(true, 1);
												} else {
													showError(wmc.get('PlanModAddChangesError'));
												}
											},
											failure: function (){
												me.hideLoadMask();
											}
										})
									});
								}
							},
							close: function () {
								if (!isSelect && newProj !== 0) {
									// удаляем проект без пунктов плана
									ajaxRequest({
										url: 'SPlanMod/CheckForDel_A',
										params: {
											projLink: newProj
										}
									});
								}
							}
						});
				}
			}
		});
	}
});