﻿Ext.define('Keysystems.Plan.Edit', {
	extend: 'Ext.tab.Panel',
	mixins: ['Keysystems.Base.Edit'],
	title: 'Запланированные мероприятия',
	linkCode: 'SDocPlan',
	isWindow: true,
	flex: 1,
	autoRender: true,
	border: 0,
	bodyPadding: 0,
	planMoney: -1,
	tRevizAuditLink: -1,
	sPersonLink: -1,
	rNormLink: -1,
	personPartLink: -1,
	modification: false,
	userCls: 'rks-panel-edit',
	bodyCls: 'rks-panel-edit-body',
	viewMinSize: [883, 600],
	profileListeners: [{ name: 'view', method: 'FormParam' }],

	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	
	initComponent: function() {
		var me = this;
		if (me.whereArgs && me.whereArgs.Modification) {
			me.modification = me.whereArgs.Modification.value === 'True';
		}

		me.linkCode = me.modification ? 'SPlanMod' : 'SDocPlan';
		//me.code = 'DOCUMENT_PLANREVIZ';
		me.title = me.modification ? 'Изменения в Запланированные мероприятия' : 'Запланированные мероприятия';

		me.beforeInitComponent();

		me.bbar = [
			me.sksc('S_STATUS', Ext.create('Keysystems.Controls.ComboBoxExtra', {
				fieldLabel: 'Статус',
				editable: false,
				queryMode: 'local',
				value: 0,
				labelWidth: 50,
				displayField: CBDataLib.displayField,
				valueField: CBDataLib.valueField,
				padding: '5 10 5 10',
				listeners: {
					change: function(th, newValue) {
						var ro = me.readOnly;

						me.setReadOnly(me.gksd('readOnlyStatuses').indexOf(newValue) !== -1); //todo readOnly только у статусов с запретом редактирования
						me.readOnly = ro;

						me.gksc('saveBtn').setKsReadOnly(false);
						this.setKsReadOnly(false);
					}
				},
				setKsReadOnly: function() {
					var res = this.callParent(arguments);
					this.setDisabled(this.store.count() < 2);
					return res;
				},
				store: Ext.create('Ext.data.Store', {
					fields: CBDataLib.getFields(),
					data: [],
					proxy: 'memory'
				})
			}))
		];

		me.baseInitComponent();
		me.callParent(arguments);
		me.afterInitComponent();
		me.sksd('isCntDaysChanged', false);
	},

	createItems: function() {
		var me = this;

		return [me.getTab('General')];
	},

	//#region таб Общие

	//конструктор таба Общие
	createTabGeneral: function() {
		var me = this;

		me.checkDtmInDt = function() {
			var ksControls = me.ksControls,
				dt = ksControls.DT.getValue(),
				dtMoney = ksControls.DTMONEY.getValue();

			if (ksControls.DTMONEY.isVisible()) {
				if (dtMoney.dh1 > dt.dh1) {
					info(KS.L10n.PlanEditView_CheckSave_Период_проведения_не_может_начинаться_раньше_проверяемого_периода_);
				} else if (dtMoney.dh2 > dt.dh2) {
					info(KS.L10n.PlanEditView_CheckSave_Период_проведения_не_может_заканчиваться_раньше_проверяемого_периода_);
				}
			}
		};

		return me.sksc('tabGeneral', Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			flex: 1,
			border: 0,
			padding: '5 0 0',			
			padding: '5 0 0',			
			minHeight: 500,
			items: [
				me.sksc('planModInfo', Ext.create('Keysystems.PlanModInfo', {
					labelWidth: me.labelWidth,
					padding: '-5 10 -3 10',
					smosnovAllowEmpty: true,
					commentAllowEmpty: true,
					commentLabel: 'Обоснование внесения изменения',
					commentPadding: '6 0 0 0',
					smosnovChanged: function(th, newVal) {
						if (me.isLoaded || !newVal.length) return;
						ajaxRequest({
							url: 'SPlanMod/ChangeStatusModel_A',
							params: {
								link: me.getLink(),
								status: me.gksc('S_STATUS').getValue(),
								osnovLinks: JSON.stringify(this.gksc('S_MOSNOV').getLinks())
							},
							success: function(res) {
								if (res && me.gksc('S_STATUS').getValue() !== +res.index) {
									me.gksc('S_STATUS').store.loadData([res], false);
									me.gksc('S_STATUS').setValue(+res.index);
								}
							}
						});
					}
				})),
				Ext.create('Ext.panel.Panel', {
					layout: { type: 'vbox', align: 'stretch' },
					border: 0,
					padding: '0 10 0 10',
					items: [
						[
							me.sksc('NUMBER', Ext.create('Ext.form.field.Text', {
								fieldLabel: '№ приказа',
								ksAllowEmpty: true,
								labelWidth: me.labelWidth,
								maxLength: 20
							})),
							me.sksc('DT0', Ext.create('Ext.form.field.Date', {
								width: 130,
								padding: '0 0 0 20',
								labelWidth: 30,
								fieldLabel: 'от',
								ksAllowEmpty: true
							})),
							me.sksc('VIEWCHANGE', Ext.create('Keysystems.Controls.ComboBoxExtra', {
								labelWidth: me.labelWidth,
								fieldLabel: 'Вид изменения',
								editable: false,
								padding: '0 0 0 20',
								value: null,
								maxHeight: 22,
								store: Ext.create('Ext.data.Store', {
									fields: CBDataLib.getFields(),
									data: CBDataLib.get('PlanViewChange', 1),
									proxy: 'memory'
								}),
								displayField: CBDataLib.displayField,
								valueField: CBDataLib.valueField
							}))
						],
						me.createDictEdit({
							key: 'S_PLAN',
							mode: 'SINGL',
							code: dnl.S_PLAN,
							fieldLabel: 'Раздел плана',
							padding: '-5 0 0 0',
							initWhereArgs: function() {
								var dh = me.gksc('DT').getValue();
								var rosnov = me.gksc('S_ROSNOV').getLink();
								return {
									DH1: { value: dh.dh1.toDateString(), type: 'Date' },
									DH2: { value: dh.dh2.toDateString(), type: 'Date' },
									SRosnov: {
										value: JSON.stringify(rosnov ? [rosnov] : me.gksd('planOsnov')),
										type: 'List_int'
									}
								};
							},
							ksSetValue: function(v) {
								this.setValue(v);

								if (me.gksc('planModInfo').isVisible()) {
									var links = this.getLinks();
									me.gksc('planModInfo').osnovWA.planRazdel = links.length ? links[0] : 0;
								}
							}
						}),
						me.sksc('objsPanel', Ext.create('Keysystems.RevizObj', {
							fieldLabel: 'Объект',
							layout: 'hbox',
							getMode: function() {
								return me.gksd('multiObject') ? 'MULTI' : 'SINGL';
							},
							getRevizOneMain: function() {
								return me.gksd('RevizOneMain');
							},
							getRevizObjType: function() {
								return me.gksd('RevizObjType');
							},
							getIndivid: function() {
								return me.gksd('Individ');
							},
							getRevizSelf: function() {
								return me.gksd('RevizSelf');
							},
							getRevizObjects: function() {
								return me.gksd('tRevizObjects');
							},
							getRevizAudit: function() {
								return me.gksd('tRevizAudit');
							},
							getRevizAuditLink: function() {
								return me.tRevizAuditLink--;
							},
							getS_ORGP_Grid: function() {
								return me.gksc('S_ORGP_Grid');
							},
							setRevizObjects: function(list) {
								me.sksd('tRevizObjects', list);
							},
							setRevizAudit: function(list) {
								me.sksd('tRevizAudit', list);
							},
							getDT: function() {
								return me.gksc('DT').getValue();
							},
							isLoading: function(){
								return me.isLoaded;	
							},
							getRowClass: function(record) {
								let cls = '';
								let orgStatus = record.get('ORGSTATUS');
								switch (parseInt(orgStatus)) {
									case 1:
										cls = 'plan-org-status-overdue';
										break;
									case 2:
										cls = 'plan-org-status-planned';
										break;
									case 3:
										cls = 'plan-org-status-revized';
										break;
									case 4:
										cls = 'plan-org-status-prepared';
										break;
									case 5:
										cls = 'plan-org-status-done';
										break;
								}
								return cls;
							},
							initWhereArgs: function(whereArgs) {
								let dt = me.gksc('DT').getValue();
								whereArgs.RevizFrequency = {
									value: JSON.stringify({
										periodType: 'Year',
										value: '1',
										dBegin: dt.dh1.toDateString(),
										dEnd: dt.dh2.toDateString()
									}),
									type: 'PartPeriodValue'
								};
								whereArgs.SPlanProj = {value: me.gksc('S_PLANPROJ').getLink(), type: 'int'};
								return whereArgs;
							},
							beforeSetData: function() {
								//применим цвета из настроек к css-стилям, которые в дальнейшем используем для подсветки строк в списке выбора орг-ий
								var planColors = me.gksd('planColors');
								if (window.planColors !== planColors) {
									window.planColors = planColors;
									let cssBlock = $('#plan-org-rows-styles');
									let text = cssBlock.text();
									for (var name in planColors) {
										let color = planColors[name];
										let what = new RegExp(`\\/\\*${name}\\*\\/.*\\/\\*${name}\\*\\/`, "gm");
										let replacement = `/*${name}*/${color}/*${name}*/`;
										text = text.replace(what, replacement);
									}
									cssBlock.text(text);
								}
							},
							checkObjectsForReviz: me.checkObjectsForPlanReviz,
							checkObjectsHistoryChange: Ext.emptyFn,
							changeObjProp: me.changeObjProp,
							thereMainObj: Ext.emptyFn,
							tRevizAuditLink: me.tRevizAuditLink,
							mainColumn: false,
							labelWidth: me.labelWidth - 83,
							troField: 'T_PLANREVIZ_OBJECTS',
							parentView: me
						})),
						me.sksc('EXTOBJECTS', Ext.create('Keysystems.form.field.TextAreaComboBox', {
							height: 50,
							padding: '-5 0 0 155',
							store: []
						})),
						me.createDictEdit({
							key: 'S_WORK',
							mode: 'SINGL',
							ksAllowEmpty: true,
							code: dnl.S_WORK,
							fieldLabel: 'Вид работы',
							initWhereArgs: function() {
								var dh = me.gksc('DT').getValue(),
									whereArgs = {
										DH1: { value: dh.dh1.toDateString(), type: 'Date' },
										DH2: { value: dh.dh2.toDateString(), type: 'Date' },
										SPersons: {
											value: JSON.stringify(Object.keys(me.gksd('personPartData'))
												.map(function(d) {
													return d * 1;
												})),
											type: 'List_int'
										}
									};

								if (me.isVfa) {
									whereArgs.InLinks = me.whereArgs.SWorks;
									whereArgs.InLinksOnly = {
										value: true,
										type: 'bool'
									}
								} else whereArgs.NotInLinks = {
									value: JSON.stringify(me.gksd('vfaWorks')),
									type: 'List_int'
								};

								return whereArgs;
							}
						}),
						me.createDictEdit({
							key: 'S_RTEMA',
							mode: me.gksd('MultiTema') ? 'MULTI' : 'SINGL',
							code: me.isVfa ? dnl.S_RTEMA_VFA : dnl.S_RTEMA,
							fieldLabel: 'Тема',
							initWhereArgs: function() {
								var dh = me.gksc('DT').getValue(),
									whereArgs = {
										DH1: { value: dh.dh1.toDateString(), type: 'Date' },
										DH2: { value: dh.dh2.toDateString(), type: 'Date' },
										SPlan: {
											value: me.gksc('S_PLAN').getLinks(1),
											type: 'List_int'
										}
									};

								if (me.isVfa) {
									// Добавляем Ограничение по объекту контроля
									var revObjs = me.gksd('tRevizObjects');
									var orgs = [];
									var otdels = [];

									if (revObjs) {
										revObjs.filter(rec => rec.LINK_SELF === null && rec.TYPE === 64 ).forEach(rec => orgs.push(rec.TLINK));//RevizObjType.СП = 64
										revObjs.filter(rec => rec.TYPE === 1 ).forEach(rec => {if(orgs.indexOf(rec.TLINK) === -1)orgs.push(rec.TLINK)});//RevizObjType.ЮЛ = 1

										var parentLinks = [];
										revObjs.filter(rec => rec.LINK_SELF === null && rec.TYPE === 64 ).forEach(rec => parentLinks.push(rec.LINK));//RevizObjType.СП = 64
										revObjs.filter(rec => parentLinks.includes(rec.LINK_SELF) && rec.TYPE === 64).forEach(rec => otdels.push(rec.TLINK));
									}

									whereArgs.OrgsLimit = {
										value: JSON.stringify(orgs),
										type: 'List_int'
									}
									
									whereArgs.OtdelsLimit = {
										value: JSON.stringify(otdels),
										type: 'List_int'
									}
								}

								return whereArgs;
							},
							ksSetValue: function(value) {
								this.setValue(value);
								var len = value && value.length,
									revizVid = me.gksc('REVIZ_VID');

								let sName = [];
								if (revizVid.isVisible()) {
									if (len > 0) {
										Ext.each(value,
											function(d) {
												if (d.get('SNAME') && d.get('SNAME').length) {
													sName.push(d.get('SNAME'));
												}
											});
									}
									revizVid.setValue(sName.join('; '));
								}
							}
						}),
						me.sksc('REVIZ_VID', Ext.create('Ext.form.field.Text', {
							fieldLabel: 'Вид КМ',
							labelWidth: me.labelWidth,
							readOnly: true
						})),
						[
							me.createDictEdit({
								key: 'S_ROSNOV',
								mode: 'SINGL',
								flex: 2,
								code: dnl.S_ROSNOV,
								ksAllowEmpty: true,
								fieldLabel: 'Основание',
								ksSetValue: function(v) {
									this.setValue(v);
									if (!me.isLoaded) {
										me.gksc('docOsnov').refresh();
									}
								},
								initWhereArgs: function() {
									var sPlanLink = me.gksc('S_PLAN').getLink(),
										dh = me.gksc('DT').getValue();

									return {
										DH1: { value: dh.dh1.toDateString(), type: 'Date' },
										DH2: { value: dh.dh2.toDateString(), type: 'Date' },
										SPlan: {
											value: sPlanLink,
											type: 'int'
										},
										OnlyPlan: {
											value: sPlanLink !== 0,
											type: 'bool'
										},
										InLinks: {
											value: JSON.stringify(sPlanLink !== 0 ? [] : me.gksd('planOsnov')),
											type: 'List_int'
										},
										InLinksOnly: {
											value: sPlanLink === 0,
											type: 'bool'
										}
									};
								}
							}),
							me.sksc('docOsnov', Ext.create('Keysystems.Document.Edit.Mini', {
								labelWidth: me.labelWidth,
								padding: '0 0 0 10',
								flex: 1,
								isPlan: true,
								parentView: me,
								getOsnovLink: function() {
									return me.gksc('S_ROSNOV').getLink();
								},
								getWorkLink: function() {
									return me.gksc('S_WORK').getLink();
								},
								getMasterLink: function() {
									return me.getLink();
								}
							}))
						],
						me.sksc('EXTOSNOV', Ext.create('Keysystems.form.field.TextAreaComboBox', {
							height: 50,
							padding: '0 0 0 155',
							store: []
						})),
						me.sksc('dtPanel', Ext.create('Ext.form.FieldContainer', {
							layout: { type: 'hbox', align: 'stretch' },
							items: [
								me.sksc('DT', Ext.create('Keysystems.Controls.PeriodEdit', {
									labelWidth: me.labelWidth,
									fieldLabel: 'Период проведения',
									ksAllowEmpty: true,
									width: 460,
									cfgDh: { width: 105 },
									cfgnbDays: { hidden: false },
									getOrgP: function() {
										var orgp = me.gksc('S_ORGP_Grid').store.getAt(0);
										return orgp ? orgp.data.LINK : window.user.org.data.LINK;
									},
									listeners: {
										ksChange: function() {
											var th = this;

											var revizorsGrid = me.gksc('RevizorsGrid');

											if (!revizorsGrid) return _;

											if (revizorsGrid.store.getDataExt().length && me.gksc('DTMONEY').isVisible()) {
												selectDialogShow(KS.L10n.PlanEditView_BeginDateChanged_Изменение_периода_проведения, KS.L10n.PlanEditView_prdDT_KSChanged_Изменить_периоды_участия_, function () {
													me.fillPersonParts(revizorsGrid.store.getLinks('S_PERSON'), true);
													me.recalcCntPersonsDays();
													me.refCostData();
												}, function() {
													me.checkErrorParts(revizorsGrid.store.getLinks('S_PERSON'));
													me.recalcCntPersonsDays();
													me.refCostData();
												});
											}

											if (th.nbDays && !me.calcByRevizors()) {
												th.swap();
												var dt = th.getValue();

												getCntDaysInPeriod(dt.dh1, dt.dh2, th.getOrgP(), function(val) {
													th.nbDays.setValue(val.workDays);
													me.sksd('durationDay', val.allDays);
												});
											}

											me.checkDtmInDt();
										}
									}
								})),
								'->',
								me.sksc('DTMONEY', Ext.create('Keysystems.Controls.PeriodEdit', {
									labelWidth: 140,
									fieldLabel: 'Проверяемый период',
									isSwap: true,
									width: 380,
									cfgDh: { width: 105 },
									getOrgP: function() {
										var orgp = me.gksc('S_ORGP_Grid').store.getAt(0);
										return orgp ? orgp.data.LINK : window.user.org.data.LINK;
									}
								}))
							]
						})),
						me.objs.S_OTDEL = Ext.create('Keysystems.Controls.Dict.Edit', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Подразделение',
							padding: window.isRfn ? '-6 0 7 0' : 0,
							mode: 'MULTI',
							ksSetValue: function(v) {
								this.setValue(v);
								var sOtdel = [];

								Ext.each(v,
									function(otdel) {
										otdel = otdel.data || otdel;

										sOtdel.push({
											S_OTDEL: otdel.LINK,
											MAIN: otdel.MAIN || false
										});
									});

								me.sksd('S_OTDEL', sOtdel);
							},
							clear: function() {
								this.ksSetValue();
							},
							handler: function() {
								dictFunc({
									mode: 'MULTI',
									title: me.titleSOtdel,
									mainColumn: true,
									readOnly: me.objs.S_OTDEL.readOnly,
									accessReadOnly: me.objs.S_OTDEL.readOnly,
									control: me.objs.S_OTDEL,
									contextSearch: me.objs.S_OTDEL.contextSearch,
									initWhereArgs: function() {
										var dh = me.gksc('DT').getValue(),
											sOrgs = me.gksc('S_ORGP_Grid').store.getLinks();
										if (!sOrgs.length) {
											sOrgs = [window.user.org.data.LINK];
										}

										return {
											DH1: { value: dh.dh1.toDateString(), type: 'Date' },
											DH2: { value: dh.dh2.toDateString(), type: 'Date' },
											SOrgs: {
												value: JSON.stringify(sOrgs),
												type: 'List_int'
											}
										};
									},
									getSOrg: function() {
										return me.gksc('S_ORGP_Grid').store.getDataExt().length
											? me.gksc('S_ORGP_Grid').store.getDataExt()[0].LINK
											: window.user.org.data.LINK;
									},
									parentView: objs.view,
									selectLinks: me.objs.S_OTDEL.getValue(),
									code: dnl.S_OTDEL
								}, {
									ok: function(value) {
										me.objs.S_OTDEL.ksSetValue(value);
									}
								});
							}
						}),
						me.sksc('S_PLANPROJ', Ext.create('Keysystems.Controls.DictName.Edit', {
							labelWidth: me.labelWidth,
							fieldLabel: 'Проект плана',
							ksAllowEmpty: true,
							cleaningKey: false,
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									initWhereArgs: function() {
										var dh = me.gksc('DT').getValue();
										
										this.whereArgs = {
											Year: { value: dh.dh1.getFullYear(), type: 'int' },
											Subcomplex: { value: me.isVfa ? 'Vfa' : 'PlanReviz', type: 'SubcomplexType' }
										};

										return this.whereArgs;
									},
									parentView: objs.view,
									selectLinks: me.gksc('S_PLANPROJ').getValue(),
									code: dnl.S_PLANPROJ,
									readOnly: me.gksc('S_PLANPROJ').readOnly,
									accessReadOnly: me.gksc('S_PLANPROJ').readOnly
								}, {
									ok: function(value) {
										if (! value.length) return;
										
										selectDialogShow(KS.L10n.attention,
											wmc.getContinueQuestion(KS.L10n.PlanEditView_dictPlanProj_Changing_При_изменении_проекта_плана_будет_изменена_проверющая_),
											function() {
												ajaxRequest({
													url: 'SDocPlan/GetOrgDataByProj_A',
													params: {
														orgLink: value[0].get('S_ORG')
													},
													success: function(result) {
														if (result.row) {
															var orgRow = result.row,
																extName = orgRow.NAME || orgRow.SNAME || orgRow.ABBR,
																oldVal = me.gksc('S_PLANPROJ').getValue(),
																oldProjLink = oldVal[0].LINK || oldVal[0].data.LINK,
																tProjs = me.gksd('tRevizProj').filter(d => { return d.S_PLANPROJ === oldProjLink; }),
																link =  me.getLink(),
																tRevizObjects = me.gksd('tRevizObjects'),
																old = me.gksd('tRevizAudit'),
																tRevizAudit = [],
																DT = me.gksc('DT'),
																oldOrgP = DT.getOrgP();

															var val = value[0],
																org = val.get('S_ORG');
															val.set('NAME', val.get('NAME') + ' . ' + extName);
															me.gksc('S_PLANPROJ').setValue(val);
															
															tProjs[0].S_PLANPROJ = val.get('LINK');
															
															Ext.each(tRevizObjects, o => {
																tRevizAudit.push({
																	LINK: me.tRevizAuditLink--,
																	T_PLANREVIZ_OBJECTS: o.LINK,
																	PLANREVIZ: link,
																	S_ORG: org
																});
															});

															var listOrgPExt = [];
															me.gksc('S_ORG_EXT').getValue().forEach(function(item) {
																var extLink = item.LINK || item.data.LINK;
																if (extLink !== org)
																	listOrgPExt.push(item);
															});

															me.gksc('S_ORG_EXT').setValue(listOrgPExt);

															me.gksc('S_ORGP_Grid').store.loadData([orgRow]);
															me.sksd('tRevizAudit', tRevizAudit);
															
															me.gksc('objsPanel').eventTRAEdit(tRevizAudit, old);
															me.gksc('S_ORGP_Grid').extraSelectFrst();

															if (DT.nbDays && oldOrgP !== DT.getOrgP()) {
																DT.swap();
																var dtVal = DT.getValue();

																if (me.calcByRevizors()) {
																	me.setDaysByRevizors();
																} else {
																	getCntDaysInPeriod(dtVal.dh1, dtVal.dh2, DT.getOrgP(), function(val) {
																		DT.nbDays.setValue(val.workDays);
																		me.sksd('durationDay', val.allDays);
																	});
																}
															}
														}
													}
												});
											});
									}
								});
							}
						})),
						me.createDictEdit({
							key: 'S_ORG_EXT',
							mode: window.isRfn ? 'SINGL' : 'MULTI',
							code: dnl.S_ORG,
							fieldLabel: 'Привлекаемые организации',
							padding: '-2 0 10 0',
							initWhereArgs: function() {
								return {
									SType: {
										value: JSON.stringify([Ext.Object.getKey(miscTypes.TypeOrg, 'Проверяющая')]),
										type: 'List_int'
									},
									HasFilterOnLoad: {
										value: 'False',
										type: 'bool'
									},
									NotInLinks: {
										value: JSON.stringify(me.gksc('S_ORGP_Grid').store.getLinks()),
										type: 'List_int'
									}
								};
							}
						}),
						[
							me.sksc('PPLAN', Ext.create('Ext.form.field.Text', {
								fieldLabel: 'Пункт плана',
								labelWidth: me.labelWidth,
								maxLength: 10,
								ksAllowEmpty: me.modType === 'add'
							})),
							'->',
							me.sksc('CNTPERSON', Ext.create('Ext.form.field.Number', {
								fieldLabel: 'Кол-во участников',
								width: 200,
								labelWidth: 120,
								allowOnlyWhitespace: false,
								enforceMaxLength: true,
								allowDecimals: false,
								allowExponential: false,
								ksLimitMaxMin: true,
								minValue: 0,
								maxValue: 32766,
								listeners: {
									blur: function() {
										var cntDays = me.gksc('CNTPERSONDAYS').getValue(),
											cnt = me.gksc('CNTPERSON').getValue();

										if (Ext.isNumber(cntDays) && me.gksc('DT').nbDays.getValue() * cnt !== cntDays) {
											me.refCostData();
											me.recalcCntPersonsDays();
										}
									}
								}
							})),
							me.sksc('CNTPERSONDAYS', Ext.create('Ext.form.field.Number', {
								fieldLabel: 'Чел.дн',
								padding: '0 0 0 10',
								width: 150,
								labelWidth: 50,
								allowOnlyWhitespace: false,
								enforceMaxLength: true,
								allowDecimals: false,
								allowExponential: false,
								maxLength: 7,
								minValue: 0
							}))
						]
					]
				}),
				me.sksc('orgPanel', Ext.create('Ext.tab.Panel', {
					flex: 1,
					border: 0,
					cls: 'rks-panel-edit-reviz',
					bodyCls: 'rks-panel-edit-reviz-body',
					items: [
						me.sksc('S_ORGP_Panel', Ext.create('Ext.panel.Panel', {
							title: 'Проверяющие',
							bodyBorder: false,
							layout: { type: 'vbox', align: 'stretch' },
							border: 0,
							items: [
								me.sksc('S_ORGP_Grid', Ext.create('Ext.grid.Panel', {
									flex: 1,
									minHeight: 100,
									border: 0,
									multiSelect: true,
									tbar: [
										me.sksc('GeneralDictBtn', Ext.create('Ext.Button', {
											iconCls: 'x_btn_dict',
											handler: function() {
												var sOrgpGrid = me.gksc('S_ORGP_Grid'),
													dt = me.gksc('DT').getValue();

												dictFunc({
													mode: window.isRfn ? 'SINGL' : 'MULTI',
													parentView: me.getKsControl('view', true, true),
													checkList: ArrayLib.copy(sOrgpGrid.store.data.items),
													selectLinks: me.gksc('S_ORGP_Grid').selModel.getSelection(),
													preserveScrollOnRefresh: true,
													whereArgs: {
														SType: {
															value: JSON.stringify([1]),
															type: 'List_int'
														},
														DBegin: {
															value: dt.dh1.toDateString(),
															type: 'Date'
														},
														DEnd: {
															value: dt.dh2.toDateString(),
															type: 'Date'
														},
														HasFilterOnLoad: {
															value: 'false',
															type: 'bool'
														}
													},
													checkListeners: {
														beforecheckchange: function(th, rowIndex, checked, rec) {
															return !(!checked && rec.get('LINK') === me.gksc('S_ORGP_Grid').lockOrg);
														},
														checkchange: function(th, rowIndex, checked, record) {
															var link = record.get('LINK');
															if (checked && (Ext.Array.indexOf(me.gksd('lockOrgList'), link) !== -1)) {
																sOrgpGrid.lockOrg = link;
																sOrgpGrid.lockRecord = record;
																th.ownerCt.grid.view.refresh();
															}
														}
													},
													checkRenderer: function(val, meta, rec) {
														if (rec.get('LINK') === sOrgpGrid.lockOrg) meta.tdCls += ' ' + this.disabledCls;
													},
													canCheck: function(rec, checked) {
														return checked || rec.get('LINK') !== me.gksc('S_ORGP_Grid').lockOrg;
													},
													code: dnl.S_ORG
												}, {
													ok: function(value) {
														if (window.isRfn && !value.length) return;
														if (!window.isRfn && ArrayLib.find(value, ['data', 'LINK'], sOrgpGrid.lockOrg) === -1) {
															value.unshift(sOrgpGrid.lockRecord);
														}
														var del = [],
															add = [],
															i,
															len,
															j,
															jLen,
															link,
															old = me.gksd('tRevizAudit'),
															res = ArrayLib.copy(old),
															DT = me.gksc('DT'),
															oldOrgP = DT.getOrgP();

														sOrgpGrid.store.each(function(rec) {
															for (i = 0, len = value.length; i < len; i++) {
																link = value[i].data ? value[i].data.LINK : value[i].LINK;
																if (link === rec.data.LINK) {
																	return;
																}
															}
															del.push(rec.get('LINK'));
														});

														for (i = 0, len = value.length; i < len; i++) {
															link = value[i].data ? value[i].data.LINK : value[i].LINK;
															if (sOrgpGrid.store.find('LINK', link) === -1) {
																add.push(link);
															}
														}

														for (i = 0, len = del.length; i < len; i++) {
															var list = ArrayLib.filter(me.gksd('tRevizAudit'), ['S_ORG'], del[i]);
															for (j = 0, jLen = list.length; j < jLen; j++) {
																var pos = Ext.Array.indexOf(res, list[j]);
																res.splice(pos, 1);
															}
														}

														for (i = 0, len = add.length; i < len; i++) {
															for (j = 0, jLen = me.gksd('tRevizObjects').length; j < jLen; j++) {
																res.push({
																	LINK: me.tRevizAuditLink--,
																	PLANREVIZ: me.gksd('tRevizObjects')[j].PLANREVIZ,
																	T_PLANREVIZ_OBJECTS: me.gksd('tRevizObjects')[j].LINK,
																	S_ORG: add[i]
																});
															}
														}

														var listOrgPExt = [];
														me.gksc('S_ORG_EXT').getValue().forEach(function(item) {
															if (add.indexOf(item.LINK || item.data.LINK) === -1)
																listOrgPExt.push(item);
														});

														me.gksc('S_ORG_EXT').setValue(listOrgPExt);
														sOrgpGrid.store.loadData(value, false);
														me.sksd('tRevizAudit', res);
														me.gksc('objsPanel').eventTRAEdit(res, old);
														sOrgpGrid.extraSelectFrst();

														if (DT.nbDays && oldOrgP !== DT.getOrgP()) {
															DT.swap();
															var dtVal = DT.getValue();

															if (me.calcByRevizors()) {
																me.setDaysByRevizors();
															} else {
																getCntDaysInPeriod(dtVal.dh1, dtVal.dh2, DT.getOrgP(), function(val) {
																	DT.nbDays.setValue(val.workDays);
																	me.sksd('durationDay', val.allDays);
																});
															}
														}
													}
												});
											}
										})),
										me.sksc('GeneralDeleteBtn', Ext.create('Ext.Button', {
											iconCls: 'x_btn_delete',
											handler: function() {
												var grid = me.gksc('S_ORGP_Grid'),
													sels = grid.selModel.getSelection(),
													i = ArrayLib.find(sels, ['data', 'LINK'], grid.lockOrg);

												if (i !== -1) {
													sels.splice(i, 1);
												}

												var len = sels.length;
												if (len) {
													selectDialogShow(KS.L10n.delete, wmc.get('DeleteMessage', len), function () {
														var old = me.gksd('tRevizAudit'),
															res = ArrayLib.copy(old);

														for (i = 0, len = sels.length; i < len; i++) {
															var list = ArrayLib.filter(me.gksd('tRevizAudit'), ['S_ORG'], sels[i].data.LINK);
															for (var j = 0, jLen = list.length; j < jLen; j++) {
																var pos = Ext.Array.indexOf(res, list[j]);
																res.splice(pos, 1);
															}
														}

														grid.store.remove(sels);
														me.gksd('tRevizAudit', res);
														me.gksc('objsPanel').eventTRAEdit(res, old);
														me.orgPSelector(grid.getFrstSelect());
													});
												}
											}
										}))
									],
									listeners: {
										select: function(th1, record) {
											me.orgPSelector(record);
											me.gksc('GeneralDeleteBtn').setDisabled(me.gksc('S_ORGP_Grid').store.getData().length < 2);
										}
									},
									store: Ext.create('Ext.data.Store', {
										fields: ['LINK', 'CODE', 'NAME', 'S_REGION'],
										data: [],
										proxy: 'memory'
									}),
									columnLines: true,
									columns: [
										{
											text: 'Код',
											dataIndex: 'CODE',
											draggable: false,
											width: '20%'
										},
										{
											text: 'Наименование',
											dataIndex: 'NAME',
											draggable: false,
											flex: 1
										}
									],
									plugins: ['gridclipboard'],
								})),
								{ xtype: 'splitter' },
								me.sksc('revizObjs_Panel', Ext.create('Ext.panel.Panel', {
									flex: 1,
									border: 1
								}))
							]
						}))
					]
				}))
			]
		}));
	},

	orgPSelector: function(record) {
		if (!record) return;
		var me = this,
			link = record.get('LINK'),
			grid = me.gksc('S_ORGP_Grid');

		grid.lastSelect = record;
		grid.selOrg = link;

		var list = ArrayLib.filter(me.gksd('tRevizAudit'), ['S_ORG'], link),
			checks = [];

		for (var i = 0, len = list.length; i < len; i++) {
			checks.push({
				data: {
					LINK: list[i].T_PLANREVIZ_OBJECTS,
					MAIN: !!list[i].MAIN
				}
			});
		}
		var rd = me.gksc('revizObjs_Dict'),
			items = rd.Grid.store.data.items;

		//Заглушка чтобы при setChecks записи чекались
		if (checks.length !== 0) {
			rd.checkList = checks;
		}

		rd.setChecks(checks);

		//Заглушка потому что setChecks не анчекает записи которые не входят в новый checkList
		Ext.each(items, function(rec) {
			var find = ArrayLib.recordIndexOf(rd.checkList, rec);
			if (rec.get('M') && find === -1) rd.checkRecord(rec, false);
		});

		me.gksc('revizObjs_Dict').objs.Grid.view.refresh();

		if (me.gksc('planModInfo').isVisible()) {
			var links = [];
			Ext.each(grid.store.data.items, function(rec) {
				links.push(rec.data.LINK)
			});
			me.gksc('planModInfo').osnovWA.orgsP = links;
		}
	},

	//Создание грида "Проверяющие"
	getRevizObjsDict: function() {
		var me = this,
			ksControls = me.ksControls;

		return me.gksc('revizObjs_Dict') ||
			Ext.create('Keysystems.Base.List', {
				tabMode: true,
				closable: false,
				code: dnl.PLANREVIZ,
				parentView: ksControls.revizObjs_Panel,
				GateCode: 'edit',
				profileKey: 'tRevizObjectsColumns',
				selectLinks: [],
				mode: 'MULTI',
				head: false,
				hidePagging: true,
				hideTBar: true,
				pageSize: 1000,				
				//createView: function() {
					//EXTJS71 вылетает на рекурсии + на событии on при комментировании строки __createView
					//this.__createView.call(this, arguments);
					//RWEB-258 специальный хромовый костыль
					// if (Ext.isChrome) this.objs.view.on('resize', function() {
					// 	this.el.dom.style.width = '';
					// });
				//},
				checkModelChange: Ext.emptyFn,
				checkListeners: {
					beforecheckchange: function(th, rowIndex, checked) {
						var selectedOrgP = ksControls.S_ORGP_Grid.selModel.getSelection().length > 0,
							lock = !window.isRfn && ksControls.S_ORGP_Grid.selOrg === ksControls.S_ORGP_Grid.lockOrg;

						return selectedOrgP && ((checked === true && lock) || !lock);
					},
					checkchange: function(th, rowIndex, checked, record) {
						if (!me.isVisible()) return;

						var grid = ksControls.S_ORGP_Grid,
							old = me.gksd('tRevizAudit'),
							res = ArrayLib.copy(old),
							onlyOrgs = ArrayLib.filter(res, ['S_ORG'], grid.selOrg),
							selectedOrgLink = ksControls.S_ORGP_Grid.selModel.getSelection()[0].get('LINK'),
							filterByOrgC = old.filter(function(d) {
								return d.S_ORG === selectedOrgLink;
							}),
							checkPos = ArrayLib.find(filterByOrgC, ['T_PLANREVIZ_OBJECTS'], record.get('LINK'));

						if (checked && checkPos === -1) {
							res.push({
								LINK: me.tRevizAuditLink--,
								S_ORG: grid.selOrg,
								MAIN: record.get('MAIN'),
								T_PLANREVIZ_OBJECTS: record.get('LINK')
							});
						} else {
							if (checked && checkPos !== -1) return;
							var del = ArrayLib.filter(onlyOrgs, ['T_PLANREVIZ_OBJECTS'], record.get('LINK'))[0];
							if (!del) return;
							var pos = Ext.Array.indexOf(res, del);
							if (pos === -1) return;
							res.splice(pos, 1);
						}

						me.sksd('tRevizAudit', res);
						me.gksc('objsPanel').eventTRAEdit(res, old);

						// разметим проверяющую, если у нее не осталось объектов
						if (ArrayLib.find(res, ['S_ORG'], selectedOrgLink) === -1) {
							grid.store.remove(grid.getStore().data.items.filter(function(d) {
								return d.get('LINK') === selectedOrgLink;
							}));
						}
					}
				},
				checkRenderer: function(val, meta) {
					if (!window.isRfn && ksControls.S_ORGP_Grid.selOrg === ksControls.S_ORGP_Grid.lockOrg) meta.tdCls += ' ' + this.disabledCls;
				},
				
				functions: {
					getData: function(endFunc, cfg) {
						var frst = (cfg.page - 1) * cfg.pageSize,
							lst = frst + cfg.pageSize,
							data =  me.getRevizObjsDictData();

						loadProfile({
							code: 'DOCUMENT_PLANREVIZ',
							gateCode: 'edit',
							profileKey: 'tRevizObjectsColumnsGridColumns',
							callBack: function() {
								endFunc({
									columns: me.gksd('tRevizObjectsColumns'),
									fields: me.gksd('tRevizObjectsFields'),
									data: {
										data: data.slice(frst, lst),
										total: data.length
									}
								});
							}
						});
					},
					refresh: function(endFunc, cfg) {
						var frst = (cfg.page - 1) * cfg.pageSize,
							lst = frst + cfg.pageSize,
							data =  me.getRevizObjsDictData();
							//data = ArrayLib.filter(me.gksd('tRevizObjects'), ['LINK_SELF'], null);

						endFunc({
							data: data.slice(frst, lst),
							total: data.length
						});

						me.orgPSelector(me.gksc('S_ORGP_Grid').getFrstSelect());
					}
				}
			});
	},

	getRevizObjsDictData: function() {
		let me = this,
			tRevizObjects = me.gksd('tRevizObjects'),
			data = ArrayLib.filter(tRevizObjects, ['LINK_SELF'], null);

		data.forEach(r => {
			let rowChild = tRevizObjects.filter(c => c.LINK_SELF === r.LINK)[0];
			if (rowChild != null) r.TEMP_SNAME = rowChild.TEMP_NAME;
		});
		return data;
	},
	
	//конструктор таба Участники
	createTabRevizorsGrid: function() {
		var me = this;

		return Ext.create('Ext.panel.Panel',
			{
				title: 'Участники',
				layout: { type: 'vbox', align: 'stretch' },
				border: 0,
				bodyBorder: false,
				items: [
					me.sksc('RevizorsGrid',
						Ext.create('Ext.grid.Panel',
							{
								flex: 3,
								minHeight: 100,
								tbar: [
									Ext.create('Ext.Button',
										{
											iconCls: 'x_btn_add_element',
											tooltip: KS.L10n.PlanEditView_InitializeComponent_Выбрать,
											tooltipType: 'title',
											handler: function() {
												var sel = [],
													itms = me.gksc('RevizorsGrid').store.data.items,
													len = itms.length,
													i = 0,
													dh = me.gksc('DT').getValue();

												for (; i < len; i++) {
													sel.push({ data: { LINK: itms[i].data.S_PERSON } });
												}

												var orgLinks = me.gksc('S_ORGP_Grid').store.getLinks();
												if (me.objs.S_ORG_EXT.isVisible()) {
													ArrayLib.addMissing(orgLinks, me.objs.S_ORG_EXT.getLinks());
												}
												var settings = {
														parentView: me.gksc('view', true, true),
														whereArgs: {
															SOrgs: {
																value: JSON.stringify(orgLinks),
																type: 'List_int'
															},
															DH1: {
																value: dh.dh1.toDateString(),
																type: 'Date'
															},
															DH2: {
																value: dh.dh2.toDateString(),
																type: 'Date'
															},
															SWork: {
																value: me.gksc('S_WORK').getLink(),
																type: 'int'
															},
															HasFilterOnLoad: {
																value: 'False',
																type: 'bool'
															},
															RevOnly: {
																value: 'True',
																type: 'bool'
															}
														},
														selectLinks: sel,
														code: dnl.S_PERSON,
														inputDicts: [
															Ext.create('InputEditDict',
																{
																	name: 'S_ORG',
																	data: [me.gksc('S_ORGP_Grid').store.getAt(0)]
																})
														],
														setRecord: function(row, cmp) {
															cmp.data.set(row);
															var newRec = cmp.data.data;
															var pos = ArrayLib.find(itms,
																['data', 'S_PERSON'],
																newRec.LINK);

															if (pos !== -1) {
																itms[pos].data.S_PERSON = newRec.LINK;
																itms[pos].data.CODE = newRec.CODE;
																itms[pos].data.NAME = 
																	window.getTextByVisibleFields(dnl.S_PERSON, _, newRec);
																itms[pos].data.S_OTDEL = newRec.OTDELS;
																itms[pos].data.STATUS =
																	itms.length === 1
																		? me.revizorStatus.ruc
																		: me.revizorStatus.member;
															}

															me.gksc('RevizorsGrid').store.loadData(itms, true);
														}
													},
													functions = {
														ok: function(value) {
															var list = [],
																links = [],
																j = 0,
																store = me.gksc('RevizorsGrid').store,
																sppd = [],
																DT = me.gksc('DT'),
																dtVal = DT.getValue();

															for (len = value.length; j < len; j++) {
																//не использовать get
																var personLink = value[j].data.LINK;
																links.push(personLink);
																if (ArrayLib.find(itms,
																	['data', 'S_PERSON'],
																	personLink) ===
																	-1) {
																	var link = me.sPersonLink--;

																	list.push({
																		S_PERSON: personLink,
																		PLANREVIZ: me.getLink(),
																		TEMP_SPERSON_CODE: value[j].data.CODE,
																		TEMP_SPERSON_FIO: window.getTextByVisibleFields(dnl.S_PERSON, _, value[j].data),
																		STATUS: value.length === 1
																			? me.revizorStatus.ruc
																			: me.revizorStatus.member,
																		LINK: link
																	});
																	sppd.push(link);
																}
															}

															var dels = [];
															for (j = 0, len = itms.length; j < len; j++) {
																if (ArrayLib.find(value, ['data', 'LINK'], itms[j].data.S_PERSON) === -1) {
																	dels.push(itms[j]);
																}
															}

															store.remove(dels);
															store.loadData(list, true);

															if (links.length) {
																me.getPersonsOut(links, function(val) {
																	me.sksd('S_PERSON_OUT_DATA', val);
																	me.fillPersonParts(links, false, !me.gksd('nastrRevizDuration'));
																});
															} else {
																me.sksd('personPartData', {});
																me.gksc('personPartGrid').store.removeAll();
																me.personGridSelector(null);

																if (!me.gksd('nastrRevizDuration')) {
																	getCntDaysInPeriod(dtVal.dh1, dtVal.dh2, DT.getOrgP(), function(val) {
																		DT.nbDays.setValue(val.workDays);
																		me.sksd('durationDay', val.allDays);
																	});
																}
															}

															me.gksc('CNTPERSON').setValue(links.length);
															me.recalcCntPersonsDays();
															me.gksc('CNTPERSON').setDisabled(links.length);

															me.refCostData();

															if (!me.gksc('RevizorsGrid').getSelectionModel().getSelection().length) {
																me.gksc('RevizorsGrid').extraSelectFrst();
															}

															me.enableToolsInnerGrid('RevizorsGrid');
														}
													};
												dictFunc(settings, functions);
											}
										}),
									Ext.create('Ext.Button',
										{
											key: 'delete',
											iconCls: 'x_btn_delete_element',
											tooltip: KS.L10n.PlanEditView_InitializeComponent_Удалить,
											tooltipType: 'title',
											disabled: true,
											handler: function() {
												me.gksc('RevizorsGrid').removeSelection(
													function(rec) {
														delete me.gksd('personPartData')[rec.data.S_PERSON];
														var len = me.gksc('RevizorsGrid').store.data.items.length;
														if (len === 1) {
															me.gksc('personPartGrid').store.removeAll();
														}
														me.gksc('CNTPERSON').setValue(len);
														me.recalcCntPersonsDays();
														me.gksc('CNTPERSON').setDisabled(len);

														if (!me.gksd('nastrRevizDuration')) {
															if (len === 1) {
																var DT = me.gksc('DT'),
																	dtVal = DT.getValue();

																getCntDaysInPeriod(dtVal.dh1, dtVal.dh2, DT.getOrgP(), function(val) {
																	DT.nbDays.setValue(val.workDays);
																	me.sksd('durationDay', val.allDays);
																});
															} else {
																me.setDaysByRevizors();
															}
														}

														me.personGridSelector(null);

														me.refCostData();
													}, () => me.enableToolsInnerGrid('RevizorsGrid'));
											}
										}),
									Ext.create('Ext.Button',
										{
											key: 'recalc',
											iconCls: 'x_btn_calcauto',
											tooltip: wmc.get('FillPersonsPart'),
											tooltipType: 'title',											
											handler: function() {
												var personLinks = [];
												Ext.each(me.gksc('RevizorsGrid').getStore().getDataExt(),
													function(d) {
														personLinks.push(d.S_PERSON);
													});

												if (personLinks.length) {
													selectDialogShow(KS.L10n.PlanEditView_FillPersonWorkDays_Изменение_чел_дн, KS.L10n.PlanEditView_FillPersonWorkDays_Пересчитать_чел_дн_, function() {
														me.fillPersonParts(personLinks, true, !me.gksd('nastrRevizDuration'));
													}, Ext.emptyFn);
												}
											}
										})
								],
								border: 0,
								plugins: [
									Ext.create('Ext.grid.plugin.CellEditing',
										{
											clicksToEdit: 1,
											listeners: {
												beforeedit: function() {
													return !me.readOnly;
												}
											}
										}),
									'gridclipboard'
								],
								features: [
									{
										ftype: 'summary',
										showSummaryRow: false
									}
								],
								store: Ext.create('Ext.data.Store',
									{
										fields: [],
										data: [],
										proxy: 'memory'
									}),
								listeners: {
									select: function(t, record) {
										if (!me.isLoaded) me.personGridSelector(record);
									},
									selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('RevizorsGrid'), sels),
									edit: function(editor, e) {
										if (e.value === null) return _;

										var record = e.record;

										if (e.field === 'STATUS' && e.value === me.revizorStatus.ruc) {
											var f = true,
												grid = me.gksc('RevizorsGrid');

											if (record) {
												grid.store.each(function(rec) {
													if (rec !== record && rec.data.STATUS === me.revizorStatus.ruc) {
														f = false;
														return false;
													}
													return true;
												});

												if (!f) {
													info(KS.L10n.PlanEditView_CheckForSingleChief_В_мероприятии_не_может_быть_больше_одного_руководителя_);
													record.set('STATUS', me.revizorStatus.member);
													return false;
												}
											}
										}
									},
									render: function(grid) {
										let view = grid.getView();
										view.tip = Ext.create('Ext.tip.ToolTip', {
											shadow: false,
											target: view.getId(),
											delegate: view.itemSelector + ' .warningTdCls',
											trackMouse: true,
											listeners: {
												beforeshow: function updateTipBody(tip) {
													const tipGridView = tip.target.component,
														record = tipGridView.getRecord(tip.triggerElement);
													let message = record.get('TEMP_MESSAGE');													
													if (!message) return false;
													tip.update(message);
												}
											}
										});
									},
								},
								columns: [],
								columnLines: true
							})),
					{ xtype: 'splitter' },
					me.sksc('personPartGrid',
						Ext.create('Ext.grid.Panel',
							{
								flex: 2,
								userCls: 'rks-filter-panel',
								header: false,
								features: [
									{
										ftype: 'summary',
										showSummaryRow: false
									}
								],
								plugins: [
									Ext.create('Ext.grid.plugin.CellEditing',
										{
											clicksToEdit: 1,
											listeners: {
												beforeedit: function() {
													return !me.readOnly;
												}
											}
										}),
									'gridclipboard'
								],
								tbar: [
									me.sksc('btnNewPart',
										Ext.create('Ext.Button',
											{
												key: 'new',
												iconCls: 'x_btn_new',
												tooltip: KS.L10n.PlanEditView_InitializeComponent_Создать_период_участия,
												tooltipType: 'title',
												disabled: true,
												handler: function() {
													var personGrid = me.gksc('RevizorsGrid'),
														sel = personGrid.getSelectionModel().getSelection(),
														personPartGrid = me.gksc('personPartGrid'),
														partLen = personPartGrid.getStore().getDataExt().length,
														isError = false,
														org = me.gksc('DT').getOrgP();

													if (sel.length && partLen) {
														Ext.each(personPartGrid.getStore().getDataExt(),
															function(i) {
																isError |= i.get('TEMP_MESSAGE');
															});
													}

													if (sel.length && partLen && !isError) {
														sel = sel[0];
														var dh = me.gksc('DT').getValue(),
															MIN = dh.dh1,
															MAX = dh.dh2,
															curPartData = personPartGrid.store.getDataExt(),
															limit = curPartData.concat(
																me.ksData.S_PERSON_OUT_DATA[sel.get('S_PERSON')]);

														var e = me.getCorrectPeriod(limit, MIN, MAX);

														if (curPartData.length > 0 && e.DT1 === MIN && e.DT2 === MAX) {
															var minArr = [];
															Ext.each(limit,
																function(rec) {
																	minArr.push(new Date(rec.DT1));
																});
															var minEl = new Date(PeriodLib.findMinData(minArr));
															e.DT1 = new Date(minEl.setDate(minEl.getDate() - 1));
															e.DT2 = e.DT1;
															e.TEMP_MESSAGE = KS.L10n.BaseRevizUpdController_Участник_отсутствует_в_период_участия;
															e.DAYS = 0;
														}

														var endFunc = function() {
															getCntDaysInPeriod(e.DT1,
																e.DT2,
																org,
																function(value) {
																	var days = Ext.isNumber(value.workDays) ? value.workDays : 0,
																		personData = me.gksd('personPartData')[sel.get('S_PERSON')],
																		pos = ArrayLib.find(personData, ['LINK'], e.LINK),
																		gridRecs = personPartGrid.store.data.items.filter(r => {
																			return r.data.LINK === e.LINK;
																		});

																	personData[pos].DAYS = days;
																	gridRecs[0].set('DAYS', days);
																	
																	me.refCostData();

																	if (!me.gksd('nastrRevizDuration')) {
																		me.setDaysByRevizors();
																	}
																	me.sksd('isCntDaysChanged', true);
																},
																Ext.emptyFn);
														};

														// добавим визуально новый период, а затем проверим его
														me.savePersonPartData(e, 'new');
														
														if (dh.dh1 > e.DT1 || dh.dh2 < e.DT2) {
															selectDialogShow(KS.L10n.attention, 
																wmc.getString('ФИО: {0}. ', sel.get('TEMP_SPERSON_FIO')) + wmc.getContinueQuestion(KS.L10n.PlanEditView_CheckPersonPart_Период_участия_не_попадает_в_период_проведения_),
																endFunc, function() {
																	me.gksd('personPartData')[sel.get('S_PERSON')] =
																		me.gksd('personPartData')[sel.get('S_PERSON')].filter(function(d) {
																			return d.LINK !== e.LINK;
																		});

																	// если запись активировалась через редактирование ячейки, то remove(sels) не сработает
																	var delRec = personPartGrid.store.data.items.filter(
																		function(d) {
																			return d.get('LINK') === e.LINK;
																		})[0];
																	personPartGrid.store.remove(delRec);
																});
														} else {
															endFunc();
														}
													}
												}
											})),
									me.sksc('btnDeletePart',
										Ext.create('Ext.Button',
											{
												key: 'delete',
												iconCls: 'x_btn_delete',
												tooltip: KS.L10n.PlanEditView_InitializeComponent_Удалить_период_участия,
												tooltipType: 'title',
												disabled:  true,
												handler: function() {
													var personPartGrid = me.gksc('personPartGrid'),
														sels = personPartGrid.getSelectionModel().getSelection();
													if (sels.length && personPartGrid.getStore().getDataExt().length > 1) {
														selectDialogShow(KS.L10n.delete,
															KS.L10n.PlanEditView_tsbAllInnerRemove_Click_Удалить_период_участия_,
															function() {
																var selPerson = me.gksc('RevizorsGrid').getSelectionModel().getSelection();
																if (selPerson.length) {
																	var selLink = sels[0].get('LINK');

																	me.gksd('personPartData')[selPerson[0].get('S_PERSON')] =
																		me.gksd('personPartData')[selPerson[0].get('S_PERSON')].filter(function(d) {
																			return d.LINK !== selLink;
																		});

																	if (!me.gksd('nastrRevizDuration')) {
																		me.setDaysByRevizors();
																	}

																	// если запись активировалась через редактирование ячейки, то remove(sels) не сработает
																	var delRec = personPartGrid.store.data.items.filter(
																		function(d) {
																			return d.get('LINK') === selLink;
																		})[0];
																	personPartGrid.store.remove(delRec);
																	me.refCostData();

																	me.sksd('isCntDaysChanged', true);
																}
															});
													}
												}
											}))
								],
								store: Ext.create('Ext.data.Store',
									{
										fields: [],
										data: [],
										proxy: 'memory',
									}),
								listeners: {
									edit: function(editor, e) {
										var row = e.record,
											person = me.gksc('RevizorsGrid').getSelectionModel().getSelection()[0],
											dh = me.gksc('DT').getValue(),
											org = me.gksc('DT').getOrgP();

										if (+e.originalValue !== +e.value) {

											const endFunc = function() {
												// todo: можно объединить обращение в базу getCntDaysInPeriod и setDaysByRevizors
												getCntDaysInPeriod(row.data.DT1,
													row.data.DT2,
													org,
													function(value) {
														row.set('DAYS', Ext.isNumber(value.workDays) ? value.workDays : 0);

														me.refCostData();
														me.savePersonPartData(row.data, 'edit');

														if (!me.gksd('nastrRevizDuration')) {
															me.setDaysByRevizors();
														}
														me.sksd('isCntDaysChanged', true);
													},
													function() {
														row.set('DAYS', 0);
													});
											};

											if (dh.dh1 > row.data.DT1 || dh.dh2 < row.data.DT2) {
												selectDialogShow(KS.L10n.attention,
													`ФИО: ${person.get('TEMP_SPERSON_FIO')} <br />` + wmc.getContinueQuestion(KS.L10n.PlanEditView_CheckPersonPart_Период_участия_не_попадает_в_период_проведения_),
													endFunc,
													function() {
														row.set(e.field, e.originalValue);
													});
											} else {
												endFunc();
											}
										}
									},
									selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('personPartGrid'), sels),
									render: function(grid) {
										let view = grid.getView();
										view.tip = Ext.create('Ext.tip.ToolTip', {
											shadow: false,
											target: view.getId(),
											delegate: view.itemSelector + ' .warningTdCls',
											trackMouse: true,
											listeners: {
												beforeshow: function updateTipBody(tip) {
													const tipGridView = tip.target.component,
														record = tipGridView.getRecord(tip.triggerElement);													
													if (!record.get('TEMP_MESSAGE')) return false;
													tip.update(record.get('TEMP_MESSAGE'));
												}
											}
										});
									},
								},
								columnLines: true,
								columns: []
							}))
				]
			});
	},

	//конструктор таба Затраты
	createTabRNormGrid: function() {
		var me = this;

		return me.sksc('RNormGrid', Ext.create('Ext.grid.Panel', {
			title: 'Затраты',
			autoScroll: true,
			autoRender: true,
			tbar: [
				Ext.create('Ext.Button', {
					tooltip: KS.L10n.PlanEditView_InitializeComponent_Выбрать,
					tooltipType: 'title',
					iconCls: 'x_btn_add_element',
					handler: function() {
						dictFunc({
							code: dnl.S_RNORM,
							initWhereArgs: function() {
								var dt = me.gksc('DT').getValue();
								return {
									DH1: {
										value: dt.dh1.toDateString(),
										type: 'Date'
									},
									DH2: {
										value: dt.dh2.toDateString(),
										type: 'Date'
									}
								};
							},
							selectLinks: me.gksc('RNormGrid').store.getDataExt(function(d) {
								return { LINK: d.S_RNORM, CODE: d.TEMP_SRNORM_CODE, NAME: d.TEMP_SRNORM_NAME };
							})
						}, {
							ok: function(v) {
								var list = me.gksc('RNormGrid').store.getDataExt(),
									newLinks = [];

								me.bindData(list.concat(), v, list,
									function(oldList, d) {
										return ArrayLib.find(oldList, ['S_RNORM'], d.LINK);
									},
									function(d) {
										newLinks.push(me.rNormLink);
										return {
											LINK: me.rNormLink--,
											S_RNORM: d.LINK,
											TEMP_SRNORM_CODE: d.CODE,
											TEMP_SRNORM_NAME: d.NAME,
											DEFAULT_VAL: d.VAL,
											VAL: d.VAL,
											UNIT: d.UNIT
										};
									}
								);

								me.gksc('RNormGrid').loadData(list);
								me.refCostData(newLinks);

								me.enableToolsInnerGrid('RNormGrid');
							}
						});
					}
				}),
				Ext.create('Ext.Button', {
					key: 'delete',
					iconCls: 'x_btn_delete_element',
					tooltip: KS.L10n.PlanEditView_InitializeComponent_Удалить,
					tooltipType: 'title',
					disabled: true,
					handler: () => {
						me.gksc('RNormGrid').removeSelection(null, () => me.enableToolsInnerGrid('RNormGrid'));
					}
				}),
				Ext.create('Ext.Button', {
					key: 'recalc',
					iconCls: 'x_btn_calcauto',
					tooltip: KS.L10n.PlanEditView_InitializeComponent_Пересчитать,
					tooltipType: 'title',
					handler: function () {
						selectDialogShow(KS.L10n.PlanEditView_tsbAllInnerRecalc_Click_Затраты, KS.L10n.PlanEditView_tsbAllInnerRecalc_Click_Пересчитать_затраты_с_учетом_периода_проведения_КМ_, function () {
							me.refCostData();
						}, Ext.emptyFn());
					}
				})
			],
			border: 0,
			plugins: [
				Ext.create('Ext.grid.plugin.CellEditing', {
					clicksToEdit: 1,
					listeners: {
						beforeedit: function() {
							return !me.readOnly;
						}
					}
				}),
				'gridclipboard'
			],
			store: Ext.create('Ext.data.Store', {
				fields: [],
				data: [],
				proxy: 'memory'
			}),
			columns: [],
			columnLines: true,
			listeners: {
				selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('RNormGrid'), sels)
			}
		}));
	},

	//конструктор таба Реквизиты
	createTabPropGrid: function() {
		var me = this;

		return me.sksc('PropGrid', Ext.create('Keysystems.Panel.Prop', {
			parentView: me,
			decimalData: me.gksd('decimalData'),
			createTBar: function() {
				var th = this,
					tbar = th.callParent(arguments),
					tsbFillProp = th.gksc('tsbFillProp');
				
				tbar = tbar.filter(function(b) {
					return b.xtype !== 'tbseparator';
				});
				th.gksc('tsbExpand').hide();
				th.gksc('tsbCollapse').hide();
				tsbFillProp.iconCls = 'x_btn_calcauto';
				tsbFillProp.needDisable = function() {
					return !me.propWithMask.length;
				};
				tsbFillProp.tooltip = KS.L10n.PlanEditView_InitializeComponent_Пересчитать;

				// порядок
				var index = tbar.indexOf(tsbFillProp);
				if (index !== -1) {
					tbar.splice(index, 1);
					tbar.push(tsbFillProp);
				}

				return tbar;
			},
			calculateProp: me.calculateProp
		}));
	},

	createTabObjPropGrid: function() {
		var me = this;

		return me.sksc('ObjPropGrid',
			Ext.create('Keysystems.Controls.GroupingGrid',
				{
					title: 'Реквизиты объектов контроля',
					code: me.code,
					sortCol: 'ORD',
					border: 0,
					GateCode: 'edit',
					controlName: 'ObjPropGrid',
					groupLinkField: 'OBJECTS',
					groupNameField: 'NAME'
				}));
	},

	//конструктор таба Полномочий
	createTabAuthorityGrid: function() {
		var me = this,
			ksControls = me.ksControls;
		return me.sksc('AuthorityGrid',
			Ext.create('Ext.tree.Panel',
				{
					title: 'Полномочия',
					autoScroll: true,
					autoRender: true,
					autoSizeOnExpandCollapse: true,
					border: 0,
					tbar: [
						ksControls.GeneralDictBtn4 = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_add_element',
								tooltip: KS.L10n.PlanEditView_InitializeComponent_Выбрать,
								tooltipType: 'title',
								handler: function() {
									const oldData = [];
									me.gksc('AuthorityGrid').getRootNode().cascade(node =>{if (!node.isRoot()) oldData.push(node.data)});
									const sel = oldData.map(r => {
										return {data: {LINK: r.LINK}}
									});
									dictFunc({
											code: dnl.S_AUTHORITY,
											selectLinks: sel,
											initWhereArgs: function() {
												const dt = me.gksc('DT').getValue();
												return {
													DH1: {
														value: dt.dh1.toDateString(),
														type: 'Date'
													},
													DH2: {
														value: dt.dh2.toDateString(),
														type: 'Date'
													}
												};
											},
											setRecord: function(row, cmp) {
												cmp.data.set(row);
												const newRow = cmp.data.data;
												const rec = me.gksc('AuthorityGrid').store.findNode('LINK', newRow.LINK);
												if (!rec) return;
												['CODE', 'NAME', 'DH1', 'DH2', 'DTCREATE', 'USERNAME', 'USERCHANGENAME', 'IDENTIFIER'].forEach(field => rec.data[field] = newRow[field]);
												me.gksc('AuthorityGrid').view.refresh();
											}
										},
										{
											ok: function(value) {
												value = value.map(v => v.data || v);
												me.gksc('AuthorityGrid').loadDataExt(value);
											}
										});
								}
							}),
						ksControls.GeneralDeleteBtn4 = Ext.create('Ext.Button',
							{
								key: 'delete',
								iconCls: 'x_btn_delete_element',
								tooltip: KS.L10n.PlanEditView_InitializeComponent_Удалить,
								tooltipType: 'title',
								disabled: true,
								handler: function() {
									me.gksc('AuthorityGrid').removeSelection();
								}
							})
					],
					rootVisible: false,
					store: Ext.create('Ext.data.TreeStore',
						{
							fields: [],
							proxy: 'memory',
							defaultRootText: '',
							rootNode: { expanded: true, children: [] },
							sorters: ['CODE']
						}),
					columnLines: true,
					lines: true,
					rowLines: true,
					columns: [],
					listeners: {
						selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('AuthorityGrid'), sels)
					},
					plugins: ['gridclipboard']
				}));
	},

	//#endregion таб Общие

	//#region таб Финансирование

	//конструктор таба Финансирование
	createTabFinanc: function() {
		var me = this,
			isNpa = false,
			isOrg = false;
			res = me.sksc('tabFinanc', Ext.create('Ext.panel.Panel', {
				title: 'Финансирование',
				layout: { type: 'vbox', align: 'stretch' },
				flex: 1,
				border: 0,
				listeners: {
					activate: function() {
						let gridFinanc = me.gksc('FinancDict');
						gridFinanc.baseRefresh.call(gridFinanc, Ext.emptyFn, {
							GateCode: 'DOCUMENT_FINANC',
							reload: true,
							filter: '',
							page: 1,
							whereArgs: me.gksc('FinancDict').getWhereArgs(),
							pageSize: 37
						});
					}
				}
			}));

		me.sksc('FinancDict', Ext.create('Keysystems.Financ.List', {
			title: 'Финансирование',
			viewCfg: function() {
				var r = this.callParent(arguments);
				r.flex = 1;
				return r;
			},
			head: false,
			hideFilterPanel: true,
			readOnly: me.readOnly,
			flex: 1,
			tabMode: true,
			closable: false,
			visibleShowFinanc: true,
			btnsHide: {
				search: true,
				print: true,
				nastr_grid: true,
				refresh: true,
				profile: true,
				journal: true,
				relations: true,
				autofilter: true,
				batch_change: true
			},
			accessTab: me.FinancGridAccess,
			code: dnl.FINANC,
			checkModel: true,
			linkCode: 'SFinanc',
			parentView: res,
			mode: 'MULTI',
			hidePagging: true,
			pageSize: 1000,
			getWhereArgs: function() {
				var dtMoney = me.gksc('DTMONEY').getValue(),
					objLinks = [],
					npaLinks = [];

				Ext.each(me.gksd('tRevizObjects'), function(obj) {
					if (obj.TTABLE === "S_NPA") {
						npaLinks.push(obj.TLINK);
					} else {
						objLinks.push(obj.TLINK);
					}
				});

				return {
					DBegin: {
						value: dtMoney.dh1.toDateString(),
						type: 'Date'
					},
					DEnd: {
						value: dtMoney.dh2.toDateString(),
						type: 'Date'
					},
					ObjLinks: {
						value: JSON.stringify(objLinks.length ? objLinks : null),
						type: 'List_int'
					},
					NpaObjLinks: {
						value: JSON.stringify(npaLinks.length ? npaLinks : null),
						type: 'List_int'
					},
					Statuses: {
						value: JSON.stringify([objLinks.length
							? Ext.Object.getKey(miscTypes.FinancStatus, 'Исполнено')
							: Ext.Object.getKey(miscTypes.FinancStatus, '....')]),
						type: 'List_int'
					}
				};
			},
			setChecks: Ext.emptyFn,
			//todo EXTJS71 бесконечная рекурсия
			// baseGetData: function(endFunc, params) {
			// 	var th = this;
			//
			// 	th.getWhereArgs(params);			
			// 	th.__baseGetData(endFunc, params);
			// },
			beforeSetData: function(data) {
				let th = this,
					planMoney = me.gksd('planMoney'),
					d = data.data.data,
					pos = ArrayLib.find(data.columns, ['dataIndex'], 'STATUS');
				
				if (pos !== -1)
					data.columns[pos].hidden = true;
				
				d = me.adaptedFinanceData(d, planMoney);
				th.callParent(arguments);
			},
			checkModelChange: function(checked, rec) {
				var th = this,
					planMoney = me.gksd('planMoney');

				if (checked) {
					planMoney.push({
						FINANC: rec.get('LINK'),
						LINK: me.planMoney--,
						PLANREVIZ: me.getLink(),
						S_ORG: rec.get('SORGC')
					});
				} else {
					planMoney.splice(ArrayLib.find(planMoney, ['FINANC'], rec.get('LINK')), 1);
					me.sksd('planMoney', planMoney);
				}

				th.callParent(arguments);
			},
			baseRefresh: function(endFunc, params) {
				var th = this;
				if (!th.objs.Grid) return;
				if (me.gksd('tRevizObjects').length) {
					th.callParent([
						function(data) {
							th.objs.Grid.loadData(me.adaptedFinanceData(data.data, me.gksd('planMoney')));
							if (endFunc) endFunc();
						}, params
					]);
				} else {
					th.objs.Grid.loadData(me.adaptedFinanceData([], me.gksd('planMoney')));
					if (endFunc) endFunc();
				}
			},
			//Отключаем серверную сортировку
			getGridStoreCfg: function() {
				var cfg = this.callParent(arguments);
				cfg.remoteSort = false;
				return cfg;
			},
			getRowClass: function(r) {
				var statuses = [];
				var planFinancStatus = me.gksd('planFinancStatus');
				if (planFinancStatus) {
					var tLink = r.get("SORGC") || r.get('S_NPA');
					planFinancStatus.filter(rec => rec.FINANC === r.get('LINK') && rec.TLINK === tLink)
						.forEach(rec => statuses.push(rec.STATUS));
				}
				//статус 4 - проверено (серый), статус 2 либо чек - запланировано (зеленый), иначе без подсветки
				return statuses.indexOf(4) >= 0 ? 'ks-gray' : (statuses.indexOf(2) >= 0 || r.get('M') ? 'ks-greenyellow' : '');
			},
			addRevizRecord: function(rec) {
				var th = this,
					columns = me.gksc('FinancDict').Grid.visibleColumnManager.columns,
					pos = ArrayLib.find(columns, ['dataIndex'], 'M');

				if (pos !== -1) {
					columns[pos].fireEvent('checkchange', th, 0, true, rec);
				}
			},
			new: function()
			{
				let th = this;

				for (var type in miscTypes.RevizObjType) {
					Ext.each(me.gksd('tRevizObjects'), obj => {
						if ((obj.TYPE & type*1) !== 0) {
							if (['ЮЛ', 'ИП'].indexOf(miscTypes.RevizObjType[type]) !== -1) {
								isOrg = true;
							}

							if (miscTypes.RevizObjType[type] === 'НПА') {
								isNpa = true;
							}
						}
					})
				}

				if (isNpa && isOrg) {
					Ext.Msg.show({
						msg: KS.L10n.RevizEditView_AddOrEditFinInfoOkpDoc_Укажите_тип_объекта_для_факта_финансирования,
						buttons: Ext.MessageBox.YESNOCANCEL,
						buttonText: { yes: 'НПА', no: 'ЮЛ/ИП' },
						fn: function(buttonId) {
							if (buttonId === 'yes') {
								isOrg = false;
								th.edit('new', null);
							} else if (buttonId === 'no') {
								isNpa = false;
								th.edit('new', null);
							}
						}
					});
				} else {
					th.edit('new', null);
				}
			},
			functions: {
				edit: function(cfg) {
					var dh = me.gksc('DTMONEY').getValue(),
						year = dh.dh1.getFullYear();

					if (cfg.f === 'new') {
						cfg.data = {};

						// Используем именно isNpa, т.к. опрделение isOrg не включает в себя ДЛ и прочие
						let obj = {};

						for (var indx in me.ksData.tRevizObjects) {
							if (me.ksData.tRevizObjects[indx].MAIN && (isNpa && me.ksData.tRevizObjects[indx].TTABLE === 'S_NPA' ||
								!isNpa && me.ksData.tRevizObjects[indx].TTABLE !== 'S_NPA')) {
								obj = me.ksData.tRevizObjects[indx];
								break;
							}
						}

						if (Ext.Object.isEmpty(obj)) {
							obj = me.ksData.tRevizObjects.filter(revObj => isNpa && revObj.TTABLE === 'S_NPA' ||
								!isNpa && revObj.TTABLE !== 'S_NPA')[0];
						}

						if (obj) {
							cfg.data.data = {
								S_ORG_CODE: obj.TEMP_CODE,
								S_ORG_NAME: obj.TEMP_NAME,
								S_ORG: obj.TLINK
							};
						} else {
							cfg.data.data = {
								S_ORG_CODE: "",
								S_ORG_NAME: "",
								S_ORG: 0
							};
						}
						cfg.isNpa = isNpa;

						if (!isNpa) {
							cfg.revizFinancStatus = CBDataLib.get('RevizFinancStatus');
						}
					}

					cfg.data.data.DT = {
						dh1: new Date(year + '/01/01'),
						dh2: new Date(year + '/12/31')
					};
					cfg.readOnly = me.readOnly;
					Ext.create(cfg.editClass, cfg);
				},
				select: function(th, rec) {
					let gridFinanc = me.gksc('FinancDict');
					if (gridFinanc.objs.tbarBtns) {
						gridFinanc.objs.tbarBtns.edit.setKsReadOnly(false);
						gridFinanc.objs.tbarBtns.showFinanc.setKsReadOnly(rec.get('S_NPA'));
					}
				}
			}
		}));

		return res;
	},

	adaptedFinanceData: function(date1, date2) {
		var row, iPos, i = 0, len = date2.length;
		for (; i < len; i++) {
			row = date2[i];
			iPos = ArrayLib.find(date1, ['LINK'], row.FINANC);
			if (iPos !== -1) {
				date1[iPos].M = true;
				date1[iPos].REVIZMONEY = row.LINK;
			}
		}
		return date1;
	},

	//#endregion таб Финансирование

	//#region таб Версии
	createTabVersions: function() {
		var me = this;

		return me.sksc('versionsPanel', Ext.create('Ext.panel.Panel', {
			title: 'Версии (журнал событий)',
			layout: { type: 'vbox', align: 'stretch' },
			flex: 1,
			border: 0,
			items: [
				me.sksc('versionsGrid', Ext.create('Ext.grid.Panel', {
					flex: 1,
					multiSelect: true,
					tbar: [
						me.sksc('versionOpenBtn', Ext.create('Ext.Button', {
							iconCls: 'x_btn_open',
							tooltip: 'Открыть',
							tooltipType: 'title',
							disabled: true,
							handler: function() {
								me.openSnapshot(me.gksc('versionsGrid').getFrstSelect());
							}
						})),
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_refresh',
							tooltip: 'Обновить',
							tooltipType: 'title',
							handler: function() {
								me.showLoadMask({
									msg: KS.L10n.loading_data,
									view: me,
									rid: ajaxRequest({
										url: me.linkCode + '/RefreshVersions_A',
										params: { link: me.getLink() },
										success: function(res) {
											if (res && res.tabVersions) {
												me.gksc('versionsGrid').store.loadData(res.tabVersions.data);
											}
										},
										failure: function() {
											showError(wmc.get('ErrorGetData'));
										},
										callback: function() {
											me.hideLoadMask();
										}
									})
								});
							}
						})
					],
					features: [
						{
							ftype: 'summary',
							showSummaryRow: false
						}
					],
					listeners: {
						select: function(th1, rec) {
							me.gksc('versionOpenBtn').setDisabled(!rec.get('SNAPSHOT'));
						}
					},
					store: Ext.create('Ext.data.Store', {
						fields: [],
						data: [],
						proxy: 'memory'
					}),
					columnLines: true,
					columns: [],
					plugins: ['gridclipboard']
				}))
			],
			setKsReadOnly: function() {
				//нет смысли вызывать базовый метод, так как сам грид доступен только на просмотр
				return false;
			},
		}));
	},
	//#endregion таб Версии

	//#region Загрузка данных 
	getExtra: function(callBack, link) {
		var me = this;

		me.baseGetExtra({
			link: link,
			reviz: me.data && me.data.data.REVIZ || 0,
			orderLink: me.OrderLink || 0,
			appealLink: me.AppealLink || 0,
			modType: me.modType,
			whereArgs: JSON.stringify(me.whereArgs),
			needResource: true
		}, function(value) {
			if (value.ErrorMsg) {
				showError(value.ErrorMsg);
				me.isExit = true;
				LoadMask.hide();
				return;
			}

			var col,
				row = value.row,
				access = row._Access,
				tabGeneral = value.tabGeneral;

			if (!tabGeneral) {
				throw new Error('Отсутствуют права доступа на вкладку "Общие"');
			}

			if (value.revizResource) {
				Ext.apply(KS.L10n, value.revizResource);
			}
			
			me.sksd('decimalData', value.decimalData);
			me.sksd('readOnlyStatuses', tabGeneral.readOnlyStatuses);
			me.sksd('MOD_TYPE', row['MOD_TYPE']);
			me.sksd('MODIFICATION', row['MODIFICATION']);

			me.sksd('planFinancStatus', value.planFinancStatus);

			me.sksd('nastrRevizDuration', tabGeneral.NastrRevizDuration);

			if (tabGeneral.planModInfo) {
				me.gksc('planModInfo').setValue(tabGeneral.planModInfo);
				me.planModInfoReadOnly = tabGeneral.planModInfo.planModInfoReadOnly;
			}

			Ext.each(['NUMBER', 'VIEWCHANGE', 'PPLAN', 'EXTOSNOV'], function(key) {
				me.gksc(key).setValue(row[key]);
			});

			me.setObjsAccess(access, [
				'planModInfo', 'NUMBER', 'DT0', 'VIEWCHANGE', 'S_PLAN', 'objsPanel', 'S_WORK', 'S_RTEMA', 'REVIZ_VID', 'S_ROSNOV', 'docOsnov', 'EXTOSNOV', 'DT',
				'S_OTDEL', 'S_PLANPROJ', 'PPLAN', 'CNTPERSON', 'CNTPERSONDAYS', 'S_STATUS', 'RevizorsGrid', 'RNormGrid', 'PropGrid', 'AuthorityGrid'
			]);
			
			const dtMoney = me.gksc("DTMONEY");
			dtMoney.setVisible(dtMoney.ksAccessEdit = access["DTMONEY1"]);
			
			me.setObjsValues(tabGeneral, ['S_PLAN', 'S_WORK', 'S_RTEMA', 'S_ROSNOV', 'S_PLANPROJ', 'S_OTDEL', 'S_ORG_EXT']);

			const Tema = me.gksc('S_RTEMA'),
				s_rtemaValue = Tema.getValue();
			//#region Заполнить ВИД КМ
			if (!Tema.hidden && s_rtemaValue && s_rtemaValue.length) {
				const revizVid = me.gksc('REVIZ_VID');

				const sName = [];
				if (!revizVid.hidden) {
					Ext.each(s_rtemaValue, (tema) => {
						if (tema.SNAME && tema.SNAME.length) {
							sName.push(tema.SNAME);
						}
					});
					revizVid.setValue(sName.join('; '));
				}
			}

			//#endregion  Заполнить ВИД КМ 

			me.gksc('DT0').setValue(row.DT);
			me.gksc('DT').setValue(row.DT1, row.DT2);
			me.gksc('S_STATUS').store.loadData(CBDataLib.get(_, tabGeneral.status === null, tabGeneral.sStatus), false);
			me.sksd('ORDER_LINK', tabGeneral.ORDER_LINK);
			me.sksd('APPEAL_LINK', tabGeneral.APPEAL_LINK);

			me.sksd('isRfn', value.isRfn);
			me.objs.S_OTDEL.setFieldLabel(me.titleSOtdel = value.isRfn ? 'Ответственный исполнитель' : 'Подразделение');
			me.setFullObjsAccess(value.isAccess, ['S_OTDEL', 'S_ORG_EXT']);
			me.gksc('objsPanel').isType = value.RevObjTypeAccess;
			me.objs.S_OTDEL.setKsAllowEmpty(value.isRfn);

			if (me.gksc('planModInfo').modType === 'Delete') {
				var ro = me.readOnly;
				me.setReadOnly(true);

				me.gksc('saveBtn').setKsReadOnly(false);
				me.readOnly = ro;
				me.gksc('S_STATUS').setKsReadOnly(false);
			}
			if (value.tabGeneral.closedProj) {
				me.gksc('S_STATUS').setKsReadOnly(true);
			}

			me.gksc('DTMONEY').setValue(row.DTMONEY1, row.DTMONEY2);
			me.sksd('tRevizObjects', tabGeneral.tRevizObjects);
			me.sksd('tRevizAudit', tabGeneral.tRevizAudit);
			me.sksd('tRevizProj', tabGeneral.tRevizProj);

			var orgPanel = me.gksc('orgPanel');

			me.gksc('CNTPERSON').setValue(tabGeneral.CNTPERSON);
			me.gksc('CNTPERSONDAYS').setValue(tabGeneral.CNTPERSONDAYS);
			me.gksc('EXTOBJECTS').setVisible(tabGeneral.showExtObject);
			me.gksc('EXTOBJECTS').setValue(tabGeneral.EXTOBJECTS);
			me.gksc('DT').nbDays.setValue(tabGeneral.durationWork);
			me.sksd('durationDay', tabGeneral.durationDay);

			var lst = [];
			Ext.each(tabGeneral.extOsnovList, function(c) {
				lst.push([c]);
			});
			me.gksc('EXTOSNOV').store.loadData(lst, true);

			lst = [];
			Ext.each(tabGeneral.extObjectsList, function(c) {
				lst.push([c]);
			});
			me.gksc('EXTOBJECTS').store.loadData(lst, true);

			//#region Участники

			me.revizorStatus = tabGeneral.revizorStatus;
			var statusStore = [];
			for (prop in tabGeneral.revizorStatus) {
				statusStore.push(tabGeneral.revizorStatus[prop]);
			}

			me.sksd('personPartData', tabGeneral.sPersonPart.data);
			if (access.RevizorsGridAccess) {
				orgPanel.changeTab(me.getTab('RevizorsGrid'), true);

				col = ArrayLib.filter(tabGeneral.S_PERSON.columns, ['dataIndex'], 'STATUS')[0];
				if (col) {
					col.editor = {
						editable: false,
						store: statusStore,
						xtype: 'combo'
					};
				}

				col = ArrayLib.filter(tabGeneral.S_PERSON.columns, ['dataIndex'], 'DT1')[0];
				if (col) col.editor = { xtype: 'datefield', format: 'd.m.Y' };
				col = ArrayLib.filter(tabGeneral.S_PERSON.columns, ['dataIndex'], 'DT2')[0];
				if (col) col.editor = { xtype: 'datefield', format: 'd.m.Y' };

				if (ArrayLib.find(tabGeneral.S_PERSON.columns, ['dataIndex'], 'IMG_MESSAGE') === -1) {
					tabGeneral.S_PERSON.columns.unshift({
						xtype: 'actionimg',
						dataIndex: 'IMG_MESSAGE',
						imgHandler: function(grid, rec) {
							if (rec.get('TEMP_MESSAGE')) {
								warning(rec.get('TEMP_MESSAGE'));
							}
						},
						text: ' ',
						getClass: function(v, meta, rec) {
							return rec.get('TEMP_MESSAGE') ? 'x_btn_warning' : '';
						},
						tdCls: 'warningTdCls',
						index: -1
					});
				}

				const colMessage = tabGeneral.S_PERSON.columns.filter(col => col.dataIndex === "TEMP_MESSAGE")[0];
				if (colMessage) colMessage.hidden = true;
				
				me.gksc('RevizorsGrid').setMetaDate(tabGeneral.S_PERSON, {
					profileCode: me.code,
					profileKey: 'RevizorsGrid',
					gateCode: me.keyEdit
				});
				me.enableToolsInnerGrid('RevizorsGrid');
				me.sksd('S_PERSON_OUT_DATA', tabGeneral.S_PERSON.personOutData);

				//#region Периоды участия

				var cols = tabGeneral.sPersonPart.columns;
				if (cols && (ArrayLib.find(cols, ['dataIndex'], 'IMG_MESSAGE') === -1)) {
					cols.unshift({
						xtype: 'actionimg',
						dataIndex: 'IMG_MESSAGE',
						imgHandler: function(grid, rec) {
							if (rec.get('TEMP_MESSAGE')) {
								warning(rec.get('TEMP_MESSAGE'));
							}
						},
						getClass: function(v, meta, rec) {
							return rec.get('TEMP_MESSAGE') ? 'x_btn_warning' : '';
						},
						tdCls: 'warningTdCls',
						index: -1
					});
				}

				me.gksc('personPartGrid').setMetaDate(tabGeneral.sPersonPart, {
					profileCode: me.code,
					profileKey: 'personPartGrid',
					gateCode: me.keyEdit
				});

				me.checkErrorParts(me.gksc('RevizorsGrid').store.getLinks('S_PERSON'));

				//#endregion Периоды участия

				me.gksc('CNTPERSON').setDisabled(tabGeneral.S_PERSON.data.length);
			}

			//#endregion Участники

			// на случай если поменяли настройку
			if (!me.gksd('nastrRevizDuration') && me.gksc('RevizorsGrid') && me.gksc('RevizorsGrid').getStore().getDataExt().length) {
				me.setDaysByRevizors();
			} else {
				getCntDaysInPeriod(me.gksc('DT').getValue().dh1,
					me.gksc('DT').getValue().dh2,
					0,
					function(val) {
						var nbDays = me.gksc('DT').nbDays,
							disabled = nbDays.disabled;
						// затычка, чтобы не вызывать событие изменения
						nbDays.disabled = true;
						me.gksc('DT').nbDays.setValue(val.workDays);
						nbDays.disabled = disabled;
						me.sksd('durationDay', val.allDays);
					}
				);
			}

			//#region Полномочия

			if (tabGeneral.isAuthority) {
				orgPanel.changeTab(me.getTab('AuthorityGrid'), true);

				if (!tabGeneral.S_AUTHORITY.fields.filter(f=>f.name==='id')[0])
					tabGeneral.S_AUTHORITY.fields.push('id');
				if (!tabGeneral.S_AUTHORITY.fields.filter(f=>f.name==='tree')[0])
					tabGeneral.S_AUTHORITY.fields.push('tree');
				if (!tabGeneral.S_AUTHORITY.columns.filter(c=>c.dataIndex === 'tree')[0]) {					
					tabGeneral.S_AUTHORITY.columns.unshift(me.getTreeColumnCfg());
				}
				
				me.gksc('AuthorityGrid').setMetaDate(tabGeneral.S_AUTHORITY, {
					profileCode: me.code,
					profileKey: 'S_AUTHORITY_GRID',
					gateCode: me.keyEdit
				}, true);
			}

			//#endregion Полномочия

			//#region Затраты
			if (access.RNormGridAccess) {
				orgPanel.changeTab(me.getTab('RNormGrid'), true);

				col = ArrayLib.filter(tabGeneral.PLANCOST.columns, ['dataIndex'], 'VAL')[0];
				if (col) {
					col.editor = {
						xtype: 'calcfield',
						fieldLabel: '',
						decimalData: me.gksd('decimalData'),
						getValue: function() {
							return this.rawToValue(this.processRawValue(this.getRawValue()));
						}
					};
				}

				//Для сохранения первоначального значение затрат
				me.gksc('RNormGrid').setMetaDate(tabGeneral.PLANCOST, {
					profileCode: me.code,
					profileKey: 'S_RNORM_GRID',
					gateCode: me.keyEdit
				});
				me.enableToolsInnerGrid('RNormGrid');
			}
			//#endregion Затраты

			//#region Реквизиты
			if (access.PropGridAccess && tabGeneral.Prop) {
				me.propWithMask = tabGeneral.Prop.data.filter(function(d) {
					return d.MASK;
				});
				orgPanel.changeTab(me.getTab('PropGrid'), true);

				var propGrid = me.gksc('PropGrid'),
					propData = tabGeneral.Prop;

				//propGrid.ownerCt.changeTab(propGrid, propData);
				if (propData) {
					propData.AllowPropFill = true;

					propGrid.loadData(propData);
				}
			}
			//#endregion Реквизиты

			//#region Реквизиты объекта
			if (access.ObjPropAccess) {
				me.sksd('objPropAccess', access.ObjPropAccess);
				me.sksd('objProp', tabGeneral.ObjProp);
			}
			//#endregion Реквизиты объекта

			//#region Проверяющие
			var S_ORGP_Grid = me.gksc('S_ORGP_Grid');

			if (me.f === 'new') {
				//залоченная проверяющая организация
				S_ORGP_Grid.lockOrg = window.user.org.data.LINK;
				S_ORGP_Grid.lockRecord = tabGeneral.orgC[0];
			}

			me.sksd('lockOrgList', tabGeneral.lockOrgList);

			//залоченная проверяющая организация
			var checkLockFn = function(link) {
				if (Ext.Array.indexOf(me.gksd('lockOrgList'), link) !== -1) {
					if (ArrayLib.filter(me.gksd('tRevizAudit'), ['S_ORG'], link).length === ArrayLib.filter(me.gksd('tRevizObjects'), ['LINK_SELF'], null).length) {
						S_ORGP_Grid.lockOrg = link;
						S_ORGP_Grid.lockRecord = ArrayLib.filter(tabGeneral.orgC, ['LINK'], link)[0];
						return true;
					}
				}
				return false;
			};

			if (!checkLockFn(window.user.org && window.user.org.data.LINK)) {
				for (var i = 0, len = me.gksd('tRevizAudit').length; i < len; i++) {
					if (checkLockFn(me.gksd('tRevizAudit')[i].S_ORG)) break;
				}
			}

			me.sksd('tRevizObjectsColumns', tabGeneral.tRevizObjectsColumns);
			me.sksd('tRevizObjectsFields', tabGeneral.tRevizObjectsFields);
			me.sksc('revizObjs_Dict', me.getRevizObjsDict());

			S_ORGP_Grid.loadData(tabGeneral.orgC);
			Ext.create('Keysystems.Controls.Grid.ColumnManager',
				{
					inputColumns: S_ORGP_Grid.config.columns.slice(),
					code: me.code,
					profileKey: 'S_ORGP_Grid',
					gateCode: 'edit',
					grid: S_ORGP_Grid
				});

			//#endregion Проверяющие

			//#region Настройки
			me.sksd('MultiTema', tabGeneral.MultiTema);
			me.sksd('RevizObjType', tabGeneral.RevizObjType);
			me.sksd('RevizOneMain', tabGeneral.RevizOneMain);
			me.sksd('Individ', tabGeneral.Individ);
			me.sksd('RevizSelf', tabGeneral.RevizSelf);
			//Если не выбран раздел плана, то в качестве основания предлагаем только значения из настройки Плановое основание
			me.sksd('planOsnov', tabGeneral.planOsnov);
			me.sksd('allowEmptyObject', tabGeneral.allowEmptyObject);
			if (tabGeneral.allowEmptyObject) {
				me.gksc('objsPanel').labelCls = me.gksc('objsPanel').labelCls.replace('ks-AllowEmpty', '');
				me.gksc('objsPanel').setKsAllowEmpty(false);
			}
			me.sksd('planColors', value.planColors);
			me.sksd('multiObject', tabGeneral.multiObject);
			//#endregion Настройки

			//#region Объекты

			me.gksc('objsPanel').setObjsData(tabGeneral.tRevizObjsAccess, tabGeneral.type, tabGeneral.orgWhereArgs);
			//#endregion Объекты

			me.gksc('S_STATUS').setValue(tabGeneral.status);

			me.gksc('docOsnov').refresh();

			//#region Таб Финансирования

			me.FinancGridAccess = access.FinancGridAccess;
			if (access.FinancGridAccess) {
				me.sksd('planMoney', value.planMoney);
				me.add(me.getTab('Financ'));
			}

			//#endregion Таб Финансирования

			//#region Таб Версии
			if (value.tabVersions) {
				var tabVersions = value.tabVersions,
					snapShots = {},
					snapCol = {
						xtype: 'actionimg',
						dataIndex: 'SNAPSHOT',
						visible: true,
						iconCls: 'x_btn_doc',
						text: 'Файл',
						imgHandler: function(grid, rec) {
							me.openSnapshot(rec);
						}
					},
					ind = ArrayLib.find(tabVersions.columns, ['dataIndex'], 'SNAPSHOT');

				me.sksd('snapshots', snapShots);
				me.add(me.getTab('Versions'));

				if (ind !== -1) {
					tabVersions.columns[ind] = snapCol;
				} else {
					tabVersions.columns.push(snapCol);
				}

				me.gksc('versionsGrid').setMetaDate(tabVersions, {
					profileCode: me.code,
					profileKey: 'versionsGridColumns',
					gateCode: 'edit',
					controlName: 'SimplePlanVersionsTab'
				});
			}

			//#endregion Таб Версии

			me.gksc('DT').setHolidays(tabGeneral.holidaysKey, tabGeneral.holidays);
			me.sksd('vfaWorks', value.tabGeneral.vfaWorks);

			if (callBack) callBack();
		});
	},
	//#endregion Загрузка данных 

	//#region Сохранение данных
	dataCollector: function() {
		var me = this,
			res = me.callParent(arguments),
			DT = me.gksc('DT').getValue(),
			DTMONEY = me.gksc('DTMONEY').getValue(),
			whereArgs = me.whereArgs;

		res.S_PLANPROJ = me.gksc('S_PLANPROJ').getLink();
		res.S_PLAN = me.gksc('S_PLAN').getLink();
		res.S_WORK = me.gksc('S_WORK').getLink();
		res.S_ROSNOV = me.gksc('S_ROSNOV').getLink();
		res.EXTOSNOV = me.gksc('EXTOSNOV').getValue();
		res.EXTOBJECTS = me.gksc('EXTOBJECTS').getValue();
		res.PPLAN = me.gksc('PPLAN').getValue();
		res.CNTPERSON = me.gksc('CNTPERSON').getValue();
		res.DT1 = DT ? DT.dh1.toDateString() : '';
		res.DT2 = DT ? DT.dh2.toDateString() : '';
		res.DTMONEY1 = DTMONEY ? DTMONEY.dh1.toDateString() : '';
		res.DTMONEY2 = DTMONEY ? DTMONEY.dh2.toDateString() : '';
		res.CNTPERSONDAYS = me.gksc('CNTPERSONDAYS').getValue();
		res.S_STATUS = me.gksc('S_STATUS').getValue();
		res.T_REVIZ_AUDIT = JSON.stringify(me.gksd('tRevizAudit'));
		res.orgPLinks = me.gksc('S_ORGP_Grid').store.getLinks();
		res.T_REVIZ_OBJECTS = JSON.stringify(me.gksd('tRevizObjects'));
		res.T_PLANREVIZ_SPLANPROJ = JSON.stringify(me.gksd('tRevizProj'));
		res.S_RTEMA = me.gksc('S_RTEMA').getLinks();
		res.MOD_TYPE = me.gksd('MOD_TYPE');
		res.MODIFICATION = me.gksd('MODIFICATION');
		res.ORDER_LINK = me.gksd('ORDER_LINK');
		res.APPEAL_LINK = me.gksd('APPEAL_LINK');
		res.durationWork = me.gksc('DT').nbDays.getValue();
		res.durationDay = me.gksd('durationDay');

		if (me.modification) {
			var r = me.gksc('planModInfo').dataCollector();
			res.SMOSNOV = r.osnov;
			res.COMMENT = r.comment;
		}

		if (me.gksc('NUMBER')) {
			res.NUMBER = me.gksc('NUMBER').getValue();
			res.DT0 = me.gksc('DT0').getValue();
			res.VIEWCHANGE = me.gksc('VIEWCHANGE').getValue();
		}

		res.S_OTDEL = JSON.stringify(me.gksd('S_OTDEL'));
		res.planMoney = JSON.stringify(me.gksd('planMoney'));
		res.S_ORG_EXT = me.gksc('S_ORG_EXT').getLinks();

		if (me.gksc('RevizorsGrid')) {
			var sPersonData = [];

			me.gksc('RevizorsGrid').store.each(function(rec) {
				sPersonData.push({
					LINK: rec.get('LINK'),
					S_PERSON: rec.get('S_PERSON'),
					STATUS: rec.get('STATUS')
				});
			});

			res.T_PLANREVIZ_SPERSON = JSON.stringify(sPersonData);

			var sPersonPartData = [],
				data = me.gksd('personPartData');

			for (var d in data) {
				var pos = ArrayLib.find(sPersonData, ['S_PERSON'], d);
				if (pos === -1) continue;
				for (var i = 0, len = data[d].length; i < len; i++) {
					sPersonPartData.push({
						LINK: data[d][i].LINK || data[d][i].data.LINK,
						DT1: new Date(data[d][i].DT1 || data[d][i].data.DT1).toDateString(),
						DT2: new Date(data[d][i].DT2 || data[d][i].data.DT2).toDateString(),
						tRevizPerson: sPersonData[pos].LINK
					});
				}
			}

			res.PLANREVIZ_PERSON_PART = JSON.stringify(sPersonPartData);
		}

		if (me.gksc('AuthorityGrid')) {
			var sAuthorityData = [];

			me.gksc('AuthorityGrid').store.each(function(rec) {
				sAuthorityData.push({
					S_AUTHORITY: rec.get('LINK')
				});
			});

			res.T_PLANREVIZ_SAUTHORITY = JSON.stringify(sAuthorityData);
		}

		if (me.gksc('RNormGrid')) {
			var revizCost = [];
			me.gksc('RNormGrid').store.each(function(rec) {
				revizCost.push({
					LINK: rec.get('LINK'),
					S_RNORM: rec.get('S_RNORM'),
					VAL: rec.get('VAL'),
					TEMP_SRNORM_CODE: rec.get('TEMP_SRNORM_CODE'),
					TEMP_SRNORM_NAME: rec.get('TEMP_SRNORM_NAME')
				});
			});

			res.PLANCOST = JSON.stringify(revizCost);
		}

		if (me.gksc('PropGrid')) {
			res.prop = me.gksc('PropGrid').getData(1);
		}

		if (me.gksd('objPropAccess')) {
			var objProps = {};
			if (me.gksc('ObjPropGrid')) {
				Ext.each(me.gksc('ObjPropGrid').getStore().getDataExt(),
					function(d) {
						if (d.CHECKED) objProps[d.LINK] = d.ORG_PERSON;
					});
			}
			res.objProps = JSON.stringify(objProps);
		}

		if (whereArgs) {
			res.LDT1 = whereArgs.DT1.value;
			res.LDT2 = whereArgs.DT2.value;
		}

		return res;
	},

	isFilled: function() {
		var me = this,
			ksControls = me.ksControls,
			isRfn = window.isRfn;

		let res = true;
		//Обоснование внесения изменения
		if (ksControls.planModInfo.isVisible()){
			const resPlanModInfo = ksControls.planModInfo.isFilled();
			if (!resPlanModInfo.valid) {
				resPlanModInfo.invalidControls.forEach(c => me.addToInvalidControls(c));
				res = false;
			}
		}

		if (ksControls.NUMBER.isVisible() && ksControls.NUMBER.isEmpty()) {
			me.addToInvalidControls(ksControls.NUMBER);
			res = false;
		}
		if (ksControls.DT0.isVisible() && ksControls.DT0.isEmpty()) {
			me.addToInvalidControls(ksControls.DT0, {title: 'Дата приказа'});
			res = false;
		}

		//Объект
		if (!me.gksd('allowEmptyObject')) {
			if (!me.gksd('tRevizObjects').length) {
				me.addToInvalidControls(ksControls.objsPanel, {title: 'Объект контроля'});
				res = false;
			}
		} else {
			var len = me.gksd('tRevizObjects').length,
				emptyObj = !len || len === 1 && me.gksd('tRevizObjects')[0].TTABLE === '';
			if (me.modification &&
				emptyObj &&
				!me.gksc('EXTOBJECTS').hidden &&
				me.gksc('EXTOBJECTS').getValue().trim() === '') {
				me.addToInvalidControls(me.gksc('EXTOBJECTS'), {title: 'Объект контроля'});
				res = false;
			}
		}				

		if (ksControls.S_WORK.isEmpty()) {
			me.addToInvalidControls(ksControls.S_WORK);
			res = false;
		}

		if (ksControls.S_ROSNOV.isEmpty()) {
			me.addToInvalidControls(ksControls.S_ROSNOV);
			res = false;
		}

		if (ksControls.DT.isEmpty()) {
			me.addToInvalidControls(ksControls.DT);
			res = false;
		}

		if (isRfn && me.objs.S_OTDEL.isVisible() && me.objs.S_OTDEL.isEmpty()) {
			me.addToInvalidControls(me.objs.S_OTDEL);
			res = false;
		}

		if (ksControls.S_PLANPROJ.isVisible() && ksControls.S_PLANPROJ.isEmpty()) {
			me.addToInvalidControls(ksControls.S_PLANPROJ);
			res = false;
		}
		
		if (me.modType === 'add' && ksControls.PPLAN.isEmpty()) {
			me.addToInvalidControls(ksControls.PPLAN);
			res = false;
		}
		
		const gridRevizor = me.gksc('RevizorsGrid');
		if (gridRevizor && gridRevizor.store.getDataExt().length && !gridRevizor.store.getDataExt().filter(r=>r.STATUS === me.revizorStatus.ruc).length) {			
			const message = (window.isRfn ? KS.l10n.BaseRevizUpdController_CheckRevizorRuk_Не_выбран_руководитель_проверочной_группы_ : KS.L10n.BaseRevizUpdController_CheckRevizorRuk_Не_выбран_руководитель_);
			me.addToInvalidControls(me.gksc('RevizorsGrid'), {title: message.replace('!', ''), optional: true})
			me.warningMessages.push(message);
		}
		
		return res;
	},

	//метод сохранения данных
	saveData: function () {
		const me = this;
		const continueFn = ()=>{
			me.callParent(arguments);
		};
		
		if (me.gksd('isCntDaysChanged')) {
		 	me.recalcCntPersonsDays(continueFn);
		}
		else
			continueFn();
	},
	//#endregion Сохранение данных

	//селектор грида "Участники"
	personGridSelector: function(record) {
		var me = this,
			personPartGrid = me.gksc('personPartGrid'),
			personPartData = me.gksd('personPartData'),
			btnNew = personPartGrid.getToolbarItem('new');

		if (!(record && record.data)) {
			personPartGrid.store.loadData([]);
			personPartGrid.setTitle("");
			btnNew && btnNew.setDisabled(true);
			return false;
		}

		var rowCode = record.get('TEMP_SPERSON_CODE') ? '[' + record.get('TEMP_SPERSON_CODE') + '] ' : '';

		personPartGrid.setTitle(rowCode + record.get('TEMP_SPERSON_FIO'));
		btnNew && btnNew.setDisabled(false);
		
		if (!personPartData[record.get('S_PERSON')]) {
			var dh = me.gksc('DT').getValue(),
				org = me.gksc('DT').getOrgP();

			getCntDaysInPeriod(dh.dh1, dh.dh2, org, function(value) {
				personPartData[record.get('S_PERSON')] = [
					{
						DT1: dh.dh1,
						DT2: dh.dh2,
						DAYS: value.workDays,
						TEMP_MESSAGE: null,
						LINK: me.personPartLink--
					}
				];
				personPartGrid.store.loadData(personPartData[record.get('S_PERSON')], false);
			});
		} else {
			personPartGrid.store.loadData(personPartData[record.get('S_PERSON')], false);
			//Нужно для того, чтобы данные были в формате Date, а не yyyy/mm/dd
			personPartData[record.get('S_PERSON')] = personPartGrid.store.getDataExt();
		}
	},

	//Сохранение периода участия
	savePersonPartData: function(data, f) {
		var me = this,
			sel = me.gksc('RevizorsGrid').getSelectionModel().getSelection();

		if (sel.length) {
			var sPersonLink = sel[0].get('S_PERSON'),
				personData = me.gksd('personPartData')[sPersonLink];

			if (f === 'new') {
				personData.push(data);
			} else {
				var pos = ArrayLib.find(personData, ['LINK'], data.LINK);
				personData[pos] = data;
			}

			me.checkErrorParts([sPersonLink]);
		}
	},

	//Пересчитать затраты
	refCostData: function(newLinks) {
		var me = this,
			RNormGrid = me.gksc('RNormGrid');

		if (RNormGrid) {
			newLinks = newLinks || RNormGrid.store.getLinks();

			for (var i = 0, len = newLinks.length; i < len; i++) {
				var rec = ArrayLib.filter(RNormGrid.store.data.items, ['data', 'LINK'], newLinks[i])[0];
				if (rec) {
					rec.set('VAL', me.getCostVal(rec, 'DEFAULT_VAL'));
				}
			}
		}
	},

	//Получить значение для "Затраты"
	getCostVal: function(val, field) {
		var me = this,
			personPartData = me.gksd('personPartData');

		if (!field) field = 'DEFAULT_VAL';

		switch (+val.get('UNIT')) {
			case 1: //руб/чел
			case 'руб/чел':
				var len = Object.keys(personPartData).length || me.gksc('CNTPERSON').getValue();
				return val.get(field) * len;
			case 2: //руб/чел.дн
			case 'руб/чел.дн':
				var count = 0;
				for (var key in personPartData) {
					Ext.each(personPartData[key],
						function(d) {
							var dt1 = d.DT1,
								dt2 = d.DT2;

							if (dt1 && dt2) {
								count += Math.ceil((new Date(dt2) - new Date(dt1)) / (1000 * 60 * 60 * 24)) + 1;
							}
						});
				}

				if (!count)
					count = me.gksc('CNTPERSON').getValue() *
						(Math.ceil((me.gksc('DT').getValue().dh2 - me.gksc('DT').getValue().dh1) / (1000 * 60 * 60 * 24)) + 1);
				return val.get(field) * count;
			default:
				//case 0: //руб
				return val.get(field);
		}
	},
	
	enableToolsInnerGrid: function(gridKey){
		let me = this,
			grid = me.gksc(gridKey),
			sel = grid.getFrstSelect();
			
		let btnRecalc = grid.getToolbarItem('recalc');
		btnRecalc && btnRecalc.setDisabled(!grid.store.data.items.length);

		let btnDelete = grid.getToolbarItem('delete');
		btnDelete && btnDelete.setDisabled(!sel);
	},

	//Заполнить периоды участия
	fillPersonParts: function(sPersonLinks, required, calcDays) {
		var me = this,
			partData = me.gksd('personPartData'),
			outData = me.gksd('S_PERSON_OUT_DATA'),
			newPartData = {},
			dh = me.gksc('DT').getValue(),
			MIN = dh.dh1,
			MAX = dh.dh2;

		for (var key in outData) {
			outData[key] = outData[key].filter(function(d) {
				var dt1 = new Date(d.DT1),
					dt2 = new Date(d.DT2);

				// персекается ли пероид отсутствия с периодом проведения
				return dt2 >= MIN && dt1 <= MAX;
			});
		}

		for (var i = 0, len = sPersonLinks.length; i < len; i++) {
			var link = sPersonLinks[i];

			if (!required && partData[link]) {
				newPartData[link] = partData[link];
			} else {
				var correctPeriod = me.getCorrectPeriod(outData[link], MIN, MAX),
					limit = outData[link].concat(correctPeriod),
					corrPeriods = [];

				if (!(MIN > correctPeriod.DT1 || MAX < correctPeriod.DT2)) {
					corrPeriods.push(correctPeriod);

					while (PeriodLib.getPeriodsCross(correctPeriod, { DT1: MIN, DT2: MAX }, 'DT')) {
						correctPeriod = me.getCorrectPeriod(limit, MIN, MAX);
						if (MIN > correctPeriod.DT1 || (MIN === correctPeriod.DT1 && MAX === correctPeriod.DT2)) break;
						corrPeriods.push(correctPeriod);
						limit = outData[link].concat(corrPeriods);
					}
				}

				newPartData[link] = corrPeriods;
			}
		}

		var org = me.gksc('DT').getOrgP();
		getCntDaysInPeriodMany(JSON.stringify(newPartData),
			org,
			function(value) {
				for (var key in value) {
					Ext.each(value[key],
						function(v) {
							v.DT1 = new Date(v.DT1);
							v.DT2 = new Date(v.DT2);
						});
				}

				me.sksd('personPartData', value);

				var persGrid = me.gksc('RevizorsGrid'),
					persGridSel = persGrid.getSelectionModel().getSelection();

				me.personGridSelector((persGridSel.length ? persGridSel : null || persGrid.store.data.items)[0]);

				if (calcDays) {
					me.setDaysByRevizors();
				}
			});
	},

	checkObjectsForPlanReviz: function(vals, type) {
		if (!vals || !vals.length || this.isLoaded) return;
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData,
			linkSelf = me.data ? me.data.data.LINK_SELF : ksData.linkSelf;
		var tRevizObjects = [];

		for (var i = 0, len = vals.length; i < len; i++) {
			tRevizObjects.push(vals[i].data ? vals[i].data.LINK : vals[i].LINK);
		}
		if (me.FinancGridAccess)
			me.refreshPlanFinansStatus(vals);

		if (linkSelf && (type === ksData.RevizObjType.ДЛ || type === ksData.RevizObjType.ИП)) return;

		ajaxRequest({
			ignoreError: true,
			url: 'SDocPlan/CheckObjectsForReviz_A',
			timeout: 5000,
			params: {
				link: ksData.link,
				dt: ksControls.DT.getValue(1),
				tRevizObjects: tRevizObjects,
				type: type
			},
			success: function(value) {
				if (value) {
					var timerId = setInterval(function() {
						if (!Ext.Msg.isVisible()) {
							warning(value.replace('\r', '<br>'));
							clearInterval(timerId);
						}
					}, 2000);

					//В случае если пользователь тупит больше минуты то чистим интервал
					setTimeout(function() {
						clearInterval(timerId);
					}, 10000);
				}
			}
		});
	},

	changeObjProp: function(orgVals, personVals, oldVals, type) {
		if (!this.gksd('objPropAccess')) return;

		var me = this,
			objProp = me.gksd('objProp'),
			revizObjType = me.gksd('RevizObjType'),
			newOrgLinks = [],
			newPersonLinks = [],
			oldOrgLinks = [],
			oldPersonLinks = [];

		if (type === revizObjType.ФЛ) {
			personVals = orgVals;
			orgVals = [];
		}

		if (orgVals === _ && (type === revizObjType.ИП || type === revizObjType.ДЛ)) {
			orgVals = me.gksc('objsPanel')[type === revizObjType.ИП ? 'ИП_S_ORGC' : 'ДЛ_S_ORGC'].getValue();
		}
		
		Ext.each(orgVals, function(v) { newOrgLinks.push(v.data.LINK); });
		if (personVals) {
			Ext.each(personVals, function(v) { newPersonLinks.push(v.data.LINK); });
		}

		Ext.each(oldVals,
			function(v) {
				if (v.TTABLE === 'S_ORG') {
					oldOrgLinks.push(v.TLINK);
				}
				if (v.TTABLE === 'S_PERSON') {
					oldPersonLinks.push(v.TLINK);
				}
			});

		if (!me.isLoaded && ArrayLib.equal(newOrgLinks, oldOrgLinks) && ArrayLib.equal(newPersonLinks, oldPersonLinks)) return;

		var propVsbl = (newOrgLinks.length || newPersonLinks.length) && type !== revizObjType.НПА &&
			(objProp.personProp && (type === revizObjType.ФЛ || type === revizObjType.ИП) ||
				objProp.orgProp && (type === revizObjType.ЮЛ || type === revizObjType.ДЛ || type === revizObjType.ИП));

		me.gksc('orgPanel').changeTab(me.getTab('ObjPropGrid'), propVsbl);

		if (propVsbl) {
			if (!me.isLoaded || me.getLink() === 0) {
				var orgDiff = newOrgLinks.filter(function (l) { return oldOrgLinks.indexOf(l) === -1; });
				var personDiff = newPersonLinks.filter(function (l) { return oldPersonLinks.indexOf(l) === -1; });
				if (orgDiff.length || personDiff.length) {
					// если отметили новые объекты
					var selectedProps = [];
					if (me.gksc('ObjPropGrid')) {
						Ext.each(me.gksc('ObjPropGrid').getStore().getDataExt(),
							function(d) {
								if (d.CHECKED) {
									selectedProps.push(d.LINK);
								}
							});
					}

					ajaxRequest({
						url: 'SDocPlan/GetObejctProps_A',
						params: {
							orgLinks: JSON.stringify(newOrgLinks),
							personLinks: JSON.stringify(newPersonLinks),
							selectedProps: JSON.stringify(selectedProps)
						},
						success: function(value) {
							var objPropGrid = me.gksc('ObjPropGrid');

							objProp.mainData = value.mainData;
							objProp.data = value.data;
							if (me.getLink() === 0) {
								objPropGrid.setAdaptedFields(value.fields);
								objPropGrid.setColumns(value.columns);
							}
							objPropGrid.setGroupsForData(value.data, value.mainData);
						}
					});
				} else {
					// если разметили существующие
					objProp.mainData = objProp.mainData.filter(function(d) {
						var dataType = d.LINK.split('_')[1],
							link = +d.LINK.split('_')[2];
						return dataType === 'ORG' ? newOrgLinks.indexOf(link) !== -1 : newPersonLinks.indexOf(link) !== -1;
					});
					objProp.data = me.gksc('ObjPropGrid').getStore().getDataExt().filter(function(d) {
						var dataType = d.OBJECTS.split('_')[1],
							link = +d.OBJECTS.split('_')[2];
						return dataType === 'ORG' ? newOrgLinks.indexOf(link) !== -1 : newPersonLinks.indexOf(link) !== -1;
					});
					me.gksc('ObjPropGrid').setGroupsForData(objProp.data, objProp.mainData);
				}

			} else {
				var objPropGrid = me.gksc('ObjPropGrid');

				objPropGrid.setAdaptedFields(objProp.fields);
				objPropGrid.setColumns(objProp.columns);
				objPropGrid.setGroupsForData(objProp.data, objProp.mainData);

			}
		} else {
			objProp.mainData = objProp.data = [];
			me.gksc('ObjPropGrid').setGroupsForData(objProp.data, objProp.mainData);
		}
	},

	//Найти все периоды участия, которые не сходятся с периодами отсутствия
	checkErrorParts: function(sPersonLinks) {
		var me = this,
			partData = me.gksd('personPartData'),
			outData = me.gksd('S_PERSON_OUT_DATA'),
			dh = me.gksc('DT').getValue(),
			data = me.gksc('RevizorsGrid').store.data.items,
			MIN = dh.dh1,
			MAX = dh.dh2;

		for (var i = 0, len = sPersonLinks.length; i < len; i++) {
			var sPerson = sPersonLinks[i],
				outPeriod = outData[sPerson],
				partPeriod = partData[sPerson];
			persData = ArrayLib.filter(data, ['data', 'S_PERSON'], sPerson)[0];

			for (var j = 0, lenn = partPeriod.length; j < lenn; j++) {
				partPeriod[j].DT1 = new Date(partPeriod[j].DT1);
				partPeriod[j].DT2 = new Date(partPeriod[j].DT2);

				if (MIN > partPeriod[j].DT1 || MAX < partPeriod[j].DT2) {
					partPeriod[j].TEMP_MESSAGE = KS.L10n.BaseRevizUpdController_Период_участия_не_попадает_в_период_проведения_;
					continue;
				}

				let bad = false;
				Ext.each(outPeriod, function(out) {
					if (PeriodLib.getPeriodsCross(partPeriod[j], out, 'DT', true)) {
						bad = true;
						return false;
					}
				});				
				partPeriod[j].TEMP_MESSAGE = bad ? KS.L10n.BaseRevizUpdController_Участник_отсутствует_в_период_участия : '';
			}
		}

		var selPerson = me.gksc('RevizorsGrid').getSelectionModel().getSelection()[0];
		if (selPerson) me.personGridSelector(selPerson);
	},

	//Получить все актуальные периоды участия и отсутствия по линкам
	getPersonsOut: function(links, endFunc) {
		let me = this;
			
		if (links && links.length) {
			me.showLoadMask({
				msg: KS.L10n.updating_data,
				view: this.gksc('personPartGrid', true, true).view,
				rid: ajaxRequest({
					url: 'SPerson/GetSPersonsOut_A',
					params: { links: links },
					ignoreError: true,
					success: function(value) {
						me.hideLoadMask();
						if (value && endFunc) endFunc(value);
					},
					failure: function() {
						me.hideLoadMask();
					}
				})
			});
		} else {
			if (endFunc) endFunc([]);
		}
	},

	//Подсчет периодов участия, учитывая период отсутствия. limit - массив с ограничениями (уже созданные периоды или периоды отсутствия)
	getCorrectPeriod: function(limit, MIN, MAX) {
		var minArr = [],
			maxArr = [];

		minArr.push(MIN);
		maxArr.push(MAX);
		Ext.each(limit, function(rec) {
			var d = rec.DT1;
			minArr.push(new Date(d));
			d = rec.DT2;
			maxArr.push(new Date(d));
		});

		var period = PeriodLib.findMinMaxPeriod(minArr, maxArr, MAX, MIN),
			min = period.min,
			max = period.max,
			e = { DAYS: 0, TEMP_MESSAGE: null };

		if ((Ext.Date.isEqual(min, MIN) && Ext.Date.isEqual(max, MAX) && limit.length > 0) || (max < MIN) || (min < MIN)) {
			var minEl = new Date(PeriodLib.findMinData(minArr));
			e.DT1 = new Date(minEl.setDate(minEl.getDate() - 1));
			e.DT2 = e.DT1;
		} else {
			e.DT1 = min > max ? PeriodLib.findMinData(minArr) : min;
			e.DT2 = max > MAX ? MAX : max;
		}

		if (min < MIN && max === MAX || limit.length === 0) {
			e.DT1 = MIN;
			e.DT2 = MAX;
		}
		e.LINK = this.personPartLink--;

		return e;
	},

	calcByRevizors: function() {
		var me = this;

		return !me.gksd('nastrRevizDuration') && Object.keys(me.gksd('personPartData')).length;
	},

	setDaysByRevizors: function() {
		var me = this,
			personPartData = me.gksd('personPartData'),
			partData = [],
			org = me.gksc('DT').getOrgP();

		// отсортируем и не учитваем периоды, где DT1 > DT2
		for (var key in personPartData) {
			Ext.each(personPartData[key],
				function(d) {
					if (d.DT1 < d.DT2) partData.push({ DT1: d.DT1, DT2: d.DT2 });
				});
		}

		partData.sort(function(p1, p2) {
			return p1.DT1 - p2.DT1;
		});

		ajaxRequest({
			url: 'SReviz/GetDaysByRevizors_A',
			params: {
				periods: JSON.stringify(partData),
				sOrg: org
			},
			success: function(value) {
				me.gksc('DT').nbDays.setValue(value.workDays);
				me.sksd('durationDay', value.allDays);
			}
		});
	},

	//Пересчитать чел.дн
	//continueFn - функция, которая в IsFilled передаётся
	recalcCntPersonsDays: function(continueFn = Ext.emptyFn) {
		var me = this;

		selectDialogShow(KS.L10n.PlanEditView_FillPersonWorkDays_Изменение_чел_дн, KS.L10n.PlanEditView_FillPersonWorkDays_Пересчитать_чел_дн_, function () {
			var personPartData = me.gksd('personPartData'),
				newCntDays = 0;

			if (me.gksc('CNTPERSON').disabled) {

				for (var key in personPartData) {
					Ext.each(personPartData[key], function(personPart) {
						newCntDays += personPart.DAYS;
					});
				}
			} else {
				newCntDays = me.gksc('CNTPERSON').getValue() * me.gksc('DT').nbDays.getValue();
			}

			me.gksc('CNTPERSONDAYS').setValue(newCntDays);
			me.sksd('isCntDaysChanged', false);
			continueFn();
		}, continueFn);
	},

	//Пересчет реквизитов
	calculateProp: function() {
		var me = this,
			parentView = me.parentView,
			sel = me.propPanel.getSelectionModel().getSelection(),
			newData = parentView.dataCollector(),
			data = parentView.oldData !== JSON.stringify(newData) ? newData : '',
			calcFn = function(links) {
				parentView.showLoadMask({
					msg: 'Пересчёт реквизитов...',
					rid: ajaxRequest({
						url: 'SCalc/FillPropByMask_A',
						params: {
							code: parentView.code,
							link: me.parentView.ksData.link,
							data: SignalR.pack(data),
							sProps: JSON.stringify(links)
						},
						success: function(result) {
							if (result) {
								for (var key in result) {
									if (result[key] !== '') {
										var rec = me.propPanel.store.getRecord(key);
										if (rec) {
											var val = result[key],
												isDict = false;
											switch (miscTypes.CalcType[rec.data.TEMP_SPROP_TYPE]) {
												case 'Флаг':
													val = val.toLowerCase();
													break;
												case 'Список':
													var list = rec.get('LIST').split('\r\n');
													val = list[val];
													break;
												case 'Справочник':
													isDict = true;
													break;
											}
											if (isDict) {
												rec.set('VAL', val ? val.LINK : '');
												rec.set('VAL_CODE', val ?val.CODE : '');
												rec.set('VAL_NAME', val ?val.NAME : '');
											} else {
												rec.set('VAL', val);
											}

											me.propPanel.view.refresh();
										}
									}
								}
							}
						},
						failure: function() {
							showError('Ошибка при пересчете реквизитов');
						},
						callback: function() {
							parentView.hideLoadMask();
						}
					})
				});
			};

		if (sel.length) {
			Ext.Msg.show({
				title: KS.L10n.PlanEditView_tsbAllInnerRecalc_Click_Реквизиты,
				buttons: Ext.MessageBox.YESNOCANCEL,
				buttonText: { yes: 'Да', no: 'Текущий', cancel: 'Нет' },
				msg: KS.L10n.PlanEditView_tsbAllInnerRecalc_Click_Пересчитать_реквизиты_,
				fn: function(buttonId) {
					if (buttonId === 'yes') {
						const links = me.propPanel.getStore().getDataExt().map(r => r.S_PROP);
						calcFn(links);
					}
					if (buttonId === 'no') {
						calcFn([sel[0].get('S_PROP')]);
					}
				},
				icon: Ext.MessageBox.QUESTION
			});
		}
	},

	//Открыть snapshot
	openSnapshot: function(rec) {
		let snapshotHtml = rec.get('SNAPSHOT'),
			code = this.code;
		Ext.create('Ext.window.Window', {
			height: 600,
			width: 800,
			minHeight: 600,
			minWidth: 800,
			modal: true,
			maximizable: true,
			scrollable: true,
			items: [
				Ext.create('Ext.panel.Panel', {
					layout: 'fit',
					border: 0,
					bodyStyle: 'border:0; padding: 0 5px;',
					html: snapshotHtml,
					tbar: [
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_save',
							tooltip: 'Сохранить',
							tooltipType: 'title',
							handler: function () {
								let uploader = Ext.create('Keysystems.Uploader.DataUploader', {
									parseUrl: function (url) {
										return urlPrefix + parsUrl(url);
									}
								});
								uploader.getFileFromSnapshot(code, rec.get('LINK'));
							}
						}),
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_print',
							tooltip: 'Печать',
							tooltipType: 'title',
							handler: function () {
								let win = window.open('', 'snapshot');
								win.document.open();
								win.document.write(snapshotHtml);
								win.document.close();
								win.print();
							}
						})
					]
				})
			]
		}).show();
	},
	setReadOnly: function(v, reason, fake) {
		var me = this;

		var sr = me.mixins['Keysystems.Base.Edit'].setReadOnly;
		sr.call(me, v, reason, fake);

		me.gksc('DT').nbDays.setDisabled(v || !me.gksd('nastrRevizDuration'));

		me.gksc('objsPanel').setReadOnly(v);

		if (me.modification) {
			me.gksc('planModInfo').setReadOnly(me.planModInfoReadOnly ||
				me.gksd('readOnlyStatuses').indexOf(me.gksc('S_STATUS').getValue()) !== -1);
		}

		// Доступность кнопок грида Финансирования при изменении статуса планирования
		if (me.FinancGridAccess) {
			var dictFinanc = me.gksc('FinancDict');
			dictFinanc.setAccess(v);
			dictFinanc.setReadOnly(v || me.FinancGridAccess === 1);
			if (dictFinanc.objs.tbarBtns) dictFinanc.objs.tbarBtns.showFinanc.setKsReadOnly(false);
		}
	},

	afterClose: function() {
		var me = this;

		if (me.f === 'new' && me.modType === 'add') {
			// удаляем проект без пунктов плана
			ajaxRequest({
				url: 'SPlanMod/CheckForDel_A',
				params: {
					projLink: me.gksc('S_PLANPROJ').getLink()
				}
			});
		}
	},

	refreshPlanFinansStatus: function(vals) {
		if (!vals || !vals.length || this.isLoaded) return;
		var me = this,
			ksControls = me.ksControls,
			tRevizObjects = [];

		for (var i = 0, len = vals.length; i < len; i++) {
			tRevizObjects.push((vals[i].data || vals[i]).LINK);
		}

		ajaxRequest({
			ignoreError: true,
			url: 'SDocPlan/GetPlanFinancStatus_A',
			timeout: 5000,
			params: {
				dt: ksControls.DT.getValue(1),
				dtMoney: ksControls.DTMONEY.getValue(1),
				tRevizObjects: tRevizObjects,
				isOrg: !Ext.Array.contains(me.gksc('objsPanel').visibleObjs, 'НПА')
			},
			success: function(value) {
				if (value) {
					me.sksd('planFinancStatus', value);
					var dictFinanc = me.gksc('FinancDict');
					if (dictFinanc) dictFinanc.Grid.view.refresh();
				}
			}
		});
	},
	
	successSaveFunc: function(result, endFunc, params) {
		let me = this;
		
		me.callParent(arguments);
		
		if (result.tabVersions) {
			me.gksc('versionsGrid').getStore().loadData(result.tabVersions.data);
		}
	}
});