﻿Ext.define('Keysystems.OuterReviz.List', {
	extend: 'Keysystems.Base.List',
	startYear: (new Date()).getFullYear(),
	bodyPadding: 10,
	labelWidth: 150,
	title: 'Проверки внешних КНО',
	deleteCode: 'DOCUMENT_OUTER_REVIZ',

	profileListeners: [{ name: 'DT', method: 'KsPeriodChange' }],

	/*viewCfg: function() {
		var cfg = this.callParent(arguments);
		cfg.layout = { type: 'vbox', align: 'stretch' };
		return cfg;
	},*/
	
	setWhereArgs: function(d1, d2) {
		if (!Ext.isDate(d1)) d1 = longPeriod.begin;
		if (!Ext.isDate(d2)) d2 = longPeriod.end;

		let me = this,
			whereArgs = {
				DBegin: { value: d1.toDateString(), type: 'Date' },
				DEnd: { value: d2.toDateString(), type: 'Date' }
			};

		return Ext.apply(me.whereArgs, whereArgs);
	},
	createItems: function() {
		var me = this,
			objs = me.objs,
			d1 = new Date(me.startYear, 1, 1),
			d2 = new Date(me.startYear, 11, 31),
			items = me.callParent(arguments);

		me.isCreate = true;
		items.unshift(Ext.create('Ext.panel.Panel', {
			collapsible: !me.hideBottomPanel,
			bodyPadding: !me.hideBottomPanel ? me.bodyPadding : (me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding),
			border: 0,
			bodyBorder: 0,
			userCls: 'rks-filter-panel',
			header: {
				title: 'Фильтр по Внешним проверкам',
				hidden: me.hideBottomPanel,
			},
			animCollapse: false,
			items: [
				objs.DT = Ext.create('Keysystems.Controls.KsPeriod', {
					width: 400,
					state: 4,
					allStates: 12,
					listeners: {
						ksChange: function (dh1, dh2) {
							if (!me.isCreate) {
								me.setWhereArgs(dh1, dh2);
								me.refresh();
							}
						}
					}
				})
			]
		}));

		objs.DT.setValue(d1, d2);
		me.isCreate = false;

		return items;
	},
	getGridCfg: function(){
		let res = this.callParent(arguments);
		res.userCls = 'rks-grid-with-filter-panel';
		return res;
	},
});