﻿Ext.define('Keysystems.OuterReviz.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Внешняя проверка',
	linkCode: 'SOuterReviz',
	labelWidth: 100,
	f: 'new',
	profilePrefix: 'Outer.Reviz',
	narRemLink: -1,
	kbkLink: -1,
	bodyPadding: 0,
	viewMinSize: [800, 600],
	createItems: function() {
		let me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			flex: 1,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: me.objs.items = [me.getTab('General'), me.getTab('Result'), me.getTab('NarRemove')]
		});
	},

	//конструктор таба Общие
	createTabGeneral: function() {
		var me = this,
			objs = me.objs;

		return objs.tabGeneral = Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			flex: 1,
			border: 0,
			items: [
				objs.S_ORGC_Label = Ext.create('Ext.form.Label', { text: '', padding: '0 0 10 0' }),
				objs.S_ORGP = Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Проверяющая организация',
					margin: '0 0 10 0',
					ksAllowEmpty: true,
					handler: function() {
						dictFunc({
							mode: 'SINGL',
							parentView: objs.view,
							selectLinks: objs.S_ORGP.getValue(),
							typeOrg: 1,
							whereArgs: {
								SType: { value: '[1]', type: 'List_int' },
								HasFilterOnLoad: { value: 'false', type: 'bool' }
							},
							accessReadOnly: true,
							code: 'DICTIONARY_SORG',
							readOnly: objs.S_ORGP.readOnly,
							control: objs.S_ORGP,
							contextSearch: objs.S_ORGP.contextSearch
						}, {
							ok: function(v) { objs.S_ORGP.setValue(v); }
						});
					}
				}),
				Ext.create('Ext.form.FieldContainer', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Вид и форма проверки',
					
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						objs.ROSNOV = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							flex: 1,
							value: 1,
							queryMode: 'local',
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: CBDataLib.get('OuterRevizROsnov'),
								proxy: 'memory'
							})
						}),
						objs.WORK = Ext.create('Ext.form.field.ComboBox', {
							editable: false,
							padding: '0 0 0 10',
							flex: 1,
							value: 2,
							queryMode: 'local',
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: CBDataLib.get('OuterRevizWork'),
								proxy: 'memory'
							})
						}),
						objs.TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra', {
							editable: false,
							padding: '0 0 0 10',
							flex: 1,
							value: null,
							queryMode: 'local',
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: Ext.create('Ext.data.Store', {
								fields: CBDataLib.getFields(),
								data: CBDataLib.get('OuterRevizType', 1),
								proxy: 'memory'
							})
						})
					]
				}),
				objs.RTEMA = Ext.create('Ext.form.field.TextArea', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Тема',
					padding: '0 0 10 0',
					enforceMaxLength: true,
					maxLength: 2000,
					flex: 1
				}),
				Ext.create('Ext.form.FieldContainer', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Перечень проверяемых направлений',
					layout: { type: 'hbox', align: 'stretch' },
					flex: 2,
					items: [
						objs.OUTER_REVIZ_DIRECTION = Ext.create('Ext.grid.Panel', {
							autoScroll: true,
							autoRender: true,
							plugins: [Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }), 'gridclipboard'],
							columns: [],
							bodyCls: 'rks-panel-border',
							tbar: [
								Ext.create('Ext.Button', {
									key: 'new',
									iconCls: 'x_btn_new',
									tooltip: 'Создать',
									tooltipType: 'title',
									handler: function() {
										let rec = objs.OUTER_REVIZ_DIRECTION.store.add({ ORD: objs.OUTER_REVIZ_DIRECTION.store.getMaxOrd() + 1 });
										objs.OUTER_REVIZ_DIRECTION.getSelectionModel().select(rec);										
									}
								}),
								Ext.create('Ext.Button', {
									key: 'delete',
									iconCls: 'x_btn_delete',
									tooltip: 'Удалить',
									tooltipType: 'title',
									disabled: true,
									handler: function() {
										objs.OUTER_REVIZ_DIRECTION.removeSelection(function(rec) {
											var ord = rec.get('ORD');
											objs.OUTER_REVIZ_DIRECTION.store.each(function(r) {
												var o = r.get('ORD');
												if (o > ord) r.set('ORD', o - 1);
											});
										});
									}
								})
							],
							store: Ext.create('Ext.data.Store', {
								fields: ['ORD', 'DIRECTION'],
								data: [],
								proxy: 'memory',
								sorters: [{ property: 'ORD', direction: 'ASC' }],
								getMaxOrd: function() {
									var max = 0;
									this.each(function(rec) {
										var o = rec.get('ORD');
										if (o > max) max = o;
									});
									return max;
								}
							}),
							columnLines: true,
							flex: 1,
							listeners: {
								selectionchange: (_, sels) => me.enableToolsGrid(objs.OUTER_REVIZ_DIRECTION, sels)
							}
						})
					]
				}),
				objs.EXTOSNOV = Ext.create('Ext.form.field.TextArea', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Основание',
					enforceMaxLength: true,
					maxLength: 2000,
					flex: 1
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'stretch' },
					padding: '10 0 0 0',
					items: [
						objs.DT = Ext.create('Keysystems.Controls.PeriodEdit', {
							labelWidth: me.labelWidth,
							flex: 1,
							cfgDh: { emptyText: '' },
							fieldLabel: 'Период проведения',
							getOrgP: function () { return objs.S_ORGP.getLink() }
						}),
						objs.DTMONEY = Ext.create('Keysystems.Controls.PeriodEdit', {
							padding: '0 0 0 40',
							labelWidth: me.labelWidth,
							flex: 1,
							cfgDh: { emptyText: '' },
							fieldLabel: 'Проверяемый период',
							getOrgP: function () { return objs.S_ORGP.getLink() }
						})
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Участники',
					layout: { type: 'hbox', align: 'stretch' },
					flex: 2,
					items: [
						objs.OUTER_REVIZ_PERSON = Ext.create('Ext.grid.Panel', {
							autoScroll: true,
							autoRender: true,
							plugins: [Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }), 'gridclipboard'],
							columns: [],
							bodyCls: 'rks-panel-border',
							tbar: [
								Ext.create('Ext.Button', {
									key: 'new',
									iconCls: 'x_btn_new',
									tooltip: 'Создать',
									tooltipType: 'title',
									handler: () => {
										let rec = objs.OUTER_REVIZ_PERSON.store.add({});
										objs.OUTER_REVIZ_PERSON.getSelectionModel().select(rec);
									}
								}),
								Ext.create('Ext.Button', {
									key: 'same',
									iconCls: 'x_btn_copy',
									tooltip: 'Создать подобную',
									tooltipType: 'title',
									disabled: true,
									handler: function() {
										let sel = objs.OUTER_REVIZ_PERSON.getFrstSelect();
										if (!sel) return;
										let data = sel.getData();
										delete data.id;
										sel = objs.OUTER_REVIZ_PERSON.store.add(data);
										objs.OUTER_REVIZ_PERSON.getSelectionModel().select(sel);
									}
								}),
								Ext.create('Ext.Button', {
									key: 'delete',
									iconCls: 'x_btn_delete',
									tooltip: 'Удалить',
									tooltipType: 'title',
									disabled: true,
									handler: function() { objs.OUTER_REVIZ_PERSON.removeSelection(); }
								})
							],
							store: Ext.create('Ext.data.Store', {
								fields: [],
								data: [],
								proxy: 'memory'
							}),
							columnLines: true,
							flex: 1,
							listeners: {
								selectionchange: (_, sels) => me.enableToolsGrid(objs.OUTER_REVIZ_PERSON, sels)
							}
						})
					]
				})
			]
		});
	},

	//конструктор таба Результаты проверки
	createTabResult: function() {
		var me = this,
			objs = me.objs,
			narLink = -1,
			editFn = function(token, rec) {
				if (token !== 'new' && !rec) {
					rec = objs.OUTER_FACTNAR.getSelectionModel().getSelection();
					if (rec.length) rec = rec[0];
					else return;
				}

				var now = new Date((new Date).toDateString()),
					dtEnd = objs.DT.getValue().dh2;
				Ext.create('Keysystems.OuterReviz.Edit.FactNar', {
					f: token,
					data: rec,
					dtDetect: now < dtEnd ? now : dtEnd,
					dt: objs.DT.getValue(),
					dtMoney: objs.DTMONEY.getValue(),
					Thousands: objs.Thousands,
					kbk: {
						columns: JSON.parse(objs.OUTER_FACTNAR_KBK.columns),
						fields: JSON.parse(objs.OUTER_FACTNAR_KBK.fields),
						//columns: objs.OUTER_FACTNAR_KBK.columns,
						//fields: objs.OUTER_FACTNAR_KBK.fields,
						data: ArrayLib.filter(objs.OUTER_FACTNAR_KBK.data, ['OUTER_FACTNAR'], rec ? rec.get('LINK') : 0),
						svbudjData: objs.OUTER_FACTNAR_KBK.svbudjData
					},
					S_ORGP: [user.org],
					decimalData: me.decimalData,
					personWhereArgs: { SOrgs: { value: JSON.stringify([user.org.data.LINK]), type: 'List_int' } },
					readOnly: me.readOnly,
					baseSaveData: function(params, callBack) {
						if (!params.link) this.objs.link = params.link = narLink--;
						this.oldData = JSON.stringify(params);
						params.LINK = params.link;
						if (rec) {
							rec.set(params);
						} else {
							rec = objs.OUTER_FACTNAR.store.createModel(params);
							objs.OUTER_FACTNAR.store.loadData([rec], true);

							me.getTab('NarRemove').store.add({ OUTER_FACTNAR: rec.get('LINK'), LINK: me.narRemLink-- });
						}

						me.bindData(
							ArrayLib.filter(objs.OUTER_FACTNAR_KBK.data, ['OUTER_FACTNAR'], rec.get('LINK')),
							params.kbk,
							objs.OUTER_FACTNAR_KBK.data,
							function(l, d) { return ArrayLib.find(l, ['LINK'], d.LINK); },
							function(d) {
								d.OUTER_FACTNAR = rec.get('LINK');
								d.LINK = me.kbkLink--;
								return d;
							},
							function(r, d) {
								r.KBK = d.KBK;
								r.SUMMA = d.SUMMA;
								r.S_VBUDJ = d.S_VBUDJ;
							}
						);

						this.f = 'edit';
						
						QuickMsgs.save();

						if (callBack) callBack();
					}
				});
			},
			items = [
				objs.OUTER_FACTNAR = Ext.create('Ext.grid.Panel', {
					title: 'Нарушения',
					userCls: 'rks-filter-panel',
					autoScroll: true,
					autoRender: true,
					columns: [],
					tbar: [
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_new',
							tooltip: 'Создать',
							tooltipType: 'title',
							handler: function() { editFn('new'); }
						}),
						objs.btnEditNar = Ext.create('Ext.Button', {
							iconCls: 'x_btn_edit',
							tooltip: 'Редактировать',
							disabled: true,
							tooltipType: 'title',
							handler: function() { editFn('edit'); }
						}),
						objs.btnDelNar = Ext.create('Ext.Button', {
							iconCls: 'x_btn_delete',
							tooltip: 'Удалить',
							disabled: true,
							tooltipType: 'title',
							handler: function() {
								objs.OUTER_FACTNAR.removeSelection(function(r) {
									var s = me.getTab('NarRemove').store,
										indx = s.find('OUTER_FACTNAR', r.get('LINK'));
									if (indx !== -1) s.removeAt(indx);
								});
							}
						})
					],
					store: Ext.create('Ext.data.Store', {
						fields: [],
						data: [],
						proxy: 'memory'
					}),
					columnLines: true,
					listeners: {
						itemdblclick: function(th1, record) { editFn('edit', record); },
						selectionchange: function(th, sels) {
							objs.btnEditNar.setDisabled(!sels[0]);
							objs.btnDelNar.setDisabled(!sels[0]);
						}
					},
					flex: 1,
					plugins: ['gridclipboard']
				}),
				objs.OUTER_DOCUMENTS = Ext.create('Ext.grid.Panel', {
					title: 'Документы',
					autoScroll: true,
					autoRender: true,
					userCls: 'rks-filter-panel',
					plugins: [Ext.create('Keysystems.grid.plugin.RowEditing', { listeners: { beforeedit: function() { return !objs.isDisable; } } }), 'gridclipboard'],
					columns: [],
					listeners: { selectionchange: function(th, sels) { me.docselectionchange(sels[0]); } },
					tbar: [
						objs.btnNewDoc = Ext.create('Ext.Button', {
							iconCls: 'x_btn_new',
							tooltip: 'Создать',
							tooltipType: 'title',
							disabled: true,
							handler: function() {
								var sel = objs.OUTER_DOCUMENTS.getSelectionModel().getSelection()[0];
								if (!sel) return;
								objs.OUTER_DOCUMENTS.store.add({
									S_DOCVID: sel.get('S_DOCVID'),
									TEMP_SDOCVID_NAME: sel.get('TEMP_SDOCVID_NAME'),
									S_DOCVID_ORD: sel.get('S_DOCVID_ORD')
								});
							}
						}),
						objs.btnDelDoc = Ext.create('Ext.Button', {
							iconCls: 'x_btn_delete',
							tooltip: 'Удалить',
							tooltipType: 'title',
							disabled: true,
							handler: function() {
								objs.OUTER_DOCUMENTS.removeSelection(function(rec) {
									return ArrayLib.filter(objs.OUTER_DOCUMENTS.store.data.items, ['data', 'S_DOCVID'], rec.data.S_DOCVID).length > 1;
								});
							}
						}),
						'-',
						objs.btnFile = Ext.create('Ext.Button', {
							key: 'template',
							text: 'Файл',
							disabled: true,
							handler: function () {
								let sel = objs.OUTER_DOCUMENTS.getFrstSelect();
								if (sel) me.fileGridEdit(sel);
							}
						})
					],
					store: Ext.create('Ext.data.Store', {
						fields: [],
						data: [],
						sorters: [{ property: 'S_DOCVID_ORD', direction: 'ASC' }],
						proxy: 'memory'
					}),
					columnLines: true,
					flex: 1
				})
			];

		return objs.tabResult = Ext.create('Ext.panel.Panel', {
			title: 'Результаты проверки',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			items: items
		});
	},

	//конструктор таба План устранения
	createTabNarRemove: function() {
		var me = this,
			objs = me.objs;

		return objs.tabNarRemove = Ext.create('Ext.grid.Panel', {
			title: 'План устранения',
			autoScroll: true,
			autoRender: true,
			border: 0,
			columns: me.getNarRemoveColumns(),
			plugins: [Ext.create('Keysystems.grid.plugin.RowEditing'), 'gridclipboard'],
			store: Ext.create('Ext.data.Store', {
				fields: ['LINK', 'OUTER_FACTNAR', 'CONTENT', 'DTSROK', 'DTDONE'],
				data: [{}],
				proxy: 'memory'
			}),
			columnLines: true
		});
	},

	getFactNarRec: function(link) {
		var store = this.objs.OUTER_FACTNAR.store,
			indx = store.find('LINK', link);
		return indx === -1 ? _ : store.getAt(indx);
	},

	getNarRemoveColumns: function() {
		var me = this;
		return me.narRemoveColumns || (me.narRemoveColumns = [
			{
				text: 'Факт нарушения',
				dataIndex: 'FACTNAR',
				columns: [
					{
						text: 'Вид<br>нарушения',
						width: 150,
						renderer: function(v, m, r) {
							r = me.getFactNarRec(r.get('OUTER_FACTNAR'));
							return r ? r.get('NAR') : _;
						}
					},
					{
						text: 'Сумма<br>нарушения',
						width: 150,
						renderer: function(v, m, r) {
							var data = ArrayLib.filter(me.objs.OUTER_FACTNAR_KBK.data, ['OUTER_FACTNAR'], r.get('OUTER_FACTNAR')),
								max = 0;
							Ext.each(data, function(rec) { max += rec.SUMMA; });
							return max;
						}
					}
				]
			},
			{
				text: 'Мероприятия по<br>устранению',
				flex: 1,
				dataIndex: 'CONTENT',
				editor: {
					xtype: 'triggertexteditor',
					maxLength: 8000,
					getEditorTitle: function() { return this.column.text; }
				}
			},
			{
				text: 'Срок<br>устранения',
				flex: 1,
				dataIndex: 'DTSROK',
				xtype: 'datecolumn',
				format: 'd.m.Y',
				editor: 'datefield'
			},
			{
				text: 'Дата<br>устранения',
				flex: 1,
				dataIndex: 'DTDONE',
				xtype: 'datecolumn',
				format: 'd.m.Y',
				editor: 'datefield'
			}
		]);
	},

	//"{Вид док.} № {Номер} от {Дата('дд мм гггг')}"
	getDocFileName: function(rec) {
		var name = rec.get('TEMP_SDOCVID_NAME'),
			n = rec.get('NUMBER'),
			d = rec.get('DT');

		if (n) name += ' № ' + n;

		if (d) name += ' от ' + (Ext.isDate(d) ? Ext.Date.format(d, 'd m Y') : d);

		return name;
	},

	docselectionchange: function(rec) {
		var objs = this.objs;
		objs.btnNewDoc.setDisabled(!rec);
		objs.btnDelDoc.setDisabled(!rec || ArrayLib.filter(objs.OUTER_DOCUMENTS.store.data.items, ['data', 'S_DOCVID'], rec.data.S_DOCVID).length < 2);
		objs.btnFile.setDisabled(!rec);
		objs.btnFile.setIconCls(rec ? getExtStyle(rec.get('TEMP_EXT')) : '');
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.maximizable = true;
		result.resizable = true;
		result.minWidth = 600;
		result.minHeight = 600;
		return result;
	},

	profileListeners: [{ name: 'view', method: 'FormParam' }],

	getExtra: function(callBack, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link }, function(value) {
			if (value.ErrorMsg) {
				info(value.ErrorMsg);
				me.isExit = true;
				LoadMask.hide();
				return;
			}

			me.decimalData = value.decimalData;
			objs.Thousands = value.Thousands;

			objs.S_ORGC = value.S_ORGC || window.user.org;
			objs.S_ORGC_Label.setText(objs.S_ORGC.data.NAME);
			objs.S_ORGP.setValue(value.S_ORGP);

			var row = value.row;
			objs.EXTOSNOV.setValue(row.EXTOSNOV);
			objs.ROSNOV.setValue(row.ROSNOV || 1);
			objs.RTEMA.setValue(row.RTEMA);
			objs.TYPE.setValue(row.TYPE);
			objs.WORK.setValue(row.WORK || 2);

			me._setDh(objs.DT, row.DT1, row.DT2);
			me._setDh(objs.DTMONEY, row.DTMONEY1, row.DTMONEY2);

			//#region Таблица ПроверяемоеНапрвление

			var dir = value.OUTER_REVIZ_DIRECTION,
				store = objs.OUTER_REVIZ_DIRECTION.store;

			store.setFields(dir.fields);
			Ext.Array.filter(dir.columns, function(rec) {
				switch (rec.dataIndex) {
				case 'ORD':
					rec.width = 70;
					break;
				case 'DIRECTION':
					rec.flex = 1;
					rec.editor = {
						enforceMaxLength: true,
						maxLength: 200,
						xtype: 'textfield'
					};
					delete rec.width;
					break;
				}
			});
			objs.OUTER_REVIZ_DIRECTION.reconfigure(store, dir.columns);
			store.loadData(dir.data, false);

			//#endregion Таблица ПроверяемоеНапрвление

			//#region Таблица Участник

			var pers = value.OUTER_REVIZ_PERSON;
			store = objs.OUTER_REVIZ_PERSON.store;

			store.setFields(pers.fields);
			var arr = ['FIO', 'DOLG', 'OTDEL'];
			Ext.Array.filter(pers.columns, function(rec) {
				if (arr.indexOf(rec.dataIndex) !== -1) {
					rec.flex = 1;
					rec.editor = {
						enforceMaxLength: true,
						maxLength: 200,
						xtype: 'textfield'
					};
					delete rec.width;
				}
			});
			objs.OUTER_REVIZ_PERSON.reconfigure(store, pers.columns);
			store.loadData(pers.data, false);

			//#endregion Таблица Участник

			//#region Таблица Нарушения

			var factnar = value.OUTER_FACTNAR;
			store = objs.OUTER_FACTNAR.store;

			store.setFields(factnar.fields);
			objs.OUTER_FACTNAR.reconfigure(store, factnar.columns);
			objs.OUTER_FACTNAR.loadData(factnar.data);

			Ext.each((objs.OUTER_FACTNAR_KBK = value.OUTER_FACTNAR_KBK).fields, function(f) { if (f.name === 'SUMMA') f.type = 'float'; });
			objs.OUTER_FACTNAR_KBK.columns = JSON.stringify(objs.OUTER_FACTNAR_KBK.columns);
			objs.OUTER_FACTNAR_KBK.fields = JSON.stringify(objs.OUTER_FACTNAR_KBK.fields);
			objs.OUTER_FACTNAR_KBK.svbudjData[0] = '...';

			//#endregion Таблица Нарушения

			//#region Таблица Документы

			var doc = value.OUTER_DOCUMENTS;
			store = objs.OUTER_DOCUMENTS.store;

			var iPos = ArrayLib.find(doc.fields, ['name'], me.fieldFile);
			if (iPos !== -1) doc.fields[iPos].type = 'string';
			store.setFields(doc.fields);
			var fileCol;
			Ext.each(doc.columns, function(c) {
				switch (c.dataIndex) {
				case 'NUMBER':
					c.editor = {
						xtype: 'textfield',
						maxLength: 25,
						enforceMaxLength: true
					};
					break;
				case 'COMMENT':
					c.editor = {
						xtype: 'triggertexteditor',
						//maxLength: 8000,
						getEditorTitle: function() { return this.column.text; }
					};
					break;
				case 'DT':
					c.editor = { xtype: 'datefield' };
					break;
				case 'FileEdit':
					fileCol = c;
					break;
				}
			});

			if (!fileCol)
				doc.columns.push(fileCol = {
					xtype: 'actioncolumn',
					dataIndex: 'FileEdit',
					text: 'Файл',
					width: 60,
					align: 'center',
					items: [
						{
							getClass: function(v, m, r) { return getExtStyle(r.get(me.fieldExt)); },
							handler: function(grid, rowIndex) {
								me.fileGridEdit(grid.getStore().getAt(rowIndex));
							}
						}
					]
				});

			objs.OUTER_DOCUMENTS.reconfigure(store, doc.columns);
			store.loadData(doc.data, false);

			//#endregion Таблица Документы

			//#region Таб План устранения

			var narRemList = [];
			objs.OUTER_FACTNAR.store.each(function(r) {
				var narRemRec = ArrayLib.filter(value.OUTER_NARREMOVE, ['OUTER_FACTNAR'], r.get('LINK'))[0];
				if (!narRemRec) narRemRec = { OUTER_FACTNAR: r.get('LINK'), LINK: me.narRemLink-- };
				narRemList.push(narRemRec);
			});
			me.getTab('NarRemove').loadData(narRemList);

			//#endregion Таб План устранения

			if (callBack) callBack();
		});
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs;

		var data = me.callParent([false]);
		data.S_ORGC = objs.S_ORGC.data.LINK;
		data.S_ORGP = objs.S_ORGP.getLink();
		data.ROSNOV = objs.ROSNOV.getValue();
		data.WORK = objs.WORK.getValue();
		data.TYPE = objs.TYPE.getValue();
		data.RTEMA = objs.RTEMA.getValue();
		data.EXTOSNOV = objs.EXTOSNOV.getValue();
		data.DT = objs.DT.getValue(1);
		data.DTMONEY = objs.DTMONEY.getValue(1);

		//таблицы
		data.OUTER_REVIZ_DIRECTION = objs.OUTER_REVIZ_DIRECTION.store.getDataExt(_, 1);
		data.OUTER_REVIZ_PERSON = objs.OUTER_REVIZ_PERSON.store.getDataExt(_, 1);
		data.OUTER_FACTNAR = objs.OUTER_FACTNAR.store.getDataExt(function(rec) {
			rec.KBK = JSON.stringify(ArrayLib.filter(objs.OUTER_FACTNAR_KBK.data, ['OUTER_FACTNAR'], rec.LINK));
			return rec;
		}, 1);
		data.OUTER_DOCUMENTS = objs.OUTER_DOCUMENTS.store.getDataExt(_, 1);
		data.OUTER_NARREMOVE = me.getTab('NarRemove').store.getDataExt(_, 1);
		return data;
	},

	isFilled: function() {
		const me = this;
		const objs = me.objs;

		let res = true;
		if (objs.S_ORGP.isEmpty()) {
			me.addToInvalidControls(objs.S_ORGP);
			res = false;
		}

		const d1 = objs.DT.dh1.getValue();
		const d2 = objs.DT.dh2.getValue();
		if ((d1 && !Ext.isDate(d1)) || (d2 && !Ext.isDate(d2))) {
			me.addToInvalidControls(objs.DT);
			res = false;
		}

		const d = objs.DT.getValue();
		if (d.dh1 > d.dh2) {
			me.errorMessages.push(wmc.get('EventPeriodStartMoreThenEnd'));
		}

		const dm1 = objs.DTMONEY.dh1.getValue();
		const dm2 = objs.DTMONEY.dh2.getValue();
		if ((dm1 && !Ext.isDate(dm1)) || (dm2 && !Ext.isDate(dm2))) {
			me.addToInvalidControls(objs.DTMONEY);
			res = false;
		}

		const dm = objs.DTMONEY.getValue();
		if (dm.dh1 > dm.dh2) {
			me.errorMessages.push(wmc.get('CheckingPeriodStartMoreThenEnd'));
		}
		return res;
	}
});