﻿Ext.define('Keysystems.OuterReviz.Edit.FactNar', {
	extend: 'Keysystems.Base.Edit',
	title: 'Нарушение',
	linkCode: 'SOuterFactNar',
	f: 'new',
	profilePrefix: 'Outer.FactNar',
	keyEdit: 'editFactNar',
	money8: 922337203685477,
	arrSpec: ['NAR', 'NPA', 'DTDETECT', 'DTNAR', 'CONTENT'],

	viewMinSize: [600, 700],

	createItems: function() {
		var me = this,
			objs = me.objs;
		return objs.items = [
			objs.NAR = Ext.create('Ext.form.field.TextArea', {
				labelWidth: me.labelWidth,
				fieldLabel: 'Вид нарушения',
				ksAllowEmpty: true,
				enforceMaxLength: true,
				maxLength: 1500,
				minHeight: 70,
				flex: 2
			}),
			objs.NPA = Ext.create('Ext.form.field.TextArea', {
				labelWidth: me.labelWidth,
				fieldLabel: 'НПА',
				enforceMaxLength: true,
				maxLength: 500,
				minHeight: 70,
				flex: 2
			}),
			Ext.create('Ext.form.FieldContainer', {
				labelWidth: me.labelWidth,
				fieldLabel: 'Бюджетная классификация',
				layout: { type: 'hbox', align: 'stretch' },
				flex: 4,
				items: [
					objs.KBK = Ext.create('Ext.grid.Panel', {
						tbar: [
							Ext.create('Ext.Button', {
								key: 'new',
								iconCls: 'x_btn_new',
								tooltip: 'Создать',
								tooltipType: 'title',
								handler: function() {
									var grid = objs.KBK,
										rec = grid.store.add({ S_VBUDJ: null }),
										col = ArrayLib.filter(grid.getColumnManager().getColumns(), ['dataIndex'], 'S_VBUDJ')[0];
									grid.getSelectionModel().select(rec);
									grid.editingPlugin.startEdit(rec[0], col);
								}
							}),
							Ext.create('Ext.Button', {
								key: 'delete',
								iconCls: 'x_btn_delete',
								tooltip: 'Удалить',
								tooltipType: 'title',
								disabled: true,
								handler: function() { objs.KBK.removeSelection(); }
							}),
							'-',
							objs.curr = Ext.create('Ext.form.field.ComboBox', {
								editable: false,
								value: 0,
								width: 100,
								queryMode: 'local',
								padding: '0 0 0 8',
								displayField: CBDataLib.displayField,
								valueField: CBDataLib.valueField,
								store: Ext.create('Ext.data.Store', {
									fields: CBDataLib.getFields(),
									data: CBDataLib.get('', 0, { 0: 'руб.', 1: 'тыс. руб.' }),
									proxy: 'memory'
								}),
								listeners: { change: me.updKbkPadding.bind(me) }
							})
						],
						flex: 1,
						autoScroll: true,
						bodyCls: 'rks-panel-border',
						plugins: [
							Ext.create('Keysystems.grid.plugin.RowEditing', {
								//createColumnField: function(column) {
								//	var field = this.callParent(arguments);
								//	if (field && column.dataIndex === 'KBK') {
								//		field.on('afterrender', function() {
								//			if (this.inputEl) {
								//				$(this.inputEl.dom).mask("000r0r00r00000r00r0000r000", {
								//					translation: { 'r': { pattern: /[\/]/, fallback: ' ' } }
								//				});
								//			}
								//		});
								//	}
								//	return field;
								//},
								listeners: { updrecord: function(fieldName) { if (fieldName === 'SUMMA') me.updKbkPadding(); } }
							}),
							'gridclipboard'
						],
						store: Ext.create('Ext.data.Store', {
							fields: [],
							data: [],
							proxy: 'memory'
						}),
						bbar: [objs.kbkPadding = Ext.create('Ext.form.Label')],
						columns: [],
						columnLines: true,
						listeners:{
							selectionchange: (_, sels) => me.enableToolsGrid(objs.KBK, sels)
						}
					})
				]
			}),
			objs.DTDETECT = Ext.create('Ext.form.field.Date', {
				labelWidth: me.labelWidth,
				maxWidth: 275,
				emptyText: '',
				fieldLabel: 'Дата выявления'
			}),
			objs.S_PERSON = Ext.create('Keysystems.Controls.Dict.Edit', {
				labelWidth: me.labelWidth,
				fieldLabel: 'Нарушил',
				code: dnl.S_PERSON,
				handler: function() {
					dictFunc({
						mode: 'SINGL',
						parentView: objs.view,
						selectLinks: objs.S_PERSON.getValue(),
						whereArgs: me.personWhereArgs,
						code: dnl.S_PERSON,
						readOnly: objs.S_PERSON.readOnly,
						control: objs.S_PERSON,
						contextSearch: objs.S_PERSON.contextSearch,
						inputDicts: [Ext.create('InputEditDict', { name: 'S_ORG', data: me.S_ORGP })]
					}, {
						ok: function(v) { objs.S_PERSON.setValue(v); }
					});
				}
			}),
			objs.DTNAR = Ext.create('Ext.form.field.Date', {
				labelWidth: me.labelWidth,
				maxWidth: 275,
				emptyText: '',
				ksAllowEmpty: true,
				fieldLabel: 'Дата совершения'
			}),
			objs.CONTENT = Ext.create('Ext.form.field.TextArea', {
				labelWidth: me.labelWidth,
				fieldLabel: 'Характер',
				flex: 3
			})
		];
	},

	updKbkPadding: function() {
		var me = this,
			objs = me.objs,
			max = 0;
		objs.KBK.store.each(function(rec) { max += rec.get('SUMMA'); });

		objs.kbkPadding.setText(max + ' ' + objs.curr.getDisplayValue());
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		result.minWidth = 500;
		result.minHeight = 500;
		return result;
	},

	loadNewData: function() {
		var me = this;
		me.objs.DTDETECT.setValue(me.dtDetect);
	},

	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = {};
		Object.assign(data, me.data.data);
			
		Ext.each(me.arrSpec, function(key) { objs[key].setValue(data[key]); });

		data.LINK = data.S_PERSON;
		data.CODE = data.TEMP_SPERSON_CODE;
		objs.S_PERSON.setValue(data);

		me.callParent();
	},

	createListeners: function() {
		var me = this;

		me.code = me.code || dnl.OUTERREVIZ;
	},

	profileListeners: [{ name: 'view', method: 'FormParam' }],

	_getExtra: function(callBack) {
		var me = this,
			objs = me.objs;

		Ext.each(me.kbk.columns, function(col) {
			col.flex = 1;
			switch (col.dataIndex) {
			case 'S_VBUDJ':
				col.editor = {
					xtype: 'comboboxextra',
					editable: false,
					value: null,
					queryMode: 'local',
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					store: Ext.create('Ext.data.Store', {
						fields: CBDataLib.getFields(),
						data: CBDataLib.get('', 0, me.kbk.svbudjData),
						proxy: 'memory'
					})
				};
				col.renderer = function(v) { return me.kbk.svbudjData[v * 1] || '...'; };
				break;
			case 'SUMMA':
				col.editor = {
					xtype: 'calcfield',
					fieldLabel: '',
					decimalData: me.decimalData,
					getValue: function() {
						return this.rawToValue(this.processRawValue(this.getRawValue()));
					}
				};
				break;
			case 'KBK':
				col.editor = {
					xtype: 'textfield',
					maxLength: 20,
					enforceMaxLength: true
				};
				col.flex = 1;
			}
		});

		objs.KBK.reconfigure(objs.KBK.store, me.kbk.columns);
		objs.KBK.store.setFields(me.kbk.fields);

		var kbkData = JSON.parse(JSON.stringify(me.kbk.data)),
			curr = 1;
		Ext.each(kbkData, function(r) {
			if (me.Thousands) r.SUMMA *= 1000;
			if (curr && ((!r.SUMMA) || (r.SUMMA % 1000))) curr = 0;
		});

		if (curr) Ext.each(kbkData, function(el) { el.SUMMA /= 1000; });

		objs.KBK.loadData(kbkData);

		objs.curr.setValue(curr);

		me.updKbkPadding();

		if (callBack) callBack();
	},
	getExtra: function(endFunc) { this._getExtra(endFunc, this.data.data.LINK); },
	getExtraNew: function(endFunc) { this._getExtra(endFunc, 0); },

	dataCollector: function() {
		var me = this,
			objs = me.objs;

		var data = me.callParent([false]);
		if (!objs.S_PERSON.isEmpty()) {
			var tmp = objs.S_PERSON.getValue()[0];
			tmp = tmp.data || tmp;
			data.S_PERSON = tmp.LINK;
			data.TEMP_SPERSON_CODE = tmp.CODE;
			data.TEMP_SPERSON_FIO = tmp.NAME;
			data.TEMP_SPERSON_DOLGS = tmp.DOLGS;
			data.FIRSTNAME = tmp.FIRSTNAME;
			data.LASTNAME = tmp.LASTNAME;
			data.PATRONYMIC = tmp.PATRONYMIC;
		}

		Ext.each(me.arrSpec, function(key) { data[key] = objs[key].getValue(); });

		var m = Math.pow(1000, objs.curr.getValue());
		if (me.Thousands) m /= 1000;
		var minMoney = me.money8 * -1;
		data.kbk = objs.KBK.store.getDataExt(function(r) {
			if (r.SUMMA) r.SUMMA *= m;
			if (r.SUMMA > me.money8) r.SUMMA = me.money8;
			if (r.SUMMA < minMoney) r.SUMMA = minMoney;
			return r;
		});

		return data;
	},

	isFilled: function() {
		const me = this,
			objs = me.objs;
		
		let res = true;
		if (!objs.NAR.getValue()) {
			me.addToInvalidControls(objs.NAR);
			res = false;
		}

		var d = objs.DTNAR.getValue();
		if (!d || !Ext.isDate(d)) {
			me.addToInvalidControls(objs.DTNAR);
			res = false;
		}
		if (!PeriodLib.contain(d, me.dtMoney)) {
			me.errorMessages.push(wmc.get('NeedInW', objs.DTNAR.fieldLabel, 'Проверяемый период'));
		}

		d = objs.DTDETECT.getValue();
		if (d) {
			if (!Ext.isDate(d)) {
				me.addToInvalidControls(objs.DTDETECT);
				res = false;
			}
			if (!PeriodLib.contain(d, me.dt)) {
				me.errorMessages.push(wmc.get('NeedInW', objs.DTDETECT.fieldLabel, 'Период проведения'));
			}
		}
		return res;
	}
});