﻿Ext.define('Keysystems.Orders.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Поручения',
	linkCode: 'SOrders',
	f: 'new',
	labelWidth: 100,
	arrType: ['ФЛ', 'ЮЛ', 'ИП'],
	isFileBtn: true,
	fieldName: 'NUMBER',

	createItems: function() {
		var me = this,
			objs = me.objs,
			rot = window.miscTypes.RevizObjType;

		me.dataType = {};
		for (var t in rot) {
			if (me.arrType.indexOf(rot[t]) !== -1) me.dataType[t] = rot[t];
		};

		return objs.items = [
			me.createDictEdit({
				key: 'S_ORGP',
				mode: 'SINGL',
				code: dnl.S_ORG,
				fieldLabel: 'Организация',
				readOnly: true,
			}),
			{ xtype: 'menuseparator' },
			Ext.create('Ext.form.FieldContainer', {
				labelWidth: me.labelWidth,
				layout: { type: 'hbox', align: 'stretch' },
				items: [
					objs.NUMBER = Ext.create('Ext.form.field.Text', {
						labelWidth: me.labelWidth,
						ksAllowEmpty: true,
						allowBlank: false,
						maxLength: 15,
						enforceMaxLength: true,
						fieldLabel: '№'
					}),
					'->',
					objs.DT = Ext.create('Ext.form.field.Date', {
						labelWidth: 50,
						ksAllowEmpty: true,
						allowBlank: false,
						width: 275,
						padding: '0 2 0 0',
						emptyText: '',
						fieldLabel: 'От'
					})
				]
			}),
			me.createDictEdit({
				key: 'S_PERSON_FROM',
				labelWidth: me.labelWidth,
				fieldLabel: 'Поручение от',
				mode: 'SINGL',
				code: dnl.S_PERSON,
				initWhereArgs: function() {
					let dt = new Date().toDateString();
					return {
						// SDolg - замена DolgByNastr в вине
						SDolg: { value: objs.sDolgFrom, type: 'List_int' },
						STypeOrgs: { value: JSON.stringify([me.checkTypeOrg]), type: 'List_int' },
						DH1: { value: me.data.data.DT ? me.data.data.DT : dt, type: 'Date' },
						DH2: { value: me.data.data.DT ? me.data.data.DT : dt, type: 'Date' }
					};
				}
			}),
			Ext.create('Ext.form.FieldContainer', {
				labelWidth: me.labelWidth,
				fieldLabel: 'Объект',
				ksAllowEmpty: true,
				layout: { type: 'hbox', align: 'stretch' },
				items: [
					objs.TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra', {
						editable: false,
						hidden: true,
						value: 0,
						padding: '0 5 0 0',
						store: Ext.create('Ext.data.Store', {
							fields: CBDataLib.getFields(),
							data: CBDataLib.get(_, _, me.dataType),
							proxy: 'memory'
						}),
						listeners: {
							change: function(th) {
								var fl = th.getRawValue() === 'ФЛ';
								objs.S_ORG.setVisible(!fl);
								objs.S_PERSON.setVisible(fl);
							}
						},
						displayField: CBDataLib.displayField,
						valueField: CBDataLib.valueField,
						width: 58
					}),
					objs.S_ORG = Ext.create('Keysystems.Controls.Dict.Edit', {
						flex: 1,
						ksAllowEmpty: true,
						handler: function() {
							dictFunc({
								mode: 'SINGL',
								parentView: objs.view,
								selectLinks: objs.S_ORG.getValue(),
								whereArgs: me.initWhereArgs(objs.TYPE.getRawValue() == 'ИП'
									? { SType: { value: JSON.stringify(objs.ip), type: 'List_int' } }
									: _),
								code: dnl.S_ORG,
								readOnly: objs.S_ORG.readOnly,
								control: objs.S_ORG,
								contextSearch: objs.S_ORG.contextSearch
							}, { ok: function(v) { objs.S_ORG.setValue(v); } });
						}
					}),
					me.createDictEdit({
						key: 'S_PERSON',
						hidden: true,
						ksAllowEmpty: true,
						flex: 1,
						mode: 'SINGL',
						code: dnl.S_PERSON,
						initWhereArgs: function() {
							return me.initWhereArgs();
						}
					})
				]
			}),
			Ext.create('Ext.form.FieldSet', {
				title: 'Суть поручения',
				flex: 1,
				layout: { type: 'vbox', align: 'stretch' },
				items: [objs.NOTE = Ext.create('Ext.form.field.TextArea', { flex: 1 })]
			}),
			
				objs.CONSIDERED_AT = Ext.create('Ext.form.field.Date', {
					labelWidth: me.labelWidth + 50,
					padding: '0 20 0 0',
					maxWidth: me.labelWidth + 200,
					emptyText: '',
					fieldLabel: 'Срок рассмотрения'
				}),
				objs.RECOMMENDATION = Ext.create('Keysystems.Controls.ComboBoxExtra', {
					labelWidth: me.labelWidth + 50,
					fieldLabel: 'Рекомендовать для',
					editable: false,
					value: 0,
					store: Ext.create('Ext.data.Store', {
						fields: CBDataLib.getFields(),
						data: CBDataLib.get('RecommendationTypes'),
						proxy: 'memory'
					}),
					displayField: CBDataLib.displayField,
					valueField: CBDataLib.valueField,
					maxWidth: me.labelWidth + 200
				})
			
		];
	},

	initWhereArgs: function(cfg) {
		var d = { value: this.objs.DT.getValue() || new Date(), type: 'Date' };
		return Ext.apply({
			DH1: d,
			DH2: d,
			//todo хз надо ли
			//UseActualData: { value: 'True', type: 'bool' },
			MarkBusy: { value: 'True', type: 'bool' }
		}, cfg);
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		result.minWidth = 600;
		//result.minHeight = 500;
		//result.width = this.width;
		return result;
	},

	getExtra: function(callBack, link) {
		var me = this,
			objs = me.objs;

		me.checkTypeOrg = 1;

		// ReSharper disable UseOfImplicitGlobalInFunctionScope
		for (var k in miscTypes.TypeOrg) {
			if (miscTypes.TypeOrg[k] === 'Проверяющая') {
				// ReSharper restore UseOfImplicitGlobalInFunctionScope
				me.checkTypeOrg = k * 1;
				break;
			}
		}

		me.baseGetExtra({ link: link }, function(value) {
			var row = value.row;

			if (value.isType) objs.TYPE.show();
			objs.TYPE.setValue(row.TYPE || 1);

			objs.NUMBER.setValue(row.NUMBER);
			objs.DT.setValue(me.getDateOrToday(row.DT));
			objs.sDolgFrom = JSON.stringify(value.sDolgFrom);
			objs.S_PERSON_FROM.setValue(value.S_PERSON_FROM);
			objs.S_PERSON.setValue(value.S_PERSON);
			objs.ip = value.ip;
			objs.S_ORGP.setValue(value.S_ORGP || window.user.org);
			objs.S_ORG.setValue(value.S_ORG);
			objs.NOTE.setValue(row.NOTE);
			objs.RECOMMENDATION.setValue(row.RECOMMENDATION);
			objs.CONSIDERED_AT.setValue(row.CONSIDERED_AT);
			objs.CONSIDERED_AT.setVisible(value.isConsideredAt);
			me.data.data.FILES = row.FILES;
			me.data.data.TEMP_EXT = value.tempExt;
			objs.btnFile.setIconCls(getExtStyle(value.tempExt));

			if (callBack) callBack();
		});
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs;

		var data = me.callParent([false]);
		data.NUMBER = objs.NUMBER.getValue();
		data.DT = me.getDateOrToday(objs.DT.getValue())?.toDateString();
		data.S_PERSON_FROM = objs.S_PERSON_FROM.getLink();
		data.S_ORGP = objs.S_ORGP.getLink();
		data.S_ORG = objs.S_ORG.getLink();
		data.S_PERSON = objs.S_PERSON.getLink();
		data.TYPE = objs.TYPE.getValue();
		data.NOTE = objs.NOTE.getValue();
		data.RECOMMENDATION = objs.RECOMMENDATION.getValue();
		data.FILES = me.data.data.FILES;

		if (!objs.CONSIDERED_AT.isHidden()) data.CONSIDERED_AT = objs.CONSIDERED_AT.getValue();

		return data;
	},

	isFilled: function() {
		const me = this;
		const objs = this.objs;

		let res = true;
		if (!objs.NUMBER.getValue()) {
			me.addToInvalidControls(objs.NUMBER);
			res = false;
		}

		var d = objs.DT.getValue();
		if (!Ext.isDate(d)) {
			me.addToInvalidControls(objs.DT);
			res = false;
		}

		const obj = objs[objs.S_ORG.isVisible() ? 'S_ORG' : 'S_PERSON'];
		if (obj.isEmpty()) {
			me.addToInvalidControls(obj, {title: 'Объект'});
			res = false;
		}

		return res;
	},

	loadNewData: function() { this.data = { data: { FILES: 0 }, raw: { FILES: 0 } }; }
});