﻿Ext.define('RevizorSettingsView', {
	objs: {},
	config: {},
	constructor: function(cfg) {
		var me = this;
		me.objs = {};
		me.initConfig(cfg);

		me.createItems();
		me.createBtns();
		me.createView();
	},
	createItems: function() {
		var me = this;
		me.objs.items = [
			Ext.create('Ext.form.FieldSet', {
				title: 'Внешний вид',
				collapsible: true,
				layout: 'anchor',
				items: [
					Ext.create('Ext.form.field.ComboBox', {
						editable: false,
						store: Ext.create('Ext.data.Store', {
							fields: ['name', 'value'],
							data: [
								{
									name: 'Classic',
									value: 'classic'
								}, {
									name: 'Gray',
									value: 'gray'
								}, {
									name: 'Accessibility',
									value: 'access'
								}, {
									name: 'Neptune',
									value: 'neptune'
								}
							]
						}),
						value: Theme,
						displayField: 'name',
						valueField: 'value',
						listeners: {
							select: function(combo) {
								var theme = combo.getValue();
								if (theme != Theme) {
									me.setParam(theme);
								}
							}
						}
					})
				]
			})
		];
	},
	createBtns: function() {
		var me = this;
		me.objs.btns = [
			Ext.create('Ext.Button', {
				text: 'Закрыть',
				handler: function() {
					me.objs.view.close();
				}
			})
		];
	},
	viewCfg: function() {
		var me = this,
			objs = me.objs;
		objs.viewCfg = {
			title: 'Параметры',
			iconCls: 'x_btn_keysystems',
			closable: true,
			layout: 'anchor',
			anchor: '100% 100%',
			minHeight: 200,
			minWidth: 200,
			tbar: objs.tbar,
			items: objs.items,
			buttons: objs.btns,
			listeners: objs.listeners,
			modal: true,
			width: 200,
			height: 200,
			maximizable: true,
			autoRender: true
		};
		return objs.viewCfg;
	},
	createView: function() {
		var me = this,
			cfg = me.viewCfg();
		me.objs.view = Ext.create('Ext.window.Window', cfg);
		me.show();
	},
	show: function() {
		var me = this,
			objs = me.objs;
		objs.view.show(me.parentView, function() {
			if (objs.view.getX() < 0) {
				objs.view.setX(0);
			}
			if (objs.view.getY() < 0) {
				objs.view.setY(0);
			}
		});
	},
	setParam: function(theme) {
		Ext.util.Cookies.set('theme', theme, new Date((new Date()).getTime() + cacheTime));
		location.reload();
	}
});