﻿Ext.define('Keysystems.ObjectionAct.Edit', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Edit'],
	layout: { type: 'vbox', align: 'stretch' },
	title: 'Результаты проверки',
	isWindow: true,
	flex: 1,
	labelWidth: 100,
	viewMinSize: [550, 305],

	_arrReadOnly: ['REVIZ_NUMBER', 'REVIZ_DT', 'REVIZ_RTEMA', 'DH', 'ACT_DT'],
	
	constructor: function(cfg) {
		var me = this;
		Ext.apply(me, cfg);

		me.callParent(arguments);
	},
		
	initComponent: function() {
		var me = this;

		if (me.code !== dnl.OBJECTIONACT) me.code = dnl.OBJECTIONACT; //без этого вылетает сохранение профиля в отчете

		me.beforeInitComponent();
		me.baseInitComponent();

		me.callParent(arguments);

		me.afterInitComponent();
	},

	createItems: function() {
		var me = this,
			items = [
				Ext.create('Ext.form.FieldSet', {
					title: 'Общие сведения',
					flex: 1,
					layout: { type: 'vbox', align: 'stretch' },
					items: [
						[
							me.sksc('REVIZ_NUMBER', Ext.create('Ext.form.field.Text', {
								labelWidth: me.labelWidth,
								maxWidth: me.labelWidth + 100,
								disabledCls: '',
								fieldLabel: '№'
							})),
							me.sksc('REVIZ_DT', Ext.create('Ext.form.field.Date', {
								maxWidth: 130,
								padding: '0 0 0 20',
								disabledCls: '',
								labelWidth: 30,
								fieldLabel: 'от'
							}))
						],
						me.sksc('REVIZ_RTEMA', Ext.create('Ext.form.field.TextArea', {
							fieldLabel: 'Тема',
							labelWidth: me.labelWidth,
							flex: 1
						})),
						me.createDHEdit({ fieldLabel: 'Период проведения', labelWidth: me.labelWidth, maxWidth: me.labelWidth + 253 })
					]
				}),
				Ext.create('Ext.form.FieldSet', {
					title: 'Акт',
					layout: { type: 'vbox', align: 'stretch' },
					items: [
						[
							me.sksc('ACT_DT', Ext.create('Ext.form.field.Date', {
								labelWidth: me.labelWidth,
								maxWidth: me.labelWidth + 100,
								disabledCls: '',
								fieldLabel: 'от'
							})),
							me.sksc('ACT_S_STATUS', Ext.create('Ext.form.field.ComboBox', {
								maxWidth: 200,
								editable: false,
								value: 0,
								disabledCls: '',
								queryMode: 'local',
								fieldLabel: 'Статус',
								labelWidth: 60,
								padding: '0 0 0 20',
								displayField: CBDataLib.displayField,
								valueField: CBDataLib.valueField,
								store: CBDataLib.getStore([])
							})),
							'->',
							me.sksc('ACT_FILE', Ext.create('Ext.Button', {
								text: 'Файл',
								handler: function() {
									var actRow = me.gksd('actRow');
									if (actRow.FILES) UploaderLib.getFile(actRow.FILES, 'Акт');
								}
							}))
						]
					]
				}),
				me.sksc('OBJECTIONT_FS', Ext.create('Ext.form.FieldSet', {
					title: 'Возражения',
					layout: { type: 'vbox', align: 'stretch' },
					checkboxToggle: true,
					listeners: {
						beforecollapse: function() {
							var res = !me.gksd('objectiontRow').LINK;
							if (!res) this.checkboxCmp.setValue(true);
							return res;
						}
					},
					items: [
						[
							me.sksc('OBJECTIONT_NUMBER', Ext.create('Ext.form.field.Text', {
								labelWidth: me.labelWidth,
								maxWidth: me.labelWidth + 100,
								disabledCls: '',
								fieldLabel: '№'
							})),
							me.sksc('OBJECTIONT_DT', Ext.create('Ext.form.field.Date', {
								maxWidth: 130,
								padding: '0 0 0 20',
								ksAllowEmpty: true,
								disabledCls: '',
								labelWidth: 30,
								fieldLabel: 'от'
							})),
							'->',
							me.sksc('OBJECTIONT_FILE', Ext.create('Ext.Button', {
								text: 'Файл',
								handler: function() {
									Ext.create('Keysystems.File', {
										iconCls: getExtStyle(me.gksd('objectiontRow').TEMP_EXT),
										createFile: function(callback) { me.createFile(me.gksd('objectiontRow').FILES, callback); },
										updRecord: function(fileObj) {
											var objectiontRow = me.gksd('objectiontRow');
											objectiontRow.FILES = fileObj.id;
											me.gksc('OBJECTIONT_FILE').setIconCls(getExtStyle(objectiontRow.TEMP_EXT = fileObj.ext));
										},
										getFileId: function() { return me.gksd('objectiontRow').FILES; },
										downloadFile: function() {
											var objectiontRow = me.gksd('objectiontRow');
											if (objectiontRow.FILES) UploaderLib.getFile(objectiontRow.FILES, 'Возражения');
										},
										clearFile: function() { this.updRecord({ id: 0, ext: '' }); }
									});
								}
							}))
						]
					]
				}))
			];

		return me.callParent([items]);
	},

	createFile: function(link, callback) { this.runCreateFile(callback); },

	//сообщение о наличии несохраненных данных при создании файла
	createFileMsgShow: function(cfg) {
		Ext.Msg.show({
			title: wmc.get('Attention'),
			msg: wmc.get('NeedSaveChange'),
			buttons: Ext.MessageBox.OKCANCEL,
			buttonText: { ok: 'Сохранить', },
			fn: function(buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.INFO
		});
	},

	runCreateFile: function(callback) {
		if (this.beforeCreateFile(callback) !== false) {
			UploaderLib.newFile('DOCUMENTS', this.gksd('objectiontRow').LINK || 0, 0, -1, 0, this.getLoadMaskTarget(), callback);
		}
	},

	beforeCreateFile: function(callback) {
		var me = this;
		me.checkFilled(res => {
			if (!res) return;
			var newData = me.saveChangesFn();
			if (newData || !me.gksd('objectiontRow').LINK) {
				me.createFileMsgShow({
					ok: function () {
						me.saveData(function () {
							me.runCreateFile(callback);
						}, newData);
					}
				});
				return false;
			}
			return _;
		});
	},

	successSaveFunc: function(res) {
		if (res.objectiontRow) this.sksd('objectiontRow', res.objectiontRow);
		this.callParent(arguments);
		this.dictList && this.dictList.refresh(_, 1);
	},

	dataCollector: function() {
		var me = this,
			data = me.callParent(arguments);

		if (me.data) {
			data.REVIZ_LINK = me.gksd('revizRow').LINK;
			data.ACT_LINK = me.gksd('actRow').LINK;
			data.ACT_S_STATUS = me.gksc('ACT_S_STATUS').getValue();

			if (!me.gksc('OBJECTIONT_FS').collapsed) {
				var objectiontRow = me.gksd('objectiontRow');
				data.OBJECTIONT = JSON.stringify({
					LINK: objectiontRow.LINK || 0,
					NUMBER: me.gksc('OBJECTIONT_NUMBER').getValue(),
					DT: me.gksc('OBJECTIONT_DT').getValue(),
					FILES: objectiontRow.FILES
				});
			}

			data.isVfa = me.isVfa;
		}

		return data;
	},

	getExtra: function(callBack) {
		var me = this,
			data = me.data.data;

		me.baseGetExtra({
			revizLink: data.REVIZ_LINK,
			actLink: me.getLink(),
			objectiontLink: data.OBJECTIONT || 0
		}, function(value) {
			Ext.each(me._arrReadOnly, function(k) { me.gksc(k).setReadOnly(true); });

			//#region Общие сведения

			me.sksd('revizRow', value.revizRow);
			me.gksc('REVIZ_NUMBER').setValue(value.revizRow.NUMBER);
			me.gksc('REVIZ_DT').setValue(value.revizRow.DT);
			me.gksc('DH').setValue(value.revizRow.DT1, value.revizRow.DT2);
			me.gksc('REVIZ_RTEMA').setValue(data.REVIZ_SRTEMA);

			//#endregion Общие сведения

			//#region Акт

			me.sksd('actRow', value.actRow);
			var status = '';
			for (var s in value.statusList) {
				status = s * 1;
				break;
			}
			if (value.actStatus) {
				value.actStatusList[value.actStatus.index] = value.actStatus.value;
				status = value.actStatus.index * 1;
			}
			var c = me.gksc('ACT_S_STATUS');
			c.loadData(CBDataLib.get(_, _, value.actStatusList));
			c.setValue(status);
			me.gksc('ACT_DT').setValue(value.actRow.DT);
			me.gksc('ACT_FILE').setIconCls(getExtStyle(value.actRow.TEMP_EXT));

			//#endregion Акт

			//#region Возражения

			me.sksd('objectiontRow', value.objectiontRow || {});
			me.gksc('OBJECTIONT_FS').setExpanded(!!value.objectiontRow);
			if (value.objectiontRow) {
				me.gksc('OBJECTIONT_NUMBER').setValue(value.objectiontRow.NUMBER);
				me.gksc('OBJECTIONT_DT').setValue(value.objectiontRow.DT);
				me.gksc('OBJECTIONT_FILE').setIconCls(getExtStyle(value.objectiontRow.TEMP_EXT));
			}

			//#endregion Возражения

			KsLib.tryRun(callBack);
		});
	},

	profileListeners: [{ name: 'view', method: 'FormParam' }],

	//{Документ.Вид.Имя}+' № '+ {Документ.Номер} + ' от ' + ДАТАПРОП({Документ.Дата},4)
	getFileName: function() {
		var me = this,
			objs = me.objs,
			d = objs.DT.getValue();
		return Ext.String.format('{0} № {1} от {2}', me.NAME, objs.NUMBER.getValue(), Ext.isDate(d) ? Ext.Date.format(d, 'd_m_Y') : d);
	},

	isFilled: function() {
		var me = this,
			c = me.gksc('OBJECTIONT_DT'),
			d = c.getValue();

		if (!(me.gksc('OBJECTIONT_FS').collapsed || (d && Ext.isDate(d)))) {
			me.addToInvalidControls(c);
			return false;
		}
		return true;
	},

	getParamsForCancel: function() {
		let me = this,
			data = me.data.data,
			params = me.callParent(arguments);

		params.code = dnl.DOCUMENTS;
		params.revizLink = data.REVIZ_LINK;

		return params;
	}
});