Ext.define('Keysystems.Panel.ObjAccess', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Abstract'],

	title: 'Назначение прав доступа к объектам комплекса',
	iconCls: 'x_btn_key',
	border: 0,
	layout: {type: 'vbox', align: 'stretch'},
	layoutConfig: {
		align: 'stretch',
		pack: 'start',
	},
	header: false,
	flex: 1,
	headerHeight: 26,
	cacheObjAccess: {},
	changedObjects: [],
	initComponent: function () {
		//window.startLog();
		let me = this;
		me.loading = true;
		me.beforeInitComponent();
		me.ajaxPropTable = {};
		me.items = [
			me.dictUser = Ext.create('Ext.form.field.Text', {
				fieldLabel: 'Пользователь/группа',
				labelWidth: 200,
				link: null,
				editable: false,
				disabled: me.startUser,
				padding: '5 5 0 5',
				triggers: {
					dict: {
						cls: 'x_btn_dict x-dict-trigger',
						handler: function () {
							let changes = me.getChanges(),
								showDict = () => {
									me.usersGroupsTree = Ext.create('Keysystems.UsersGroups.Tree',
										{
											title: 'Группы пользователей',
											closeAction: 'hide',
											uids: [me.dictUser.link],
											mode: "get_tree_groups_users",
											ok: function (records) {
												const row = records.length > 0 ? records[0].data : null;
												if (row) {
													if (row.UID === me.dictUser.link) return;
													if (row.NAME.indexOf('<font') > 0) 
														row.NAME = row.NAME.substring(0, row.NAME.indexOf('<font'));

													me.dictUser.setValue(row.NAME);
													me.dictUser.link = row.UID;
												} else {
													me.dictUser.setValue(null);
													me.dictUser.link = null;
												}
												me.getAccessData(row.UID);
											}
										});
									me.usersGroupsTree.show();
								};
							if (changes.length > 0) {
								Ext.Msg.show({
									title: KS.L10n.attention,
									msg: wmc.get('SaveChanges'),
									buttons: Ext.MessageBox.YESNOCANCEL,
									fn: function (buttonId) {
										if (buttonId === 'yes') {
											me.save(() => {
												showDict();
											});
										}
										if (buttonId === 'no') {
											showDict();
										}

									},
									icon: Ext.MessageBox.QUESTION
								});
							} else {
								showDict();
							}
						}
					}
				}
			}),
			Ext.create('Ext.panel.Panel', {
				layout: {type: 'hbox', align: 'stretch'},
				flex: 1,
				items: [
					me.treePanel = Ext.create('Ext.tree.Panel', {
						hideHeaders: true,
						width: 250,
						cls: Ext.baseCSSPrefix + 'autowidth-table',
						tbar: [
							me.btnSave = Ext.create('Ext.Button', {
								tooltip: 'Сохранить',
								tooltipType: 'title',
								iconCls: 'x_btn_save',
								disabled: true,
								handler: function () {
									me.save();
								}
							}),
							{
								iconCls: 'x_btn_refresh',
								tooltip: 'Обновить',
								tooltipType: 'title',
								handler: function () {
									me.getAccessData(me.dictUser.link);
								}
							},
							{
								tooltip: 'Развернуть все узлы',
								tooltipType: 'title',
								iconCls: 'x_btn_treeexpand',
								handler: function () {
									me.treePanel.expandAll();
								}
							},
							{
								tooltip: 'Свернуть все узлы',
								tooltipType: 'title',
								iconCls: 'x_btn_treecollapse',
								handler: function () {
									me.treePanel.collapseAll();
								}
							},
							me.btnToolbarAccess = Ext.create('Ext.Button', {
								tooltip: 'Права доступа на элементы панели инструментов',
								tooltipType: 'title',
								iconCls: 'x_btn_design',
								handler: function () {
									const sel = me.treePanel.getSelectionModel().getSelection()[0];
									if (!sel) return;
									
									let toolbarAccessTree = Ext.create('Keysystems.ToolbarAccess',
										{
											title: 'Права доступа на элементы панели инструментов',
											closeAction: 'hide',
											user: me.dictUser.link,
											code: sel.data.CODE,
											ok: function (row) {
											}
										});
									toolbarAccessTree.show();
								}
							}),
							Ext.create('Ext.Button', {
								tooltip: 'Выход',
								tooltipType: 'title',
								iconCls: 'x_btn_exit',
								handler: function () {
									me.ownerCt.close();
								}
							})
						],
						caseSensitive: false,
						columns: [{
							xtype: 'treecolumn',
							text: 'Name',
							dataIndex: 'NAME',
							renderer: (value, node) => {
								let cls = node.record.match;
								if (cls) return Ext.String.format('<span class="{0}">{1}</span>', cls, node.record.data.NAME);
								return value;
							}
						}],
						border: 0,
						autoScroll: true,
						store: Ext.create('Ext.data.TreeStore', {
							fields: ['NAME', 'CODE'],
							root: {expanded: true, children: []},
							defaultRootText: ''
						}),
						rootVisible: false,
						split: true,
						listeners: {
							select: function (th, rec) {
								me.updateAccessGrid(rec.get('LINK'));
							}
						}
					}),
					{xtype: 'splitter'},
					me.rightPanel = Ext.create('Ext.panel.Panel', {
						autoScroll: true,
						flex: 1,
						border: 0,
						layout: {type: 'vbox', align: 'stretch'},
						items: [
							me.gridAccess = Ext.create('Ext.grid.Panel', {
								flex: 1,
								userCls: 'rks-grid-access',
								border: 0,
								padding: 0,
								plugins: [
									Ext.create('Ext.grid.plugin.CellEditing', {
										clicksToEdit: 1,
									}),
									'gridclipboard'
								],
								store: Ext.create('Ext.data.Store', {fields: [], data: [], proxy: 'memory'}),
								columns: [],
								columnLines: true,
								viewConfig: {
									getRowClass: function (rec) {
										return !rec.get('VISIBLE') ? 'ks-textgray' : '';
									}
								}
							})
						]
					})
				]
			})
		]
		me.treePanel.addDocked([me.createSearchPanel()]);
		me.callParent(arguments);
		me.on('afterrender',() => me.getAccessData());
		me.loading = false;
	},

	createSearchPanel: function () {
		let me = this;
		return me.searchField = Ext.create('Keysystems.Tree.SearchPanel', {
			treePanel: me.treePanel
		});
	},

	getChanges: function () {
		let me = this,
			changes = [];
		me.changedObjects.forEach(r => {
			let node = me.treePanel.getStore().getNodeBy(r.LINK, "LINK");
			if (node) {
				changes.push(
					{
						LINK: node.data.REDIRECT || node.data.LINK,
						CODE: node.data.CODE,
						Access: node.data.Access,
						DenyAccess: node.data.DenyAccess
					}
				)
			}

		});
		return changes;
	},

	enableTools: function () {
		let me = this;
		me.btnSave.setDisabled(me.changedObjects.length === 0);
	},

	save: function (callback) {
		let me = this,
			changes = me.getChanges();
		if (changes.length === 0) return;

		Log.sendLog('Данные к сохранению');
		Log.sendRawLog(changes);

		me.setLoading(wmc.get('ObjAccessSaving'));
		ajaxRequest({
			url: '/SObjAccess/SaveObjAccess_A',
			params: {user: me.dictUser.link, changes: JSON.stringify(changes)},
			success: function (result) {
				me.setLoading(false);
				if (!result || result.Fail) {
					failureShow(result.Message ?? wmc.get('ObjAccessSaveFailed'), wmc.get('SavingError'));
					console.warn(wmc.get('ObjAccessSaveFailed') + ',' + result.Message);
					return false;
				}
				QuickMsgs.save();
				me.changedObjects = [];
				me.enableTools();
				me.treePanel.getRootNode().cascade(function (node) {
					node.set('initAccess', node.get('Access'));
					node.set('initDenyAccess', node.get('DenyAccess'));
				});
				if (callback) callback();
			},
			failure: function (response) {
				me.setLoading(false);
				failureShow(wmc.get('ObjAccessSaveFailed'), wmc.get('SavingError'));
				console.error("Error", response.responseText);
			}
		});
	},

	getValueMask: function () {
		let me = this,
			data = me.gridAccess.store.getDataExt(),
			res = {grant: 0, deny: 0};
		data.forEach(row => {
			res.grant |= row.GRANT ? row.Value : 0;
			res.deny |= row.DENY ? row.Value : 0;
		});
		return res;
	},

	/**
	 * Получить данные по правам доступа. В качестве кода объекта берет код объекта окна Прав доступа.
	 * response: {
	 *      tree - древовидная структура с объектами и правами,
	 *      rights - таблица возможных прав,
	 *      user - данные пользователя, на которого получили права
	 * }
	 * @param user {number} UID пользователя.
	 *          если user не задан - будут получены права для группы пользователя либо для самого пользователя (если пользователь не включен ни в одну группу)
	 *          данные по пользователю приходят в response.user
	 * */
	getAccessData: function (user, callback) {
		let me = this,
			key = JSON.stringify({ObjCode: me.code, User: user ?? me.startUser ?? 0});

		// if (me.cacheObjAccess[key]) {
		// 	callback(me.cacheObjAccess[key]);
		// } else {
		{
			const loadMask = new Ext.LoadMask({
				msg: KS.L10n.objects_tree_loading,
				target: me,
				autoShow: true,
				rid: ajaxRequest({
					url: 'SObjAccess/GetTreeData_A',
					params: {user: user ?? me.startUser ?? 0, code: me.code || null},
					success: function (response) {
						console.log(response);
						me.data = response.tree;
						me.cacheObjAccess[key] = response;
						me.changedObjects = [];
						me.enableTools();

						if (!user) {
							me.dictUser.setValue(response.user.data.CODE);
							me.dictUser.link = response.user.data.LINK;

							let clmsCheck = response.rights.columns.filter(clm => clm.dataIndex === "GRANT" || clm.dataIndex === "DENY");
							clmsCheck.forEach(clm => {
									clm.renderer = function (v, meta, rec) {
										if (!rec.get('VISIBLE')) meta.tdCls = 'x-item-disabled';
										return this.callParent(arguments, this.defaultRenderer);
									};
									clm.listeners = {
										beforecheckchange: function (th, inx, check, rec) {
											return rec.get('VISIBLE');
										},
										checkchange: function (th, rowIndex, checked, rec) {
											if (checked)
												rec.set(th.dataIndex === 'GRANT' ? 'DENY' : 'GRANT', !checked);

											let nodeSelected = me.treePanel.getFrstSelect(),
												link = nodeSelected ? nodeSelected.get('LINK') : null,
												accessMask = me.getValueMask(),
												rowChanges = me.changedObjects.filter(r => r.LINK === link)[0];

											let newValGrant = nodeSelected.get('AccessBase') & (accessMask.grant),
												newValDeny = nodeSelected.get('AccessBase') & (accessMask.deny);

											if (!rowChanges) {
												//добавляем нод в коллекцию изменных, запоминаем изначально заданный доступ
												me.changedObjects.push({
													LINK: nodeSelected.get('LINK'),
													initAccess: nodeSelected.get('initAccess'),
													initDenyAccess: nodeSelected.get('initDenyAccess')
												});
											} else if (rowChanges.initAccess === newValGrant && rowChanges.initDenyAccess === newValDeny) {
												//убираем нод из числа измененных в случае, если измененные маски совпадают с изначально заданными
												let idx = me.changedObjects.indexOf(rowChanges);
												if (idx >= 0) me.changedObjects.splice(idx, 1);
												me.enableTools();
												return;
											}
											nodeSelected.set('Access', newValGrant);
											nodeSelected.set('DenyAccess', newValDeny);
											me.enableTools();
										}
									}
								}
							);
							response.rights.columns.forEach(clm => clm.menuDisabled = true);
							me.gridAccess.setMetaDate(response.rights);
						}

						let linkSelected = me.getSelectedLink();
						me.treePanel.store.setRoot({expanded: true, children: me.buildTree()});
						let selModel = me.treePanel.getSelectionModel();
						if (selModel) {
							let selectedNode = linkSelected ? me.treePanel.getStore().findNode('LINK', linkSelected) : null;
							selModel.select(selectedNode ?? me.treePanel.store.root.firstChild);
							if (selectedNode) me.treePanel.expandPath(selectedNode.getPath());
						}
						if (callback) callback(response);
					},
					callback: function () {
						loadMask.destroy();
					}
				})
			});
		}
	},

	prepareData: function (r) {
		let me = this;
		if (r.image !== 'FOLDER') r.iconCls = 'x_btn_' + r.image.toLowerCase() + ' x_btn_' + r.image.toUpperCase();
		r.initAccess = r.Access;
		r.initDenyAccess = r.DenyAccess;
		Ext.each(r.children, me.prepareData, me);
	},
	buildTree: function () {
		let me = this;
		Ext.each(me.data, me.prepareData, me);
		return me.data;
	},
	getSelectedLink: function () {
		let node = this.treePanel.getFrstSelect();
		return node ? node.get('LINK') : null;
	},
	/**
	 * Обновить грид с правами доступа
	 * @param objLink {number} линк объекта
	 * */
	updateAccessGrid: function (objLink) {
		let me = this,
			node = me.treePanel.getStore().findNode('LINK', objLink),
			rowData = node ? node.data : null;
		me.gridAccess.setDisabled(!rowData);
		if (!rowData) return;

		let hasToolbar = (rowData.Mask & 0x0100) !== 0;
		me.btnToolbarAccess.setDisabled(!hasToolbar);

		me.gridAccess.store.suspendEvents();
		me.gridAccess.store.each(function (r) {
			//инвертированная маска устарела (optInv), ее не учитываем
			let optValue = parseInt(r.get('Value')),
				visible = (parseInt(rowData.AccessBase) & optValue) !== 0,
				grant = (parseInt(rowData.AccessBase) & ((parseInt(rowData.Access) & optValue))) !== 0,
				deny = (parseInt(rowData.AccessBase) & ((parseInt(rowData.DenyAccess) & optValue))) !== 0;
			r.beginEdit();

			r.set('VISIBLE', visible);
			r.set('GRANT', grant);
			if (rowData.DenyAccess != null)
				r.set('DENY', deny);
			//r.set('Name', node.NAME + Ext.String.format(' [visible, grant, deny] = [{0},{1},{2}]', visible, grant, deny));			
			r.endEdit();
		});
		me.gridAccess.store.resumeEvents();
		me.gridAccess.getView().refresh();
	}
});
window.ObjAccess = {

	show: function (code, title, startUser) {
		let parentView = window.tabView,
			tabID = 'ACCESS' + (code ? '_' + code : '');
		if (parentView && code) {
			let tab = parentView.items.items.filter(item => item.tabID === tabID)[0];
			if (tab) {
				tab.show();
				return;
			}
		}

		let objAccessPanel = Ext.create('Keysystems.Panel.ObjAccess', {
			flex: 1,
			code: code,
			startUser: startUser
		});
		let view = Ext.create('Ext.panel.Panel',
			{
				border: 0,
				closable: true,
				tabID: tabID,
				code: code,
				title: title ? 'Права доступа - ' + title : 'Права доступа',
				iconCls: 'x_btn_key',
				autoScroll: true,
				layout: {type: 'vbox', pack: 'start', align: 'stretch'},
				items: objAccessPanel,
				checkChanges: true,
				listeners: {
					beforeclose: function () {
						let me = this;
						if (!me.checkChanges) return true;

						let arrChanges = objAccessPanel.getChanges();
						if (arrChanges.length) {
							Ext.Msg.show({
								title: KS.L10n.attention,
								msg: wmc.get('SaveChanges'),
								buttons: Ext.MessageBox.YESNOCANCEL,
								fn: function (buttonId) {
									if (buttonId === 'yes') {
										objAccessPanel.save(() => {
											me.checkChanges = false;
											me.close();
										});
									}
									if (buttonId === 'no') {
										me.checkChanges = false;
										me.close();
									}
								},
								icon: Ext.MessageBox.QUESTION
							});
							return false;
						}
						return true;
					}
				}
			});

		let tab = window.tabView.add(view);
		if (tab && window.tabView.setActiveTab) window.tabView.setActiveTab(tab);

		view.show(window.tabView);
		view.updateLayout();
	}
};