﻿Ext.define('Keysystems.Map.List', {
	constructor: function() {
		if (!window.isMapListShow) {
			window.mapListShow(function() {
				window.tabView.add(window.mapListView).show();
			});
		} else {
			window.mapListView.show();
		}
	}
});

var mapListShow = function(ef) {
	var dy = 10,
		dx = 10,
		objs = {};
	objs.isCityLabel = true;
	window.mapListView = new Ext.panel.Panel({
		title: 'Карта',
		iconCls: 'x_btn_map',
		//layout: 'border',
		closable: true,
		defaults: {
			split: true
		},
		listeners: {
			close: function() {
				window.isMapListShow = false;
			}
		},
		tbar: [
			new Ext.Button({
				iconCls: 'x_btn_map_level_up',
				handler: function() {
					objs.GetMap('00');
				}
			}),
			new Ext.Button({
				iconCls: 'x_btn_map_show_cities',
				handler: function() {
					objs.isCityLabel = !objs.isCityLabel;
					objs.SetMapData(objs.mapData);
				}
			}),
			new Ext.Button({
				iconCls: 'x_btn_map',
				handler: function() {
					objs.isRegionLabel = !objs.isRegionLabel;
					objs.SetMapData(objs.mapData);
				}
			}),
			new Ext.Button({
				disabled: true,
				iconCls: 'x_btn_map_show_grid',
				handler: function() {
				}
			}),
			new Ext.Button({
				iconCls: 'x_btn_print',
				handler: function() {
				}
			}),
			new Ext.Button({
				disabled: true,
				iconCls: 'x_btn_refresh'
			}),
			new Ext.Button({
				iconCls: 'x_btn_settings'
			}),
			{ xtype: 'tbseparator' },
			new Ext.Button({
				iconCls: 'x_btn_ZoomIn',
				handler: function() {
				}
			}),
			new Ext.Button({
				iconCls: 'x_btn_ZoomOut',
				handler: function() {
				}
			}),
			new Ext.Button({
				iconCls: 'x_btn_ZoomToFit',
				handler: function() {
				}
			}),
			{ xtype: 'tbseparator' },
			new Ext.Button({
				iconCls: 'x_btn_exit',
				handler: function() {
					window.mapListView.close();
				}
			})
		],
		items: [
			new Ext.panel.Panel({
				autoScroll: true,
				layout: 'absolute',
				border: 0,
				width: '100%',
				height: 2 * dy + 180,
				items: [
					new Ext.form.Label({
						x: dx,
						y: dy + 4,
						text: 'Проверяющие'
					}),
					new Ext.form.field.Text({
						x: dx + 150,
						y: dy,
						readOnly: true,
						width: 100
					}),
					new Ext.Button({
						x: dx + 228,
						y: dy,
						iconCls: 'x_btn_dict',
						handler: function() {
						}
					}),
					new Ext.form.field.Text({
						x: dx + 255,
						y: dy,
						readOnly: true,
						width: 400
					}),
					new Ext.form.field.Checkbox({
						x: dx + 675,
						y: dy,
						boxLabel: 'По проверяюшим'
					}),
					new Ext.form.Label({
						x: dx,
						y: dy + 34,
						text: 'Виды средств'
					}),
					new Ext.form.field.Text({
						x: dx + 150,
						y: dy + 30,
						readOnly: true,
						width: 100
					}),
					new Ext.Button({
						x: dx + 228,
						y: dy + 30,
						iconCls: 'x_btn_dict',
						handler: function() {
						}
					}),
					new Ext.form.field.Text({
						x: dx + 255,
						y: dy + 30,
						readOnly: true,
						width: 400
					}),
					new Ext.form.Label({
						x: dx,
						y: dy + 64,
						text: 'Проверяемый период'
					}),
					new Ext.form.field.Date({
						x: dx + 150,
						y: dy + 60,
						width: 100,
						format: 'd.m.Y',
						minValue: '01.01.1900',
						maxValue: '31.12.2100',
						value: '01.01.1900'
					}),
					new Ext.form.Label({
						x: dx + 258,
						y: dy + 64,
						text: '-'
					}),
					new Ext.form.field.Date({
						x: dx + 270,
						y: dy + 60,
						width: 100,
						format: 'd.m.Y',
						minValue: '01.01.1900',
						maxValue: '31.12.2100',
						value: '31.12.2100'
					}),
					new Ext.form.Label({
						x: dx,
						y: dy + 94,
						text: 'Период проведения'
					}),
					new Ext.form.field.Date({
						x: dx + 150,
						y: dy + 90,
						width: 100,
						format: 'd.m.Y',
						minValue: '01.01.1900',
						maxValue: '31.12.2100',
						value: '01.01.1900'
					}),
					new Ext.form.Label({
						x: dx + 258,
						y: dy + 94,
						text: '-'
					}),
					new Ext.form.field.Date({
						x: dx + 270,
						y: dy + 90,
						width: 100,
						format: 'd.m.Y',
						minValue: '01.01.1900',
						maxValue: '31.12.2100',
						value: '31.12.2100'
					}),
					new Ext.form.Label({
						x: dx,
						y: dy + 124,
						text: 'Виды нарушений'
					}),
					new Ext.form.field.Text({
						x: dx + 150,
						y: dy + 120,
						readOnly: true,
						width: 100
					}),
					new Ext.Button({
						x: dx + 228,
						y: dy + 120,
						iconCls: 'x_btn_dict',
						handler: function() {
						}
					}),
					new Ext.form.field.Text({
						x: dx + 255,
						y: dy + 120,
						readOnly: true,
						width: 115
					}),
					new Ext.form.Label({
						x: dx,
						y: dy + 154,
						text: 'Показатели'
					}),
					new Ext.form.field.Text({
						x: dx + 150,
						y: dy + 150,
						readOnly: true,
						width: 100
					}),
					new Ext.Button({
						x: dx + 228,
						y: dy + 150,
						iconCls: 'x_btn_dict',
						handler: function() {
						}
					}),
					new Ext.form.field.Text({
						x: dx + 255,
						y: dy + 150,
						readOnly: true,
						width: 115
					}),
					new Ext.form.Label({
						x: dx + 400,
						y: dy + 60,
						text: 'Показать'
					}),
					new Ext.form.CheckboxGroup({
						x: dx + 520,
						y: dy + 60,
						columns: 1,
						vertical: true,
						height: 80,
						autoScroll: true,
						items: [
							{ boxLabel: 'Профинансированно', name: 'rb' },
							{ boxLabel: 'Запланированно', name: 'rb' },
							{ boxLabel: 'Проверено', name: 'rb' },
							{ boxLabel: 'Нарушено', name: 'rb' },
							{ boxLabel: 'Направлено', name: 'rb' },
							{ boxLabel: 'Возмещено', name: 'rb' }
						]
					}),
					new Ext.form.Label({
						x: dx + 400,
						y: dy + 150,
						text: 'Выделить цветом'
					}),
					new Ext.form.ComboBox({
						x: dx + 520,
						y: dy + 150,
						width: 200,
						editable: false,
						value: '....'
					}),
					new Ext.form.field.Checkbox({
						x: dx + 740,
						y: dy + 150,
						boxLabel: 'Организации'
					})
				]
			}),
			new Ext.panel.Panel({
				autoScroll: true,
				layout: 'border',
				//border: 0,
				width: '100%',
				height: 650,
				defaults: {
					split: true
				},
				items: [
					objs.draw = new Ext.draw.Component({
						//autoScroll: true,
						autoRender: true,
						region: 'center',
						width: 650,
						height: 650,
						viewBox: false
					}),
					new Ext.grid.Panel({
						width: '50%',
						region: 'east',
						autoScroll: true,
						collapsible: true,
						columnLines: true,
						plugins: [
							new Ext.grid.plugin.CellEditing({
								clicksToEdit: 1
							}),
							'gridclipboard'
						],
						columns: [
							{
								text: 'Код',
								dataIndex: 'cod',
								width: '25%'
							}, {
								text: 'Наименование',
								dataIndex: 'name',
								width: '25%'
							}, {
								text: 'Период действия',
								width: '50%',
								columns: [
									{
										header: 'с',
										dataIndex: 'begin',
										xtype: 'datecolumn',
										format: 'd.m.Y',
										editor: {
											xtype: 'datefield',
											format: 'd.m.Y'
										}
										//    width: '50%'
									}, {
										text: 'по',
										dataIndex: 'end'
										//width: '50%'
									}
								]
							}
						]
					})
				]
			})
		]
	});


	objs.selectRegion = function(okato) {
		if (objs.selectLocality.length) {
			Ext.each(objs.selectLocality, function(sel) {
				sel.attr.stroke = 'black';
				sel.attr['stroke-width'] = 1;
				sel.show(true);
			});
			objs.selectLocality = [];
		}
		if (okato) {
			Ext.each(objs.draw.surface.items.items, function(locality) {
				if (locality.okato == okato) {
					objs.selectLocality.push(locality);
					locality.attr.stroke = 'blue';
					locality.attr['stroke-width'] = 3;
					locality.show(true);
				}
			});
		};
	};

	objs.addSprite = function(list, color, isLabel) {
		Ext.each(list, function(locality) {
			var l = new Ext.draw.Sprite({
				type: 'path',
				path: locality.path,
				stroke: 'black',
				'stroke-width': 1,
				fill: color,
				listeners: {
					click: {
						element: 'el',
						fn: function(e) {
							if (e.hasChild) {
								objs.GetMap(e.okato);
							}
						}
					},
					mouseover: function(e) {
						objs.selectRegion(e.okato);
					}
				}
			});
			l.okato = locality.okato;
			l.hasChild = locality.hasChild;
			objs.draw.surface.add(l);
			l.show(true);
// ReSharper disable WrongExpressionStatement
			new Ext.tip.ToolTip({
				target: l.el,
				showDelay: 50,
				html: locality.name
			});
// ReSharper restore WrongExpressionStatement

			if (isLabel) {
				var text = new Ext.draw.Sprite({
					x: locality.x,
					y: locality.y,
					type: 'text',
					text: locality.name,
					font: '6px'
				});
				objs.draw.surface.add(text);
				text.show(true);
			}
		});
	};

	objs.SetMapData = function(mapData) {
		objs.selectLocality = [];
		objs.draw.surface.removeAll(true);
		var localityLists = [[], [], [], []];

		Ext.each(mapData, function(value) {
			var path = 'M';
			Ext.each(value.Points, function(p) {
				path += ' ' + p.X + ' ' + p.Y;
			});
			path += 'z';
			localityLists[value.Type].push({
				path: path,
				name: value.Name,
				x: value.Bounds.X,
				y: value.Bounds.Y,
				hasChild: value.HasChild,
				okato: value.Okato
			});
		});

		objs.addSprite(localityLists[0], 'white', objs.isRegionLabel);
		objs.addSprite(localityLists[1], 'red', objs.isCityLabel);
		objs.addSprite(localityLists[2], 'blue', objs.isCityLabel);
		objs.addSprite(localityLists[3], 'green', objs.isCityLabel);
	};
	objs.GetMap = function(okato) {
		ajaxRequest({
			params: { okato: okato },
			url: 'data/GetMap_A',
			success: function(value) {
				objs.mapData = value;
				objs.SetMapData(objs.mapData);
			}
		});
	};

	objs.GetMap('00');
	window.isMapListShow = true;

	if (ef)
		ef();
};