Ext.define('Keysystems.Revizor.Mail', {
	extend: 'Ext.Component',
	statics: {
		groupDictionary: {},		
		refresh: function () {
			window.objs.mail?.checkMailTask();
		},
		refreshTree: function () {
			window.objs.mail?.checkMailTask({onlyTreeRefresh: true});
		},

		sendToFilter: null,
		getSendToFilter: async function(){
			if (this.sendToFilter) return this.sendToFilter;
			const res = await ajaxRequestAsync({
				url: 'SSettings/GetSendToFilter_A',
				params: {}});
			this.sendToFilter = res;
			return res;
		},
		resetData: function(){
			this.sendToFilter = null;
		}
	},
	defaultInterval: 60 * 1000,
	firstCheck: true,
	config: {
		interval: null,
		data: null,
	},
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		let me = this;
		me.Tree = new Ext.tree.Panel({
			useArrows: true,
			maskDisabled: false,
			rootVisible: false,
			title: KS.L10n.pochta,
			code: 'MAIL',
			tooltip: KS.L10n.pochta,
			margin: '2 2 2 2',
			iconCls: 'x_btn_message24',
			border: false,
			bodyBorder: false,
			root: {
				expanded: true,
				children: [
					// Типы сообщений (MailType): Входящие (INBOX) = 0, Отправленные (OUTBOX) = 1, Черновики (DRAFTS) = 2
					{
						id: 'pm_inbox',
						text: KS.L10n.vkhodyashchie,
						name: KS.L10n.vkhodyashchie,
						iconCls: 'x_btn_inbox',
						leaf: true,
						mailType: 0
					},
					{
						id: 'pm_outbox',
						text: KS.L10n.otpravlennie,
						name: KS.L10n.otpravlennie,
						iconCls: 'x_btn_outbox',
						leaf: true,
						mailType: 1
					},
					{
						id: 'pm_drafts',
						text: KS.L10n.chernoviki,
						name: KS.L10n.chernoviki,
						iconCls: 'x_btn_drafts',
						leaf: true,
						mailType: 2
					}
				]
			},
			columns: [{
				xtype: 'treecolumn',
				dataIndex: 'text',
				flex: 1,
				renderer: function (val, meta, rec) {
					let notRead = rec.get('notRead');
					return notRead
						? `<b>${rec.get('text')} <span style=\'color:#0285d0;\'>${notRead}</span></b>`
						: rec.get('text');
				}
			}],
			listeners: {
				itemclick: function (th, rec) {
					me.openList(rec.data);
				},
				ksRefresh: function () {
					me.checkMailTask();
				},
				ksTabActivate: function () {
					//me.checkMailTask.bind(me);
				}
			},
			Refresh: me.checkMailTask.bind(me),
		});
		//проверку почту запускаем через 2 сек после инициализации
		setTimeout(Keysystems.Revizor.Mail.refresh, 2000);
		//почту проверяем с интервалом из настроек (если задан) либо по дефолту
		setInterval(Keysystems.Revizor.Mail.refresh, me.interval || me.defaultInterval);
	},

	//таск проверки почты (запросить данные с сервера)
	checkMailTask: function (cfg) {
		//console.log('checkMailTask at ' + new Date());
		let me = this;
		if (me.Disabled) return;
		if (me.firstCheck) me.Tree?.setLoading(wmc.getMask('Updating'));

		ajaxRequest({
			scope: me,
			url: '/SMail/GetMailInfo_A',
			params: {stamp: me.getStamp()},
			success: function (res) {
				if (res.err) {
					if (window.isDebug)
						console.error(res.err);
					else
						Log.sendLog(res.err);
					return;
				}
				let hasChanges = false;
				if (!me.data) {
					me.data = res;
					hasChanges = true;
				}
				else if (me.data.stamp !== res.stamp) {
					me.mergeData(res);
					hasChanges = true;
				}

				if (me.Tree) {
					let inboxNode = me.Tree.getStore().getRootNode().findChild('id', 'pm_inbox', true);
					inboxNode.set('notRead', me.data.notReadInbox);

					let outboxNode = me.Tree.getStore().getRootNode().findChild('id', 'pm_outbox', true);
					outboxNode.set('notRead', me.data.notReadOutbox);
					me.refreshCounterWidget();
				}
				
				if (hasChanges) {
					me.notify(me.data.messages);
					if (!cfg?.onlyTreeRefresh) {
						const index = window.tabView.items.findIndex('code', 'MAIL');
						if (index !== -1) {
							const mailList = window.tabView.items.items[index];
							mailList.refresh();
						}
					}
				}

				me.Tree.setLoading(false);
			},
			failure: function (ex) {
				me.Tree.setLoading(false);
			}
		});

		if (me.firstCheck)
			me.firstCheck = false;
	},

	mergeData: function (res) {
		let me = this;

		//Есть изменения - необходимо обновить локальные данные
		me.data.notReadInbox += res.notReadInbox;
		me.data.notReadInboxImportant += res.notReadInboxImportant;
		me.data.notReadOutbox += res.notReadOutbox;
		me.data.stamp = res.stamp;

		//мержинг
		if (res.messages.length > 0) {
			res.messages.forEach(function (message) {
				let result = me.data.messages.filter(obj => obj.Type === message.Type && obj.ID === message.ID)[0];
				if (!result) me.data.messages.push(message);

				if (message.IsRead && message.Type !== 2) {
					//найти в me.Data.mgo.Messages и пометить как прочтенное
					if (result) {
						result.IsRead = true;
						switch (result.Type) {
							case 0:
								if (me.data.notReadInbox > 0)
									me.data.notReadInbox -= 1;
								if (me.data.notReadInboxImportant > 0)
									me.data.notReadInboxImportant -= 1;
								break;
							case 1:
								if (me.data.notReadOutbox > 0)
									me.data.notReadOutbox -= 1;
								break;
						}
					}
				}
			});
		}
		//server addressees keys
		let sak = Object.keys(res.addresses);
		if (sak.length > 0) {
			if (!me.data.addresses || Object.keys(me.data.addresses).length == 0) {
				me.data.addresses = res.addresses;
			} else {
				sak.forEach(function (key) {
					if (!me.data.addresses[key])
						me.data.addresses[key] = res.addresses[key];
				});
			}
		}

		//если есть удаленные сообщения
		if (res.deletedMessages) {
			//пометить на удаление
			res.deletedMessages.forEach(function (message) {
				let result = me.data.messages.filter(function (obj) {
					return obj.Type === message.Type && obj.ID === message.ID;
				});
				if (result && result.length > 0) result[0].Deleted = true;
			});
		}
		//удалить
		me.data.messages = me.data.messages.filter(obj => obj.Deleted === false);

	},

	getStamp: function () {
		return this.data && this.data.stamp ? this.data.stamp : -1
	},

	//Отобразить оповещение(я)
	notify: function (messages) {
		let me = this,
			importantMessages = [];

		messages.filter(message => message.Type === 0 && message.IsRead === false).forEach(message => {
				if (message.State === 2) {
					importantMessages.push(message);
				} else {
					let theme = (message.Theme != null && message.Theme !== void 0)
						? Ext.util.Format.stripTags(message.Theme).trim() : '';
					if (theme === '') theme = `<${KS.L10n.nettemy}>`;

					let messageText = message.TextBody ?? message.Body,
						body = /<body[^>]*>((.|[\n\r])*)<\/body>/im.exec(messageText) ?? [],
						shortDesc = Ext.util.Format.stripTags(body.length ? body[0].trim() : messageText).substring(0, 200).trim(),
						author = (message.Sender.Value ? message.Sender.Value.join().slice(0, -1) : message.Sender).substring(0, 200).trim();

					// if (shortDesc.startsWith('.cs') || shortDesc.indexOf('{') !== -1) {
					// 	shortDesc = `<a href="#Dashboard.Mail.OpenMailByLink(id=${message.ID})">${KS.L10n.podrobnee}</a>`;
					// }

					window.NotificationManager.AddNotification({
						title: theme,
						author: author,
						creationDate: message.Date,
						id: message.ID,
						type: 'mail',
						description: shortDesc,
						notSave: true,
						events: {
							close: function () {
								//пометить как прочитанное
								//me.MarkAsRead(message);
							},
							markasread: function () {
								//пометить как прочитанное
								//me.MarkAsRead(message);
							},
							//notificationdblclick: me.NotificationDblClick.bind(me, message)
						}
					});
				}
			}
		);
		// if (importantMessages.length > 0) {
		// 	me.ShowImportantMessages(importantMessages);
		// }
	},

	openList: function (cfg) {

		const index = window.tabView.items.findIndex('code', 'MAIL');

		if (index !== -1) {
			const mailList = window.tabView.items.items[index];
			mailList.setTitle(cfg.text);
			mailList.setIconCls(cfg.iconCls);
			mailList.setMailType(cfg.mailType);
			mailList.reFilter();
			window.tabView.setActiveTab(mailList.id);
			//window.tabView.items.items[index].getEl().frame("#0000b9", 1, { duration: 1000 });
		} else {
			//todo получать с бд
			let mailSettings = LocalStorage.get('mail_settings') || {isCompact: true, isHorizontal: false};
			let view = Ext.create('Keysystems.Mail.List', {
				flex: 1,
				code: 'MAIL',
				parentView: window.tabView,
				tabMode: true,
				title: cfg.text,
				iconCls: cfg.iconCls,
				isCompact: mailSettings.isCompact,
				isHorizontal: mailSettings.isHorizontal,
				mailType: cfg.mailType
			});

			let tab = window.tabView.add(view);
			tab.show(window.tabView);
			view.updateLayout();
		}
	},

	refreshCounterWidget: function () {
		let me = this;
		if (me.notReadlabel) {
			me.notReadlabel.setText(me.data.notReadInbox);
			if (me.data.notReadInbox > 0) {
				me.notReadPanel.setHidden(false);
			} else {
				me.notReadPanel.setHidden(true);
			}
		}
	},
	
	createCounterWidget: function (t) {
		let me = this;
		if (t && t.tab.btnIconEl && t.tab.rendered) {
			if (!me.notReadlabel) {
				me.notReadlabel = Ext.create('Ext.form.Label',
					{
						style: {
							top: '-7px',
							color: '#FFF',
							fontFamily: 'arial',
							fontSize: '10px'
						}
					});
				me.notReadPanel = Ext.create('Ext.panel.Panel',
					{
						hidden: true,
						border: false,
						bodyBorder: false,
						width: 16,
						height: 16,
						counterLabel: me.notReadlabel,
						style:
							{
								borderWidth: '1px',
								borderStyle: 'solid',
								borderColor: '#FFF',
								backgroundColor: '#F83E33',
								borderRadius: '6px',
								fontSize: '12px',
								left: '15px',
								top: '-3px'
							},
						items: [me.notReadlabel],
						renderTo: t.tab.btnIconEl
					});
			}
			if (me.data) {
				me.refreshCounterWidget();
			}
		} else {
			t.tab.on('render', me.createCounterWidget.bind(me, t));
		}
	},

	initGroupDictionary: function () {
		let me = this,
			dict = {};

		//Сегодня
		let today = new Date();
		dict[today.toLocaleDateString()] = KS.L10n.segodnya;

		//Вчера
		let yesterday = new Date(today);
		yesterday.setDate(today.getDate() - 1);
		dict[yesterday.toLocaleDateString()] = KS.L10n.vchera;

		//Дни текущей недели от (не включая) "вчера" до понедельника (включая)
		let days = [KS.L10n.voskresene, KS.L10n.ponedelnik, KS.L10n.vtornik, KS.L10n.sreda, KS.L10n.chetverg, KS.L10n.pyatnitsa, KS.L10n.subbota];
		let d = new Date(yesterday);
		if (d.getDay() !== 0) {
			d.setDate(d.getDate() - 1);
			let dw = d.getDay();
			while (dw > 0) {
				dict[d.toLocaleDateString()] = days[dw];
				dw--;
				d.setDate(d.getDate() - 1);
			}
		}

		dict[d.toLocaleDateString()] = KS.L10n.naproshloinedele;

		let i;
		for (i = 0; i < 6; i++) {
			d.setDate(d.getDate() - 1);
			dict[d.toLocaleDateString()] = KS.L10n.naproshloinedele;
		}

		for (i = 0; i < 7; i++) {
			d.setDate(d.getDate() - 1);
			dict[d.toLocaleDateString()] = KS.L10n.dvenedelinazad;
		}

		for (i = 0; i < 7; i++) {
			d.setDate(d.getDate() - 1);
			dict[d.toLocaleDateString()] = KS.L10n.trinedelinazad;
		}

		//Ранее в этом месяце
		if (today.getMonth() === d.getMonth()) {
			var dd = d.getDate() - 1;
			while (dd > 1) {
				d.setDate(dd);
				dict[d.toLocaleDateString()] = KS.L10n.raneevetommesyatse;
				dd = d.getDate() - 1;
			}
			d.setDate(1);
			dict[d.toLocaleDateString()] = KS.L10n.raneevetommesyatse;
		}

		//В прошлом месяце
		let lastMonth = new Date(today), di = 1;
		lastMonth.setDate(-1);
		lastMonth.setDate(1);
		let lml = lastMonth.toLocaleDateString();
		while (dict[lml] === void 0) {
			dict[lml] = KS.L10n.vproshlommesyatse;
			di++;
			lastMonth.setDate(di);
			lml = lastMonth.toLocaleDateString();
		}

		me.GroupDictionary = dict;
		//необходимо для правильной сортировки периодов 
		me.GroupOrders =
			{
				[KS.L10n.segodnya]: 0,
				[KS.L10n.vchera]: 1,
				[KS.L10n.voskresene]: 2,
				[KS.L10n.subbota]: 3,
				[KS.L10n.pyatnitsa]: 4,
				[KS.L10n.chetverg]: 5,
				[KS.L10n.sreda]: 6,
				[KS.L10n.vtornik]: 7,
				[KS.L10n.ponedelnik]: 8,
				[KS.L10n.naproshloinedele]: 9,
				[KS.L10n.dvenedelinazad]: 10,
				[KS.L10n.trinedelinazad]: 11,
				[KS.L10n.raneevetommesyatse]: 12,
				[KS.L10n.vproshlommesyatse]: 13,
				[KS.L10n.boleestarie]: 14
			};
	},
})