//Панель для отображения содержимого письма в режиме "чтения"
Ext.define('Keysystems.Mail.Preview', {
	extend: 'Ext.panel.Panel',
	border: false,
	flex: 2,
	//stateful: true,
	//stateId: 'mailContentContainer',
	layout:
		{
			type: 'vbox',
			align: 'stretch'
		},
	//информация о доступности аттач файлов по id письма
	//структура: { letterId: [attachFilesArray]} 
	//новая сессия - файлов нет
	//при первом обращении - получаем файлы и заносим информацию в данную структуру
	//при повторном - берем информацию из данной структуры
	existingAttachFiles: {},

	constructor: function (cfg) {
		let me = this;
		Ext.apply(me, cfg);
		me.callParent(arguments);
	},

	initComponent: function () {
		let me = this;
		me.TitleLabel = Ext.create('Ext.form.Label',
			{
				colspan: 3,
				style:
					{
						overflow: 'hidden',
						textOverflow: 'ellipsis',
						lineHeight: '30px',
						maxHeight: '46px',
						fontWeight: 'bold',
						fontSize: '14.25pt'
					}
			});
		me.ls =
			{
				fontSize: '9.75pt',
				color: '#999999'
			};
		me.FromLabel = Ext.create('Ext.form.Label', {colspan: 2, flex: 1});
		me.ToLabel = Ext.create('Ext.form.Label', {colspan: 2, flex: 1});
		me.DateLabel = Ext.create('Ext.form.Label', {colspan: 2, flex: 1});

		me.SignerLabel = Ext.create('Ext.form.Label', {flex: 1});
		me.SignerDescriptionImage = Ext.create('Ext.Img', {
			imgCls: 'x_btn_key_primary',
			alt: '',
			width: 16,
			height: 16
		});

		me.SignPanel = Ext.create('Ext.panel.Panel',
			{
				colspan: 3,
				flex: 1,
				border: false,
				layout:
					{
						type: 'hbox',
						align: 'stretch'
					},
				items: [
					{
						xtype: 'label',
						text: KS.L10n.podpisano_info,
						style: me.ls,
						width: 80
					},
					me.SignerLabel,
					me.SignerDescriptionImage
				]
			});

		me.HeaderPanel = Ext.create('Ext.panel.Panel',
			{
				layout:
					{
						type: 'table',
						columns: 3,
						tableAttrs: {
							style: {
								width: '100%'
							}
						},
						trAttrs: {
							style: {
								height: '23px'
							}
						}
					},
				items:
					[
						me.TitleLabel,
						{
							xtype: 'label',
							text: KS.L10n.ot,
							style: Object.assign(me.ls, {'width': '80px'}),
							//cellCls: 'mailTableCell'
						},
						me.FromLabel,
						{
							xtype: 'label',
							text: KS.L10n.komu,
							style: me.ls
						},
						me.ToLabel,
						{
							xtype: 'label',
							text: KS.L10n.polucheno,
							style: me.ls
						},
						me.DateLabel,
						me.SignPanel
					],
				hidden: true,
				padding: 10,
				border: false,
				bodyBorder: false
			});
		me.MessagePage = Ext.create('Ext.panel.Panel', {
			title: KS.L10n.soobshchenie,
			iconCls: 'x_btn_message',
			scrollable: true,
			border: false,
			padding: '10 10 10 10',
			listeners: {
				click: {
					element: 'el',
					fn: function (e, target) {
						let el = Ext.fly(target);
						if (el.dom.nodeName === 'A' && el.dom.href.indexOf('smartLink') >= 0) {
							e.preventDefault();
							e.stopPropagation();
							Meta.SmartLink.Open(el.dom.href);
						}
					}
				}
			}
		});

		//контейнер для тела письма
		me.BodyTabPanel = Ext.create('Ext.tab.Panel', {
			flex: 1,
			border: false,
			hidden: true,
			ui: 'mail-tabs-ks',
			listeners:
				{
					beforetabchange: me.BeforeTabChange.bind(me)
				},
			items: [
				me.MessagePage,
				//me.DocumentsPage
			],
			style:
				{
					borderTop: '1px solid #cecece'
				}
		});
		Ext.apply(this,
			{
				items: [
					me.HeaderPanel,
					me.BodyTabPanel
				]
			});
		this.callParent(arguments);
	},
	SetHeader: function (data) {
		let me = this;
		let sendToKeys = Object.keys(data.SendTo), sendTo = '', names = [];
		for (let i = 0; i < sendToKeys.length; i++) {
			let sendItem = data.SendTo[sendToKeys[i]];
			for (let j = 0; j < sendItem.length; j++) {
				if (sendItem[j] !== '')
					names.push(sendItem[j].trim());
			}
		}
		sendTo = names.join(', ');
		if (sendTo.length > 100) {
			let lel = me.ToLabel.getEl();
			if (lel) {
				lel.set({'data-qtip': sendTo});
			} else {
				me.ToLabel.qtip = sendTo;
				me.ToLabel.addListener('afterrender',
					function (label) {
						if (label.qtip) {
							label.getEl().set({'data-qtip': label.qtip});
						}
					});
			}
			sendTo = sendTo.substring(0, 100) + '...';
		}
		//sendTo = sendTo.slice(0, -1);
		me.HeaderPanel.setHidden(false);
		//заголовок
		me.TitleLabel.setText(data.Theme ? data.Theme : KS.L10n.beztemi);
		//от
		me.FromLabel.setText(data.Sender.Value ? data.Sender.Value.join().slice(0, -1) : data.Sender);
		//кому
		me.ToLabel.setText(sendTo);
		//дата
		me.DateLabel.setText(data.Date.toLocaleString());
	},

	//Отобразить содержимое письма
	Draw: function (selected) {
		let me = this,
			data = selected.items ? selected.items[0].data.DATA : selected;
		me.BodyTabPanel.setVisible(data != null);
		me.HeaderPanel.setVisible(data != null);
		if (data == null) return;

		me.ActiveMailRecord = data;

		//все кроме тела письма (если оно в rtf формате) можно отобразить сразу
		//отображение заголовка (от кого, кому, дата получения)
		me.SetHeader(data);

		//удалить вкладки с Attach от прошлого письма
		let attachTabs = me.BodyTabPanel.query('panel[isAttach]');
		if (attachTabs.length > 0) {
			attachTabs.forEach(function (item) {
				me.BodyTabPanel.remove(item);
			});
		}

		data.ExistInfo = true;
		//количество доступных (уже выгруженных) файлов
		let existFileCount = 0;
		//если есть прикрепленные файлы, список их можно отобразить сразу т.к. массив с их именами уже доступен
		if (data.AttachedFiles.length > 0) {
			for (let i = 0; i < data.AttachedFiles.length; i++) {
				let file = data.AttachedFiles[i], ii = me.IsImage(file.Name);
				if (file.uidWeb)
					existFileCount++;
				let panel = Ext.create('Ext.panel.Panel',
					{
						ID: file.ID,
						title: file.Name,
						iconCls: 'x_btn_add_attachment',
						scrollable: true,
						border: false,
						isAttach: true,
						padding: '10 10 10 10',
						items: {
							xtype: 'component',
							renderData: {
								msg: KS.L10n.neudaloszagruzitsoderzhimoefaila
							},
							renderTpl: '<b>msg</b>'
						}
					});
				if (ii) {
					panel.isImage = true;
					panel.iconCls = ii;
				}
				me.BodyTabPanel.add(panel);
			}
			//если аттач файлы уже скачаны - сразу отобразить
			if (me.existingAttachFiles[data.ID]) {
				//с одним и тем же ID может быть входящее и исходящее сообщение
				//чтобы не скачивать снова берем уже готовые данные
				data.AttachedFiles = me.existingAttachFiles[data.ID];
				//отобразить
				me.SetAttachInfo(data);
			} else {
				if (existFileCount > 0 && data.AttachedFiles.length === existFileCount) {
					me.existingAttachFiles[data.ID] = data.AttachedFiles;
					me.SetAttachInfo(data);
				}
				//установить признак необходимости запроса на сервер
				data.ExistInfo = false;
			}
		}

		//если поле Hash не пустое - значит есть информация о ЭЦП
		//и если статус 0 - необходимо проверить 
		let needCheckSign = data.Hash && data.SignStatus === 0;
		if (needCheckSign) {
			data.ExistInfo = false;
		} else {
			me.SetSignInfo(data);
			//отобразить информацию о подписи если доступна
			// me.SignerLabel.setText(data.Signer ? data.Signer : '');
			// me.SignerDescriptionImage.setTitle(data.SignDescription ? data.SignDescription : '');
		}
		me.SignPanel.setHidden(!data.Hash);

		//очистить список связанных документов
		//me.DocumentsStore.removeAll();
		//установить видимость вкладки связанных документов
		//me.DocumentsPage.tab.setHidden(data.RelatedDocuments.length === 0);
		//если есть связанные документы
		//if (data.RelatedDocuments.length > 0) {
		//отобразить
		//me.DocumentsStore.loadData(data.RelatedDocuments);
		//}

		//сделать активной первую вкладку (сообщение)
		me.BodyTabPanel.setActiveTab(0);

		let bar = me.BodyTabPanel.getTabBar();
		if (me.BodyTabPanel.items.length === 1 && data.RelatedDocuments.length === 0) {
			bar.hide();
		} else {
			bar.show();
		}

		me.MessagePage.setHtml(data.Body);
	},

	//установить информацию о прикрепленных файлах
	SetAttachInfo: function (data) {
		let me = this, id = data.ID;
		if (data.AttachedFiles && data.AttachedFiles.length > 0) {
			me.existingAttachFiles[id] = data.AttachedFiles;
			let attachById = {};
			data.AttachedFiles.forEach(function (item) {
				attachById[item.ID] = item;
			});
			let attachTabs = me.BodyTabPanel.query('panel[isAttach]');
			attachTabs.forEach(function (page) {
				let attach = attachById[page.ID];
				//если есть что прикреплять
				if (attach.uidWeb) {
					page.uidWeb = attach.uidWeb;
					page.menu = me.GetAttachMenu(attach);
					let el = page.tab.getEl();
					if (el) {
						el.on('contextmenu',
							function (e) {
								e.preventDefault();
								page.menu.showAt(e.getXY());
							});
					} else if (!page.tab.rendered) {

					}

					//если картинка - отобразить
					if (page.isImage)
						page.html = Ext.String.format('<img src="{0}" alt="">', _all.rsa + '/File/Get/' + attach.uidWeb);
				}
			});
		}
	},
	GetAttachMenu: function (attach) {
		let me = this;
		return Ext.create('Ext.menu.Menu', {
			items: [
				{
					file: attach.uidWeb,
					text: KS.L10n.sokhranit,
					handler: function (item) {
						// if (item && item.file) {
						// 	FileUtils.DownloadPost(Ext.String.format('{0}/{1}/{2}', _all.rsa, 'File', 'Get'),
						// 		{ id: item.file });
						// }
					}
				},
				{
					text: KS.L10n.sokhranitvsevlozheniya,
					handler: function () {
						// if (me.ActiveMailRecord) {
						// 	FileUtils.DownloadPost(Ext.String.format('{0}/{1}/{2}', _all.rsa, 'Mail', 'GetAllFiles'),
						// 		{ id: me.ActiveMailRecord.ID });
						// }
					}
				}
			]
		});
	},
	//установить информацию о электронной подписи
	SetSignInfo: function (data) {
		let me = this;
		if (data.SignDescription && data.Signer) {
			if (data.SignStatus === 1) //OK
			{
				me.SignerLabel.setText(data.Signer);
				me.SignerLabel.setStyle('color', '');

			} else { //FAIL
				me.SignerLabel.setText(data.SignStatusText);
				me.SignerLabel.setStyle('color', 'red');
			}
			let title = `${data.SignDescription}`;
			let lel = me.SignerDescriptionImage.getEl();
			if (lel) {
				lel.set({'data-qtip': title});
			}
		}
	},
	IsImage: function (name) {
		let en = name.substr(name.lastIndexOf('.') + 1);
		if (('bmp,dds,gif,jpg,png,psd,pspimage,tga,thm,tif,tiff,yuv,webp'.indexOf(en) !== -1)) {
			if (en === 'jpg') en = 'jpeg';
			return 'x_btn_ext-' + en;
		}
		return false;
	},
	//обработка события от клика по табу до переключения на наго (сообщение, документы, вложения)
	BeforeTabChange: function (tabPanel, newCard) {
		if (newCard && newCard.isAttach && !newCard.isImage) {
			//если вложение - не картинка, то не переключаться на таб, а вызвать скачивание файла
			if (newCard.uidWeb) {
				FileUtils.DownloadPost(_all.rsa + '/File/Get', {id: newCard.uidWeb});
			} else {
				FileUtils.DownloadPost(_all.rsa + '/Mail/GetAttach', {
					mailId: this.ActiveMailRecord.ID,
					attachId: newCard.ID
				});
			}

			return false;
		}
		//переключиться на таб
		return true;
	}
});