Ext.define('Keysystems.Mail.List',
	{
		extend: 'Ext.panel.Panel',
		mixins: ['Keysystems.ToolbarBuilder'],
		isHorizontal: true,
		isCompact: false,
		border: false,
		checkModel: true,
		hidePagging: true,
		closable: true,
		btnsHide: {},
		code: 'MAIL',
		selButtons: ['mail_read_plt', 'mail_reply_plt', 'mail_replyall_plt', 'mail_forward_plt', 'mail_delete_plt'],
		layout: {
			type: 'hbox',
			align: 'stretch'
		},
		config: {
			mailType: null
		},
		constructor: function (cfg) {
			let me = this;
			Ext.apply(me, cfg);
			me.callParent(arguments);
		},
		statics: {
			groupDictionary: null,
			groupOrders: null
		},
		initComponent: function () {
			let me = this;
			me.items = me.createItems();
			me.callParent(arguments);

			me.on('afterrender', () => {
				me.getData();
			});
		},

		createItems: function () {
			let me = this;
			me.isCreate = true;

			me.GridStore = Ext.create('Ext.data.Store',
				{
					fields: [
						{name: 'DATA', type: 'auto'},
						{name: 'ID', type: 'int'},
						{name: 'IS_READ', type: 'bool'},
						{name: 'CHECKED', type: 'bool'},
						{name: 'STATE', type: 'string'},
						{name: 'IMAGE', type: 'string'},
						{name: 'DOC', type: 'string'},
						{name: 'ATTACHMENT', type: 'string'},
						{name: 'SENDER', type: 'string'},
						{name: 'SENDTO', type: 'string'},
						{name: 'THEME', type: 'string'},
						{name: 'DATE', type: 'date'},
						{name: 'STATUS', type: 'string'},
						{name: 'NOT_DELIVERED', type: 'string'},
						{name: 'dateGroup', type: 'string'},
						{name: 'dateGroupOrder', type: 'int'}
					],
					data: [],
					//фильтр по типу сообщения подключен сразу
					//фильтр по значению будет подключаться при необходимости
					//filters: [me.FilterByType.bind(me)],
					remoteSort: false,
					sorters: [
						{
							property: 'DATE',
							direction: 'DESC'
						}
					],
					grouper: {
						sortProperty: 'dateGroupOrder',
						groupFn: function (record) {
							return record.get('dateGroup');
						}
					},
					groupDir: 'ASC',
					listeners:
						{
							beforesort: function (store, opts) {
								//при сортировке по колонке "Дата" необходимо также выполнить перегруппировку
								if (opts[0]._property === 'DATE') {
									var grouper = store.getGrouper();
									if (grouper && (grouper._direction === opts[0]._direction) && !store.doGroup) {
										store.doGroup = true;
										grouper.setDirection((grouper._direction === 'ASC') ? 'DESC' : 'ASC');
										delete store.doGroup;
									}
								}
							},
							sort: function (store, opts) {
								//if (opts[0]._property === 'Date')
								//me.Refilter();
							}
						}
				});

			me.columns = [
				//Важное
				{
					xtype: 'actionimg',
					dataIndex: 'IMG_STATE',
					iconCls: 'x_btn_message_important',
					menuDisabled: true,
					getClass: (v, meta, rec) => rec.get('STATE') ? 'x_btn_message_important' : ''
				},
				//Прочитано/Не прочитано
				{
					xtype: 'actionimg',
					dataIndex: 'IMG_IMAGE',
					iconCls: 'x_btn_message_read',
					menuDisabled: true,
					getClass: function (v, meta, rec) {
						return rec.get('IMAGE') ? 'x_btn_' + rec.get('IMAGE') : '';
					}
				},
				//Вложения
				{
					xtype: 'actionimg',
					dataIndex: 'IMG_ATTACHMENT',
					iconCls: 'x_btn_message_attach',
					menuDisabled: true,
					getClass: (v, meta, rec) => rec.get('ATTACHMENT') ? 'x_btn_message_attach' : ''
				},
				{text: "От", dataIndex: 'SENDER', width: 200, isSummary: false},
				{text: "Кому", dataIndex: 'SENDTO', width: 200, isSummary: false},
				{text: "Тема", dataIndex: 'THEME', width: 200, isSummary: false},
				{
					text: "Получено",
					dataIndex: 'DATE',
					width: 80,
					isSummary: false,
					xtype: 'datecolumn',
					format: 'd.m.Y'
				},
				{text: "Статус", dataIndex: 'STATUS', width: 200, isSummary: false},
				{text: "Не доставлено", dataIndex: 'NOT_DELIVERED', width: 200, isSummary: false},
				{
					text: "Компактное представление",
					flex: 1,
					dataIndex: 'COMPACT',
					hidden: true,
					renderer: me.renderCompact.bind(me)
				}
			];

			me.Grid = objs.Grid = Ext.create('Keysystems.Controls.GroupingGrid',//
				{
					flex: 1,
					autoScroll: true,
					autoRender: true,
					border: 0,
					bodyBorder: 0,
					columnLines: false,
					store: me.GridStore,
					selModel: {
						selType: 'checkboxmodel',
						mode: 'MULTI'
					},
					features: [
						{
							ftype: 'grouping',
							groupHeaderTpl: [
								'{[values.children[0].data.dateGroup]}'
							]
						}],
					viewConfig: {
						markDirty: false,
						stripeRows: false,
						getRowClass: function (record) {
							return me.isCompact ? 'compact' : ('full' + (!record.data.IS_READ ? ' notRead' : ''));
						}
					},
					columns: [],
					fieldLink: 'ID',
					groupField: 'dateGroup',
					sortField: 'dateGroupOrder',
					listeners:
						{
							selectionchange: me.read.bind(me),
							//groupclick: () => me.disableButtons(me.selButtons, true)
						}
				});
			me.HBox = Ext.create('Ext.panel.Panel',
				{
					border: false,
					flex: true,
					layout: {
						type: 'hbox',
						align: 'stretch'
					}
				});
			me.VBox = Ext.create('Ext.panel.Panel',
				{
					border: false,
					flex: true,
					layout: {
						type: 'vbox',
						align: 'stretch'
					}
				});

			const size = window.tabView.getSize(),
				pw = parseInt(size.width / 3),
				ph = parseInt(size.height / 3);

			//контейнер для списка писем
			me.ListContainer = Ext.create('Ext.panel.Panel',
				{
					border: false,
					height: 2*ph,
					width: pw,//300,
					items: [me.Grid],
					layout: 'fit',
					stateful: true,
					stateId: 'mailListContainer'
				});

			//контейнер для отображения содержимого письма
			me.ContentContainer = Ext.create('Keysystems.Mail.Preview',
				{
					border: false,
					height: 1 * ph,
					width: 1 * pw,
				});

			me.HSplitter = Ext.create('Ext.resizer.Splitter', {
				performCollapse: false,
				style: {border: '1px #cecece solid'}
			});
			me.VSplitter = Ext.create('Ext.resizer.Splitter', {
				performCollapse: false,
				style: {border: '1px #cecece solid'}
			});


			if (me.isHorizontal) {
				me.HBox.add(me.ListContainer);
				me.HBox.add(me.HSplitter);
				me.HBox.add(me.ContentContainer);
			} else {
				me.VBox.add(me.ListContainer);
				me.VBox.add(me.VSplitter);
				me.VBox.add(me.ContentContainer);
			}

			let items = [];
			items.push(me.isHorizontal ? me.HBox : me.VBox);

			me.isCreate = false;
			return items;
		},
		getData: function (cfg) {
			let me = this,
				p = {needToolbar: true};

			Ext.apply(p, cfg);
			if (!window.cachedResources.mail) p.needResource = true;
			const loadMask = new Ext.LoadMask({
				msg: KS.L10n.loading_data,
				view: me,
				rid: ajaxRequest({
					params: {cfg: JSON.stringify(p)},
					url: 'SMail/GetMailList_A',
					success: function (value) {
						let errorMsg = value.ErrorMsg || value.data?.ErrorMsg;
						if (errorMsg) {
							info(errorMsg);
							return false;
						}
						if (value.resource) {
							window.cachedResources.mail = true;
							Ext.apply(KS.L10n, value.resource);
						}
						me.isLoading = true;
						me.setData(value, function () {
							me.isLoading = false;
						});
					},
					callback: () => loadMask.destroy()
				})
			});
			loadMask.show();
		},

		fillData: function () {
			let me = this,
				messages = window.objs.mail.data.messages,
				data = [];
			for (let i = 0; i < messages.length; i++) {
				let message = messages[i],
					isImportant = message.State === 2,
					row = {};
				row.CHECKED = false;
				row.DATA = message;
				row.ID = message.ID;
				row.TYPE = message.Type;
				row.IS_READ = message.IsRead;
				row.STATE = isImportant ? 'message_important' : '';
				row.IMAGE = message.IsRead || message.Type === 2
					? (!message.Hash ? "message_read" : "message_sign_read")
					: (!message.Hash ? "message" : "message_sign")

				row.ATTACHMENT = message.AttachedFiles != null && message.AttachedFiles.length > 0 ? 'message_attach' : '';
				row.SENDER = message.Sender.Value ? message.Sender.Value.join().slice(0, -1) : message.Sender;
				if (message.Type !== 0) row.SENDTO = me.getSendTo(message);
				if (message.Type === 0 || message.Type === 1) {
					row.DATE = message.Date;
				}
				row.THEME = message.Theme;
				if (message.Type === 0) {
					row.STATUS = message.Status;
				}
				data.push(row);

				//дополняем данным фиктивными группами для корректного выделения группы

				const group = me.getGroup(row.DATE),
					groupOrder = me.self.groupOrders[group];

				if (!data.filter(val => val.dateGroup === group && val.ID === 0 && val.TYPE === row.TYPE)[0]) {
					data.push({
						dateGroup: group,
						dateGroupOrder: groupOrder,
						ID: 0,
						TYPE: row.TYPE,
						DATE: new Date(2100, 11, 31).toISOString(),
					})
				}
				row.dateGroup = group;
				row.dateGroupOrder = groupOrder;
			}
			return data;
		},

		getSendTo: function (data) {
			let sendToKeys = Object.keys(data.SendTo), names = [];
			for (let i = 0; i < sendToKeys.length; i++) {
				let sendItem = data.SendTo[sendToKeys[i]];
				for (let j = 0; j < sendItem.length; j++) {
					if (sendItem[j] !== '')
						names.push(sendItem[j].trim());
				}
			}
			return names.join(', ');
		},

		setData: function (value, endFunc) {
			let me = this;
			me.objs = me.objs || {};

			if (!me.self.groupDictionary) {
				me.initGroupDictionary();
			}

			if (value.toolbar) {
				me.toolbarModel = value.toolbar;
				let compactBtn = me.toolbarModel.filter(item => item.code === "BUTTON_MAIL_COMPACT_VIEW_PLT")[0];
				if (compactBtn) compactBtn.nodeStyle = 101;

				let fullBtn = me.toolbarModel.filter(item => item.code === "BUTTON_MAIL_FULL_VIEW_PLT")[0];
				if (fullBtn) fullBtn.nodeStyle = 101;

				me.createToolbar.call(this);
			}

			value.data = me.fillData();

			const columns = me.columnsAdapted();
			me.setFilterByType();
			me.selectFirstRow();

			const compact = me.isCompact;
			this.objs.tbarBtns.mail_compact_view_plt.setPressed(compact);
			this.objs.tbarBtns.mail_full_view_plt.setPressed(!compact);
			//me.switchView(compact);

			me.reconfigure(columns);
			me.Grid.loadData(value.data);

			if (endFunc) endFunc();
		},

		refresh: function () {
			let me = this,
				data = me.fillData(),
				sel = me.Grid.getFrstSelect();
			me.Grid.loadData(data);
			if (sel) me.Grid.getSelectionModel().select(sel);
		},

		reconfigure: function (columns) {
			let me = this;
			delete me.Grid.columnSettings;
			me.Grid.setHideHeaders(me.isCompact);

			if (!me.isCompact) {
				Ext.create('Keysystems.Controls.Grid.ColumnManager',
					{
						inputColumns: columns,
						code: me.code,
						profileKey: `gridMail_${me.mailType}`,
						grid: me.Grid
					});
			} else
				me.Grid.reconfigure(me.Grid.getStore(), columns);
		},

		columnsAdapted: function () {
			let me = this,
				cols = me.columns,
				mailType = me.getMailType();

			for (let i = 0; i < cols.length; i++) {
				let col = cols[i];

				col.hidden = me.isCompact ? col.dataIndex !== 'COMPACT' : col.dataIndex === 'COMPACT'
				if (me.isCompact) continue;

				switch (col.dataIndex) {
					case "SENDER":
						col.hidden = mailType !== 0;
						break;
					case "SENDTO":
						col.hidden = mailType === 0;
						break;
					case "STATUS":
						col.hidden = mailType !== 0;
						break;
					case "DATE":
						if (mailType === 0)
							col.text = 'Получено';
						else if (mailType === 1)
							col.text = 'Отправлено';
						col.hidden = mailType === 2;
						break;
					case "NOT_DELIVERED":
						col.hidden = mailType !== 1;
						break;
				}
			}
			return cols;
		},

		setColumnToImage: function (columns, dataIndex, cls, tdClsByValue) {
			let idx = ArrayLib.find(columns, ['dataIndex'], dataIndex);

			if (idx === -1) return;

			columns[idx] = {
				xtype: 'actionimg',
				dataIndex: 'IMG_' + dataIndex,
				iconCls: cls,
				menuDisabled: true,
				getClass: function (v, meta, rec) {
					return rec.get(dataIndex) ? (tdClsByValue ? 'x_btn_' + rec.get(dataIndex) : cls) : '';
				}
			};
		},

		//Отрисовка компактного представления
		renderCompact: function (value, metadata, record) {
			let me = this,
				data = record.data,
				icons = [],
				readState = !data.IS_READ ? ' notRead' : '';

			data.STATE && icons.push('x_btn_' + data.STATE);
			data.IMAGE && icons.push('x_btn_' + data.IMAGE);
			data.ATTACHMENT && icons.push('x_btn_' + data.ATTACHMENT);
			//icons.push(data.AttachedFilesImg);

			while (icons.length < 4) icons.unshift('');
			let sender = data.SENDER,
				theme = data.THEME,
				filter = null; //me.CompactFilter.getValue();
			if (filter) {
				sender = me.markFiltered(filter, sender);
				theme = me.markFiltered(filter, theme);
			}

			const template = [
				'<div class="compactMail' + readState + '">',
				'<div class="compactMailRow">',
				'<div class="compactMailHeaderText">{0}</div>',
				icons[0] ? '<div class="compactMailHeaderIcon ' + icons[0] + '"></div>' : '',
				icons[1] ? '<div class="compactMailHeaderIcon ' + icons[1] + '"></div>' : '',
				icons[2] ? '<div class="compactMailHeaderIcon ' + icons[2] + '"></div>' : '',
				icons[3] ? '<div class="compactMailHeaderIcon ' + icons[3] + '"></div>' : '',
				'</div>',
				'<div  class="compactMailRow">',
				'<div class="compactMailTheme">{1}</div>',
				'<div class="compactMailDate">{2}</div>',
				'</div>',
				'</div>'
			].join('\n');
			return Ext.String.format(template, sender, theme, data.DATE ? data.DATE.toLocaleTimeString().slice(0, 8) : '');
		},

		markFiltered: function (search, subject) {
			const regex = new RegExp(search, 'gi');
			return subject.replace(regex,
				function (str) {
					return '<span style=\'color: #619e26;\'><b>' + str + '</b></span>';
				});
		},

		setFilterByType: function () {
			let me = this,
				mailType = me.getMailType(),
				store = me.Grid.getStore();
			store.clearFilter();
			store.filter([{
				property: 'TYPE',
				value: mailType,
				filterFn: function (item) {
					return item.get('TYPE') === mailType
				}
			}]);
		},


		reFilter: function () {
			let me = this;
			me.setFilterByType();
			let cols = me.columnsAdapted();
			me.reconfigure(cols);
			me.selectFirstRow();
		},

		initGroupDictionary: function () {
			let me = this,
				dict = {};

			//Сегодня
			let today = new Date();
			dict[today.toLocaleDateString()] = KS.L10n.Mail_segodnya;

			//Вчера
			let yesterday = new Date(today);
			yesterday.setDate(today.getDate() - 1);
			dict[yesterday.toLocaleDateString()] = KS.L10n.Mail_vchera;

			//Дни текущей недели от (не включая) "вчера" до понедельника (включая)
			let days = [KS.L10n.Mail_voskresene, KS.L10n.Mail_ponedelnik, KS.L10n.Mail_vtornik, KS.L10n.Mail_sreda, KS.L10n.Mail_chetverg, KS.L10n.Mail_pyatnitsa, KS.L10n.Mail_subbota];
			let d = new Date(yesterday);
			if (d.getDay() !== 0) {
				d.setDate(d.getDate() - 1);
				let dw = d.getDay();
				while (dw > 0) {
					dict[d.toLocaleDateString()] = days[dw];
					dw--;
					d.setDate(d.getDate() - 1);
				}
			}

			dict[d.toLocaleDateString()] = KS.L10n.Mail_naproshloinedele;

			let i;
			for (i = 0; i < 6; i++) {
				d.setDate(d.getDate() - 1);
				dict[d.toLocaleDateString()] = KS.L10n.Mail_naproshloinedele;
			}

			for (i = 0; i < 7; i++) {
				d.setDate(d.getDate() - 1);
				dict[d.toLocaleDateString()] = KS.L10n.Mail_dvenedelinazad;
			}

			for (i = 0; i < 7; i++) {
				d.setDate(d.getDate() - 1);
				dict[d.toLocaleDateString()] = KS.L10n.Mail_trinedelinazad;
			}

			//Ранее в этом месяце
			if (today.getMonth() === d.getMonth()) {
				var dd = d.getDate() - 1;
				while (dd > 1) {
					d.setDate(dd);
					dict[d.toLocaleDateString()] = KS.L10n.Mail_raneevetommesyatse;
					dd = d.getDate() - 1;
				}
				d.setDate(1);
				dict[d.toLocaleDateString()] = KS.L10n.Mail_raneevetommesyatse;
			}

			//В прошлом месяце
			let lastMonth = new Date(today), di = 1;
			lastMonth.setDate(-1);
			lastMonth.setDate(1);
			let lml = lastMonth.toLocaleDateString();
			while (dict[lml] === void 0) {
				dict[lml] = KS.L10n.Mail_vproshlommesyatse;
				di++;
				lastMonth.setDate(di);
				lml = lastMonth.toLocaleDateString();
			}

			me.self.groupDictionary = dict;
			//необходимо для правильной сортировки периодов 
			me.self.groupOrders =
				{
					[KS.L10n.Mail_segodnya]: 0,
					[KS.L10n.Mail_vchera]: 1,
					[KS.L10n.Mail_voskresene]: 2,
					[KS.L10n.Mail_subbota]: 3,
					[KS.L10n.Mail_pyatnitsa]: 4,
					[KS.L10n.Mail_chetverg]: 5,
					[KS.L10n.Mail_sreda]: 6,
					[KS.L10n.Mail_vtornik]: 7,
					[KS.L10n.Mail_ponedelnik]: 8,
					[KS.L10n.Mail_naproshloinedele]: 9,
					[KS.L10n.Mail_dvenedelinazad]: 10,
					[KS.L10n.Mail_trinedelinazad]: 11,
					[KS.L10n.Mail_raneevetommesyatse]: 12,
					[KS.L10n.Mail_vproshlommesyatse]: 13,
					[KS.L10n.Mail_boleestarie]: 14
				};
		},

		getGroup: function (date) {
			let me = this,
				dt = (new Date(date));
			let gr = me.self.groupDictionary[dt.toLocaleDateString()];
			if (!gr) {
				return KS.L10n.Mail_boleestarie;
			}
			return gr;
		},

		//Отобразить содержимое письма
		read: function (selection) {
			let me = this;
			selected = selection.selected;
			if (selected.length > 0 && !selected.items[0].data.ID) selected = [];

			if (selected.length > 0) {
				let record = selected.items[0],
					data = record.data;
				//me.ActiveMailRecord = data;

				//отобразить доступное на данный момент содержимое
				me.ContentContainer.Draw(selected);

				if (!me.isLoading && data.TYPE === 0 && !data.IS_READ || !data.DATA.ExistInfo) {
					// пометка на сервере письма как прочитанного
					// маска отображается только при необходимости получить вложенные файлы
					if (!data.DATA.ExistInfo) {
						const loadMask = new Ext.LoadMask({
							msg: KS.L10n.Mail_podgotovka,
							target: me,
							autoShow:true,
							rid: ajaxRequest({
								url: '/SMail/ConfirmMail_A',
								params: {links: [data.ID]},
								success: function (response) {
									if (!response) return;
									//me.SetBody.bind(this, data)
								},
								callback: function () {
									loadMask.destroy();
								}
							})
						});
					} else {
						ajaxRequest({
							url: '/SMail/ConfirmMail_A',
							params: {links: [data.ID]}
						});
					}

					if (!data.IS_READ) {
						//локально пометить как прочитанное (вызовет перерисовку с другим стилем)
						data.IS_READ = true;
						record.commit();
						//в дереве (навигаторе) необходима перерисовка с новым значением счетчика непрочтенных
						Keysystems.Revizor.Mail.refreshTree();
					}
				}
				me.setMailVisible(true);
				me.disableButtons(me.selButtons, false);
			} else {
				//выделение отсутствует - скрыть панель отображения письма
				me.setMailVisible(false);
				me.disableButtons(me.selButtons, true);
			}
		},
		setMailVisible: function (visible) {
			let me = this,
				panels = me.ContentContainer.items.items;//.query('panel');
			Ext.Array.each(panels, function (panel) {
				if (visible)
					panel.show();
				else
					panel.hide();
			});
		},
		selectFirstRow: function () {
			let me = this,
				firstRow = me.GridStore.findBy(rec => rec.get('ID'));//me.GridStore.getAt(0);
			if (firstRow !== -1) {
				me.Grid.getSelectionModel().select(firstRow);
				me.Grid.focus();
				me.Grid.scrollTo(0, 0, false);
				me.setMailVisible(true);
				me.disableButtons(me.selButtons, false);
			} else {
				//выделение отсутствует - скрыть панель отображения письма
				me.setMailVisible(false);
				me.disableButtons(me.selButtons, true);
			}
		},

		highlightRenderer: function (text) {
			var me = this, filter = [];//me.CompactFilter.getValue();
			if (filter.length > 0) {
				return me.mark(filter, text);
			} else {
				return text;
			}
		},
		mark: function (search, subject) {
			var regex = new RegExp(search, 'gi');
			return subject.replace(regex,
				function (str) {
					return '<span style=\'color: #619e26;\'><b>' + str + '</b></span>';
				});
		},

		switchView: function (compact) {
			let me = this;
			me.isCompact = compact != null ? compact : me.isCompact;
			let cols = me.columnsAdapted();
			me.reconfigure(cols);
			me.saveSettings();
		},

		saveSettings: function () {
			let me = this;
			LocalStorage.set('mail_settings', {isCompact: me.isCompact, isHorizontal: me.isHorizontal});
		},

		/**
		 * Сформировать сообщение
		 * @param {any} to
		 * @param {any} theme
		 * @param {any} body
		 * @param {any} re
		 */
		copy: function (to, theme, body, re) {
			let me = this,
				sel = me.Grid.getFrstSelect(),
				data = sel?.data?.DATA;
			if (!data) return;
			let messageForm = Ext.create('Keysytems.Mail.Edit');

			let sendTo = [],
				sendKeys = Object.keys(data.SendTo),
				sendValues = [];
			sendKeys.forEach(key => {
				sendTo.push(
					{
						UID: key,
						DefaultName: data.SendTo[key][0]
					});
				sendValues.push(data.SendTo[key][0]);
			});

			//блок сообщения
			var message = body ? data.Body : '';
			//вставка блока RE:
			if (re) {
				let reFooter = [
					'<span style="font-size:10pt;font-weight:400;font-family:Segoe UI, OpenSans, sans-serif;line-height:16px">',
					`<b>${KS.L10n.Mail_ot}: </b>{0}<br>`,
					`<b>${KS.L10n.Mail_data}: </b>{1}<br>`,
					`<b>${KS.L10n.Mail_komu}: </b>{2}<br>`,
					`<b>${KS.L10n.Mail_tema}: </b>{3}<br><br>`,
					'</span>'
				];
				let footerText = Ext.String.format(reFooter.join(''),
					data.Sender.Value ? data.Sender.Value.join().slice(0, -1) : data.Sender,
					data.Date,
					sendValues.join(),
					data.Theme);
				message = '<br><br><hr style="border: 0.5px solid #E1E1E1">' + footerText + message;
			}
			messageForm.Message.setValue(message);

			//блок темы
			if (theme) messageForm.Theme.setValue(re ? 'RE: ' + data.Theme : data.Theme);

			//копирование блока "кому"
			if (to) {
				messageForm.To.store.loadData(sendTo)
				messageForm.To.setValue(sendTo.map(r => r.UID));
			}
			messageForm.show();
		},

		//#region ТАСКИ

		mailNewTask: function () {
			Ext.create('Keysytems.Mail.Edit').show();
		},

		mailReadTask: function () {
			let sels = this.Grid.getSelectionModel().getSelection();
			if (sels.length === 0) return;

			sels = sels.filter(sel => !sel.data.IS_READ);

			ajaxRequest({
				url: '/SMail/ConfirmMail_A',
				params: {links: sels.map(sel => sel.data.ID)}
			});

			sels.forEach(sel => {
				sel.data.IS_READ = true;
				sel.commit();
			});
		},

		mailRefreshTask: function () {
			window.objs.mail?.checkMailTask();
		},

		mailReplyTask: function () {
			this.copy(true, true, true, true);
		},

		mailReplyAllTask: function () {
			//todo в чем отличие от mailReplyTask?
			this.copy(true, true, true, true);
		},

		mailForwardTask: function () {
			this.copy(false, false, true, true);
		},

		mailDeleteTask: function () {
			let me = this,
				sels = me.Grid.getSelectionModel().getSelection();
			if (sels.length === 0) return;

			selectDialogShow(KS.L10n.delete,
				wmc.get('DeleteMessage', sels.length),
				() => {
					let links = sels.map(sel => sel.data.ID);

					const loadMask = new Ext.LoadMask({
						msg: `${KS.L10n.delete}...`,
						view: me,
						autoShow: true,
						rid: ajaxRequest({
							url: '/SMail/DeleteMail_A',
							params: {links: links, mailType: me.mailType},
							success: function (response) {
								if (!response) return;
								Keysystems.Revizor.Mail.refresh();
							},
							callback: function () {
								loadMask.destroy();
							}
						})
					});
				}
			);
		},

		/**
		 * Компактное представление
		 */
		mailCompactViewTask: function () {
			let me = this;
			if (me.isCompact) {
				me.objs.tbarBtns.mail_compact_view_plt.setPressed(true);
				return;
			}
			me.objs.tbarBtns.mail_full_view_plt.setPressed(false);
			me.switchView(true);
		},

		/**
		 * Полное представление
		 */
		mailFullViewTask: function () {
			let me = this;
			if (!me.isCompact) {
				me.objs.tbarBtns.mail_full_view_plt.setPressed(true);
				return;
			}
			me.objs.tbarBtns.mail_compact_view_plt.setPressed(false);
			me.switchView(false);
		},

		/**
		 * Переключить область чтения
		 */
		mailSwitchReadAreaTask: function () {
			let me = this;

			me.isHorizontal = !me.isHorizontal;
			me.removeAll(false);

			if (me.isHorizontal) {
				me.HBox.add(me.ListContainer);
				me.HBox.add(me.HSplitter);
				me.HBox.add(me.ContentContainer);
				me.add(me.HBox);
			} else {
				me.VBox.add(me.ListContainer);
				me.VBox.add(me.VSplitter);
				me.VBox.add(me.ContentContainer);
				me.add(me.VBox);
			}
			me.saveSettings();
		},

		//#endregion
	},
)