﻿//"Форма" письма
Ext.define('Keysytems.Mail.Edit', {
		extend: 'Ext.window.Window',
		cls: 'mailFormMessage',
		constrain: true,
		width: 800,
		height: 600,
		layout: 'fit',
		state: 1,
		constructor: function (cfg) {
			let me = this;
			me.callParent(arguments);
			me.setTitle(KS.L10n.Mail_novoesoobshcheniebeztemi);
		},
		//прикрепленные файлы
		initComponent: function () {
			var me = this;
			me.Panel = Ext.create('Ext.panel.Panel',
				{
					border: false,
					bodyBorder: false,
					layout: {
						type: 'vbox',
						align: 'stretch'
					}
				});
			me.Toolbar =
				Ext.create('Ext.Toolbar', {
					dock: 'top',
					border: 0,
					padding: '0 0 0 10px',
					items: [
						{
							itemId: 'btn_mail_important',
							text: KS.L10n.Mail_vazhnoepismo,
							tooltipType: 'title',
							iconCls: 'x_btn_message_important',
							enableToggle: true,
							handler: function (btn) {
								me.state = btn.pressed ? 2 : 1;
							}
						},
						{
							itemId: 'btn_mail_save',
							text: KS.L10n.Mail_sokhranitvchernoviki,
							tooltipType: 'title',
							iconCls: 'x_btn_save_in_drafts',
							handler: function () {
								me.Send(true);
							}
						},
						{
							hidden: true,
							itemId: 'btn_mail_cliche',
							//scale: 'small',
							text: KS.L10n.Mail_podpisvpisme,
							iconCls: 'x_btn_mail_sign',
							menu: [{
								text: KS.L10n.Mail_dobavitpodpis,
								itemId: 'btn_mail_cliche_add'
							}],
							handler: function () {

							}
						}
					]
				});
			//кому
			me.toStore = Ext.create('Ext.data.Store',
				{
					fields: [
						{name: 'DefaultName'},
						{name: 'UID'}
					],
					data: []
				});

			//список всех адресов использованных в письмах (для быстрого ввода)
			const addressees = window.objs.mail.getData()?.addresses;
			if (addressees) {
				let uids = Object.keys(addressees);
				uids.forEach(function (uid) {
					me.toStore.add(
						{
							UID: uid,
							DefaultName: addressees[uid]
						});
				});
			}
			me.To = Ext.create('Ext.form.field.Tag',
				{
					store: me.toStore,
					displayField: 'DefaultName',
					valueField: 'UID',
					queryMode: 'local',
					filterPickList: true,
					hideTrigger: true,
					listeners:
						{
							specialkey: function (field, e) {
								if (e.getKey() === e.ENTER) {
									field.blur();
								}
							},
							change: function (field, newvalue) {
								me.SendButton.setDisabled(newvalue.length === 0);
							}
						},
					flex: 1,
					maxHeight: 96,
					fieldStyle: {
						border: 'none!important',
						borderWidth: '0 !important',
						backgroundImage: 'none !important',
						backgroundColor: 'transparent !important'
					}
				});
			me.Theme = Ext.create('Ext.form.field.Text',
				{
					flex: 1,
					margin: '0 0 0 0',
					padding: '4px, 0, 0, 0',
					height: 24,
					listeners:
						{
							change: me.OnThemeChanged.bind(me)
						}
				});
			me.SendButton = Ext.create('Ext.button.Button',
				{
					rowspan: 3,
					xtype: 'button',
					disabled: true,
					height: 68,
					width: 69,
					margin: '0 10px 0 0',
					handler: me.Send.bind(me, false),
					scale: 'large',
					iconAlign: 'top',
					text: KS.L10n.Mail_otpravitpismo,
					iconCls: 'x_btn_message_send32'
				});

			//me.UploadsView = Ext.create('KSWN.meta.mail.UploadsView');

			var container1 = Ext.create('Ext.panel.Panel',
				{
					padding: '0 0 5 0',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					items:
						[
							{
								xtype: 'panel',
								border: false,
								layout: {
									type: 'vbox',
									align: 'stretch'
								},
								items: [me.SendButton, {xtype: 'component', flex: 1}]
							},
							{
								xtype: 'panel',
								border: false,
								flex: 1,
								layout: {
									type: 'vbox',
									align: 'stretch'
								},
								items: [
									{
										xtype: 'panel',
										border: false,
										layout:
											{
												type: 'hbox',
												align: 'stretch'
											},
										items: [
											{
												xtype: 'panel',
												border: false,
												layout: {
													type: 'vbox',
													align: 'stretch'
												},
												items: [
													{
														width: 40,
														xtype: 'button',
														itemId: 'toBtn',
														text: KS.L10n.Mail_komu,
														margin: '0 5px 0 0',
														handler: me.ShowUsersDictionary.bind(me, me.To, null)
													},
													{xtype: 'component', flex: 1}
												]
											},
											//me.To
											{
												flex: 1,
												xtype: 'panel',
												layout: 'fit',
												items: [me.To],
												scrollable: 'y',
												border: false
											}
										],
										padding: '0 0 5 0'
									},
									{
										xtype: 'panel',
										border: false,
										layout:
											{
												type: 'hbox',
												align: 'stretch'
											},
										items: [
											{
												xtype: 'label',
												width: 35,
												text: KS.L10n.Mail_tema,
												margin: '0 5px 0 5px',
												style:
													{
														color: '#666666',
														top: '6px'
													}
											},
											me.Theme
										]
									},
									//me.UploadsView
								]
							}
						],
					border: false
				});
			//сообщение
			me.Message = Ext.create('Ext.form.HtmlEditor',
				{
					flex: 1,
					cls: 'mailEditor',
					enableFont: false,
					listeners: {
						initialize: function (editor) {
							editor.getEditorBody().onpaste = function () {
								var str = event.clipboardData.getData('text');
								//вставка фрагмента html
								if (/<(?=.*? .*?\/ ?>|br|hr|input|!--|wbr)[a-z]+.*?>|<([a-z]+).*?<\/\1>/i.test(str)) {
									event.preventDefault();
									event.stopPropagation();
									editor.insertAtCursor(str);
								}
							};
						}
					}
				});
			var container = Ext.create('Ext.panel.Panel',
				{
					border: false,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					flex: 1,
					padding: '6px 6px 1px 6px',
					items: [
						container1,
						//me.UploadsView,
						me.Message
					]
				});
			me.Panel.add(container);

			Ext.apply(this,
				{
					dockedItems: [me.Toolbar],
					items: [
						me.Panel
					]
				});

			this.callParent(arguments);
			me.initState(me.state);		
			//получить подписи
			//todo me.LoadCliche();
		},
		initState: function (state) {
			const me = this;
			if (!state)
				state = 1;
			if (state === 1 || state === 2) {
				const button = this.Toolbar.query('button[itemId~=btn_mail_important]');
				if (button && button.length === 1) {
					button[0].toggle(state === 2);
				}
				me.state = state;
			}
		},
		// toolbarRendered: function () {
		// 	var me = this;
		// 	me.UploadsView.CreateUploader({
		// 		endpoint: _all.rsa + '/Mail/UploadFile',
		// 		button: me.Toolbar.down('#btn_mail_upload').el.dom
		// 	});
		// },
		//при открытии формы "на редактирование" необходимо отобразить прикрепленные файлы
		AddFilesToShow: function (files) {
			var me = this;
			for (var i = 0; i < files.length; i++) {
				var img = 'x_btn_add_attachment';
				var en = files[i].Name.substr(files[i].Name.lastIndexOf('.') + 1);
				if (KSWN.meta.mail.Mail.isImage(en)) {
					if (en === 'jpg') en = 'jpeg';
					img = 'x_btn_ext-' + en;
				}

				var uploadName = files[i].Name;
				me.UploadsView.UploadFilesStore.add(
					{
						uidWeb: files[i].uidWeb,
						//phisPathWeb: files[i].phisPathWeb,
						uploadName: uploadName,
						filename: files[i].Name,
						fileId: files[i].ID,
						size: 0,//file.size,
						image: img,
						progress: 100
					});
			}
		},
		
		ShowUsersDictionary: async function (tagfield, filterValue) {
			const sendToFilter = await Keysystems.Revizor.Mail.getSendToFilter();
			let usersGroupsTree = Ext.create('Keysystems.UsersGroups.Tree',
				{
					title: 'Группы пользователей',
					closeAction: 'hide',
					uids: tagfield.getValue().map(i => i),
					mode: +sendToFilter === 2 ? "get_tree_org_groups_users_m" : "get_tree_groups_users_m",
					multiSelect: 'true',
					ok: function (records) {
						let value = [];
						records.forEach(function (record) {
							if (record.data.leaf) {
								if (tagfield.store.find('UID', record.data.UID) === -1) {
									let userName = record.data.NAME;
									if (userName.indexOf('<font') > 0)
										userName = userName.substring(0, userName.indexOf('<font'));
									tagfield.store.add(
										{
											UID: record.data.UID,
											DefaultName: userName
										}
									);
								}
								//глючит при filterPickList:true
								value.push(record.data.UID);
							}
						});
						tagfield.setValue(value);
					}
				});
			usersGroupsTree.show();
		},

		//Очистка формы
		Clear: function () {
			var me = this;
			me.To.clearValue();
			//me.Copy.clearValue();
			//me.UploadFiles.clearValue();
			me.UploadsView.UploadFilesStore.removeAll();
			me.Theme.setValue('');
			me.Message.setValue('');
			me.State = 1;
		},
		//Отправка письма
		Send: function (isDraft) {
			var me = this;
			////если есть прикрепленные файлы, то сначала передать их на сервер
			//if (me.UploadFilesStore.getCount() > 0) {
			//    me.FileUploader.uploadStoredFiles();
			//} else
			me.ContinueSend(isDraft);
		},
		ContinueSend: function (isDraft) {
			let me = this;
			//var files = [], reldocs = [];
			// me.UploadsView.UploadFilesStore.each(function (record) {
			// 	if (record.data.uploadName)
			// 		files.push(record.data.uidWeb || record.data.uploadName);
			// });
			// if (me.DocumentsStore)
			// 	me.DocumentsStore.each(function (record) {
			// 		reldocs.push({
			// 			Link: record.data.Link,
			// 			Name: record.data.Name,
			// 			ObjectCode: record.data.ObjectCode,
			// 			ObjectLink: record.data.ObjectLink
			// 		});
			// 	});

			let textValue = me.Message.getValue();

			//выведено эксперементальным путем, при отладке на исходниках extjs в firefox
			//https://www.fileformat.info/info/unicode/char/200b/index.htm
			//getValue возвращает строку с дополнительным нечитаемым символом 8203 в начале и (или конце)
			//который при переводе строки в base64 и обратно становится вполне читаемым символом '?'
			//Для одной строки только в firefox, но для нескольких строк повторилось и в Chrome
			//необходимо зачистить перед кодированием
			if (/*Ext.isGecko && */textValue.length > 0) {
				let correctTextValue = '';
				for (let i = 0; i < textValue.length; i++) {
					let char = textValue.charCodeAt(i);
					if (char !== 8203) {
						correctTextValue += textValue[i];
					}
				}
				textValue = correctTextValue;
			}

			//var body = Base64.encode(textValue);
			const params = {
				id: -1,
				theme: me.Theme.getValue(),
				body: textValue,
				state: me.state,
				isDraft: !!isDraft,
				sendToUids: JSON.stringify(me.To.getValue()),
				sendToNames: JSON.stringify(me.To.getRawValue().split(',')),
				// files: files,
				// signInfo: { checkSign: !!isDraft }
			};
			me.setLoading(KS.L10n.Mail_otpravkapisma);
			ajaxRequest({
				url: '/SMail/SendMail_A',
				success: me.SendCallback.bind(me),
				failure: function (ex) {
					failureShow(ex, "Ошибка при отправке письма");
					me.setLoading(false);
				},
				params: {gzipData: SignalR.pack(params)}
			});
		},
		SendCallback: function (res, p) {
			let me = this;
			// if (res && res.Sign && res.Hash) {
			// 	Ext.Msg.confirm(KS.L10n.vnimanie, `${KS.L10n.Mail_podpisat_soobshhenie}?`, function (btn) {
			// 		if (btn === 'yes') {
			// 			window.FormSigner.SignLocalText({
			// 				text: res.Hash,
			// 				idContainerMain: me.id,
			// 				onSuccess: me.SignCallback.bind(me, p),
			// 				onError: function (e) {
			// 					alert(e);
			// 				}
			// 			});
			// 		} else {
			// 			me.SignCallback(p, false);
			// 		}
			// 	});
			// } else {
			me.setLoading(false);
			me.close();
			window.objs.mail?.checkMailTask();
			//}
		},
		SignCallback: function (p, sigs) {
			let me = this;
			if (sigs) {
				let sig = sigs[0];
				Ext.apply(p,
					{
						signInfo:
							{
								signature: sig.Signature,
								notAfter: sig.NotAfter,
								notBefore: sig.NotBefore,
								serial: sig.Serial
							}
					});
			} else {
				p.sign = '';
			}
			ajaxRequest({
				url: '/SMail/SendMail',
				mask:
					{
						id: me.id,
						text: KS.L10n.Mail_otpravkapisma
					},
				success: me.SendCallback.bind(me),
				params: p
			});
		},
		OnThemeChanged: function (themeField, newValue) {
			let me = this;
			if (newValue.length === 0) newValue = KS.L10n.Mail_beztemi;
			me.setTitle(KS.L10n.Mail_novoesoobshchenie + ' - ' + newValue);
		},
		//Подписи
		LoadCliche: function () {
			var me = this;
			me.clicheStore = Ext.create('Ext.data.Store',
				{
					fields: [
						{name: 'title', type: 'string'},
						{name: 'content', type: 'string'},
						{name: 'default', type: 'boolean'}
					],
					data: []
				});
			IDB.Get('profiles', 'cliche', me.LoadClicheCallback.bind(me));
		},
		LoadClicheCallback: function (res) {
			var me = this;
			if (res && res.Content && res.Content.length > 0) {
				me.clicheStore.loadData(res.Content);
			} else {
				me.clicheStore.loadData([
					{title: KS.L10n.Mail_moyapodpis, content: KS.L10n.Mail_suvazheniem, default: true}
				]);
			}
			me.UpdateCliche(me.clicheStore);
		},
		EditCliche: function (record) {
			var me = this;
			if (me.FormCliche === void 0) {
				me.FormCliche = Ext.create('widget.MailCliche',
					{
						clicheStore: me.clicheStore,
						listeners:
							{
								updateCliche: function (store) {
									me.UpdateCliche(store);
								}
							}
					});
			}
			me.FormCliche.Show(record);
		},
		UpdateCliche: function (store) {
			var me = this, cb = me.Toolbar.GetButtons(['btn_mail_cliche']);
			if (cb) {
				cb[0].menu.removeAll();
				store.each(function (rec) {
					cb[0].menu.add(
						{
							text: rec.data.title,
							menu: {
								xtype: 'menu',
								plain: true,
								items:
									[
										{
											xtype: 'panel',
											layout: {
												type: 'table',
												columns: 3
											},
											border: false,
											margin: '15px 5px 20px 20px',
											width: 370,
											items: [
												{
													colspan: 3,
													xtype: 'label',
													html: rec.data.content
												},
												{
													xtype: 'button',
													text: KS.L10n.Mail_izmenitpodpis,
													width: 127,
													height: 28,
													handler: me.EditCliche.bind(me, rec)
												}
											]
										}
									],
								listeners:
									{
										render: function (panel) {
											panel.body.on('click', function () {
												if (arguments[1].id.indexOf('button') >= 0) return;
												me.Message.setValue(me.Message.value + '<br>' + rec.data.content);
												cb[0].menu.hide();
											});
										}
									}
							}
						}
					);
				});
				cb[0].menu.add('-');
				cb[0].menu.add({text: KS.L10n.Mail_dobavitpodpis, itemId: 'btn_mail_cliche_add'});
			}
		}
	}
);

Ext.define('Keysystems.Mail.Cliche',
	{
		extend: 'Ext.panel.Panel',
		alias: 'widget.MailCliche',
		border: false,
		layout: {type: 'absolute'},
		profile:
			{
				id: 'mailCliche',
				settings: {}
			},
		initComponent: function () {
			var me = this;
			me.listStore = this.clicheStore;
			me.editor = Ext.create('Ext.form.HtmlEditor', {
				enableFont: false,
				width: 375,
				x: 110,
				y: 148,
				disabled: true
			});
			me.list = Ext.create('Ext.view.View', {
				tpl: ['<tplfor=".">',
					'<div class="listItem"><span>{title}</span></div>',
					'</tpl>'],
				height: 100,
				width: 375,
				x: 110, y: 10,
				trackOver: true,
				border: 1,
				scrollable: true,
				style: {
					borderColor: '#CCCCCC',
					borderStyle: 'solid'
				},
				itemSelector: 'div.listItem',
				emptyText: KS.L10n.Mail_netpodpisei,
				store: me.listStore,
				listeners:
					{
						selectionchange: function (view, selected) {
							if (selected.length === 1) {
								me.SaveRecord();
								me.editor.setDisabled(false);
								me.editor.record = selected[0];
								me.editor.setValue(selected[0].data.content);
								me.defaultCheck.setValue(selected[0].data.default);
							} else {
								me.editor.setValue('');
								me.editor.record = void 0;
								me.editor.setDisabled(true);
							}
						}
					}
			});
			me.defaultCheck = Ext.create('Ext.form.field.Checkbox', {
				boxLabel: KS.L10n.Mail_ispolzovatpoumolchaniyu,
				x: 109,
				y: 333
			});
			me.list.getSelectionModel().select(me.listStore.getAt(0));
			Ext.apply(this,
				{
					items: [
						{xtype: 'label', text: KS.L10n.naimenovanie, x: 10, y: 15},
						me.list,
						{
							xtype: 'button', text: KS.L10n.udalit, x: 110, y: 116, handler: function () {
								var model = me.list.getSelectionModel(), sel = model.getSelection();
								if (sel.length > 0) {
									me.listStore.remove(sel);
									var zero = me.listStore.getAt(0);
									if (zero)
										model.select(zero);
								}
							}
						},
						{
							xtype: 'button', text: KS.L10n.sozdat, x: 180, y: 116, handler: function () {
								Ext.Msg.prompt(KS.L10n.naimenovanie, KS.L10n.Mail_vveditenaimenovaniedlyanovoipodpisi, function (btn, text) {
									if (btn === 'ok') {
										var record = me.listStore.add({title: text, content: ''});
										me.list.getSelectionModel().select(record[0]);
									}
								});
							}
						},
						{
							xtype: 'button', text: KS.L10n.pereimenovat, x: 247, y: 116, handler: function () {
								var sel = me.list.getSelectionModel().getSelection();
								if (sel.length > 0) {
									Ext.Msg.prompt(KS.L10n.naimenovanie, KS.L10n.Mail_novoenaimenovanie, function (btn, text) {
										if (btn === 'ok') {
											sel[0].data.title = text;
											sel[0].commit();
										}
									}, me, false, sel[0].data.title);
								}
							}
						},
						{xtype: 'label', text: KS.L10n.Mail_tekstpodpisi, x: 10, y: 150},
						me.editor,
						me.defaultCheck
					],
					dockedItems: [{
						xtype: 'toolbar',
						dock: 'bottom',
						ui: 'footer',
						style:
							{
								marginLeft: '1px',
								marginRight: '1px',
								borderTopWidth: '1px',
								borderTopColor: '#cecece'
							},
						items: [
							{xtype: 'component', flex: 1},
							{
								xtype: 'button', text: KS.L10n.zakrit, handler: function () {
									me.up('window').close();
								}
							}
						]
					}]
				});

			me.callParent(arguments);
		},
		SaveRecord: function () {
			var me = this;
			if (me.editor.record) {
				me.editor.record.data.content = me.editor.getValue();
				me.editor.record.data.default = me.defaultCheck.checked;
				me.editor.record.commit();
			}
		},
		Show: function (record) {
			var me = this;
			if (me.Window === void 0) {
				me.Window = Ext.create('Ext.window.Window',
					{
						title: KS.L10n.Mail_podpisi,
						resizable: false,
						width: 495,
						height: 440,
						layout: 'fit',
						closeAction: 'hide',
						items: [me],
						listeners:
							{
								close: function () {
									me.SaveRecord();
									me.Save();
									me.fireEvent('updateCliche', me.listStore);
								}
							}
					});
			}
			if (record) {
				me.list.getSelectionModel().select(record);
			}
			me.Window.show();
		},
		Save: function () {
			var me = this, data = [];
			me.listStore.each(function (rec) {
				data.push({title: rec.data.title, content: rec.data.content, default: rec.data.default});
			});
			IDB.Set('profiles', 'cliche', data);
			//IDB.SetProfileObjects(me);
		}
	});

Ext.define('Meta.Mail.AddressFieldView',
	{
		extend: 'Ext.view.View',
		alias: 'widget.address',
		tpl: [
			'<tplfor=".">',
			'<div class="addressItem">',
			'<div class="addressItemName" title="{Note}">{DefaultName}</div>',
			'<div class="addressItemDelete x_btn_close_hover"></div>',
			'</div>',
			'</tpl>'
		],
		overItemCls: 'addressItemOver',
		itemSelector: 'div.addressItem',
		scrollable: false,
		trackOver: true,
		defaultListeners: false,
		listeners:
			{
				itemclick: function (view, record, item, idx, event) {
					if (event.target.className.indexOf('Delete') !== -1) {
						view.store.remove(record);
						this.fireEvent('change');
					}
				},
				afterrender: function () {
					var me = this, parentStyle = me.getEl().dom.parentElement.style;
					parentStyle.borderStyle = 'solid';
					parentStyle.borderWidth = '1px';
					parentStyle.borderColor = '#cecece';
					parentStyle.padding = '0 0 3px 0';
				}
			},
		selectionModel: {
			mode: 'SINGLE'
		},
		allowDrag: false,
		setValue: function (values) {
			var me = this, data = [];
			me.store.clearData();
			for (var i = 0; i < values.length; i++) {
				data.push(values[i].data.INode);
			}
			me.store.loadData(data);
			me.fireEvent('change');
		},
		//строка с отобранными UID пользователей
		getValue: function () {
			var val = [];
			this.store.each(function (record) {
				val.push(record.data.UID);
			});
			return val.join();
		},
		//строка с выбранными именами пользователей
		getStringValue: function () {
			var val = [];
			this.store.each(function (record) {
				val.push(record.data.DefaultName);
			});
			return val.join();
		}
	});