﻿Ext.define('RevizorListEditor', {
	extend: 'Ext.window.Window',
	iconCls: 'x_btn_keysystems',
	modal: true,
	title: 'Пункты',
	width: 300,
	height: 500,
	border: 0,
	maximizable: true,
	objs: {},
	layout: 'anchor',
	list: undefined, //входящий массив значений
	sourceList: [],  //упорядоченный list для работы с гридом
	okFunc: undefined,
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		if (this.list) this.sourceList = this.list.map((r, index) => ({value: r, ord: index}));
		this.callParent(arguments);
	},

	initComponent: function () {
		let me = this;
		me.buttons = me.createButtons();
		me.items = me.createItems();

		me.callParent(arguments);
	},

	createItems: function () {
		let me = this,
			objs = me.objs,
			items = [
				objs.grid = Ext.create('Ext.grid.Panel', {
					border: 0,
					columnLines: true,
					anchor: '100% 100%',
					plugins: [
						Ext.create('Ext.grid.plugin.CellEditing', {clicksToEdit: 1}),
						'gridclipboard'
					],
					tbar: [
						Ext.create('Ext.Button', {
							iconCls: 'x_btn_new',
							handler: function () {
								me.addItem();
							}
						}),
						Ext.create('Ext.Button', {
							key: 'same',
							iconCls: 'x_btn_copy',
							tooltip: 'Создать подобный',
							tooltipType: 'title',
							disabled: true,
							handler: function () {
								let sel = objs.grid.getFrstSelect();
								me.addItem(sel ? sel.get('value') : null);
							}
						}),
						Ext.create('Ext.Button', {
							key: 'delete',
							iconCls: 'x_btn_delete',
							tooltip: 'Удалить',
							tooltipType: 'title',
							disabled: true,
							handler: function () {
								objs.grid.removeSelection(null, () => {
									objs.grid.store.getData().items.forEach((item, index) => item.set('ord', index));
								});
							}
						})
					],
					store: Ext.create('Ext.data.Store', {
						fields: ['value', 'ord'],
						data: [],
						proxy: 'memory',
						sorters: ['ORD'],
					}),
					columns: [
						{
							dataIndex: 'value',
							draggable: false,
							flex: 1,
							editor: {}
						}
					],
					listeners: {
						selectionchange: (_, sels) => Keysystems.Base.Edit.prototype.enableToolsGrid.call(this, objs.grid, sels)
					}
				})
			];
		if (me.sourceList) objs.grid.getStore().loadData(me.sourceList, false);
		return items;
	},
	createButtons: function () {
		var me = this,
			objs = me.objs;
		return objs.btns = [
			Ext.create('Ext.Button', {
				text: 'OK',
				handler: function () {
					me.okFunc && me.okFunc(objs.grid.store.getLinks('value').filter(r => r && r.toString().trim()));
					me.close();
				}
			}),
			Ext.create('Ext.Button', {
				text: 'Отмена',
				handler: function () {
					me.close();
				}
			})
		];
	},

	/**
	 * Добавить строку в список
	 * @param value {string} значение
	 */
	addItem: function (value) {
		let me = this,
			objs = me.objs,
			sel = objs.grid.getFrstSelect(),
			ord;
		if (sel) {
			//добавление после выделенной строки
			ord = sel.get('ord');
			me.sourceList.forEach(r => {
				if (r.ord > ord)
					r.ord++;
			});
		} else {
			//добавление в конец списка
			ord = Math.max.apply(null, me.sourceList.map(r => r.ord)) ?? 0;
		}
		ord++;
		sel = objs.grid.store.add({value: value, ord: ord});
		objs.grid.getSelectionModel().select(sel);
		objs.grid.store.sort('ord', 'ASC');
	}
});