﻿Ext.define('Keysystems.Kurs.List', {
	extend: 'Keysystems.Base.List',
	title: 'Курсы валют',
	hidePagging: true,
	/*viewCfg: function() {
		var cfg = this.callParent(arguments);
		cfg.layout = { type: 'vbox', align: 'stretch' };
		return cfg;
	},*/
	getGridCfg: function() {
		var res = this.callParent(arguments);
		(res.plugins || (res.plugins = [])).push(Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }));
		return res;
	},
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = me.callParent(arguments);
		me.isCreate = true;
		items.unshift(Ext.create('Ext.panel.Panel', {
			region: 'north',
			overflowX: 'auto',
			layout: 'anchor',
			border: 0,
			bodyPadding: me.bodyPadding,
			width: '100%',
			items: [
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					anchor: '100%',
					items: [
						Ext.create('Ext.form.Label', {
							text: 'Дата',
							width: 100,
							padding: '5 0 0 10'
						}),
						objs.dCheck = Ext.create('Ext.form.field.Date', {
							width: 140,
							format: 'd.m.Y',
							listeners: {
								blur: function() {
									var val = me.objs.dCheck.getValue();
									if (val && Ext.isDate(val)) {
										me.setWhereArgs(val);
										me.refresh();
									}
								}
							}
						})
					]
				})
			]
		}));
		me.Grid.addEvents('summchange');
		me.Grid.on('summchange', function(newSum) {
			var sel = me.Grid.getSelectionModel().getSelection()[0].data;
			sel.SUMMA = newSum;
			sel.DT = me.objs.dCheck.getValue().toDateString();

			if (sel.LINK < 0) sel.LINK = 0;
			window.Keysystems.Base.Edit.prototype.baseSaveData.call(me, sel);
		});
		me.isCreate = false;
		if (!me.objs.dCheck.getValue()) {
			var today = new Date();
			me.objs.dCheck.setValue(today);
			me.setWhereArgs(today);
		}

		return items;
	},
	columnsAdapted: function(columns) {
		var me = this;
		for (var i = 0; i < columns.length; i++) {
			if (columns[i].dataIndex === 'SUMMA') {
				columns[i].editor = {
					xtype: 'numberfield',
					minValue: 0,
					listeners: { blur: function(th) { me.Grid.fireEvent('summchange', th.value); } }
				};
				break;
			}
		};
		return me.callParent([columns]);
	},
	setWhereArgs: function(dCheck) {
		let me = this,
			whereArgs = { DCheck: { value: dCheck.toDateString(), type: 'Date' } };

		return Ext.apply(me.whereArgs, whereArgs);
	},
	successSaveFunc: function() { this.refresh(); }
});