﻿Ext.define('Keysystems.Info.List', {
	extend: 'Keysystems.Base.List',
	deleteCode: 'DOCUMENT_INFO',
	startYear: (new Date()).getFullYear(),
	bodyPadding: 10,
	labelWidth: 150,
	profileListeners: [{name: 'holdingPeriod', method: 'KsPeriodChange'}],
	setWhereArgs: function () {
		let me = this,
			objs = me.objs,
			dRev = objs.holdingPeriod.getValue(),
			orgLinks = objs.OrgR.getLinks(),
			whereArgs = {
				DBegin: {value: dRev.dh1, type: 'Date'},
				DEnd: {value: dRev.dh2, type: 'Date'}
			};

		return Ext.apply(me.whereArgs, whereArgs);
	},
	createItems: function () {
		var me = this,
			objs = me.objs,
			items = me.callParent(arguments);

		me.isCreate = true;
		items.unshift(objs.filterPanel = Ext.create('Ext.panel.Panel', {
			collapsible: true,
			layout: {type: 'hbox', align: 'stretch'},
			title: 'Фильтр по организациям',
			border: 0,
			bodyBorder: 0,
			userCls: 'rks-filter-panel',
			bodyPadding: me.bodyPadding,
			animCollapse: false,
			items: [
				objs.holdingPeriod = Ext.create('Keysystems.Controls.KsPeriod', {
					startYear: me.startYear,
					state: 4,
					allStates: 13,
					width: 400,
					listeners: {
						ksChange: function () {
							if (me.head) me.setDate();
						}
					}
				}),
				me.createDictEdit({
					key: 'OrgR',
					mode: 'MULTI',
					padding: '0 0 0 50',
					flex: 1,
					code: dnl.S_ORG,
					fieldLabel: 'Проверяющая',
					whereArgs: {
						SType: {
							value: JSON.stringify([KsLib.getKeyByValue(miscTypes.TypeOrg, 'Проверяющая') * 1]),
							type: 'List_int'
						}
					},
					ksSetValue: function (v) {
						this.setValue(v);
						me.setWhereArgs();
						me.refresh();
					}
				})
			]
		}));

		objs.Year = objs.holdingPeriod.Quarter.holdingYear;
		objs.Quarter = objs.holdingPeriod.Quarter.holdingQuarter;

		if (me.head === false) objs.filterPanel.hide();


		me.isCreate = false;
		return items;
	},
	edit: function (f, data, defCfg) {
		defCfg = defCfg || {};
		defCfg.dBegin = this.objs.holdingPeriod.getValue().dh1;

		return this.callParent([f, data, defCfg]);
	},
	getRowClass: function (r) {
		return r.data.COLOR ? 'ks-' + r.data.COLOR.toLowerCase() : '';
	},
	setDate: function () {
		var me = this;

		me.setWhereArgs();
		me.refresh();
	},
	getGridCfg: function () {
		let res = this.callParent(arguments);
		res.userCls = 'rks-grid-with-filter-panel';
		return res;
	},
	setSBText: function () {
		let me = this;
		me.callParent(arguments);
		if (me.hideTBar) return;

		let tbarBtns = me.objs.tbarBtns,
			sel = me.Grid ? me.Grid.getFrstSelect() : null;
		if (!tbarBtns) return;

		tbarBtns.add_reviz?.setDisabled(!sel || sel.data["REVIZ_LINKS"]);
		tbarBtns.edit_reviz?.setDisabled(!sel || !sel.data["REVIZ_LINKS"]);
		tbarBtns.delete_reviz?.setDisabled(!sel || !sel.data["REVIZ_LINKS"]);
	},
	initializeFilter: function () {
		let me = this;
		if (!me.whereArgs) return;

		me.updateDateFromWhereArg(me.whereArgs.DBegin.value, me.whereArgs.DEnd.value, me.objs.holdingPeriod);
	},
	/** Task Revizor.Reviz.AddFromInfo
	 */
	revizAddFromInfo: function () {
		this.revizAddOrEdit('new');
	},
	/** Task Revizor.Reviz.EditFromInfo
	 */
	revizEditFromInfo: function () {
		this.revizAddOrEdit('edit');
	},
	/** Task Revizor.Reviz.DeleteFromInfo
	 */
	revizDeleteFromInfo: function () {
		let me = this,
			sel = me.Grid.getFrstSelect(),
			funcDel = function (reviz) {
				selectDialogShow(KS.L10n.delete, KS.L10n.RevizTasks_RevizDeleteFromInfo_Удалить_мероприятие_,
					function () {
						me.showLoadMask({
							msg: KS.L10n.InfoListPresenter_DeleteReviz_Удаление_мероприятия___,
							rid: ajaxRequest({
								params: {
									code: dnl.REVIZ,
									links: [reviz],
									recursive: false
								},
								url: 'data/DelSDictionary_A',
								success: function (value) {
									me.hideLoadMask();
									if (value.errorMessage) {
										showError(`${KS.L10n.InfoListPresenter_DeleteReviz_Ошибка_при_удалении_мероприятия}<br />${value.errorMessage}`);
										return;
									}
									let oldLinks = sel.data.REVIZ_LINKS.split(',');
									if (value.notDelLinks.indexOf(reviz) >= 0) return;

									let newLinks = oldLinks.filter(link => link != reviz);
									sel.data.REVIZ_LINKS = newLinks.join(',');
									me.setSBText();
								}
							})
						});

						
					});
			};

		let revizLinks = sel ? sel.data.REVIZ_LINKS.split(',') : [];
		if (revizLinks.length === 0) return;

		if (revizLinks.length > 1) {
			dictFunc({
					parentView: tabView,
					mode: 'SINGL',
					code: dnl.REVIZ,
					hideFilterPnl: true,
					ksReadOnly: true,
					_arrEditTBarBtns: [],
					canBold: true,
					readOnlyPlanInfo: true,
					initWhereArgs: function () {
						let wa = {
							DBegin: {value: longPeriod.begin, type: 'Date'},
							DEnd: {value: longPeriod.end, type: 'Date'},
							InLinksOnly: {value: true, type: 'bool'},
							InLinks: {value: JSON.stringify(revizLinks), type: 'List_int'}
						};
						return wa;
					}
				},
				{
					ok: function (value) {
						if (!value.length) return;
						funcDel(value[0].data.LINK);
					}
				});
		} else
			funcDel(revizLinks[0]);
	},
	revizAddOrEdit: function (f) {
		let me = this,
			sel = me.Grid.getFrstSelect(),
			data = null,
			funcEdit = function (revizData) {
				let cfg = {
					f: f,
					data: revizData,
					code: dnl.REVIZ,
					refreshFunc: function () {
						me.refresh();
					},
					parentView: me.objs.view,
					selectRecord: function () {
						me.refresh(true);
					},
					addRecord: Ext.emptyFn,
				};
				cfg["infoLinks"] = JSON.stringify([sel.data.LINK]);

				Ext.apply(cfg, dictListController.DOCUMENT_REVIZ);
				Ext.create(cfg.editClass, cfg);
			};

		if (f === 'edit') {
			let revizLinks = sel ? sel.data.REVIZ_LINKS.split(',') : [];
			if (revizLinks.length === 0) return;

			if (revizLinks.length > 1) {
				dictFunc({
						parentView: tabView,
						mode: 'SINGL',
						code: dnl.REVIZ,
						hideFilterPnl: true,
						ksReadOnly: true,
						_arrEditTBarBtns: [],
						canBold: true,
						readOnlyPlanInfo: true,
						initWhereArgs: function () {
							let wa = {
								DBegin: {value: longPeriod.begin, type: 'Date'},
								DEnd: {value: longPeriod.end, type: 'Date'},
								InLinksOnly: {value: true, type: 'bool'},
								InLinks: {value: JSON.stringify(revizLinks), type: 'List_int'}
							};
							return wa;
						}
					},
					{
						ok: function (value) {
							if (!value.length) return;

							data = {data: {LINK: value[0].data.LINK}};
							funcEdit(data);
						}
					});
			} else {
				data = {data: {LINK: revizLinks[0]}};
				funcEdit(data)
			}
		} else {
			funcEdit(null);
		}
	}
});