﻿Ext.define('Keysystems.Info.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Информация о нарушениях',
	f: 'new',
	readOnlyList: [
		'S_ORGP', 'S_PERSON', 'S_ORGC', 'S_ORGR', 'S_INFO', 'S_NAR', 'DT', 'SUMMA', 'S_VAL', 'CONTENT', 'tabProp'
	],
	viewMinSize: [690, 400],
	bodyPadding: 0,
	createItems: function() {
		var me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			flex: 1,
			items: me.objs.items = [me.getTab('General')]
		});
	},
	//конструктор таба Общие
	createTabGeneral: function() {
		var me = this,
			objs = me.objs;

		return objs.tabGeneral = Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			flex: 1,
			border: 0,
			items: [
				me.createDictEdit({
					key: 'S_ORGP',
					ksAllowEmpty: true,
					mode: 'SINGL',
					code: dnl.S_ORG,
					fieldLabel: 'Источник'
				}),
				me.createDictEdit({
					key: 'S_PERSON',
					mode: 'SINGL',
					fieldLabel: 'Нарушил',
					code: dnl.S_PERSON,
					initWhereArgs: function() {
						const dt = me.gksc('DT').getValue().toDateString();
						return {
							DH1: {value: dt, type: 'Date'},
							DH2: {value: dt, type: 'Date'},
							SOrgs: {
								value: objs.S_ORGC.getLinks(true),
								type: 'List_int'
							}
						};
					},
				}),
				me.createDictEdit({
					key: 'S_ORGC',
					mode: 'SINGL',
					code: dnl.S_ORG,					
					fieldLabel: 'Организация'
				}),
				me.createDictEdit({
					key: 'S_ORGR',
					mode: 'SINGL',
					ksAllowEmpty: true,
					height: 33,
					initWhereArgs: function() {
						return {
							SType: { value: '[1]', type: 'List_int' }
						};
					},
					code: 'DICTIONARY_SORG',
					fieldLabel: 'Контролирующая организация'
				}),
				me.createDictEdit({
					key: 'S_INFO',
					mode: 'SINGL',
					code: dnl.S_INFO,
					fieldLabel: 'Вид информации',
					ksSetValue: function(value) {
						let tabProp = me.gksc('tabProp');
						
						objs.S_INFO.setValue(value);
						if (value && value.length) {
							me.getActualPropData(objs.link, value[0].get('LINK'));
						} else if (tabProp) {
							objs.allTab.changeTab(tabProp, false);
						}
					}
				}),
				me.createDictEdit({
					key: 'S_NAR',
					mode: 'SINGL',
					code: dnl.S_NAR,
					fieldLabel: 'Вид нарушения'
				}),
				me.sksc('DT', objs.DT = Ext.create('Ext.form.field.Date', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Дата',
					ksAllowEmpty: true,
					maxWidth: 305
				})),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						me.sksc('SUMMA', objs.SUMMA = Ext.create('Keysystems.Controls.CalcField', {
							labelWidth: me.labelWidth,
							width: 305
						})),
						me.sksc('S_VAL', objs.S_VAL = Ext.create('Keysystems.Controls.DictCode.Edit', {
							fieldLabel: 'в валюте',
							padding: '0 10 0 10',
							labelWidth: 60,
							flex: 1,
							hidden: true,
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									selectLinks: objs.S_VAL.getValue(),
									code: dnl.S_VAL,
									control: me.objs.S_VAL,
									contextSearch: me.objs.S_VAL.contextSearch
								}, {
									ok: function(value) {
										objs.S_VAL.setValue(value);
									}
								});
							}
						})),
						me.sksc('SUMMAVAL', objs.SUMMAVAL = Ext.create('Keysystems.Controls.CalcField', {
							fieldLabel: '',
							labelWidth: 0,
							width: 150,
							flex: 1,
							minVal: 0,
							hidden: true
						}))
					]
				}),
				me.sksc('CONTENT', objs.CONTENT = Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Содержание',
					flex: 1,
					maxLength: 8000,
					enforceMaxLength: true,
					labelWidth: me.labelWidth,
					height: 100
				}))
			]
		});
	},
	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.maximizable = true;
		result.resizable = true;
		result.width = this.width;
		result.minWidth = 750;
		return result;
	},
	//конструктор таба Реквизиты
	createTabProp: function() {
		var me = this,
			objs = me.objs;

		return me.sksc('tabProp', objs.tabProp = Ext.create('Keysystems.Panel.Prop', {
			minHeight: 358,
			minWidth: 750,
			parentView: me,
			decimalData: me.gksd('decimalData')
		}));
	},
	afterGetExtra: function () {
		var me = this,
			objs = me.objs;

		if (me.data && me.f === 'new') {
			var data = me.data.data;

			objs.S_ORGC.setValue({
				LINK: data.S_ORG,
				CODE: data.S_ORG_CODE,
				NAME: data.S_ORG_NAME
			});
			data.DT ? objs.DT.setValue(data.DT.dh1, data.DT.dh2) : objs.DT.setValue(me.whereArgs.DBegin.value, me.whereArgs.DEnd.value);
			objs.S_ORGR.setValue(data.S_ORGR || []);
		}

		me.callParent(arguments);
	},

	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({
			link: link,
			dBegin: me.dBegin,
			needResource: true
		}, function(val) {
			me.sksd('decimalData', val.decimalData);
			objs.S_INFO.setValue(val.S_INFO);
			objs.S_NAR.setValue(val.S_NAR);
			objs.S_ORGP.setValue(val.S_ORGP);
			objs.S_ORGC.setValue(val.S_ORGC);
			objs.S_PERSON.setValue(val.S_PERSON);
			objs.S_VAL.setValue(val.S_VAL);
			objs.DT.setValue(val.DT);
			objs.SUMMA.setValue(val.SUMMA);
			objs.SUMMA.decimalData = val.decimalData;
			objs.SUMMAVAL.setValue(val.SUMMAVAL);
			objs.CONTENT.setValue(val.CONTENT);
			objs.S_ORGR.setValue(val.S_ORGR);
			me.getExtraProp(val);

			if (me.readOnly || (me.data && me.data.data.readOnly)) me.setReadOnly(true);
			if (endFunc) endFunc();
		});
	},	
	getActualPropData: function(infoLink, sInfoLink, endFunc) {
		var me = this;

		me.showLoadMask({
			msg: KS.L10n.updating_data,
			rid: ajaxRequest({
				url: 'SDocInfo/GetActualPropDS_A',
				params: {
					infoLink: infoLink,
					sInfoLink: sInfoLink
				},
				success: function(res) {
					if (res) {
						me.getExtraProp({tabProp: res});
					}					
					if (endFunc) endFunc();
				},
				callback: me.hideLoadMask.bind(me)
			})
		});

	},
	//загрузка данных таба "Реквизиты"
	getExtraProp: function(value) {
		if (value.tabProp) {
			var me = this,
				objs = me.objs;

			objs.allTab.changeTab(me.getTab('Prop').loadData(value.tabProp), true);
		}
	},
	//Сборка данных таба "Реквизиты"
	dataCollectorProp: function() {
		var me = this,
			tabProp = me.gksc(me.getTabKey('Prop'));

		return tabProp && !tabProp.hidden ? tabProp.getData() : [];
	},
	isFilled: function() {
		var me = this,
			objs = me.objs;

		let res = true;
		if (objs.S_ORGP.isEmpty()) {
			me.addToInvalidControls(objs.S_ORGP);
			
		}
		if (objs.S_ORGR.isEmpty()) {
			me.addToInvalidControls(objs.S_ORGR);
			res = false;
		}		
		if (!objs.DT.getValue()) {
			me.addToInvalidControls(objs.DT);
			res = false;
		}		
		if (objs.S_ORGC.isEmpty() && objs.S_PERSON.isEmpty()) {			
			me.addToInvalidControls(objs.S_ORGC);
			//me.addToInvalidControls(objs.S_PERSON);
			res = false;
		}
		if (objs.SUMMA.getNumValue() === 0) {
			me.addToInvalidControls(objs.SUMMA, {optional: true});
			me.warningMessages.push(KS.L10n.InfoEditView_CheckSave_Не_заполнена_сумма_);
		}
		return res;
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs;

		var data = me.callParent(arguments);

		data.S_INFO = objs.S_INFO.getLink();
		data.S_NAR = objs.S_NAR.getLink();
		data.S_ORGP = objs.S_ORGP.getLink();
		data.S_ORGC = objs.S_ORGC.getLink();
		data.S_PERSON = objs.S_PERSON.getLink();
		data.S_VAL = objs.S_VAL.getLink();
		data.DT = me.getDateOrToday(objs.DT.getValue())?.toDateString();
		data.SUMMA = objs.SUMMA.getValue();
		data.SUMMAVAL = objs.SUMMAVAL.getValue();
		data.CONTENT = objs.CONTENT.getValue();
		data.S_ORGR = objs.S_ORGR.getLink();
		data.tabProp = JSON.stringify(me.dataCollectorProp());

		return data;
	},
	//Функция для пересчета суммы организации
	countSumm: function(orgRec) {
		var summ = 0,
			me = this,
			info = orgRec.raw.info;

		for (var i = 0, len = info.length; i < len; i++) {
			summ += info[i].SUMMA;
		}

		orgRec.raw.SUMMA = summ;
		orgRec.data.SUMMA = summ;
		me.objs.Grid.store.reload();
	}
})