Ext.define('Keysystems.SRiskLevel.Edit', {
	extend: 'Keysystems.Base.Edit',
	createItems: function () {
		let me = this,
			items = [
				me.sksc('OBJTYPE', Ext.create('Ext.form.field.ComboBox', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Тип объекта',
					maxWidth: 300,
					ksAllowEmpty: true,
					store: Ext.create('Ext.data.Store', {
						fields: CBDataLib.getFields(),
						data: CBDataLib.get('ObjType').filter(r => r["index"] !== "0"),
						proxy: 'memory'
					}),
					displayField: 'value',
					valueField: 'index',
					value: 0,
					editable: false
				})),
			];

		me.isCodeEdit = true;
		me.codeEditCfg = {maxLength: 10, enforceMaxLength: true};
		me.isNameEdit = true;
		me.nameEditCfg = {maxLength: 225, enforceMaxLength: true};
		me.isDHEdit = true;

		return me.callParent([items]);
	},
	dataCollector: function () {
		let me = this,
			data = me.callParent(arguments);
		data.OBJTYPE = me.gksc('OBJTYPE').getValue();
		return data;
	},
	getExtra: function (callBack, link) {
		let me = this;
		me.baseGetExtra({link: link}, function (value) {
			me.autoFillControl(value.row);
			me.gksc('OBJTYPE').setValue(value.row.OBJTYPE);
			if (!value.isVFK || !value.isFincontrol) {
				me.gksc('OBJTYPE').setVisible(false);
			}
			if (callBack) callBack();
		});
	}	
});