﻿Ext.define('Keysystems.RiskLevelValue.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Матрицы бюджетных рисков',
	labelWidth: 300,
	createItems: function () {
		var me = this,
			items = [
				me.sksc('OBJTYPE', Ext.create('Ext.form.field.ComboBox', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Тип объекта',
					maxWidth: 600,
					ksAllowEmpty: true,
					store: Ext.create('Ext.data.Store', {
						fields: CBDataLib.getFields(),
						data: CBDataLib.get('ObjType').filter(r => r["index"] !== "0"),
						proxy: 'memory'
					}),
					displayField: 'value',
					valueField: 'index',
					value: 0,
					editable: false,
					listeners: {
						beforeselect: function (th, rec) {
							let yesFunc = function () {
								let objType = rec.data.index;
								me.fillCombosByObjType(objType);
								Ext.each(me._arrCombo, function (arr) {
									me.gksc(arr[0]).setValue(null);
								});
							}
							if (!me.gksc('OBJTYPE').getValue()) {
								yesFunc();
								return;
							}
							selectDialogShow(wmc.get('Attention'),
								wmc.get('changeObjTypeRiskLevelValue'), yesFunc,
								() => {
									return false;
								}
							);
						}
					}
				})),
				me.sksc('PRValue', Ext.create('Ext.form.field.ComboBox', {
					editable: false,
					store: CBDataLib.getStore([]),
					fieldLabel: 'Уровень риска по критерию "Вероятность"',
					ksAllowEmpty: true,
					labelWidth: me.labelWidth,
					queryMode: 'local',
					displayField: 'NAME',
					valueField: 'LINK'
				})),
				me.sksc('IRValue', Ext.create('Ext.form.field.ComboBox', {
					editable: false,
					store: CBDataLib.getStore([]),
					fieldLabel: 'Уровень риска по критерию "Последствия"',
					ksAllowEmpty: true,
					labelWidth: me.labelWidth,
					queryMode: 'local',
					displayField: 'NAME',
					valueField: 'LINK'
				})),
				me.sksc('RLValue', Ext.create('Ext.form.field.ComboBox', {
					editable: false,
					store: CBDataLib.getStore([]),
					fieldLabel: 'Значение уровня риска',
					ksAllowEmpty: true,
					labelWidth: me.labelWidth,
					queryMode: 'local',
					displayField: 'NAME',
					valueField: 'LINK'
				}))
			];

		me.isDHEdit = true;
		me.dhEditCfg = {labelWidth: me.labelWidth, maxWidth: 600};

		return me.callParent([items]);
	},
	dataCollector: function () {
		var me = this,
			data = me.callParent([false]);

		data.OBJTYPE = me.gksc('OBJTYPE').getValue();
		Ext.each(me._arrCombo, function (arr) {
			data[arr[1]] = me.gksc(arr[0]).getValue();
		});

		return data;
	},

	_arrCombo: [
		//[controlName, storeKey, rowField]
		['PRValue', 'IFC_S_PROB_RISK_L'],
		['IRValue', 'IFC_S_IMPL_RISK_L'],
		['RLValue', 'IFC_S_RISK_L']
	],

	getExtra: function (endFunc) {
		let me = this;
		me.baseGetExtra({link: me.getLink()}, function (value) {
			let objType = me.gksc('OBJTYPE');
			objType.setValue(value.row.OBJTYPE);
			if (!value.isVFK || !value.isFincontrol) {
				me.gksc('OBJTYPE').setVisible(false);
			}

			me.sksd('comboStores', value.comboStores);
			me.fillCombosByObjType(value.row.OBJTYPE);
			Ext.each(me._arrCombo, function (arr) {
				me.gksc(arr[0]).setValue(value.row[arr[1]]);
			});

			if (endFunc) endFunc();
		});
	},

	isFilled: function () {
		var me = this,
			res = me.callParent(arguments);
		
		let dh = me.gksc('DH').getValue();
		if (res && dh.dh1 > dh.dh2) {
			me.errorMessages.push(wmc.get('ActionPeriodStartMoreThenEnd'));
		}
		return res;
	},

	/**
	 * Заполнить store выпадающих списков уровней рисков в зависимости от типа объекта
	 * @param objType {integer} тип объекта
	 * */
	fillCombosByObjType: function (objType) {
		let me = this,
			comboStores = me.gksd('comboStores');

		Ext.each(me._arrCombo, function (arr) {
			let ctrl = me.gksc(arr[0]),
				data = comboStores[arr[1]].filter(r => r.OBJTYPE === objType);
			ctrl.loadData(data);
		});
	}
});