﻿Ext.define('Keysystems.RiskLevel.Edit', {
	extend: 'Keysystems.Base.Edit',
	isProbability: true,
	createItems: function() {
		var me = this,
			items = [
				Ext.create('Ext.panel.Panel',
					{
						layout: { type: 'hbox', align: 'stretch' },
						border: 0,
						padding: '0 0 5 0',
						items: [
							me.sksc('MIN_VALUE', Ext.create('Ext.form.field.Number', {
								labelWidth: me.labelWidth,
								fieldLabel: 'Уровень риска',
								ksLimitMaxMin: true,
								allowDecimals: false,
								allowExponential: false,
								maxValue: 2147483647,
								minValue: 0
							})),
							{ xtype: 'label', text: '...', padding: '4 5 0 5' },
							me.sksc('MAX_VALUE', Ext.create('Ext.form.field.Number', {
								ksLimitMaxMin: true,
								allowDecimals: false,
								allowExponential: false,
								maxValue: 2147483647,
								minValue: 0
							}))
						]
					}),
				me.sksc('OBJTYPE', Ext.create('Ext.form.field.ComboBox', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Тип объекта',
					maxWidth: 300,
					ksAllowEmpty: true,
					store: Ext.create('Ext.data.Store', {
						fields: CBDataLib.getFields(),
						data: CBDataLib.get('ObjType').filter(r=>r["index"] !== "0"),
						proxy: 'memory'
					}),
					displayField: 'value',
					valueField: 'index',
					value: 0,
					editable: false
				})),
			];

		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 10, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 255, enforceMaxLength: true };
		me.isDHEdit = true;

		return me.callParent([items]);
	},

	saveData: function(endFunc, inputParams) {
		var me = this;
		me.checkPeriod(function(res) {
			if (res) { //попадают ли в диапазон?
				info(wmc.get('ExistsPeriod'));
			} else {
				me.baseSaveData(inputParams || me.dataCollector(), endFunc);
			}
		});
	},

	dataCollector: function() {
		var me = this,
			data = me.callParent(arguments);

		data.MIN_VALUE = me.gksc('MIN_VALUE').getValue();
		data.MAX_VALUE = me.gksc('MAX_VALUE').getValue();
		data.OBJTYPE = me.gksc('OBJTYPE').getValue();

		return data;
	},

	getExtra: function(endFunc, link) {
		var me = this;
		me.baseGetExtra({ link: link }, function(value) {
			me.autoFillControl(value.row);
			me.gksc('MIN_VALUE').setValue(value.row.MIN_VALUE);
			me.gksc('MAX_VALUE').setValue(value.row.MAX_VALUE);
			me.gksc('OBJTYPE').setValue(value.row.OBJTYPE);
			if (!value.isVFK || !value.isFincontrol){
				me.gksc('OBJTYPE').setVisible(false);
			}
			KsLib.tryRun(endFunc);
		});
	},
	isFilled: function() {
		var me = this,
			dh = me.gksc('DH').getValue(),			
			minVal = me.gksc('MIN_VALUE').getValue(),
			maxVal = me.gksc('MAX_VALUE').getValue();
		
		let res = me.callParent(arguments);
		if (dh.dh1 > dh.dh2) {
			me.errorMessages.push(wmc.get('ActionPeriodStartMoreThenEnd'));
		}
		if (minVal > maxVal && maxVal) {
			me.errorMessages.push(wmc.get('invalidRange'));
		}	
		return res;
	},

	//ajax-запрос на проверку попадания в уже существующий диапазон
	checkPeriod: function(callBack) {
		var me = this,
			objs = me.objs,
			dh = objs.DH.getValue();

		ajaxRequest({
			url: 'SRiskLevelValue/CheckPeriod_A',
			params: {
				link: me.getLink(),
				dbegin: dh.dh1,
				dend: dh.dh2,
				minValue: me.gksc('MIN_VALUE').getValue() || 0,
				maxValue: me.gksc('MAX_VALUE').getValue() || 0,
				isProbability: me.isProbability,
				objType: parseInt(me.gksc('OBJTYPE').getValue())
			},
			success: callBack
		});
	}
});