﻿Ext.define('Keysystems.Register.List', {
	extend: 'Keysystems.Base.List',
	startYear: (new Date()).getFullYear(),
	title: 'Регистры (журналов) ВФК',
	errorCls: 'colorize-row-byOverdue',
	profileListeners: [
		{ name: 'S_ORG', method: 'ksDictChange' },
		{ name: 'S_OTDEL', method: 'ksDictChange' },
		{ name: 'DH', method: 'KsPeriodChange' },
		{ name: 'timeLost', method: 'ksCheckBoxChange' },
	],
	btnsHide: { relations: true },
	labelWidth: 150,

	/*viewCfg: function() {
		var cfg = this.callParent(arguments);
		cfg.layout = { type: 'vbox', align: 'stretch' };
		return cfg;
	},*/

	getRowClass: function(rec) {
		const dt = rec.get('TERM_OF_CORRECTION_AT');
		const correction_at = rec.get('CORRECTION_AT');
		return dt && new Date(dt) < now && !correction_at ? this.errorCls : '';
	},

	beforeInitComponent: function() {
		this.code = dnl.IFC_REGISTER;
		return this.callParent(arguments);
	},
	setWhereArgs: function() {
		var me = this,
			ksControls = me.ksControls,
			DH = me.ksControls.DH.getValue(),
			whereArgs = {
				DBegin: { value: DH.dh1.toDateString(), type: 'Date' },
				DEnd: { value: DH.dh2.toDateString(), type: 'Date' },
				SOrgs: { value: me.ksControls.S_ORG.getLinks(1), type: 'List_int' },
				SOtdel: { value: me.ksControls.S_OTDEL.getLinks(1), type: 'List_int' },
				IsDelayed: { value: ksControls.timeLost.getValue() ? 'True' : 'False', type: 'bool' }
			};

		return Ext.apply(me.whereArgs, whereArgs);
	},
	createItems: function() {
		var me = this,
			d1 = longPeriod.begin,
			d2 = longPeriod.end,
			items = me.callParent(arguments);
		me.isCreate = true;
		items.unshift(Ext.create('Ext.panel.Panel', {
			title: 'Фильтр по организациям',
			userCls: 'rks-filter-panel',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			border: 0,
			bodyBorder: 0,
			animCollapse: false,
			items: [
				me.createDictEdit({
					key: 'S_ORG',
					mode: 'MULTI',
					cleaningKey: false,
					flex: 1,
					code: dnl.S_ORG,
					fieldLabel: 'Организация',
					initWhereArgs: function (){
						const whereArgs = {};
						whereArgs.SType = { value: JSON.stringify([KsLib.getKeyByValue(miscTypes.TypeOrg, 'Проверяющая') * 1]), type: 'List_int' };
						if (me.gksd('slaveOrgPInclude') === 1) {
							whereArgs.InLinksOnly = { value: 'True', type: 'bool' };
							const sOrgsLinks = me.gksd('sOrgs').slice();
							if (sOrgsLinks.indexOf(user.org.data.LINK) === -1)
							{
								whereArgs.InLinks = { value: JSON.stringify(sOrgsLinks.concat(user.org.data.LINK)), type: 'List_int' };
							}
							else
							{
								whereArgs.InLinks = { value: JSON.stringify(sOrgsLinks), type: 'List_int' };
							}
						} else {
							whereArgs.LinkMaster = { value: user.org.data.LINK, type: 'int' };
						}
						return whereArgs;
					},
					ksSetValue: function(v) {
						if (me.isLoading) return;
						this.setValue(v.length ? v : [user.org]);
						me.setWhereArgs();
						me.refresh();
					}
				}),
				me.createDictEdit({
					key: 'S_OTDEL',
					mode: 'SINGL',
					flex: 1,
					code: dnl.S_OTDEL,
					fieldLabel: 'Подразделение',
					clear: function() { this.ksSetValue(); },
					getSOrg: function() { 
						return me.gksc('S_ORG').getValue(); 
					},
					initWhereArgs: function() {
						const whereArgs = {};
						if (me.isNastrShowIfcRecordOwnOtdel()) {
							whereArgs.InLinksOnly = {value: 'True', type: 'bool'};
							whereArgs.InLinks = {
								value: JSON.stringify(me.gksd('otdelInLinks') ?? []),
								type: 'List_int'
							};
						}
						else {
							whereArgs.SOrgs = {value: me.gksc('S_ORG').getLinks(1), type: 'List_int'};
						}
						return whereArgs;
					},
					ksSetValue: function(v) {
						if (me.isLoading) return;
						this.setValue(v);
						me.setWhereArgs();
						me.refresh();
					}
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: { type: 'hbox', align: 'left' },
					border: 0,
					items: [
						me.sksc('DH', Ext.create('Keysystems.Controls.PeriodEdit', {
							fieldLabel: 'Период',
							startYear: me.startYear,
							state: 4,
							allStates: 13,
							width: 400,
							listeners: {
								ksChange: function() {
									if (me.isLoading) return;
									me.setWhereArgs();
									me.refresh();
								}
							}
						})),
						me.sksc('timeLost', Ext.create('Ext.form.field.Checkbox', {
							boxLabel: 'Просроченные',
							padding: '0 0 0 10',
							handler: function() {
								if (me.isLoading) return;
								me.setWhereArgs();
								me.refresh();
							}
						}))
					]
				})
			]
		}));
		me.gksc('DH').setValue(d1, d2);
		me.isCreate = false;
		return items;
	},
	
	getGridCfg: function(){
		let res = this.callParent(arguments);
		res.userCls = 'rks-grid-with-filter-panel';
		return res;
	},

	/**
	 * Является ли NastrShowIfcRecord одним из значений (3,4,5)
	 * @returns {boolean}
	 */
	isNastrShowIfcRecordOwnOtdel(){
		const me = this;
		const val = +me.gksd('NastrShowIfcRecord');
		return val === 3 || val === 4 || val === 5;
	},
	
	baseGetData: function(endFunc, params) {
		var me = this;

		return me.callParent([
			function(data) {
				me.sksd('LimitOperation', data.LimitOperation);
				me.sksd('NastrShowIfcRecord', data.NastrShowIfcRecord);
				if (data.otdelInLinks) me.sksd('otdelInLinks', data.otdelInLinks);
				me.sksd('slaveOrgPInclude', data.slaveOrgPInclude);
				me.sksd('sOrgs', data.sOrgs);

				KsLib.tryRun(endFunc, me, data);
			}, params
		]);
	},

	edit: function(f, data, defCfg) {
		defCfg = defCfg || {};
		defCfg.LimitOperation = this.gksd('LimitOperation');

		return this.callParent([f, data, defCfg]);
	}
});