﻿Ext.define('Keysystems.Register.Edit', {
	extend: 'Ext.tab.Panel',
	mixins: ['Keysystems.Base.Edit'],
	title: 'Регистры (журналы) ВФК',
	linkCode: 'RegisterEdit',
	fieldFile: 'FILES',
	isWindow: true,
	flex: 1,
	scrollable: true,
	autoRender: true,
	border: 0,
	bodyPadding: 0,

	viewMinSize: [800, 630],
	profileListeners: [{ name: 'view', method: 'FormParam' }],
	userCls: 'rks-panel-edit',
	bodyCls: 'rks-panel-edit-body',
	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		me.baseInitComponent();

		//bind ksMethods
		Ext.each(['docEdit', 'docDel', 'setReadOnly'], function(k) { me.ksMethods[k] = me[k]; });

		me.callParent(arguments);

		me.afterInitComponent();
	},

	initEvents: function() {
		var me = this;

		me.callParent(arguments);
		me.on('beforetabchange', function(th, newTab) {
			if (me.ridGetExtra || me.inTabChange) return;
			return me.checkTab(newTab, function() {
				me.inTabChange = true;
				me.setActiveTab(newTab);
				me.inTabChange = false;
			});
		});
	},

	createItems: function() { return [this.getTab('General'), this.getTab('Docs'), this.getTab('Resp')]; },

	//#region таб Общие

	//конструктор таба Общие
	createTabGeneral: function() {
		var me = this,
			ksControls = me.ksControls,
			subLabelWidth = 140;

		return me.sksc('tabGeneral', Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 5,
			border: 0,
			flex: 1,
			items: [
				me.createDictEdit({
					key: 'S_ORG',
					fieldLabel: 'Организация',
					mode: 'SINGL',
					labelWidth: me.labelWidth,
					ksAllowEmpty: true,
					code: dnl.S_ORG,
					_clear: function() { this.ksSetValue([]); },
					initWhereArgs: function() {
						let wa = me.gksd('extOrgWhereArgs');
						wa.MarkBusy = { value: 'True', type: 'bool' };
						wa.SType = {
							value: JSON.stringify([KsLib.getKeyByValue(miscTypes.TypeOrg, 'Проверяющая') * 1]),
							type: 'List_int'
						};
						
						return wa;
					},
					ksSetValue: function(v) {
						var c = this,
							newLink = (v && v[0]) ? (v[0].data || v[0]).LINK : 0,
							currVal = c.getLink();

						if (currVal != newLink) {
							if (!me.gksc('IFC_ACTION').isEmpty()) {
								me.attentionMsgShow({
									msg: wmc.get('changeOrgReg'),
									ok: function() {
										c.setValue(v);
										me.gksc('S_OTDEL').ksSetValue(_, 1);
									}
								});
							} else {
								c.setValue(v);
								me.gksc('S_OTDEL').ksSetValue();
							}
						}
					},
				}),
				me.createDictEdit({
					key: 'S_OTDEL',
					fieldLabel: 'Подразделение',
					mode: 'SINGL',
					labelWidth: me.labelWidth,
					ksAllowEmpty: true,
					code: dnl.S_OTDEL,
					_clear: function() { this.ksSetValue([]); },
					ksSetValue: function(v, notMsg) {
						var c = this,
							newLink = (v && v[0]) ? (v[0].data || v[0]).LINK : 0,
							currVal = c.getLink();

						if (currVal != newLink) {
							if (notMsg) {
								c.setValue(v);
								me.gksc('IFC_ACTION').ksSetValue();
							} else {
								if (!me.gksc('IFC_ACTION').isEmpty()) {
									me.attentionMsgShow({
										msg: wmc.get('changeOtdelReg'),
										ok: function() {
											c.setValue(v);
											me.gksc('IFC_ACTION').ksSetValue();
										}
									});
								} else {
									c.setValue(v);
								}
							}
						}
					},
					getSOrg: function() { return me.gksc('S_ORG').getLink(); },
					initWhereArgs: function() {
						return {
							SOrg: {value: me.gksc('S_ORG').getLink(), type: 'int'},
							MarkBusy: {value: 'True', type: 'bool'}
						};
					}
				}),
				Ext.create('Ext.form.FieldSet', {
					title: 'Результаты контрольного действия',
					defaultType: 'textfield',
					layout: { type: 'vbox', align: 'stretch' },
					collapsible: false,
					autoHeight: true,
					minHeight: 485,
					bodyPadding: 0,
					flex: 10,
					items: [
						[
							me.createCodeEdit({
								labelWidth: subLabelWidth,
								enforceMaxLength: true,
								width: 155 + subLabelWidth,
								fieldLabel: '№',
								maxLength: 15
							}),
							me.sksc('INSPECTION_ACTION_AT', Ext.create('Ext.form.field.Date', {
								labelWidth: 25,
								padding: '0 0 0 5',
								format: 'd.m.Y',
								fieldLabel: 'от:',
								maxWidth: 150,
								maxValue: user.Settings.ActionPeriod.dh2,
								minValue: user.Settings.ActionPeriod.dh1,
								ksAllowEmpty: true,
								listeners: { change: function() { me.gksc('IFC_ACTION').ksSetValue([]); } }
							}))
						],
						me.createDictEdit({
							key: 'IFC_ACTION',
							fieldLabel: 'Операция',
							mode: 'SINGL',
							labelWidth: subLabelWidth,
							ksAllowEmpty: true,
							code: dnl.IFC_ACTION,
							accessReadOnly: true,
							_clear: function() { this.ksSetValue([]); },
							whereArgs: {
								InLinks: { value: JSON.stringify([]), type: 'List_int' },
								InLinksOnly: { value: 'True', type: 'bool' },
								//RecordActionLinks: { value: 'True', type: 'bool' }
							},
							ksSetValue: function(v) {
								const c = this;
								const oldLink = c.getLink();
								const newLink = (v && v[0]) ? (v[0].data || v[0]).LINK : 0; 
								if (oldLink === newLink) return;
								
								c.setValue(v);
								if (me.isLoaded) return;
								
								me.gksc('IFC_RECORD_ACTION_INSP').ksSetValue();
								if (!c.isEmpty()) {
									me.getActionInfo(me.gksc('S_ORG').getLink(), me.gksc('S_OTDEL').getLink(), c.getLink(), me.gksc('INSPECTION_ACTION_AT').getValue(), function (res) {
										if (!res) return;
										
										if (res.data.length === 1) {
											const val = res.data;
											me.getInspectors(function (links) {
												me.sksd('inspInLinks', links);
												ksControls.IFC_RECORD_ACTION_INSP.ksSetValue(val);
											});
											
										}
										res.data = {data: res.data, total: res.data.length};
									});
								}
							},
						}, function(o) {
							var handler = o.handler;
							o.handler = function() {
								var dict = me.gksc('IFC_ACTION');
								me.getSubdivisionActions(function(links) {
									dict.whereArgs.InLinks.value = JSON.stringify(links);
									handler.call(dict);
								});
							};
							return o;
						}),
						me.sksc('COMMENT', Ext.create('Ext.form.field.TextArea', {
							fieldLabel: 'Доп. информация по операции',
							labelWidth: subLabelWidth,
							enforceMaxLength: true,
							maxLength: 1000,
							minHeight: 40,
							flex: 10,
							fieldCls: 'rks-textarea'
						})),
						me.sksc('DT_CHECK', Ext.create('Keysystems.Controls.PeriodEdit', {
							labelWidth: 140,
							fieldLabel: 'Проверяемый период',
							isSwap: true,
							width: 380,
							maxWidth: 467,
							cfgDh: { width: 105 }//,
							// getOrgP: function() {
							// 	var orgp = me.gksc('S_ORGP_Grid').store.getAt(0);
							// 	return orgp ? orgp.data.LINK : 0;
							// }
						})),

						me.createDictEdit({
							key: 'IFC_RECORD_ACTION_INSP',
							fieldLabel: 'Контролирующий',
							mode: 'SINGL',
							labelWidth: subLabelWidth,
							ksAllowEmpty: true,
							code: dnl.IFC_R_A_INSP,
							visibleFields: "INSPECTOR_NAME",
							clear: function() { this.ksSetValue([]); },
							listCfg: {
								accessReadOnly: true,
								btnsHide: {
									edit: true
								},
								hidePagging: true,
							},
							codeField: 'INSPECTOR_CODE',
							ksSetValue: function(value) {
								this.setValue(value);
								me.gksc('IFC_RECORD_ACTION_RESP_PERS').ksSetValue(value);
							},
							initWhereArgs: function() {
								return {
									MarkBusy: { value: 'True', type: 'bool'},
									LimitInspectors: { value: me.LimitOperation, type: 'bool'},
									InLinksOnly: { value: 'True', type: 'bool'},
									InLinks: { value: JSON.stringify(me.gksd('inspInLinks')), type: 'List_int' },
									DT: { value: me.gksc('INSPECTION_ACTION_AT').getValue(), type: 'Date'}
								};
							}
						}, function(o) {
							var handler = o.handler;
							o.handler = function() {
								var dict = me.gksc('IFC_RECORD_ACTION_INSP');
								me.getInspectors(function(links) {
									me.sksd('inspInLinks', links);
									handler.call(dict);
								});
							};
							return o;
						}),
						me.createDictEdit({
							key: 'IFC_RECORD_ACTION_RESP_PERS',
							fieldLabel: 'Ответственное лицо',
							labelWidth: subLabelWidth,
							fieldLink: 'IFC_T_RECORD_ACTION',
							codeField: 'RESPONSIBLE_PERSON_CODE',
							nameField: 'RESPONSIBLE_PERSON_NAME',
							code: dnl.IFC_R_A_RESP_PERS,
							mode: 'SINGL',
							//cls: 'ks-readOnly',
							readOnly: true,
							listCfg: {
								accessReadOnly: true,
								hidePagging: true,
							},
							ksSetValue: function(v) {
								this.setValue(v);
								v = this.getValue()[0];
								me.gksc('gridInspTable').loadData(v ? [v] : []);

								v = v ? v.data || v : v;
								Ext.each(me._arrInspTable, function(k) { me.sksd(k, v ? v[k] : ''); });
							},
							ksGetValue: function() {
								let th = this,
									value = [];
								Ext.each(this.getValue(), val => {
									let v = val.data ? val.data : val;
									value.push({
										LINK: v[th.fieldLink],
										CODE: v[th.codeField],
										NAME: v[th.nameField]
									});
								})
								
								return value;
							},
							initWhereArgs: function() {
								let wa = {
									MarkBusy: { value: 'True', type: 'bool'},
									InLinksOnly: { value: 'True', type: 'bool'},
									DT: { value: me.gksc('INSPECTION_ACTION_AT').getValue(), type: 'Date'}
								},
									inspControl = me.gksc('IFC_RECORD_ACTION_INSP'),
									inLinks = [];

								if (inspControl.getLink()) {
									let value = inspControl.getValue()[0],
										val = value.data ? value.data : value;
									inLinks.push(val.IFC_T_RECORD_ACTION);
								}
								
								wa.InLinks = { value: JSON.stringify(inLinks), type: 'List_int' };

								return wa;
							}
						}),
						Ext.create('Ext.form.FieldContainer', {
							fieldLabel: 'Характеристики контрольного действия',
							labelWidth: subLabelWidth,
							layout: {type: 'vbox', align: 'stretch'},
							minHeight: 70,
							flex: 15,
							items: [
								me.sksc('gridInspTable', Ext.create('Ext.grid.Panel', {
									autoScroll: true,
									autoRender: true,
									flex: 1,
									border: 1,
									columns: [],
									columnLines: true,
									store: Ext.create('Ext.data.Store', { fields: [], data: [], proxy: 'memory' }),
									plugins: ['gridclipboard']
								}))
							]
						}),
						me.sksc('INSPECTION_ACTION_RESULTS', Ext.create('Ext.form.field.TextArea', {
							fieldLabel: 'Результаты',
							labelWidth: subLabelWidth,
							enforceMaxLength: true,
							maxLength: 1000,
							minHeight: 20,
							flex: 10,
							fieldCls: 'rks-textarea'
						})),
						ksControls.CAUSES_OF_VIOLATIONS = Ext.create('Ext.form.field.TextArea', {
							fieldLabel: 'Причины',
							labelWidth: subLabelWidth,
							enforceMaxLength: true,
							maxLength: 1000,
							minHeight: 20,
							flex: 10,
							fieldCls: 'rks-textarea'
						}),
						ksControls.CORRECTIVE_ACTIONS = Ext.create('Ext.form.field.TextArea', {
							fieldLabel: 'Меры',
							labelWidth: subLabelWidth,
							enforceMaxLength: true,
							maxLength: 1000,
							minHeight: 20,
							flex: 10,
							fieldCls: 'rks-textarea'
						}),
						ksControls.TERM_OF_CORRECTION_AT = Ext.create('Ext.form.field.Date', {
							labelWidth: subLabelWidth,
							format: 'd.m.Y',
							fieldLabel: 'Срок устранения:',
							maxValue: user.Settings.ActionPeriod.dh2,
							minValue: user.Settings.ActionPeriod.dh1,
							maxWidth: 155 + subLabelWidth
						}),
						me.sksc('CORRECTION_FC', Ext.create('Ext.form.FieldContainer', {
							fieldLabel: 'Отметка об устранении',
							labelWidth: subLabelWidth,
							layout: { type: 'vbox', align: 'stretch' },
							minHeight: 40,
							flex: 16,
							items: [
								[
									ksControls.MARK_OF_CORRECTION = Ext.create('Ext.form.field.Checkbox', {
										listeners: { change: function(th, v) { ksControls.CORRECTION_AT.setDisabled(!v); } }
									}),
									ksControls.CORRECTION_AT = Ext.create('Ext.form.field.Date', {
										labelWidth: me.labelWidth,
										format: 'd.m.Y',
										disabled: true,
										fieldLabel: 'Дата устранения:',
										maxValue: user.Settings.ActionPeriod.dh2,
										minValue: user.Settings.ActionPeriod.dh1,
										align: '',
										padding: '0 0 0 20',
										maxWidth: 135 + subLabelWidth
									})
								],
								ksControls.CORRECTION_WAY = Ext.create('Ext.form.field.TextArea', {
									enforceMaxLength: true,
									maxLength: 1000,
									height: 15,
									minHeight: 20,
									margin: '0 0 10 0',
									flex: 1,
									fieldCls: 'rks-textarea'
								})
							]
						}))
					]
				})
			]
		}));
	},

	_arrInspTable: ['IFC_S_CMETHOD', 'IFC_S_CACTION', 'IFC_S_CTYPE', 'IFC_S_CMODE', 'INSPECTION_RUN_FREQUENCY'],

	//adaptIspectColumn: function(insp) {
	//	Ext.each(insp.columns,
	//		function(el) {
	//			switch (el.dataIndex) {
	//			case 'IFC_S_CMETHOD':
	//			{
	//				el.hidden = false;
	//				el.xtype = 'dictcolumn';
	//				el.code = dnl.IFC_S_CMETHOD;
	//				el.ignoreCodeField = true;
	//				el.cleaningKey = false;
	//				el.controlName = 'dictIfcMethod';

	//				break;
	//			}
	//			case 'IFC_S_CACTION':
	//			{
	//				el.hidden = false;
	//				el.xtype = 'dictcolumn';
	//				el.code = dnl.IFC_S_CACTION;
	//				el.ignoreCodeField = true;
	//				el.cleaningKey = false;
	//				el.controlName = 'dictIfcAction';

	//				break;
	//			}
	//			case 'IFC_S_CTYPE':
	//			{
	//				el.hidden = false;
	//				el.xtype = 'dictcolumn';
	//				el.code = dnl.IFC_S_CTYPE;
	//				el.ignoreCodeField = true;
	//				el.cleaningKey = false;
	//				el.controlName = 'dictIfcType';

	//				break;
	//			}
	//			case 'IFC_S_CMODE':
	//			{
	//				el.hidden = false;
	//				el.xtype = 'dictcolumn';
	//				el.code = dnl.IFC_S_CMODE;
	//				el.ignoreCodeField = true;
	//				el.cleaningKey = false;
	//				el.controlName = 'dictIfcMode';

	//				break;
	//			}
	//			}
	//		});
	//},

	//#endregion таб Общие

	createTabDocs: function() {
		var me = this,
			ksControls = me.ksControls;
		var tD = me.sksc('tabDocs', Ext.create('Ext.grid.Panel', {
			title: 'Документы',
			autoScroll: true,
			autoRender: true,
			flex: 1,
			border: 0,
			tbar: [
				ksControls.btnNew = Ext.create('Ext.Button', {
					iconCls: 'x_btn_new',
					tooltip: 'Создать',
					tooltipType: 'title',
					handler: function() { me.editDoc(); }
				}),
				ksControls.btnCreate = Ext.create('Ext.Button', {
					key: 'edit',
					iconCls: 'x_btn_edit',
					tooltip: 'Редактировать',
					tooltipType: 'title',
					disabled: true,
					handler: function() { if (me.gksc('tabDocs').getFrstSelect()) me.editDoc(me.gksc('tabDocs').getFrstSelect()); }
				}),
				ksControls.btnDel = Ext.create('Ext.Button', {
					key: 'delete',
					tooltip: 'Удалить',
					tooltipType: 'title',
					iconCls: 'x_btn_delete',
					disabled: true,
					handler: function() { ksControls.tabDocs.removeSelection(); }
				})
			],
			features: [
				{
					ftype: 'summary',
					showSummaryRow: false
				}
			],
			store: ksControls.storeDocs = Ext.create('Ext.data.Store', {
				fields: [],
				data: [],
				proxy: 'memory'
			}),
			columns: [],
			columnLines: true,
			listeners: { 
				itemdblclick: function(th, rec) { if (!me.readOnly) me.editDoc(rec); },
				selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('tabDocs'), sels)
			},
			plugins: ['gridclipboard']
		}));

		return tD;
	},

	createTabResp: function(){
		var me = this,
			ksControls = me.ksControls;
		let cfg = { isVfa: me.isVfa, code: me.code };
		return me.sksc('tabResp', Ext.create('Keysystems.Register.Edit.Resp', cfg));
	},

	editDoc: function(rec) {
		var me = this;
		Ext.create('Keysystems.Register.Edit.Docs', {
			f: rec ? 'edit' : 'new',
			data: rec,
			parentView: me,
			getExtra: function(callback) { KsLib.tryRun(callback); },
			baseSaveData: function(params, callBack) {
				this.oldData = JSON.stringify(params);

				if (rec)
					rec.set(params);
				else
					rec = me.gksc('tabDocs').store.add(params)[0];

				this.f = 'edit';
				
				QuickMsgs.save();
				if (callBack) callBack();
			}
		});
	},

	getSubdivisionActions: function(callBack) {
		var me = this,
			org = me.gksc('S_ORG').getLink(),
			otdel = me.gksc('S_OTDEL').getLink(),
			dt = me.gksc('INSPECTION_ACTION_AT').getValue()?.toDateString();

		if (org && otdel && dt) {
			me.showLoadMask({
				msg: KS.L10n.loading_data,
				rid: ajaxRequest({
					url: 'SRegister/GetSubdivisionActions_A',
					params: { org: org, otdel: otdel, dt: dt },
					callback: function(result) {
						callBack(result || []);
						me.hideLoadMask();
					}
				})
			});
		} else {
			callBack([]);
		}
	},

	getInspectors: function(callBack) {
		var me = this,
			org = me.gksc('S_ORG').getLink(),
			otdel = me.gksc('S_OTDEL').getLink(),
			actionLink = me.gksc('IFC_ACTION').getLink(),
			dt = me.gksc('INSPECTION_ACTION_AT').getValue()?.toDateString();

		if (org && otdel && dt && actionLink) {
			me.showLoadMask({
				msg: KS.L10n.loading_data,
				rid: ajaxRequest({
					url: 'SRegister/GetInspectors_A',
					params: { org: org, otdel: otdel, actionLink: actionLink, dt: dt},
					callback: function(result) {
						callBack(result || []);
						me.hideLoadMask();
					}
				})
			});
		} else {
			callBack([]);
		}
	},

	getExtra: function(callBack, link) {
		var me = this,
			ksControls = me.ksControls;

		me.baseGetExtra({ link: link }, function(value) {
			var row = value.row;

			Ext.each([
				'CODE',
				'INSPECTION_ACTION_RESULTS',
				'CAUSES_OF_VIOLATIONS',
				'CORRECTIVE_ACTIONS',
				'TERM_OF_CORRECTION_AT',
				'MARK_OF_CORRECTION',
				'CORRECTION_AT',
				'CORRECTION_WAY',
				'COMMENT'
			], function(k) { me.gksc(k).setValue(row[k]); });
			
			me.sksd('extOrgWhereArgs', value.extOrgWhereArgs)
			me.gksc('S_ORG').ksSetValue(value['S_ORG']);
			me.gksc('S_OTDEL').ksSetValue(value['S_OTDEL']);

			if (me.gksc('S_ORG').isEmpty()) {
				me.gksc('S_ORG').ksSetValue([user.org]);
			}
			if (me.gksc('S_OTDEL').isEmpty()) {
				me.gksc('S_OTDEL').ksSetValue([user.otdel]);
			}

			me.gksc('INSPECTION_ACTION_AT').setValue(me.getDateOrToday(row.INSPECTION_ACTION_AT));

			me.sksd('sOrgWhereLinks', value.sOrgWhereLinks);

			me.gksc('IFC_ACTION').whereArgs.InLinks.value = JSON.stringify(value.actionInLinks);
			me.sksd('inspInLinks', value.inspInLinks);
			Ext.each(['IFC_ACTION', 'IFC_RECORD_ACTION_INSP'], function(k) {
				var c = me.gksc(k);
				(c.ksSetValue || c.setValue).call(c, [value[k]]);
			});
			
			me.gksc('DT_CHECK').setValue(row.DT_CHECK1, row.DT_CHECK2);
			
			me.setFullObjsAccess(value.isAccess, ['COMMENT', 'DT_CHECK']);

			/*if (me.LimitOperation) {
				Ext.each(['S_ORG', 'S_OTDEL'], function(k) { me.gksc(k).setReadOnly(true); });

				var insp = me.gksc('IFC_RECORD_ACTION_INSP').getValue()[0];
				if (insp && (insp.data || insp).S_PERSON != user.person.data.LINK) {
					me.readOnlyList = [];
					for (var key in me.ksControls) me.readOnlyList.push(key);
					me.setReadOnly(true);
				}
			}*/

			//me.adaptIspectColumn(value.responsible);
			ksControls.gridInspTable.setMetaDate(value.responsible, {
				code: me.code,
				profileKey: 'gridInspTable',
				gateCode: 'edit',
			});

			if (me.f === 'edit' && !PeriodLib.contain(me.gksc('INSPECTION_ACTION_AT').getValue(), user.Settings.ActionPeriod, _, 'dh')) 
				me.setReadOnly(true);

			if (value.tabDocs) {
				Ext.each(value.tabDocs.fields, function(field) {
					if (field.name === 'FILES') {
						field.type = 'string';
						return false;
					}
					return true;
				});

				const pos = ArrayLib.find(value.tabDocs.columns, ['dataIndex'], 'FILES');
				const fileColumn = {
					xtype: 'actioncolumn',
					dataIndex: 'FileColumn',
					text: 'Файл',
					width: 40,
					align: 'center',
					flex: 1,
					items: [
						{
							getClass: function(v, meta, rec) { return getExtStyle(rec.get(me.fieldExt)); },
							handler: (grid, rowIndex) => me.fileGridEdit(grid.getStore().getAt(rowIndex))
						}
					]
				};
				if (pos === -1) {
					value.tabDocs.columns.push(fileColumn);
				} else {
					value.tabDocs.columns[pos] = fileColumn;
				}

				ksControls.tabDocs.setMetaDate(value.tabDocs, {
					profileCode: me.code,
					profileKey: 'tabDocs',
					gateCode: me.keyEdit
				});
			}

			if (value.tabResp) {
				me.sksd('sWork', value.tabResp.sWork)
				var resp = me.gksc('tabResp');
				resp.tempTask = value.tabResp.tempTask;
				resp.ksData.access = value.tabResp.access;
				resp.ksData.sWork = value.tabResp.sWork;
				resp.access = value.tabResp.access;
				resp.loadData(value.tabResp.tasksRespData);
			}

			if (callBack) callBack();
		});
	},

	attentionMsgShow: function(cfg) {
		Ext.Msg.show({
			title: wmc.get('Attention'),
			msg: cfg.msg,
			buttons: Ext.MessageBox.OKCANCEL,
			fn: function(buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.INFO
		});
	},

	// ajax-запрос контролирующих и ответственных лиц данной организации, отдела, операции.
	getActionInfo: function(orgLink, otdelLink, actionLink, date, callBack) {
		var me = this;

		me.showLoadMask({
			msg: KS.L10n.updating_data,
			rid: ajaxRequest({
				url: 'SRegister/GetInspAndRespPers_A',
				params: {
					orgLink: orgLink,
					otdelLink: otdelLink,
					actionLink: actionLink,
					date: date?.toDateString()
				},
				callback: function(result) {
					callBack(result);
					me.hideLoadMask();
				}
			})
		});
	},

	dataCollector: function() {
		var me = this,
			data = { link: me.getLink() },
			DT_CHECK = me.gksc('DT_CHECK').getValue();

		Ext.each([
			'CODE',
			'INSPECTION_ACTION_AT',
			'INSPECTION_ACTION_RESULTS',
			'CAUSES_OF_VIOLATIONS',
			'CORRECTIVE_ACTIONS',
			'TERM_OF_CORRECTION_AT',
			'MARK_OF_CORRECTION',
			'CORRECTION_AT',
			'CORRECTION_WAY',
			'COMMENT'
		], function(k) { data[k] = me.gksc(k).getValue(); });

		Ext.each(['S_ORG', 'S_OTDEL', 'IFC_RECORD_ACTION_INSP'], function(k) { data[k] = me.gksc(k).getLink(); });

		data.TEMP_IFC_ACTION = me.gksc('IFC_ACTION').getLink();
		data.IFC_RECORD_ACTION_RESP_PERS = me.gksc('IFC_RECORD_ACTION_RESP_PERS').getLink();

		data.tabDocs = me.gksc('storeDocs').getDataExt(_, 1);

		data.DT_CHECK1 = DT_CHECK ? DT_CHECK.dh1.toDateString() : '';
		data.DT_CHECK2 = DT_CHECK ? DT_CHECK.dh2.toDateString() : '';

		Ext.each(me._arrInspTable, function(k) { data[k] = me.gksd(k); });

		return data;
	},

	isFilled: function() {
		var me = this,
			ksControls = me.ksControls;
		
		let res = true;
		if (ksControls.S_ORG.isEmpty()) {
			me.addToInvalidControls(ksControls.S_ORG, {parent: me, tab: me.getTab('General')});
			res = false;
		}

		if (ksControls.S_OTDEL.isEmpty()) {
			me.addToInvalidControls(ksControls.S_OTDEL, {parent: me, tab: me.getTab('General')});
			res = false;
		}

		if (ksControls.CODE.isEmpty()) {
			me.addToInvalidControls(ksControls.CODE, {parent: me, tab: me.getTab('General')});
			res = false;
		}

		if (!ksControls.INSPECTION_ACTION_AT.ksReadOnly && ksControls.INSPECTION_ACTION_AT.isEmpty()) {
			me.addToInvalidControls(ksControls.INSPECTION_ACTION_AT, {title: 'от', parent: me, tab: me.getTab('General')});
			res = false;
		}

		if (ksControls.IFC_ACTION.isEmpty()) {
			me.addToInvalidControls(ksControls.IFC_ACTION, {parent: me, tab: me.getTab('General')});
			res = false;
		}

		if (ksControls.DT_CHECK.isVisible()) {
			dh = ksControls.DT_CHECK.getValue();
			if (dh.dh1 > dh.dh2) {
				me.errorMessages.push(wmc.get('CheckingPeriodStartMoreThenEnd'));
			}
			dt = ksControls.INSPECTION_ACTION_AT.getValue();
			if(dh.dh2 > dt){
				me.errorMessages.push(wmc.get('CheckingPeriodEndMoreThenDt'));
			}
		}

		if (ksControls.IFC_RECORD_ACTION_INSP.isEmpty()) {
			me.addToInvalidControls(ksControls.IFC_RECORD_ACTION_INSP, {parent: me, tab: me.getTab('General')});
			res = false;
		}

		if (ksControls.IFC_RECORD_ACTION_RESP_PERS.isEmpty()) {
			me.addToInvalidControls(ksControls.IFC_RECORD_ACTION_RESP_PERS, {parent: me, tab: me.getTab('General')});
			res = false;
		}
		
		Ext.each(['INSPECTION_ACTION_AT', 'TERM_OF_CORRECTION_AT', 'CORRECTION_AT'], function(k) {
			var c = me.gksc(k),
				d = c.getValue();

			if (d && !PeriodLib.contain(d, user.Settings.ActionPeriod, _, 'dh')) {
				if (!me.invalidControls.filter(ic => ic.control === c).length) {
					me.addToInvalidControls(c, {parent: me, tab: me.getTab('General')});
					res = false;
				}
			}			
		});

		return res;
	},

	checkTab: function (newTab, callBack) {
		const me = this;
		if (newTab.tabKey === "Resp" && !this.getLink()) {
			me.saveMessageShow(null, callBack)
		} else {
			callBack();
		}
		return false;
	},
	//#region Работа с документами

	//#region окно выбора доступных документов

	taskDocTypeImgFormat: '<img class="x-action-col-icon {0}">',

	getTaskDocVidColumns: function() {
		var me = this;
		return [
			{
				text: 'Тип',
				dataIndex: 'TYPE',
				renderer: function(v, m) {
					m.align = 'center';
					var imgs = '';
					for (var t in miscTypes.DocType) {
						if (v & t) {
							imgs += Ext.String.format(me.taskDocTypeImgFormat, KsLib.getTaskTypeIconCls(t * 1));
						}
					}
					return imgs;
				}
			},
			{
				text: 'Код',
				dataIndex: 'S_DOCVID_CODE'
			},
			{
				text: 'Наименование',
				dataIndex: 'S_DOCVID_NAME',
				flex: 1
			}
		];
	},

	getTaskDocVidFields: function() { return ['LINK', 'TYPE', 'S_DOCVID_CODE', 'S_DOCVID', 'S_DOCVID_NAME']; },

	getTaskDocVidDict: function(data, okFn, parentStack = "[]") {
		const me = this;
		const alreadyCreatedTasks = JSON.parse(parentStack);

		Ext.create('Keysystems.Base.List', {
			code: dnl.S_DOCVID,
			title: 'Виды документов',
			mode: 'SINGL',
			parentView: me,
			hidePagging: true,
			baseGetData: function(callBack) {
				if (callBack) {
					callBack({
						columns: me.getTaskDocVidColumns(),
						fields: me.getTaskDocVidFields(),
						data: me.getTaskDocVidData(data)
					});
				}
			},
			baseRefresh: function(callBack) { if (callBack) callBack(me.getTaskDocVidData(data)); },
			GateCode: 'edit',
			prefix: 'Task',
			profileKey: 'DocVid',
			btnsHide: {
				new: true,
				same: true,
				edit: true,
				search: true,
				treeadd: true
			},
			getRowClass: function(record) {
				let rowStyle = '';

				if (record.data.OPTIONAL) {
					rowStyle += ' ks-textgray';
				}

				if (alreadyCreatedTasks) {
					let S_DOCVID = record.get('S_DOCVID');
					let isExist;

					for (let key in alreadyCreatedTasks) {
						isExist = !!alreadyCreatedTasks[key].filter(task => task.S_DOCVID === S_DOCVID).length;
					}

					if (!isExist) {
						rowStyle += ' ks-boldtext';
					}
				}

				return rowStyle;
			},
			functions: { ok: okFn }
		});
	},

	getTaskDocVidData: function(data) {
		var d = JSON.parse(JSON.stringify(data));
		return { data: d, total: d.length };
	},

	//#endregion окно выбора доступных документов

	docShow: function(cfg) { Ext.create('Keysystems.Documents.Edit', cfg); },

	getDocParentStack: function(node) {
		var parentStack = [],
			n,
			parseNodeFn = function(node) {
				return {
					LINK: node.get('LINK'),
					LINK_SELF: node.get('LINK_SELF'),
					TYPE: node.get('TYPE'),
					S_DOCVID: node.get('S_DOCVID'),
					DTUTV: node.get('DTUTV')
				};
			};

		while (!node.parentNode.isRoot()) {
			var child = node.childNodes[0];
			n = parseNodeFn(node);
			if (child && ArrayLib.filter(parentStack, ['LINK'], child.get('LINK')).length === 0) {
				parentStack.push(parseNodeFn(child));
			}
			parentStack.push(n);
			node = node.parentNode;
		}

		if (n) n.LINK_SELF = null;

		var tmp = {};
		tmp[node.data.LINK] = parentStack;
		return JSON.stringify(tmp);
	},

	pickTaskDocType: function(v, callBack) {
		var bt = {}, i = 0;
		for (var t in miscTypes.DocType) {
			if (v & t) bt[Ext.Msg.buttonIds[i]] = miscTypes.DocType[t];
			i++;
		}

		Ext.Msg.show({
			title: 'Ввод документа',
			msg: 'Добавить документ',
			buttons: v * 1,
			buttonText: bt,
			fn: function(buttonId) {
				if (buttonId === 'cancel' || !callBack) return;
				callBack(Math.pow(2, Ext.Msg.buttonIds.indexOf(buttonId)));
			},
			icon: Ext.MessageBox.INFO
		});
	},

	pickTaskDocTypeAndEdit: function(type, cfg) {
		var me = this,
			i = 0;
		for (var t in miscTypes.DocType) if (type & t) i++;
		if (i > 1) {
			me.pickTaskDocType(type, function(pt) {
				cfg.taskDocType = pt;
				me.docShow(cfg);
			});
		} else {
			cfg.taskDocType = type;
			me.docShow(cfg);
		}
	},

	getDocCopyStack: function(rec) {
		var me = this,
			res = { LINK: rec.get('LINK'), children: [] };
		Ext.each(rec.childNodes, function(r) { res.children.push(me.getDocCopyStack(r)); });
		res.children = JSON.stringify(res.children);
		return JSON.stringify(res);
	},
	docCopyRun: function(docLink, recursive, parentNode) {
		const me = this;
		me.showLoadMask({
			msg: wmc.getMask('Copy'),
			rid: ajaxRequest({
				url: 'SDocuments/Copy_A',
				params: { link: me.getLink(), docCode: me.code, docLink: docLink, recursive: recursive },
				success: function(res) {
					me.hideLoadMask();
					if (!res || res.ErrorMsg) {
						info(res.ErrorMsg ?? wmc.get('NotChieldDoc'));
						return;
					}
					if (res.SavedStampMUC) {
						me.sksd('STAMP', res.SavedStampMUC);
						if (me.oldData) {
							const oldData = JSON.parse(me.oldData);
							oldData.STAMP = res.SavedStampMUC;
							me.oldData = JSON.stringify(oldData);
							me.updateStamp(me.getLink(), res.SavedStampMUC);
						}

					}
					if (res.data) {
						parentNode.appendChild(res.data);
					}
				},
				failure: function() { me.hideLoadMask(); }
			})
		});
	},
	docCopy: function(rec) {
		var me = this,
			parentNode = rec.parentNode;

		if (parentNode.get('S_TASK') === 0) return;

		me.showLoadMask({
			msg: wmc.getMask('CanCopyDoc'),
			rid: ajaxRequest({
				url: 'SDocuments/CanCopy_A',
				params: {
					link: me.getLink(),
					docCode: me.code,
					taskLink: parentNode.get('S_TASK'),
					parentDocLink: parentNode.get('parentId') === 'root' ? 0 : parentNode.get('LINK'),
					workLink: me.ksData.sWork,
					curDocVid: rec.get('S_DOCVID')
				},
				success: function(res) {
					me.hideLoadMask();
					if (!res) {
						info(wmc.get('NotChieldDoc'));
						return;
					}

					if (rec.childNodes.length) {
						var bt = {},
							btnTxt = ['Документ', 'Всю цепочку', 'Отмена'];

						for (var i = 0; i < 3; i++) bt[Ext.Msg.buttonIds[i]] = btnTxt[i];

						Ext.Msg.show({
							title: wmc.get('Copy'),
							buttons: Ext.MessageBox.YESNO,
							buttonText: bt,
							msg: wmc.getQuestion('CopyChainDocs'),
							fn: function(buttonId) {
								if (buttonId === 'ok') me.docCopyRun(rec.get('LINK'), false, parentNode);
								if (buttonId === 'yes') me.docCopyRun(rec.get('LINK'), true, parentNode);
							},
							icon: Ext.MessageBox.QUESTION
						});
					} else {
						selectDialogShow(wmc.get('Copy'), 'Копировать документ?',
							function() { me.docCopyRun(rec.get('LINK'), false, parentNode); }
						);
					}
				},
				failure: function() { me.hideLoadMask(); }
			})
		});
	},

	docEdit: function(initCfg, data, taskGrid, defCfg) {
		var me = this,
			cfg = {
				data: data,
				readOnly: data.readOnly,
				title: 'Документы',
				linkCode: 'SDocuments',
				parentView: taskGrid,
				isVfa: me.isVfa,
				addRecord: function(row) {
					row.children = [];
					row.leaf = true;
					data.set('leaf', false);
					return data.appendChild(row);
				},
				//метод сохранения данных
				saveData: function (endFunc, params) {
					this.callParent([
						function (result) {
							if (result.row) {
								let sel = taskGrid.getStore().findNode('LINK', result.row.LINK);
								if (sel) taskGrid.getSelectionModel().select(sel);
								taskGrid.refreshTask(result.tempTask, result.row.S_TASK);
							}
							if (result.SavedStampMUC) {
								me.sksd('STAMP', result.SavedStampMUC);
								const oldData =  JSON.parse(me.oldData);
								oldData.STAMP = result.SavedStampMUC;
								me.oldData = JSON.stringify(oldData);
								me.updateStamp(me.getLink(), result.SavedStampMUC);
							}
							if (endFunc) endFunc(result);
						}, params
					]);
				},
				createFile: function(link, callback) { this.runCreateFile(link, callback); },

				//сообщение о наличии несохраненных данных при создании файла
				createFileMsgShow: function(c) {
					Ext.Msg.show({
						title: KS.L10n.attention,
						msg: wmc.get('NeedSaveReviz'),
						buttons: Ext.MessageBox.OKCANCEL,
						buttonText: { ok: 'Сохранить', },
						fn: function(buttonId) {
							var fn = c[buttonId] || c.default;
							if (fn) fn();
						},
						icon: Ext.MessageBox.INFO
					});
				},

				runCreateFile: function(link, callback) {
					if (this.beforeCreateFile(callback) !== false) {
						UploaderLib.newFile(this.code, link, 0, -1, 0, this.getLoadMaskTarget(), callback);
					}
				},

				beforeCreateFile: function(callback) {
					var me1 = this;
					if (this.readOnly || !me1.isFilled()) return false;
					var newData = me1.saveChangesFn();
					if (!me1.getLink() || newData || me.saveChangesFn()) {
						me1.createFileMsgShow({
							ok: function() {
								me1.saveData(function() {
									me.ownerCt.saveData(function() {
										if (me1.gksc('fileView'))
											me1.gksc('fileView').btnNew.handler();
										else if (me1.createFile)
											me1.createFile(me1.getLink(), callback);
									});
								}, newData);
							}
						});
						return false;
					}
					return _;
				},
			};

		Ext.apply(cfg, initCfg);
		Ext.apply(cfg, defCfg);

		if (cfg.f === 'copy') me.docCopy(data);
		else if (cfg.f === 'edit') me.docShow(cfg);
		else {
			let parentStack = me.getDocParentStack(data);
			me.showLoadMask({
				msg: KS.L10n.loading_data,
				rid: ajaxRequest({
					url: 'SDocuments/GetNewTaskDocsData_A',
					params: {
						link: data.data.IFC_REGISTER,
						docCode: dnl.IFC_REGISTER,
						taskLink: data.data.S_TASK,
						docLink: data.data.parentId === 'root' ? 0 : data.data.LINK,
						workLink: me.ksData.sWork
					},
					success: function(result) {
						me.hideLoadMask();
						if (!result.length) {
							info(wmc.get('NotChieldDoc'));
							return;
						}
						if (result.length === 1) {
							cfg.taskDocVidLink = result[0].LINK;
							me.pickTaskDocTypeAndEdit(result[0].TYPE, cfg);
						} else {
							me.getTaskDocVidDict(result, function(taskDocVid) {
								if (taskDocVid = taskDocVid[0]) {
									cfg.taskDocVidLink = taskDocVid.data.LINK;
									me.pickTaskDocTypeAndEdit(taskDocVid.data.TYPE, cfg);
								}
							}, parentStack);
						}
					},
					failure: function() { me.hideLoadMask(); }
				})
			});
		}

	},
	docDel: function(nodes, taskGrid) {
		var me = this;

		me.showLoadMask({
			msg: `${KS.L10n.delete}...`,
			rid: ajaxRequest({
				url: 'SDocuments/Delete_A',
				params: { code: 'DOCUMENTS', links: ArrayLib.getLinks(nodes), recursive: true, reviz: me.getLink() },
				success: function (val) {
					let value = val.delInfo,
						notDel = value.notDel;
					if (notDel && notDel.length) relationsMsg(me.code, notDel, value.notDelLinks, me.tabMode, me);
					
					if (val.STAMP) {
						me.sksd('STAMP', val.STAMP);
					}

					Ext.each(nodes, function (el) { value.notDelLinks.indexOf(el.data.LINK) === -1 && el.remove(); });
					if (taskGrid) {
						if (val.tempTask) {
							taskGrid.tempTask = val.tempTask;
							taskGrid.view.refresh();
						}
						taskGrid.getRootNode().cascade(function (node) {
							node.set('NEXT_DOCVIDS', null);
						});
					}
				},
				callback: function() { me.hideLoadMask(); }
			})
		});
	},

	setAccessTaskGrid: function(sTask){
		var th = this,
			taskAccessEdit = th.ksData.NastrTaskAccessEdit,
			userGroupEdit = th.ksData.NastrUserGroupEdit,
			personClosed = th.ownerCt.ksControls.CLOSE_PERSON.getValue(),
			access = ((personClosed[0] && personClosed[0].LINK !== window.user.person.data.LINK));

		if (Ext.Array.contains(taskAccessEdit, sTask) && access){
			var canEdit = Ext.Array.contains(userGroupEdit, window.user.id) || !!Ext.Array.intersect(userGroupEdit, th.ksData.UserGroups).length;
			th.setKsReadOnly(!canEdit);
			th.gksc('saveBtn', true).setKsReadOnly(!canEdit);
			th.ownerCt.readOnly = !canEdit;
		}
		else {
			th.setKsReadOnly(th.ownerCt.ksReadOnly);
			th.gksc('saveBtn', true).setKsReadOnly(th.ownerCt.ksReadOnly);
			th.ownerCt.readOnly = th.ownerCt.ksReadOnly;
		}
	},
	//#endregion Работа с документами

});