﻿Ext.define('Keysystems.Register.Edit.Docs', {
	extend: 'Keysystems.Base.Edit',
	title: 'Документ',
	isFileBtn: true,
	fieldName: 'NUMBER',
	fieldFile: 'FILES',
	newLink: -1,
	readOnlyList: ['S_RDOC', 'NUMBER', 'DATE_AT'],
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				me.createDictEdit({
					key: 'S_RDOC',
					ksAllowEmpty: true,
					mode: 'SINGL',
					code: dnl.S_RDOC,
					fieldLabel: 'Вид документа'
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						me.sksc('NUMBER', objs.NUMBER = Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							fieldLabel: '№'
						})),
						me.sksc('DATE_AT', objs.DATE_AT = Ext.create('Ext.form.field.Date', {
							labelWidth: 20,
							padding: '0 0 0 10',
							fieldLabel: 'от',
							minValue: '01.01.1900',
							maxValue: '31.12.2100',
							width: 130
						}))
					]
				})
			];
		return objs.items = items;
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments),
			srdoc = objs.S_RDOC.getValue();

		data.DATE_AT = objs.DATE_AT.getValue();
		data.NUMBER = objs.NUMBER.getValue();
		data.TEMP_EXT = objs.fileData.TEMP_EXT;
		data.FILES = objs.fileData.FILES;
		if (srdoc.length) {
			data.S_RDOC = srdoc[0].data.LINK;
			data.TEMP_S_RDOC_CODE = srdoc[0].data.CODE;
			data.TEMP_S_RDOC_NAME = srdoc[0].data.NAME;
		} else data.S_RDOC = 0;
		return data;
	},


	isFilled: function() {
		var me = this;

		if (!me.objs.S_RDOC.getValue().length) {
			me.addToInvalidControls(me.objs.S_RDOC);
			return false;
		}

		return true;
	},
	loadNewData: function() {
		var me = this;
		me.objs.fileData = { LINK: 0, FILES: 0, TEMP_EXT: '' };
		me.objs.LINK = me.newLink--;
		me.callParent(arguments);
	},

	fileEdit: function() {
		var me = this;
		Ext.create('Keysystems.File', {
			iconCls: getExtStyle(me.objs.fileData[me.fieldExt]),
			createFile: null, //function(callback) { me.createFile(me.getLink(), callback); },
			updRecord: function(fileObj) { me.updFileRecord(fileObj); },
			getFileId: function() { return me.objs.fileData[me.fieldFile]; },
			downloadFile: function() { me.downloadFile(); },
			clearFile: function() { me.clearFile(); }
		});
	},
	clearFile: function() {
		var me = this,
			d = me.objs.fileData;

		d[me.fieldFile] = 0;
		me.objs.btnFile.setIconCls(getExtStyle(d[me.fieldExt] = ''));
	},
	updFileRecord: function(fileObj) {
		var me = this,
			d = me.objs.fileData;

		d[me.fieldFile] = fileObj.id;
		me.objs.btnFile.setIconCls(getExtStyle(d[me.fieldExt] = fileObj.ext));
	},
	downloadFile: function() {
		var me = this,
			d = me.objs.fileData;
		UploaderLib.getFile(d[me.fieldFile], me.objs[me.fieldName].getValue());
	},

	successSaveFunc: function() {
		var me = this;
		me.callParent(arguments);
	},

	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;

		objs.LINK = data.LINK;
		objs.S_RDOC.setValue([
			{
				data: {
					LINK: data.S_RDOC,
					CODE: data.TEMP_S_RDOC_CODE,
					NAME: data.TEMP_S_RDOC_NAME
				}
			}
		]);
		objs.DATE_AT.setValue(data.DATE_AT);
		objs.NUMBER.setValue(data.NUMBER);
		objs.fileData = {
			LINK: 0,
			FILES: data.FILES,
			TEMP_EXT: data.TEMP_EXT
		};
		objs.btnFile.setIconCls(getExtStyle(data.TEMP_EXT));

		if (me.readOnly) me.setReadOnly(true);
		me.callParent(arguments);
	}
});