﻿Ext.define('Keysystems.Record.List', {
	extend: 'Keysystems.Base.List',
	title: 'Карты ВФК',
	profileCode: 'DOCUMENT_IFC_RECORD',
	canBold: false,
	initConfig: function (cfg) {
		if (!cfg.code) {
			cfg.code = dnl.IFC_RECORD;
		}
		return this.callParent(arguments);
	},

	setWhereArgs: function () {
		var me = this,
			whereArgs = {
				Modification: { value: 'False', type: 'KSBoolean' },
				ByRashDate: { value: false, type: 'bool' }
			};

		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},

	createItems: function() {
		var me = this,
			d1 = longPeriod.begin,
			d2 = longPeriod.end,
			items = me.callParent(arguments);
		me.isCreate = true;
		items.unshift(objs.filterPanel = Ext.create('Ext.panel.Panel', {
			bodyStyle: { 'borderLeft': 0 },
			header: false,
			hideCollapseTool: true,
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			items: [
				me.sksc('chkRashDate', Ext.create('Ext.form.field.Checkbox', {
					boxLabel: 'с учетом изменений на расчетную дату',
					padding: '0 30 0 0',
					handler: function (th, check) {
						me.whereArgs.ByRashDate = { value: check.toString(), type: 'bool' };
						me.showLoadMask({
							msg: KS.L10n.loading_data,
							rid: ajaxRequest({
								url: 'SRecord/ReloadByRashDate_A',
								params: {
									whereArgs: JSON.stringify(me.whereArgs)
								},
								success: function (res) {
									if (res.newWA) {
										for (var key in res.newWA) {
											me.whereArgs[key] = res.newWA[key];
										}

										// скрытие/показывание колонок
										var cols = me.objs.Grid.columnManager.getColumns(),
											dtUtvCol = ArrayLib.filter(cols, ['dataIndex'], 'DT_UTV'),
											osnovCol = ArrayLib.filter(cols, ['dataIndex'], 'MOSNOV_NAME'),
											numChangeCol = ArrayLib.filter(cols, ['dataIndex'], 'NUMBER_MOD');

										if (dtUtvCol && dtUtvCol[0]) {
											dtUtvCol[0].setVisible(check);
										}
										if (osnovCol && osnovCol[0]) {
											osnovCol[0].setVisible(check);
										}
										if (numChangeCol && numChangeCol[0]) {
											numChangeCol[0].setVisible(check);
										}

										me.refresh(true, 1);
									}
								},
								callback: me.hideLoadMask.bind(me)
							})
						});
					}
				}))
			]
		}));
		me.isCreate = false;
		if (me.head === false || me.hideFilterPnl) objs.filterPanel.hide();
		return items;
	},
	getRowClass: function (rec) {
		return this.canBold && rec.get('DT_UTV') !== null ? 'x-bold' : '';
	},

	columnsAdapted: function() {
		var me = this,
			cols = this.callParent(arguments),
			dtUtvCol = ArrayLib.filter(cols, ['dataIndex'], 'DT_UTV'),
			osnovCol = ArrayLib.filter(cols, ['dataIndex'], 'MOSNOV_NAME'),
			numChangeCol = ArrayLib.filter(cols, ['dataIndex'], 'NUMBER_MOD');

		if (me.whereArgs.Modification.value === 'False') {
			if (dtUtvCol && dtUtvCol[0]) {
				dtUtvCol[0].hidden = true;
			}
			if (osnovCol && osnovCol[0]) {
				osnovCol[0].hidden = true;
			}
			if (numChangeCol && numChangeCol[0]) {
				numChangeCol[0].hidden = true;
			}
		}

		return cols;
	},
	baseGetData: function (endFunc, params) {
		var me = this;
		params.code = me.code;
		me.callParent([
			function (data) {
				me.approvedStatuses = data.approvedStatuses;
				if (endFunc) endFunc(data);
			}, params
		]);
	},
    beforeSetData: function(data, p) {
        var me = this,
            fields = data.fields;

        numInd = ArrayLib.find(fields, ['name'], 'NUMBER');
        if (numInd != -1) {
            fields[numInd].sortType = "asNatural";
        };
        numInd = ArrayLib.find(fields, ['name'], 'NUMBER_MOD');
        if (numInd != -1) {
            fields[numInd].sortType = "asNatural";
        };
        me.callParent(arguments);
    },

	checkReadOnly: function(rec){
		var me = this;
		me.callParent(arguments);

		// приходится здесь вызывать, т.к. base.checkReadOnly перебивает disabled у delete
		var sel = me.objs.Grid.getSelectionModel().getSelection();
		if (sel && sel.length) {
			//Нельзя удалять утвержденые карты и изменения
			var closed = (me.approvedStatuses || []).indexOf(sel[0].get('S_STATUS')) !== -1;
			me.objs.tbarBtns.delete?.setDisabled(closed);
		}
	}

});