﻿Ext.define('Keysystems.Record.List.Mod', {
	extend: 'Keysystems.Record.List',
	title: 'Изменения в Карты ВФК',
	deleteCode: 'DOCUMENT_IFC_RECORD_MOD',
	profileCode: 'DOCUMENT_IFC_RECORD_MOD',
	btnsHide: {
		new: true,
		same: true
	},
	canBold: true,

	initConfig: function(cfg) {
		cfg.code = dnl.IFC_RECORD_MOD;
		return this.callParent(arguments);
	},

	setWhereArgs: function() {
		var me = this;
		var whereArgs = me.callParent(arguments);
		whereArgs.Modification = { value: 'True', type: 'KSBoolean' };
		
		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},

	listeners: {
		beforeselect: function (th, rec) {
			this.objs.tbarBtns.delete?.setDisabled(rec.data['MODIFICATION'] === true);
		}
	},

	createItems: function () {
		var me = this,
			items = me.callParent(arguments);
		me.gksc('chkRashDate').setVisible(false);

		me.title = 'Изменения в Карты ВФК';
		me.Grid.on('beforeselect', function (th, rec) {
			me.objs.tbarBtns.delete?.setDisabled(me.approvedStatuses.indexOf(rec.data.S_STATUS) !== -1);
		});
		return items;
	},	

	createTBar: function() {
		var me = this,
			objs = me.objs;

		me.callParent(arguments);
		var tbar = objs.tbar,
			tbarBtns = objs.tbarBtns;

		let i = tbar.indexOf(tbarBtns.new);
		if (i >= 0) tbar.splice(i, 1);
		i = tbar.indexOf(tbarBtns.same);
		i >= 0 && tbar.splice(i, 1);

		return tbar;
	},

	/** Revizor.PlanCentral.TreeEdit.TreeEdit
	 */
	modTreeEdit:function(){
		this.modTreeEditDel(true);
	},
	
	modTreeEditDel: function (editOrDel) {
		var me = this;
			//dtValue = me.gksc('DT').getValue();
		ajaxRequest({
			url: 'SRecordMod/ModTreeEditDelete_A',
			success: function (res) {
				if (res.errMsg) {
					showError(res.errMsg);
				} else {
					var isSelect = false,
						wa = res.whereArgs;

					dictFunc({
							parentView: tabView,
							mode: 'SINGL',
							code: dnl.IFC_RECORD,
							title: "Карты ВФК",
							whereArgs: wa,
							hideFilterPnl: true,
							canBold: true,
							readOnlyPlanInfo: true,
							btnsHide: { status: true, new: true, same: true, edit: true, delete: true, settings: true, autofilter: true },
							setWhereArgs: function () { return wa; },
							checkRenderer: function (val, meta, rec) {
								if (me.approvedStatuses.indexOf(rec.data.S_STATUS) === -1) {
									meta.tdCls += ' ' + this.disabledCls;
								}
							},
							canCheck: function(rec, v) {
								return me.approvedStatuses.indexOf(rec.data.S_STATUS) !== -1;
							},
							checkListeners: {
								beforecheckchange: function (th, inx, check, rec) {
									return me.approvedStatuses.indexOf(rec.data.S_STATUS) !== -1;
								}
							},
						
						},
						{
							ok: function (value) {
								if (value.length) {
									isSelect = true;
									var selLinks = [];
									Ext.each(value, function(rec) {
										if (me.approvedStatuses.indexOf(rec.data.S_STATUS) !== -1) selLinks.push(rec.data.LINK)
									});
									me.showLoadMask({
										msg: wmc.getMask('RecordModAddChanges'),
										rid: ajaxRequest({
											url: 'SRecordMod/' +
												'RecordModEditDelete_A',
											params: {
												recordLinks: JSON.stringify(selLinks),
												editOrDel: editOrDel
											},
											success: function(res) {
												me.hideLoadMask();
												if (res) {
													me.refresh(true, 1);
												} else {
													showError(wmc.get('RecordModAddChangesError'));
												}
											}
										})
									});
								}
							},
						});
				}
			}
		});
	}
});