﻿Ext.define('Keysystems.Record.Edit', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Edit'],
	title: 'Карты ВФК',
	linkCode: 'SRecord',
	isWindow: true,
	flex: 1,
	scrollable: true,
	autoRender: true,
	bodyPadding: 0,
	border: 0,
	layout: { type: 'vbox', align: 'stretch' },
	respPersLink: -100,
	inspLink: -100,
	actionLink: -100,
	height: 600,
	hidePrintBtn: false,
	autoheightrowsCls: 'ks-autoheightrows',
	profileListeners: [{ name: 'view', method: 'FormParam' }],
	viewMinSize: [700, 600],
	minHeight: 600,
	userCls: 'rks-panel-edit',
	bodyCls: 'rks-panel-edit-body',
	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},

	initComponent: function() {
		var me = this;

		if (me.whereArgs && me.whereArgs.Modification) {
			me.modification = me.whereArgs.Modification.value === 'True';
		}

		me.linkCode = me.modification ? 'SRecordMod' : 'SRecord';
		me.title = me.modification ? 'Изменения в Карты ВФК' : 'Карты ВФК';

		me.beforeInitComponent();

		me.bbar = [
			me.sksc('S_STATUS', Ext.create('Keysystems.Controls.ComboBoxExtra', {
				fieldLabel: 'Статус',
				editable: false,
				queryMode: 'local',
				value: 0,
				labelWidth: 50,
				padding: 5,
				displayField: CBDataLib.displayField,
				valueField: CBDataLib.valueField,
				listeners: {
					change: function(th, newValue) {
						if (me.gksd('readOnlyStatuses').indexOf(newValue) !== -1) {
							me.sksd('isClosedByStatus', true);
						}
					}
				},
				setKsReadOnly: function() {
					var res = this.callParent(arguments);
					this.setDisabled(this.store.count() < 2);
					return res;

				},
				store: Ext.create('Ext.data.Store', {
					fields: CBDataLib.getFields(),
					data: [],
					proxy: 'memory'
				})
			}))
		];

		me.baseInitComponent();
		me.callParent(arguments);
        me.afterInitComponent();
	},

	createItems: function() {
		var me = this;

		return [
			Ext.create('Ext.form.FieldContainer', {
				layout: { type: 'vbox', align: 'stretch' },
				padding: '10 10 0 10',
				items: [
					me.sksc('planModInfo', Ext.create('Keysystems.PlanModInfo',	{
						labelWidth: me.labelWidth,
						padding: '0 0 0 0'
					})),
					Ext.create('Ext.form.FieldContainer', {
						layout: 'hbox',
						items: [
							me.sksc('NUMBER', Ext.create('Ext.form.field.Text',	{
								fieldLabel: 'Номер',
								labelWidth: me.labelWidth,
								enforceMaxLength: true,
								width: 155 + me.labelWidth,
								maxLength: 50
							})),
							me.sksc('DATE_AT', Ext.create('Ext.form.field.Date', {
								fieldLabel: 'От',
								padding: '0 0 0 10',
								labelWidth: 20,
								maxWidth: 145
							}))
						]
					}),
					me.sksc('S_ORG', me.createDictEdit({
						key: 'S_ORG',
						flex: 1,
						code: dnl.S_ORG,
						ksAllowEmpty: true,
						fieldLabel: 'Организация',
						beforeclear: function(v) {
							v = v || [];

							var isSame = me.gksc('S_ORG').getLink() === (v[0] && v[0].get('LINK'));

							if (me.gksc('S_ORG').getLink() !== 0 && me.gksc('gridAction').store.getDataExt().length && !isSame)
								me.orgPordrazdelChange(v, true);
							else {
								me.gksc('S_ORG').setValue(v);
								if (!isSame) me.gksc('S_OTDEL').clear();
							}

									me.gksc('ActionDictBtn')
										.setDisabled(!v.length || !me.gksc('S_OTDEL').getValue().length);
							return false;
						},
						handler: function() {
							var whereArgs = {};

							switch (me.gksd('NastrShowIfcRecord')) {
								case 1:
								case 3:
									whereArgs = {
											InLinks: {
												value: JSON.stringify([me.gksd('userOrgLink')]),
												type: 'List_int'
											},
										InLinksOnly: { value: 'True', type: 'bool' }
									};
									break;
								case 2:
									whereArgs = {
										SType: {
												value: JSON.stringify([
													KsLib.getKeyByValue(window.miscTypes.TypeOrg, 'Проверяющая') * 1
												]),
											type: 'List_int'
										},
											InLinks: {
												value: JSON.stringify(me.gksd('userSlaveOrgs')),
												type: 'List_int'
											},
										InLinksOnly: { value: 'True', type: 'bool' }
									};
									break;
							}

							dictFunc({
								mode: 'SINGL',
                                readOnly: me.objs.S_ORG.readOnly,
                                accessReadOnly: me.objs.S_ORG.readOnly,
								selectLinks: me.gksc('S_ORG').getValue(),
								parentView: me.gksc('view', true, true),
								code: dnl.S_ORG,
								whereArgs: whereArgs,
								control: me.objs.S_ORG,
								contextSearch: me.objs.S_ORG.contextSearch
							},
							{
								ok: function(value) {
									me.gksc('S_ORG').beforeclear(value);
							}});
						}
					})),
					me.sksc('S_OTDEL', me.createDictEdit({
						key: 'S_OTDEL',
						flex: 1,
						mode: 'SINGL',
						fieldLabel: 'Подразделение',
						ksAllowEmpty: true,
						beforeclear: function(v) {
							v = v || [];

							if (me.gksc('S_OTDEL').getLink() !== 0 && me.gksc('gridAction').store.getDataExt().length &&
								me.gksc('S_OTDEL').getLink() !== (v[0] && (v[0].LINK || v[0].get('LINK'))))
								me.orgPordrazdelChange(v);
							else {
								me.gksc('S_OTDEL').setValue(v);
							}

							me.gksc('ActionDictBtn').setDisabled(!v.length);
							return false;
						},
						handler: function() {
							var whereArgs = {};
							switch (me.gksd('NastrShowIfcRecord')) {
								case 1:
									case 2:
									{
									whereArgs = {
										SOrgs: {
											value: JSON.stringify([me.gksc('S_ORG').getLink()]),
											type: 'List_int'
										}
									};
									break;
								}
									case 3:
									{
									whereArgs = {
										SOrgs: {
											value: JSON.stringify([me.gksc('S_ORG').getLink()]),
											type: 'List_int'
										},
										InLinks: {
											value: JSON.stringify(me.gksd('userOtdelLinks')),
											type: 'List_int'
										},
										InLinksOnly: { value: 'True', type: 'bool' }
									};
									break;
								}
							}
							dictFunc({
								mode: 'SINGL',
                                readOnly: me.objs.S_OTDEL.readOnly,
                                accessReadOnly: me.objs.S_OTDEL.readOnly,
								selectLinks: me.gksc('S_OTDEL').getValue(),
								code: dnl.S_OTDEL,
								getSOrg: function() {
									return me.gksc('S_ORG').getLink();
								},
								parentView: me.gksc('view', true, true),
								whereArgs: whereArgs,
								control: me.objs.S_OTDEL,
								contextSearch: me.objs.S_OTDEL.contextSearch
							},
							{
								ok: function(value) {
									me.gksc('S_OTDEL').beforeclear(value);
								}
							});
						}
					})),
					me.sksc('DH', Ext.create('Keysystems.Controls.PeriodEdit', {
						labelWidth: me.labelWidth,
						fieldLabel: 'Период действия',
						cfgDh: { width: 100 },
						cfgnbDays: { hidden: true },
						maxWidth: 477,
						listeners: {
							ksChange: function() {
								if (me.isLoaded) return;
								
								var respons = me.gksd('responsibleData'),
									inspectors = me.gksd('inspectorData'),
									responsibleLinks = [],
									inspectorsLinks = [],
									endFunc = function() {
													Ext.each(respons,
														function(resp) {
											responsibleLinks.push(resp.LINK);
										});

													Ext.each(inspectors,
														function(resp) {
											inspectorsLinks.push(resp.LINK);
										});

													if (respons.length)
														me.checkErrorPeriods(responsibleLinks, respons, true);
													if (inspectors.length)
														me.checkErrorPeriods(inspectorsLinks, inspectors);
									};

								if (respons.length || inspectors.length) {
									if (me.isVisible()) {
													selectDialogShow('Изменение периода действия',
														wmc.getQuestion('FillPersonsPeriods'),
														function() {
											me.fillPeriods();
														},
														function() {
											endFunc();
										});
									} else {
										endFunc();
									}
								}
							}
						}
					}))
				]
			}),
			Ext.create('Ext.form.FieldContainer', {
				layout: 'border',
				padding: 0,
				border: 0,
				flex: 1,
				items: [
					me.sksc('gridAction', Ext.create('Keysystems.Controls.GroupingGrid', {
						title: 'Операции',
						padding: 0,
						border: 1,
						tbar: [
							me.sksc('ActionDictBtn', Ext.create('Ext.Button', {
								iconCls: 'x_btn_dict',
								tooltip: 'Выбрать',
								tooltipType: 'title',
								handler: function() {
									var sel = [],
										itms = me.gksc('gridAction').store.getDataExt(),
										len = itms.length,
										i = 0;

									for (; i < len; i++) {
										sel.push({
											data: {
												LINK: itms[i].IFC_ACTION,
												NAME: itms[i].TEMP_ACTION_NAME,
												CODE: itms[i].TEMP_ACTION_CODE,
												IFC_S_PROCEDURE: itms[i].TEMP_IFC_S_PROCEDURE,
												PROCEDURE_NAME: itms[i].TEMP_PROCEDURE_NAME,
												IFC_RECORD: itms[i].IFC_RECORD
											}
										});
									}

									var settings = {
											title: 'Операции',
											mode: 'MULTI',
											parentView: me.gksc('view', true, true),
											selectLinks: sel,
											code: dnl.IFC_ACTION,
											initWhereArgs: function() {
												const dt = me.gksc('DH').getValue();
												const orInLinks = me.gksc('gridAction').store.getLinks('IFC_ACTION');
												return {
													SOrg: {
														value: me.gksc('S_ORG').getLink(),
														type: 'int'
													},
													SOtdel: {
														value: me.gksc('S_OTDEL').getLink(),
														type: 'int'
													},
													RecordActionLinks: { value: 'False', type: 'bool' },
													IsActivated: { value: 'True', type: 'bool' },
													DH1: {
														value: dt.dh1.toDateString(),
														type: 'Date'
													},
													DH2: {
														value: dt.dh2.toDateString(),
														type: 'Date'
													},
													RecordLink: { value: me.getLink(), type: 'int' },
													OrInLinks:	{
														value: JSON.stringify(orInLinks),
														type: 'List_int'
													}
												};
											},
											checkRenderer: function(val, meta, rec) {
												if (rec.data.MODIFICATION === true) {
													meta.tdCls += ' ' + this.disabledCls;
												}
											},
											checkListeners: {
												beforecheckchange: function(th, inx, check, rec) {
													return check || (rec.data.MODIFICATION === false);
												}
											},
											canCheck: function(rec, v) {
												return v || (rec.data.MODIFICATION === false);
											},
										},
										funcs = {
											ok: function(v) {
												var grid = me.gksc('gridAction'),
													storeData = grid.store.getDataExt(),
													outL = storeData.concat(),
													oldLinks = grid.store.getLinks('IFC_ACTION');

												grid.loadData(me.addFictOperationData(me.bindData(
													storeData,
													v,
													outL,
													function(list, d) {
														return ArrayLib.find(list,
															['IFC_ACTION'],
															d.LINK);
													},
													function(data) {
														return {
															LINK: me.actionLink--,
															IFC_ACTION: data.LINK,
															TEMP_ACTION_CODE: data.CODE,
															TEMP_ACTION_NAME: data.NAME,
															TEMP_IFC_S_PROCEDURE: data.IFC_S_PROCEDURE,
															TEMP_PROCEDURE_CODE: data.PROCEDURE_CODE,
															TEMP_PROCEDURE_NAME: data.PROCEDURE_NAME,
															TEMP_IFC_S_PROCESS: data.IFC_S_PROCESS,
															TEMP_PROCESS_CODE: data.PROCESS_CODE,
															TEMP_PROCESS_NAME: data.PROCESS_NAME,
															TEMP_ACTION_DH1: data.TEMP_DH1,
															TEMP_ACTION_DH2: data.TEMP_DH2,
															MODIFICATION: data.MODIFICATION
														};
													}
												)));

												var newRespData = [],
													newInspData = [];

												if (v.length) {
													const newActions = grid.store.getDataExt().filter(r => oldLinks.indexOf(r.IFC_ACTION) === -1);
													//Запрашиваем на сервере автозаполнение операций
													if (newActions.length) {
														me.getAllActions(oldLinks,
															me.gksc('S_ORG').getLink(),
															me.gksc('S_OTDEL').getLink(),
															function (res) {
																//Необходимо перебить линки пришедших записей
																Ext.each(newActions,
																	function (action) {
																		if (action.LINK === 0) return;
																		var actionFromServer = res.action[ArrayLib.find(res.action, ['IFC_ACTION'], action.IFC_ACTION)],
																			newResp = ArrayLib.filter(res.responsible, ['IFC_T_RECORD_ACTION'], actionFromServer.LINK),
																			newInsp = ArrayLib.filter(res.inspector, ['IFC_T_RECORD_ACTION'], actionFromServer.LINK);

																		Ext.each(newResp, function (r) {
																			r.IFC_T_RECORD_ACTION = action.LINK;
																			me.gksd('responsibleData').push(r);
																		});

																		Ext.each(newInsp, function (insp) {
																			insp.IFC_T_RECORD_ACTION = action.LINK;
																			me.gksd('inspectorData').push(insp);
																		});
																	});

																me.gridActionSelector(grid.getFrstSelect());
															});
													}

													//Чистим старые данные для responsibleData и inspectorData
													var oldRespData = me.gksd('responsibleData'),
														oldInspData = me.gksd('inspectorData');

													Ext.each(outL,
														function (action) {
															newRespData = [].concat(ArrayLib.filter(oldRespData,['IFC_T_RECORD_ACTION'], action.LINK), newRespData);
															newInspData =[].concat(ArrayLib.filter(oldInspData,['IFC_T_RECORD_ACTION'], action.LINK), newInspData);
														});
												}

												me.sksd('responsibleData', newRespData);
												me.sksd('inspectorData', newInspData);
												me.gridActionSelector(grid.getFrstSelect());
											}
										};
									dictFunc(settings, funcs);
								}
							})), 
							me.sksc('ActionDelBtn', Ext.create('Ext.Button', {
								iconCls: 'x_btn_delete',
								tooltip: 'Удалить',
								tooltipType: 'title',
								handler: function() {
									var selected = me.gksc('gridAction').getFrstSelect();
									if (selected && selected.data['MODIFICATION'] !== true) {
										me.attentionMsgShow({
											msg: wmc.get('delAction'),
											ok: function() {
												var selectedLink = selected.data['LINK'],
																	remRespPersList =
																		ArrayLib.filter(me.gksd('responsibleData'),
																			['IFC_T_RECORD_ACTION'],
																			selectedLink);

												if (remRespPersList.length) {
																	ArrayLib.removeList(me.gksd('responsibleData'),
																		remRespPersList);

													var remInspList = [];
													for (var i = 0; i < remRespPersList.length; i++) {
																		var tmp = ArrayLib.filter(
																			me.gksd('inspectorData'),
																			['IFC_RECORD_ACTION_RESP_PERS'],
																			remRespPersList[i]['LINK']);
														for (var j = 0; j < tmp.length; j++) {
															remInspList.push(tmp[j]);
														}
													}

													if (remInspList.length) {
																		ArrayLib.removeList(me.gksd('inspectorData'),
																			remInspList);
													}
												}

												if (selected.data['LINK'] === 0){
													me.gksc('gridAction').store.removeAll();
												}
												else {
													me.gksc('gridAction').store.remove(selected);
													// Удаление фиктивной записи
													if (me.gksc('gridAction').store.getDataExt().length === 1){
														me.gksc('gridAction').store.remove(me.gksc('gridAction').getStore().data.items.filter(function(d) {
															return d.get('LINK') === 0;
														}));
													}
												}
												me.gridActionSelector(me.gksc('gridAction').getFrstSelect());
											},
											cancel: function() {
											}
										});
									}
								}
							})),
							me.sksc('ActionFillBtn', Ext.create('Ext.Button', {
								iconCls: 'x_btn_fill',
								tooltip: 'Заполнить автоматически',
								tooltipType: 'title',
								disabled: false,
								handler: function() {
									me.getAllActions(me.gksc('gridAction').store.getLinks('IFC_ACTION'),
										me.gksc('S_ORG').getLink(),
										me.gksc('S_OTDEL').getLink(),
										function(res) {
											me.sksd('responsibleData',
												me.gksd('responsibleData').concat(res.responsible));
											me.sksd('inspectorData',
												me.gksd('inspectorData').concat(res.inspector));
									me.gksc('gridAction').loadData(me.addFictOperationData(res.action), true);
									});
								}
							})),
							me.sksc('ActionTreeViewBtn', Ext.create('Ext.Button', {
								iconCls: 'x_btn_tree',
								tooltip: 'Иерархическое представление',
								tooltipType: 'title',
								enableToggle: true,
								pressed: true,
								handler: function() {
									var grid = me.gksc("gridAction");
									var feature = grid.features[0];
									var indx = me.getColumnIndex(grid, 'TEMP_PROCEDURE_NAME');

									if (feature.disabled) {
										feature.enable();
														if (indx !== -1)
															grid.columnManager.columns[indx].setVisible(false);
										me.gksc("ActionCollapseBtn").enable();
										me.gksc("ActionDictExpand").enable();
									} else {
										feature.disable();
														if (indx !== -1)
															grid.columnManager.columns[indx].setVisible(true);
										me.gksc('ActionCollapseBtn').disable();
										me.gksc('ActionDictExpand').disable();
									}
									me.gksc("gridAction").reconfigure();
								}
							})),
							me.sksc('ActionCollapseBtn', Ext.create('Ext.Button', {
								iconCls: 'x_btn_treeexpand',
								tooltip: 'Развернуть все узлы',
								tooltipType: 'title',
								handler: function() {
									var feature = me.gksc("gridAction").view.features[0];
									//me.gksc("gridAction").selModel.deselectAll();
									feature.expandAll();
								}
							})),
							me.sksc('ActionDictExpand',	Ext.create('Ext.Button', {
								iconCls: 'x_btn_treecollapse',
								tooltip: 'Свернуть все узлы',
								tooltipType: 'title',
								handler: function() {
									var feature = me.gksc("gridAction").view.features[0];
									//me.gksc("gridAction").selModel.deselectAll();
									feature.collapseAll();
								}
							})),
							me.sksc('ActionWarp', Ext.create('Ext.Button', {
								iconCls: 'x_btn_wrap',
								tooltip: wmc.get('Wrap'),
								tooltipType: 'title',
								handler: function() {
									me.warpHandler(me.gksc('gridAction'), me.gksc('ActionWarp'));
								}
							})),
							me.sksc('ActionCalcBtn', Ext.create('Ext.Button', {
								iconCls: 'x_btn_calcauto',
								tooltip: wmc.get('FillPersonsPeriods'),
								tooltipType: 'title',
								handler: function() {
									var respons = me.gksd('responsibleData'),
										inspectors = me.gksd('inspectorData');

									if (respons.length || inspectors.length)
														selectDialogShow(KS.L10n.attention,
															wmc.getQuestion('FillPersonsPeriods'),
															function() {
											me.fillPeriods();
															},
															Ext.emptyFn);
								}
							}))
						], 
						features: [
							{
								ftype: 'summary',
								showSummaryRow: false
							}
						],
						data: [],
						minWidth: 250,
						minHeight: 150,
						autoScroll: true,
						autoRender: true,
						flex: 1,
						region: 'west',
						split: true,
						groupField: 'TEMP_PROCEDURE_NAME',
						columns: [],
						listeners: {
							select: function(th, rec) {
								me.gridActionSelector(rec);
							}
						},
                        viewConfig: {
                            getRowClass: function (record) {
                                return record.data.WRNNG
                                    ? 'colorize-row-byOverdue'
                                    : '';
                            }
                        }

					})),
					me.sksc('gridRespPers',	Ext.create('Ext.grid.Panel', {
						title: 'Ответственные лица',
						padding: 0,
						tbar: [
									me.sksc('RespPersAddBtn',
										Ext.create('Ext.Button',
											{
								iconCls: 'x_btn_new',
								tooltip: 'Добавить',
								tooltipType: 'title',
								handler: function() {
									var sel = me.gksc('gridAction').getFrstSelect();
									if (sel && sel.data.LINK) me.gridRespPersAdd(sel);
								}
							})),
									me.sksc('RespPersCopyBtn',
										Ext.create('Ext.Button',
											{
								iconCls: 'x_btn_copy',
								tooltip: 'Создать подобную',
								tooltipType: 'title',
								handler: function() {
									var actionSel = me.gksc('gridAction').getFrstSelect(),
										respPersSel = me.gksc('gridRespPers').getFrstSelect();

									if (respPersSel) me.gridRespPersAdd(actionSel, respPersSel.data);
								}
							})),
									me.sksc('RespPersDelBtn',
										Ext.create('Ext.Button',
											{
								iconCls: 'x_btn_delete',
								tooltip: 'Удалить',
								tooltipType: 'title',
								handler: function() {
									var selected = me.gksc('gridRespPers').getFrstSelect();

									if (selected) {
										me.attentionMsgShow({
															msg:
																'Удаление ответственного лица приведёт к удалению данных в таблицах "Контролирующие"!',
											ok: function() {
																ArrayLib.removeList(me.gksd('responsibleData'),
																	selected.data);
																ArrayLib.removeList(me.gksd('inspectorData'),
																	ArrayLib.filter(me.gksd('inspectorData'),
																		['IFC_RECORD_ACTION_RESP_PERS'],
																		selected.get('LINK')));

																me.gridActionSelector(me.gksc('gridAction')
																	.getFrstSelect());
											},
											cancel: function() {
											}
										});
									}
								}
							})),
									me.sksc('RespPersWarp',
										Ext.create('Ext.Button',
											{
								iconCls: 'x_btn_wrap',
								tooltip: wmc.get('Wrap'),
								tooltipType: 'title',
								handler: function() {
									me.warpHandler(me.gksc('gridRespPers'), me.gksc('RespPersWarp'));
								}
							}))
						],
						features: [
									{
										ftype: 'summary',
										showSummaryRow: false
									}
								],
						minWidth: 250,
						minHeight: 150,
						autoScroll: true,
						autoRender: true,
						flex: 1,
						region: 'center',
						split: true,
						store: Ext.create('Ext.data.Store',
						{
							fields: [],
							data: [],
							proxy: 'memory'
						}),
						plugins: [
							Ext.create('Ext.grid.plugin.CellEditing',
								{
									clicksToEdit: 1,
									//isDhSwap: true,
									listeners: {
										ksAfteredit: function (editor, e) {
											if (e.grid.editingPlugin.editing) return;

											if (e.value !== null) {
												if (Ext.isDate(e.value) &&
													Ext.Date.isEqual(e.originalValue, e.value) &&
													!e.ksDhSwaped) return;

												var recLink = e.record.get('LINK'),
													oldData = me.gksd('responsibleData'),
													i = ArrayLib.find(oldData, ['LINK'], recLink);

												if (i !== -1) {
													oldData[i] = e.record.data;

													if (e.field === 'DH1' || e.field === 'DH2') {
														me.checkErrorPeriods([recLink], oldData, true);
													}
												}
											}
										}
									}
								}),
							'gridclipboard'
						],
						columns: [],
						columnLines: true,
						listeners: {
							select: function(th, rec) {
								me.gridRespSelector(rec);
							},
							afterRender: function() {
								var selectedLink = me.gksc('gridAction').getFrstSelect();
								if (selectedLink)
											me.gksc('gridRespPers').loadData(ArrayLib.filter(me.gksd('responsibleData'),
												['IFC_T_RECORD_ACTION'],
												selectedLink.get('LINK')));
							}
                        },
                        viewConfig: {
							getRowClass: function (record) {
                                return record.data.S_PERSON == 0 || record.data.WRNNG
                                    ? 'colorize-row-byOverdue'
                                    : '';
                            }
                        }
					})),
					me.sksc('gridInspector', Ext.create('Ext.grid.Panel', {
						title: 'Контролирующие',
						padding: 0,
						tbar: [
							me.sksc('InspectorAddBtn',
								Ext.create('Ext.Button',
									{
								iconCls: 'x_btn_new',
								tooltip: 'Добавить',
								tooltipType: 'title',
								handler: function() {
									var grid = me.gksc('gridInspector'),
                                        selAction = me.gksc('gridAction').getFrstSelect(),
										selResp = me.gksc('gridRespPers').getFrstSelect();
                                    var ord = grid.store.getMaxOrd() + 1;
											if (selAction)
												me.gridInspAdd(selAction, selResp, ord);
								}
							})),
							me.sksc('InspectorCopyBtn',
								Ext.create('Ext.Button',
									{
								iconCls: 'x_btn_copy',
								tooltip: 'Создать подобную',
								tooltipType: 'title',
								handler: function() {
									var grid = me.gksc('gridInspector'),
                                        selInsp = me.gksc('gridInspector').getFrstSelect(),
										selAction = me.gksc('gridAction').getFrstSelect(),
										selResp = me.gksc('gridRespPers').getFrstSelect();
                                    var ord = grid.store.getMaxOrd() + 1;
											if (selInsp && selAction)
												me.gridInspAdd(selAction,
													selResp,
													ord,
													selInsp.data);
								}
							})),
							me.sksc('InspectorDelBtn',
								Ext.create('Ext.Button',
									{
								iconCls: 'x_btn_delete',
								tooltip: 'Удалить',
								tooltipType: 'title',
								handler: function() {
									var selected = me.gksc('gridInspector').getFrstSelect();

									if (selected) {
										me.attentionMsgShow({
											msg: wmc.get('DeleteMessage'),
											ok: function() {
												ArrayLib.removeList(me.gksd('inspectorData'), selected.data);
												me.gridRespSelector(me.gksc('gridRespPers').getFrstSelect());
												me.gksc('gridAction').view.refresh();
											},
											cancel: function() {
											}
										});
									}
								}
							})),
							me.sksc('InspectorTopBtn',
								Ext.create('Ext.Button',
									{
								iconCls: 'x_btn_top',
								tooltip: 'В начало',
								tooltipType: 'title',
								handler: function() {
											me.moveRec(_, 1);
								}
							})),
							me.sksc('InspectorUpBtn',
								Ext.create('Ext.Button',
									{
								iconCls: 'x_btn_up',
								tooltip: 'Вверх',
								tooltipType: 'title',
								handler: function() {
											me.moveRec(-1);
								}
							})),
							me.sksc('InspectorDownBtn',
								Ext.create('Ext.Button',
									{
								iconCls: 'x_btn_down',
								tooltip: 'Вниз',
								tooltipType: 'title',
								handler: function() {
											me.moveRec(1);
								}
							})),
							me.sksc('InspectorBottomBtn',
								Ext.create('Ext.Button',
									{
								iconCls: 'x_btn_bottom',
								tooltip: 'В конец',
								tooltipType: 'title',
								handler: function() {
											me.moveRec(_, me.gksc('gridInspector').store.count());
										}
							})),
							me.sksc('InspectorWarp',
								Ext.create('Ext.Button',
									{
								iconCls: 'x_btn_wrap',
								tooltip: wmc.get('Wrap'),
								tooltipType: 'title',
								handler: function() {
									me.warpHandler(me.gksc('gridInspector'), me.gksc('InspectorWarp'));
								}
							}))
						],
						features: [
							{
								ftype: 'summary',
								showSummaryRow: false
							}
						],
						minHeight: 150,
						autoScroll: true,
						autoRender: true,
						flex: 1,
						region: 'south',
						border: 0,
						split: true,
						store: Ext.create('Ext.data.Store',
							{
							fields: [],
							data: [],
							proxy: 'memory',
								getMaxOrd: function() {
                                var max = 0;
									this.each(function(rec) {
                                    var o = rec.get('ORD');
                                    if (o > max) max = o;
                                });
                                return max;
                            }
						}),
						plugins: [
							Ext.create('Ext.grid.plugin.CellEditing',
								{
								clicksToEdit: 1,
								//isDhSwap: true,
								listeners: {
									ksAfteredit: function(editor, e) {
										if (e.grid.editingPlugin.editing) return;

										if (e.value !== null) {
												if (Ext.isDate(e.value) &&
													Ext.Date.isEqual(e.originalValue, e.value) &&
													!e.ksDhSwaped) return;

											var recLink = e.record.get('LINK'),
												oldData = me.gksd('inspectorData'),
												i = ArrayLib.find(oldData, ['LINK'], recLink);

											if (i !== -1) {
												oldData[i] = e.record.data;

												if (e.field === 'DH1' || e.field === 'DH2') {
													me.checkErrorPeriods([recLink], oldData, false);
												}
											}
										}
									}
								}
							}),
							'gridclipboard'
						],
						columns: [],
						columnLines: true,
						listeners: {
							select: function (th, rec) {
								me.gridInspectorSelector(rec);
							}
						},
                        viewConfig: {
                            getRowClass: function (record) {
                                return record.data.S_PERSON == 0 ||
                                    record.data.IFC_S_CMETHOD == 0 ||
                                    record.data.IFC_S_CACTION == 0 ||
                                    record.data.IFC_S_CTYPE == 0 ||
                                    record.data.IFC_S_CMODE == 0 ||
									record.data.IFC_RECORD_ACTION_RESP_PERS == 0 ||
                                    record.data.WRNNG
                                    ? 'colorize-row-byOverdue'
                                    : '';
                            }
                        }
					}))
				]
			})
		];
	},

	//#region Загрузка данных 
	getExtra: function(callBack, link) {
		var me = this,
			i = 0,
			defaultRenderer = function (v, meta, rec) {
				return rec.get(this.dataIndex);
			};

		me.baseGetExtra({ link: link }, function(value) {
			me.sksd('NastrShowIfcRecord', value.nastr);
			me.sksd('userOrgLink', value.S_ORG[0].LINK);

			let otdelLinks=[];
			user.otdels.forEach((item)=>{otdelLinks.push(item.LINK)});
			me.sksd('userOtdelLinks', otdelLinks);
			
			me.sksd('userSlaveOrgs', value.userSlaveOrgs);
			me.sksd('dolgsDir', value.dolgsDir);

			me.gksc('NUMBER').setValue(value.NUMBER);
			me.gksc('DATE_AT').setValue(value.DATE_AT);

			me.gksc('S_ORG').setValue(value.S_ORG);
			me.gksc('S_OTDEL').setValue(value.S_OTDEL);
			me.sksd('subOtdels', value.subOtdels);

			me.sksd('responsibleData', value.responsible.data);
			me.sksd('inspectorData', value.inspector.data);
			me.sksd('inData', value.inData);

			me.sksd('readOnlyStatuses', value.readOnlyStatuses);
			me.sksd('isClosedByStatus', value.isClosedByStatus);
			if (value.isClosedByStatus) me.setReadOnly(true);
			me.sksd('MODIFICATION', value.row['MODIFICATION']);
			me.gksc('S_STATUS').store.loadData(CBDataLib.get(_, value.status === null, value.sStatus), false);
			me.gksc('S_STATUS').setValue(value.status);

			if (value.planModInfo) {
				me.gksc('planModInfo').setValue(value.planModInfo);
				me.planModInfoReadOnly = value.planModInfo.planModInfoReadOnly;
			}
			if (!value.row['MODIFICATION']) {
				me.gksc('planModInfo').setVisible(false)
			}

			me.setObjsAccess(value.access, ['planModInfo']);
			
			if (me.modification || value.row['MODIFICATION']) {
				Ext.each(['NUMBER', 'DATE_AT', 'S_ORG', 'S_OTDEL', 'DH'], function (name) {
					me.gksc(name).setReadOnly(true);
				})
			}

			Ext.each(value.inspector.columns, function(el) {
				switch (el.dataIndex) {
					case 'TEMP_CMETHOD': {
						el.hidden = false;
						el.xtype = 'dictcolumn';
						el.code = dnl.IFC_S_CMETHOD;
						el.ignoreCodeField = false;
						el.cleaningKey = false;
						el.controlName = 'inspIfcMethod';
						el.defaultRenderer = defaultRenderer;
						el.ksGetValue = function(rec) {
							let th = this,
								o = {};
							o[th.fieldLink] = rec.get('IFC_S_CMETHOD');
							o[th.fieldName] = rec.get(th.dataIndex);
							return [o];
						};
						el.ksSetValue = function(val, rec) {
							let th = this,
								d = val[0];

							d = d ? d.data || d : _;

							let link = d && d[th.fieldLink] || 0,
								code = d && d[th.fieldCode] || '',
								name = window.getTextByVisibleFields(th.code || th.Code, th.visibleFields, d, th.fieldName);

							rec.beginEdit();
							rec.set(th.dataIndex, code + '. ' + name);
							rec.set('IFC_S_CMETHOD', link);
							rec.endEdit();
						};
						
						break;
					}
					case 'TEMP_CACTION': {
						el.hidden = false;
						el.xtype = 'dictcolumn';
						el.code = dnl.IFC_S_CACTION;
						el.ignoreCodeField = false;
						el.cleaningKey = false;
						el.controlName = 'inspIfcAction';
						el.defaultRenderer = defaultRenderer;
						el.ksGetValue = function(rec) {
							let th = this,
								o = {};
							o[th.fieldLink] = rec.get('IFC_S_CACTION');
							o[th.fieldName] = rec.get(th.dataIndex);
							return [o];
						};
						el.ksSetValue = function(val, rec) {
							let th = this,
								d = val[0];

							d = d ? d.data || d : _;

							let link = d && d[th.fieldLink] || 0,
								code = d && d[th.fieldCode] || '',
								name = window.getTextByVisibleFields(th.code || th.Code, th.visibleFields, d, th.fieldName);

							rec.beginEdit();
							rec.set(th.dataIndex, code + '. ' + name);
							rec.set('IFC_S_CACTION', link);
							rec.endEdit();
						};
						
						break;
					}
					case 'TEMP_CTYPE': {
						el.hidden = false;
						el.xtype = 'dictcolumn';
						el.code = dnl.IFC_S_CTYPE;
						el.ignoreCodeField = false;
						el.cleaningKey = false;
						el.controlName = 'inspIfcType';
						el.defaultRenderer = defaultRenderer;
						el.ksGetValue = function(rec) {
							let th = this,
								o = {};
							o[th.fieldLink] = rec.get('IFC_S_CTYPE');
							o[th.fieldName] = rec.get(th.dataIndex);
							return [o];
						};
						el.ksSetValue = function(val, rec) {
							let th = this,
								d = val[0];

							d = d ? d.data || d : _;

							let link = d && d[th.fieldLink] || 0,
								code = d && d[th.fieldCode] || '',
								name = window.getTextByVisibleFields(th.code || th.Code, th.visibleFields, d, th.fieldName);

							rec.beginEdit();
							rec.set(th.dataIndex, code + '. ' + name);
							rec.set('IFC_S_CTYPE', link);
							rec.endEdit();
						};
						
						break;
					}
					case 'TEMP_CMODE': {
						el.hidden = false;
						el.xtype = 'dictcolumn';
						el.code = dnl.IFC_S_CMODE;
						el.ignoreCodeField = false;
						el.cleaningKey = false;
						el.controlName = 'inspIfcMode';
						el.defaultRenderer = defaultRenderer;
						el.ksGetValue = function(rec) {
							let th = this,
								o = {};
							o[th.fieldLink] = rec.get('IFC_S_CMODE');
							o[th.fieldName] = rec.get(th.dataIndex);
							return [o];
						};
						el.ksSetValue = function(val, rec) {
							let th = this,
								d = val[0];

							d = d ? d.data || d : _;

							let link = d && d[th.fieldLink] || 0,
								code = d && d[th.fieldCode] || '',
								name = window.getTextByVisibleFields(th.code || th.Code, th.visibleFields, d, th.fieldName);

							rec.beginEdit();
							rec.set(th.dataIndex, code + '. ' + name);
							rec.set('IFC_S_CMODE', link);
							rec.endEdit();
						};
						
						break;
					}
					case 'INSPECTION_RUN_FREQUENCY': {
						el.editor = {
							xtype: 'textfield',
							enforceMaxLength: true,
							maxLength: 499
						};
						break;
					}
					case 'DH1':
					case 'DH2':	{
						el.editor = {
							xtype: 'datefield',
							allowBlank: false,
							maxValue: '31.12.2100',
							minValue: '01.01.1900'
						};
						el.xtype = 'datecolumn';
						el.format = 'd.m.Y';
						break;
					}
					case 'TEMP_SPERSON_FIO': {
						el.hidden = false;
						el.xtype = 'dictcolumn';
						el.code = dnl.S_PERSON;
						el.ignoreCodeField = true;
						el.cleaningKey = false;
						el.controlName = 'inspSPersonRec';
						el.defaultRenderer = defaultRenderer;
						el.ksGetValue = function(rec) {
							let th = this,
								o = {};
							o[th.fieldLink] = rec.get('S_PERSON');
							o[th.fieldName] = rec.get(th.dataIndex);
							return [o];
						};
						el.ksSetValue = function(val, rec) {
							let th = this,
								inspData = me.gksd('inspectorData'),
								sPersLink = 0,
								d = val[0];
							
							d = d ? d.data || d : _;

							let link = d && d[th.fieldLink] || 0,
								code = d && d[th.fieldCode] || '',
								name = window.getTextByVisibleFields(th.code || th.Code, th.visibleFields, d, th.fieldName);
							
							rec.beginEdit();
							rec.set(th.dataIndex, code + '. ' + name);
							rec.set('S_PERSON', link);
							rec.endEdit();

							if (val.length) {
								var pos = ArrayLib.find(inspData, ['LINK'], rec.get('LINK'));
								if (pos !== -1) {
									val = val[0];

									if (val.data) {
										inspData[pos].S_PERSON = sPersLink = val.get('LINK');
										inspData[pos].TEMP_SPERSON_FIO = `${val.data[th.fieldCode]}. ${window.getTextByVisibleFields(th.code || th.Code, th.visibleFields, val.data, th.fieldName)}`;

										me.getPersonsIn([sPersLink], function(inData) {
											me.gksd('inData')[sPersLink] = inData[sPersLink];
											me.checkErrorPeriods([inspData[pos].LINK], [inspData[pos]]);
										});
									}
								}
							}
						};
						el.initWhereArgs = function() {
							var grid = me.gksc('gridInspector'),
								sel = grid && grid.getFrstSelect(),
								dh = me.gksc('DH').getValue(),
								whereArgs = {
									SOrgs: {
										value: JSON.stringify([me.gksc('S_ORG').getLink()]),
										type: 'List_int'
									},
									DH1: {
										value: dh.dh1,
										type: 'Date'
									},
									DH2: {
										value: dh.dh2,
										type: 'Date'
									}
								};

							//На случай если захотят вернуть самоконтроль
							//if (sel && sel.get('IFC_S_CMETHOD') === 3) {
							//  var pers = ArrayLib.filter(me.gksd('responsibleData'), ['LINK'], sel.get('IFC_RECORD_ACTION_RESP_PERS'))[0];

							//  if (pers) {
							//      whereArgs.InLinks = { value: JSON.stringify([pers.S_PERSON]), type: 'List_int' };
							//      whereArgs.InLinksOnly = { value: 'True', type: 'bool' };
							//  }

							//}

							return whereArgs;
						};
						el.closeFn = function() {
							var gridInsp = me.gksc('gridInspector'),
								inspSel = gridInsp.getFrstSelect();

							if (!inspSel) return _;
							//Находим все данные где есть этот сотрудник и актуализируем их
							var persLink = inspSel.get('S_PERSON'),
								resp = ArrayLib.filter(me.gksd('responsibleData'), ['S_PERSON'], persLink),
								insp = ArrayLib.filter(me.gksd('inspectorData'), ['S_PERSON'], persLink);

							me.getPersonsIn([persLink], function(inData) {
								me.gksd('inData')[persLink] = inData[persLink];
								//Для контролирующих
								me.checkErrorPeriods(ArrayLib.getLinks(insp), insp);
								//Для ответственных
								me.checkErrorPeriods(ArrayLib.getLinks(resp), resp, true);
							});
						};
						break;
					}
					case 'ORD': {
						el.hidden = false;
						el.sortable = false;
						el.xtype = 'actionimg';
						el.iconCls = 'x_btn_user';
						el.maxWidth = 100;
						el.width = 100;
						el.text = '';
						el.cellCond = function(rec) {
							return (rec && rec.data.IFC_RECORD_ACTION_RESP_PERS) ? true : false;
						};
						el.renderer = function(val, meta, rec) {
							meta.tdCls = (rec && rec.data.IFC_RECORD_ACTION_RESP_PERS) ? 'ks-greenyellow' : '';
						};
						el.imgHandler = function(grid, rec) {
							if (me.readOnly) return;
							var respLink = rec.data.IFC_RECORD_ACTION_RESP_PERS,
								sel = me.gksc('gridRespPers').getFrstSelect();

							if (sel) {
								Ext.Msg.show({
									title: KS.L10n.attention,
									msg: 'Вы действительно хотите ' + (respLink ? 'отвязать' : 'привязать') + ' Ответственное лицо ' + (respLink ? 'от' : 'к') + ' Контролирующ' + (respLink ? 'его' : 'ему') + '?',
									buttons: Ext.MessageBox.OKCANCEL,
									fn: function(buttonId) {
										if (buttonId === 'ok') {
											var recIndx = ArrayLib.find(me.gksd('inspectorData'), ['LINK'], rec.data.LINK);

											me.gksd('inspectorData')[recIndx].IFC_RECORD_ACTION_RESP_PERS = rec.data.IFC_RECORD_ACTION_RESP_PERS = respLink ? null : sel.get('LINK');
											me.gksd('inspectorData')[recIndx].ORD = rec.data.ORD = respLink ? null : 1;
											me.gridRespSelector(sel);
										}
									},
									icon: Ext.MessageBox.QUESTION
								});
							}
						};
						break;
					}
					case 'WRNNG': {
						el.sortable = false;
						el.text = '';
						el.xtype = 'actionimg';
						el.iconCls = 'x_btn_warning';
						el.maxWidth = 50;
						el.renderer = function(val, meta, rec) {
							meta.tdAttr += val ? ' title="' + rec.data.INVALID_DATE_TEXT + '"' : '';
						};
						el.cellCond = function(rec) {
							return (rec && rec.data.WRNNG) ? true : false;
						};
						break;
					}
				}
			});

			me.gksc('gridInspector').setMetaDate(value.inspector, {
				profileCode: me.code,
				profileKey: 'gridInspector',
				gateCode: me.keyEdit
			});

			Ext.each(value.responsible.columns, function(el) {
				switch (el.dataIndex) {
					case 'TEMP_SPERSON_FIO': {
						el.xtype = 'dictcolumn';
						el.flex = 1;
						el.hidden = false;
						el.code = dnl.S_PERSON;
						el.ignoreCodeField = true;
						el.cleaningKey = false;
						el.controlName = 'respSPersonRec';
						el.defaultRenderer = defaultRenderer;
						el.ksGetValue = function(rec) {
							let th = this,
								o = {};
							o[th.fieldLink] = rec.get('S_PERSON');
							o[th.fieldName] = rec.get(th.dataIndex);
							return [o];
						};
						el.ksSetValue = function(val, rec) {
							const th = this;
							const respData = me.gksd('responsibleData');
							const pos = ArrayLib.find(respData, ['LINK'], rec.get('LINK'));
							const respRow = pos !== -1 ? respData[pos] : null;
							const data = val.length ? val[0].data ?? val[0] : null;
							
							let sPersLink = 0;
							let visibleValue = null;
							if (val.length) {
								sPersLink = data[th.fieldLink];
								visibleValue = `${data[th.fieldCode]}. ${window.getTextByVisibleFields(th.code || th.Code, th.visibleFields, data, th.fieldName)}`;
								
								if (respRow) {
									me.getPersonsIn([sPersLink], function (inData) {
										me.gksd('inData')[sPersLink] = inData[sPersLink];
										me.checkErrorPeriods([respData[pos].LINK], [respData[pos]], true);
									});
								}
							}
							rec.beginEdit();
							rec.set(th.dataIndex, visibleValue);
							rec.set('S_PERSON', sPersLink);
							rec.endEdit();
							
							if (respRow){
								respRow.S_PERSON = sPersLink;
								respRow.TEMP_SPERSON_FIO = visibleValue;
							}
						};
						el.initWhereArgs = function() {
							var dh = me.gksc('DH').getValue();

							return {
								SOrgs: {
									value: JSON.stringify([me.gksc('S_ORG').getLink()]),
									type: 'List_int'
								},
								SOtdel: {
									value: JSON.stringify([me.gksc('S_OTDEL').getLink()]),
									type: 'List_int'
								},
								DH1: {
									value: dh.dh1,
									type: 'Date'
								},
								DH2: {
									value: dh.dh2,
									type: 'Date'
								}
							};
						};
						el.closeFn = function() {
							var gridResp = me.gksc('gridRespPers'),
								respSel = gridResp.getFrstSelect();

							if (!respSel) return _;

							//Находим все данные где есть этот сотрудник и актуализируем их
							var persLink = respSel.get('S_PERSON'),
								resp = ArrayLib.filter(me.gksd('responsibleData'), ['S_PERSON'], persLink),
								insp = ArrayLib.filter(me.gksd('inspectorData'), ['S_PERSON'], persLink);

							me.getPersonsIn([persLink], function(inData) {
								me.gksd('inData')[persLink] = inData[persLink];
								//Для контролирующих
								me.checkErrorPeriods(ArrayLib.getLinks(insp), insp);
								//Для ответственных
								me.checkErrorPeriods(ArrayLib.getLinks(resp), resp, true);
							});
						};
						break;
					}
					case 'ACTION_RUN_FREQUENCY': {
						el.editor = {
							xtype: 'textfield',
							enforceMaxLength: true,
							maxLength: 499
						};
						break;
					}
					case 'DH1':
					case 'DH2': {
						el.editor = {
							xtype: 'datefield',
							allowBlank: false,
							maxValue: '31.12.2100',
							minValue: '01.01.1900',
							isSwap: true
						};
						el.xtype = 'datecolumn';
						el.format = 'd.m.Y';
						break;
					}
					case 'WRNNG': {
						el.sortable = false;
						el.text = '';
						el.xtype = 'actionimg';
						el.iconCls = 'x_btn_warning';
						el.maxWidth = 50;
						el.renderer = function(val, meta, rec) {
							meta.tdAttr += val ? ' title="' + rec.data.INVALID_DATE_TEXT + '"' : '';
						};

        //                el.renderer = function (val, meta, rec) {
        //                    var link = rec.get('LINK'),
        //                        WRNNG = false,
        //                        msg = '',
								//insp = ArrayLib.filter(me.gksd('inspectorData'), ['IFC_RECORD_ACTION_RESP_PERS'], link);

        //                    Ext.each(insp, function (r) {
        //                        if (r.WRNNG) {
        //                            WRNNG = true;
        //                            msg = r.INVALID_DATE_TEXT;
        //                            return false;
        //                        }
        //                    });

        //                    if (rec.get('WRNNG') != WRNNG)
        //                        rec.set('WRNNG', WRNNG);

        //                    meta.tdAttr += ' title="' + msg + '"';
        //                    return !!val;
        //                };

						el.cellCond = function(rec) {
							return (rec && rec.data.WRNNG) ? true : false;
						};
						break;
					}
				}
			});

			me.gksc('gridRespPers').setMetaDate(value.responsible, {
				profileCode: me.code,
				profileKey: 'gridRespPers',
				gateCode: me.keyEdit
			});

			Ext.each(value.action.columns, function(el) {
				switch (el.dataIndex) {
					case 'Операция':
						Ext.each(el.columns, function(col) {
							col.tdCls = 'ks-group-indent';
						});
						break;
					case 'WRNNG': {
						el.sortable = false;
						el.text = '';
						el.xtype = 'actionimg';
						el.iconCls = 'x_btn_warning';
						el.maxWidth = 50;

                        el.renderer = function (val, meta, rec) {
                            meta.tdAttr += val ? ' title="' + rec.data.INVALID_DATE_TEXT + '"' : '';
                        };

      //                  el.renderer = function (val, meta, rec) {
						//	var link = rec.get('LINK'),
						//		WRNNG = false,
						//		msg = '',
						//		resp = ArrayLib.filter(me.gksd('responsibleData'), ['IFC_T_RECORD_ACTION'], link),
						//		insp = ArrayLib.filter(me.gksd('inspectorData'), ['IFC_T_RECORD_ACTION'], link);

						//	Ext.each(resp, function(r) {
						//		if (r.WRNNG) {
						//			WRNNG = true;
						//			msg = r.INVALID_DATE_TEXT;
						//			return false;
						//		}
						//	});

						//	if (!WRNNG)
						//		Ext.each(insp, function(i) {
						//			if (i.WRNNG) {
						//				WRNNG = true;
						//				msg = i.INVALID_DATE_TEXT;
						//				return false;
						//			}
						//		});

						//	if (rec.get('WRNNG') != WRNNG)
      //                          rec.set('WRNNG', WRNNG);
						//	meta.tdAttr += ' title="' + msg + '"';
						//	return !!val;
						//};
						el.cellCond = function(rec) {
							return rec.get('WRNNG');
						};
						break;
					}
					case 'NOTE': {
						el.editor = {
							xtype: 'textfield',
							enforceMaxLength: true,
							maxLength: 1024
						};
						break;
					}

				}
			});

			me.addFictOperationData(value.action.data);
			me.gksc('gridAction').getStore().sort('TEMP_ACTION_CODE', 'ASC');
			const colProcName = value.action.columns.filter(r => r.dataIndex === "TEMP_PROCEDURE_NAME")[0];
			if (colProcName) colProcName.hidden = true;
			me.gksc('gridAction').setMetaDate(value.action, {
				profileCode: me.code,
				profileKey: 'gridAction',
				gateCode: me.keyEdit
			});
			
			me.gksc('DH').setValue(value.DH1, value.DH2);

			//Проверяем периоды
			var respons = me.gksd('responsibleData'),
				inspectors = me.gksd('inspectorData');

			if (respons.length) {
				me.checkErrorPeriods(ArrayLib.getLinks(respons, ['LINK']), respons, true);
			}
			if (inspectors.length) {
				me.checkErrorPeriods(ArrayLib.getLinks(inspectors, ['LINK']), inspectors);
			}
			
			me.checkErrorActions();

			me.sksd('isPrint', value.isPrint);
			let print = me.gksc('printBtn');
			if (value.isPrint) {

				let itms = [],
					mode = KsLib.getKeyByValue(miscTypes.ReportPrintMode, 'Record');

				for (let key in value.reports) {
					itms.push({
						link: key,
						code: value.reports[key].objectCode,
						text: value.reports[key].name,
						sysCode: value.reports[key].code,
						noNeedForm: value.reports[key].noNeedForm,
						mode: mode,
						parentLink: me.objs.link
					});
				}

				print.setMenu(Ext.create('Ext.menu.Menu', {
					items: itms,
					listeners: {
						click: function(menu, item) {
							print.defReport = item.link;
							me.openReport(item);
						}
					}
				}));
			} else {
				print.setVisible(false);
			}
			
			if (callBack) callBack();
		});
	},
	//#endregion Загрузка данных 

	//#region Сохранение данных
	dataCollector: function() {
		var me = this,
			data = me.callParent(arguments),
			dh = me.gksc('DH').getValue();

		data.S_ORG = me.gksc('S_ORG').getLink();
		data.S_OTDEL = me.gksc('S_OTDEL').getLink();
		data.NUMBER = me.gksc('NUMBER').getValue();
		data.DATE_AT = me.gksc('DATE_AT').getValue()?.toDateString();
		data.DH1 = dh.dh1?.toDateString();
		data.DH2 = dh.dh2?.toDateString();

		data.S_STATUS = me.gksc('S_STATUS').getValue();
		data.MODIFICATION = me.gksd('MODIFICATION');
		if (me.modification) {
			var r = me.gksc('planModInfo').dataCollector();
			data.SMOSNOV = r.osnov;
			data.COMMENT = r.comment;
			data.DT_UTV = r.dtUtv?.toDateString() ?? "";
		}

		data.gridAction = me.gksc('gridAction').store.getDataExt(function(d) {
			if (d.LINK === 0) return;

			var respParsed = [],
				allInspParsed = [],
				respList = ArrayLib.filter(me.gksd('responsibleData'), ['IFC_T_RECORD_ACTION'], d.LINK);

			Ext.each(respList, function(r) {
				var inspList = ArrayLib.filter(me.gksd('inspectorData'), ['IFC_RECORD_ACTION_RESP_PERS'], r.LINK),
					inspParsed = [];

				Ext.each(inspList, function(i) {
					inspParsed.push({
						LINK: i.LINK,
						IFC_T_RECORD_ACTION: i.IFC_T_RECORD_ACTION,
						IFC_RECORD_ACTION_RESP_PERS: i.IFC_RECORD_ACTION_RESP_PERS,
						S_PERSON: i.S_PERSON,
						TEMP_SPERSON_FIO: i.TEMP_SPERSON_FIO,
						IFC_S_CMETHOD: i.IFC_S_CMETHOD,
						TEMP_CMETHOD: i.TEMP_CMETHOD,
						IFC_S_CACTION: i.IFC_S_CACTION,
						TEMP_CACTION: i.TEMP_CACTION,
						IFC_S_CTYPE: i.IFC_S_CTYPE,
						TEMP_CTYPE: i.TEMP_CTYPE,
						IFC_S_CMODE: i.IFC_S_CMODE,
						TEMP_CMODE: i.TEMP_CMODE,
						INSPECTION_RUN_FREQUENCY: i.INSPECTION_RUN_FREQUENCY,
						DH1: i.DH1?.toDateString(),
						DH2: i.DH2?.toDateString(),
						ORD: i.ORD
					});
				});

				respParsed.push({
					LINK: r.LINK,
					IFC_T_RECORD_ACTION: r.IFC_T_RECORD_ACTION,
					S_PERSON: r.S_PERSON,
					TEMP_SPERSON_FIO: r.TEMP_SPERSON_FIO,
					ACTION_RUN_FREQUENCY: r.ACTION_RUN_FREQUENCY,
					DH1: r.DH1?.toDateString(),
					DH2: r.DH2?.toDateString(),
					inspList: JSON.stringify(inspParsed)
				});

				allInspParsed.concat(allInspParsed, inspParsed);
			});

			return {
				LINK: d.LINK,
				IFC_RECORD: d.IFC_RECORD,
				IFC_ACTION: d.IFC_ACTION,
				MODIFICATION: d.MODIFICATION,
				NOTE: d.NOTE,
				respPersList: JSON.stringify(respParsed),
				inspList: JSON.stringify(allInspParsed),
				TEMP_PROCEDURE_CODE: d.TEMP_PROCEDURE_CODE,
				TEMP_PROCEDURE_NAME: d.TEMP_PROCEDURE_NAME,
				TEMP_ACTION_CODE: d.TEMP_ACTION_CODE,
				TEMP_ACTION_NAME: d.TEMP_ACTION_NAME,
				TEMP_PROCESS_CODE: d.TEMP_PROCESS_CODE,
				TEMP_PROCESS_NAME: d.TEMP_PROCESS_NAME
			};
		}, 1);
		return data;
	},

    setSelect: function (grid, selectLinks) {
		var me = grid;
        if (!selectLinks) return;
        var selected = [];
        Ext.each(selectLinks, function (row) {
            if (row) {
                if (row.data) row = row.data;
                var el = me.store.findRecord('LINK', row['LINK'] || row);
                if (el) {
                    selected.push(el);
                }
            }
        });
        if (selected.length !== 0) {
            extraSelect(selected, me);
        }
    },

	isFilled: function() {
        var me = this,
            type = -1,
            dh = me.gksc('DH').getValue(),
            dbegin = dh.dh1,
            dend = dh.dh2,
            errMsg = '',
            actionLink = 0,
			respPersLink = 0,
            inspLink = 0;

        let res = true;
		if (dbegin > dend) {
			me.errorMessages.push(wmc.get('ActionPeriodStartMoreThenEnd'));
		}

		if (me.gksc('S_ORG').isEmpty()) {
			me.addToInvalidControls(me.gksc('S_ORG'));
			res = false;
		}

		if (me.gksc('S_OTDEL').isEmpty()) {
			me.addToInvalidControls(me.gksc('S_OTDEL'));
			res = false;
		}

		if (me.ksControls.planModInfo.isVisible()){
			var resPMI = me.ksControls.planModInfo.isFilled();
			if (!resPMI.valid){
				resPMI.invalidControls.forEach(c => me.addToInvalidControls(c));
				res = false;
			}
		}

		Ext.each(me.gksd('responsibleData'), function (resp) {
            actionLink = resp.IFC_T_RECORD_ACTION;
            respPersLink = resp.LINK;

            if (!resp.S_PERSON) {
				type = 0;
				return false;
			}
			if (resp.DH1 < dbegin || resp.DH2 > dend) {
				type = 1;
				return false;
			}
			if (resp.DH1 > resp.DH2){
				type = 2;
				return false;
			}
        });

		if (type >= 0) {
            me.gksc('gridAction').setSelect([actionLink]);
            me.setSelect(me.gksc('gridRespPers'), [respPersLink]);

            switch (type) {
                case 0:
                {
	                me.errorMessages.push('Не выбрано Ответственное лицо!');
                    break;
                }
                case 1:
                {
	                me.errorMessages.push(KS.L10n.RecordEditView_CheckSave_Период_действия_ответственных_лиц_за_пределами_периода_действия_Карты_ВФК_);
	                break;
                }
				case 2:
					me.errorMessages.push(KS.L10n.RecordUpdController_CheckSave_Дата_начала_периода_действия_ответственных_лиц_не_может_быть_больше_даты_окончания_);
					break;
            }
        }
        Ext.each(me.gksd('inspectorData'), function(insp) {
            actionLink = insp.IFC_T_RECORD_ACTION;
            respPersLink = insp.IFC_RECORD_ACTION_RESP_PERS;
            inspLink = insp.LINK;

            if (!insp.IFC_S_CMETHOD) {
				type = 2;
				return false;
			}
			if (!insp.IFC_S_CACTION) {
				type = 3;
				return false;
			}
			if (!insp.IFC_S_CTYPE) {
				type = 4;
				return false;
			}
			if (!insp.IFC_S_CMODE) {
				type = 5;
				return false;
			}
			if (!insp.S_PERSON) {
				type = 6;
				return false;
			}
			if (insp.DH1 < dbegin || insp.DH2 > dend) {
				type = 7;
				return false;
			}
			if (!insp.IFC_RECORD_ACTION_RESP_PERS) {
				type = 8;
				var actData = me.gksc('gridAction').store.getDataExt(),
					pos = ArrayLib.find(actData, ['LINK'], actionLink);

				errMsg = 'В операции с кодом "' + actData[pos].TEMP_ACTION_CODE + '" необходимо привязать контролирующего к ответственному лицу!';
			}
			if (insp.DH1 > insp.DH2) {
				type = 9;
				errMsg = KS.L10n.RecordUpdController_CheckSave_Дата_начала_периода_действия_контролирующих_лиц_не_может_быть_больше_даты_окончания_;
				return false;
			}
		});

        if (type >= 2) {
            me.gksc('gridAction').setSelect([actionLink]);
            me.setSelect(me.gksc('gridRespPers'), [respPersLink]);
            me.setSelect(me.gksc('gridInspector'), [inspLink]);

            switch (type) {
                case 2:
                {
	                me.errorMessages.push('Не выбран Метод контроля!');
	                break;
                }
                case 3:
                {
	                me.errorMessages.push('Не выбрано Контрольное действие!');
	                break;
                }
                case 4:
                {
	                me.errorMessages.push('Не выбран Вид контроля!');
	                break;
                }
                case 5:
                {
	                me.errorMessages.push('Не выбран Способ контроля!');
	                break;
                }
                case 6:
                {
	                me.errorMessages.push('Не выбрано Контролирующее лицо!');
	                break;
                }
                case 7:
                {
	                me.errorMessages.push(KS.L10n.RecordEditView_CheckSave_Период_действия_контролирующих_лиц_за_пределами_периода_действия_Карты_ВФК_);
	                break;
                }
                case 8:
				case 9:
                {
	                me.errorMessages.push(errMsg);
	                break;
                }
            }
        }

        //Для изменения в карту ВФК проверяем, если статус изменился на "Утверждено", дата утверждения должна быть заполнена
		if (me.code === 'DOCUMENT_IFC_RECORD_MOD') {
			const dt_utv = me.gksc('planModInfo').ksControls.dtUtv.getValue();
			if (me.gksd('isClosedByStatus') === true && !dt_utv) {
				me.errorMessages.push('Введите Дату утверждения!');
			}
			// Дата утверждения изменения должна быть позже даты утверждения Карты
			if (dt_utv) {
				var date_at = me.gksc('DATE_AT').getValue();
				if (dt_utv <= date_at) {
					me.errorMessages.push('Дата утверждения Изменения должна быть позже даты Карты ВФК!');
					if (me.gksc('planModInfo').ksControls.dtUtv.isVisible) {
						me.gksc('planModInfo').ksControls.dtUtv.focus();
					}
				}
			}
		}

		//Для карт ВФК проверяем, если статус изменился на "Утверждено", дата карты(утверждения) должна быть заполнена
		if (me.code === 'DOCUMENT_IFC_RECORD') {
			var date_at = me.gksc('DATE_AT').getValue();
			if (me.gksd('isClosedByStatus') === true && !date_at) {
				me.errorMessages.push('Введите Дату карты');
				me.gksc('DATE_AT').focus;
			}

			// Дата карты должна быть не позднее даты начала периода действия Карты
			if (date_at) {
				if (dbegin < date_at) {
					me.errorMessages.push('Дата Карты должна быть не позднее даты начала периода действия Карты ВФК!');
					me.gksc('DATE_AT').focus;
				}
			}
		}
		return res;
	},

	isFilledAsync: async function(){
		const me = this;
		const dh = me.gksc('DH').getValue();
		const dbegin = dh.dh1;
		const dend = dh.dh2;
		if (me.code !== 'DOCUMENT_IFC_RECORD_MOD') {
			const res = await me.checkExistenceAsync(me.gksc('S_ORG').getLink(),
				me.gksc('S_OTDEL').getLink(),
				dbegin,
				dend,
				me.getLink());
			if (res) {
				me.errorMessages.push('По данному подразделению за указанный период уже есть Карта ВФК!')
			}
			return !res;
		}
		return true;
	},

	//метод сохранения данных
	saveData: function (endFunc, params) {
		const me = this;
			
		me.callParent([
			function (result) {
				if (result?.result) {
					if (me.gksd('isClosedByStatus') === true) {
						const reason = `${me.code === 'DOCUMENT_IFC_RECORD_MOD' ? "Изменение в карты ВФК" : "Карты ВФК"} со статусом ${me.gksc('S_STATUS').getRawValue()}`;
						me.setReadOnly(true, reason);
					}
				}
				if (endFunc) endFunc(result);
			}, params
		]);
	},
	//#endregion Сохранение данных

	//Получить данные по кнопке заполнить автоматически
	getAllActions: function(actionLinks, sOrg, sOtdel, endFunc) {
		var me = this,
			dh = me.gksc('DH').getValue();

		me.showLoadMask({
			msg: KS.L10n.updating_data,
			view: me.parentView,
			rid: ajaxRequest({
				url: 'SRecord/GetAllActions_A',
				params: {
					actionLinks: actionLinks,
					sorg: sOrg,
					sotdel: sOtdel,
					dbegin: dh.dh1?.toDateString(),
					dend: dh.dh2?.toDateString()
				},
				success: function(value) {
					if (value) endFunc(value);
				},
				callback: function() {
					me.hideLoadMask();
				}
			})
		});
	},
	//Получение индекса видимой колонки по датаиндексу
	getColumnIndex: function(grid, colName) {
		var indx = -1;
		grid.columnManager && grid.columnManager.columns.forEach(function(val, i) {
			if (val.dataIndex === colName) {
				indx = i;
				return false;
			}
		});
		return indx;
	},

	attentionMsgShow: function(cfg) {
		Ext.Msg.show({
			title: KS.L10n.attention,
			msg: cfg.msg,
			buttons: Ext.MessageBox.OKCANCEL,
			fn: function(buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.WARNING
		});
	},

	checkExistenceAsync: async function(sOrg, sOtdel, dbegin, dend, link) {
		const res = await ajaxRequestAsync({
			loadMask: true,
			url: 'SRecord/CheckExistence_A',
			timeout: 5000,
			params: {
				sorg: sOrg,
				sotdel: sOtdel,
				dbegin: dbegin?.toDateString(),
				dend: dend?.toDateString(),
				link: link
			},
			
		});
		return res;
	},
	//Событие кнопки "перенсти строки"
	warpHandler: function(grid, warpBtn) {
		if (!grid) return;

		var me = this;

		if (grid.autoheightrows) {
			grid.getEl().removeCls(me.autoheightrowsCls);
			warpBtn.setIconCls('x_btn_wrap');
			warpBtn.setTooltip(wmc.get('Wrap'));
		} else {
			grid.getEl().addCls(me.autoheightrowsCls);
			warpBtn.setIconCls('x_btn_nonwrap');
			warpBtn.setTooltip(wmc.get('NonWrap'));
		}

		grid.autoheightrows = !grid.autoheightrows;
	},
	//Событие изменения организации или подразделения isOrg - true меняем из организаций/ false из подразделения
	orgPordrazdelChange: function(v, isOrg) {
		var me = this;

		me.attentionMsgShow({
			msg: wmc.get(isOrg ? 'changeOrgRec' : 'changeOtdelRec'),
			ok: function() {
				if (isOrg) me.gksc('S_ORG').setValue(v);

				me.gksc('S_OTDEL').setValue(isOrg ? [] : v);
				me.gksc('gridAction').store.removeAll();
				me.gksc('gridRespPers').store.removeAll();
				me.gksc('gridInspector').store.removeAll();
				me.sksd('responsibleData', []);
				me.sksd('inspectorData', []);

				const otdel = me.gksc('S_OTDEL').getLink();
				if (otdel) {
					me.sksd('subOtdels', [otdel])
					ajaxRequest({
							url: 'SOtdel/GetSubDepartmentsList_A',
							params: {
								otdel: otdel,
							},
							success: function (res) {
								if (res) me.sksd('subOtdels', res);
							}
						}
					)
				}
				else {
					me.sksd('subOtdels', [])
				}
			},
			cancel: function() {
				me.gksc('ActionDictBtn').setDisabled(false);
			}
		});
	},
	//Заполнить периоды по картам
	fillPeriods: function() {
		var me = this,
			respons = me.gksd('responsibleData'),
			inspectors = me.gksd('inspectorData'),
			responsLinks = [],
			inspectorsLinks = [],
			dh = me.gksc('DH').getValue();

		Ext.each(respons, function(resp) {
			resp.DH1 = dh.dh1;
			resp.DH2 = dh.dh2;
			responsLinks.push(resp.LINK);
		});

		Ext.each(inspectors, function(insp) {
			insp.DH1 = dh.dh1;
			insp.DH2 = dh.dh2;
			inspectorsLinks.push(insp.LINK);
		});

		me.checkErrorPeriods(responsLinks, respons, true);
		me.checkErrorPeriods(inspectorsLinks, inspectors);

		me.gksc('gridAction').getSelectionModel().select(me.gksc('gridAction').getFrstSelect());
	},
	
	checkErrorActions: function(){
		const me = this;
		const respData = me.gksd('responsibleData');
		const inspData = me.gksd('inspectorData');
		
		respData.forEach(function (rR) {
			rR.INVALID_DATE_TEXT = rR.INVALID_DATE_TEXT?.replace(KS.L10n.RecordEditView_CheckSave_Имеются_несоответствия_в_периодах_действия_в_таблице__Контролирующие__ + '\r\n', '');
			if (inspData.filter(rI => rR.LINK === rI.IFC_RECORD_ACTION_RESP_PERS && rI.INVALID_DATE_TEXT).length){
				rR.INVALID_DATE_TEXT = KS.L10n.RecordEditView_CheckSave_Имеются_несоответствия_в_периодах_действия_в_таблице__Контролирующие__ 
					+ '\r\n' + rR.INVALID_DATE_TEXT;
			}
		});

		me.gksc('gridAction').store.each(function (rec) {
			const link = rec.get('LINK');
			if (!link) return;
			
			let errorMessage = '';
			if (respData.filter(r=>r.IFC_T_RECORD_ACTION === link && r.INVALID_DATE_TEXT).length){
				errorMessage = KS.L10n.RecordEditView_CheckSave_Имеются_несоответствия_в_периодах_действия_в_таблице__Ответственные__;
			}
			if (inspData.filter(r=>r.IFC_T_RECORD_ACTION === link && r.INVALID_DATE_TEXT).length){				
				if (errorMessage.length) errorMessage += '\r\n';
				errorMessage += KS.L10n.RecordEditView_CheckSave_Имеются_несоответствия_в_периодах_действия_в_таблице__Контролирующие__;
			}
			if (rec.get('TEMP_S_OTDEL') && rec.get('TEMP_S_OTDEL') !== me.gksc('S_OTDEL').getLink()){
				if (errorMessage.length) errorMessage += '\r\n'; 
				errorMessage += KS.L10n.RecordEditView_CheckSave_Операция_не_относится_к_данному_подразделению_;
			}
			
			const recordPeriod = me.gksc('DH').getValue();
			const actionPeriod = {dh1: new Date(rec.get('TEMP_ACTION_DH1')), dh2 : new Date(rec.get('TEMP_ACTION_DH2'))};
			if (!PeriodLib.getPeriodsCross(recordPeriod, actionPeriod, 'dh', true)){
				if (errorMessage.length) errorMessage += '\r\n';
				errorMessage += KS.L10n.RecordEditView_CheckSave_Период_действия_операции_не_пересекается_с_периодом_действия_Карты_ВФК_;
			}
			rec.set('WRNNG', errorMessage.length > 0);
			rec.set('INVALID_DATE_TEXT', errorMessage.length ? errorMessage : null);
		});
		me.gksc('gridRespPers').view.refresh();
		me.gksc('gridAction').view.refresh();
	},
	//Найти все периоды участия, которые не сходятся с периодами действия
	checkErrorPeriods: function(links, data, isResp) {
		var me = this,
			inData = me.gksd('inData'),
			dh = me.gksc('DH').getValue(),
			sel = me.gksc(isResp ? 'gridAction' : 'gridRespPers').getFrstSelect();

		for (var i = 0, len = links.length; i < len; i++) {
			var link = links[i],
				MIN = dh.dh1,
				MAX = dh.dh2,
				recData = ArrayLib.filter(data, ['LINK'], link)[0],
				errMsg = '',
				inPeriods = inData[recData.S_PERSON];

			if (recData) {
				recData.DH1 = new Date(recData.DH1);
				recData.DH2 = new Date(recData.DH2);

				if (MIN > recData.DH1 || MAX < recData.DH2) {
					recData.WRNNG = true;
					recData.INVALID_DATE_TEXT = errMsg = isResp 
						? KS.L10n.RecordEditView_CheckSave_Период_действия_ответственного_лица_за_пределами_периода_действия_карты_ВФК_ 
						: KS.L10n.RecordEditView_CheckSave_Период_действия_контролирующего_лица_за_пределами_периода_действия_карты_ВФК__;
					continue;
				}
				
				if (recData.DH1 > recData.DH2){
					recData.WRNNG = true;
					recData.INVALID_DATE_TEXT = errMsg = isResp 
						? KS.L10n.RecordUpdController_CheckSave_Дата_начала_периода_действия_ответственных_лиц_не_может_быть_больше_даты_окончания_ 
						: KS.L10n.RecordUpdController_CheckSave_Дата_начала_периода_действия_контролирующих_лиц_не_может_быть_больше_даты_окончания_
					continue;
				}

				if (inPeriods) {
					const sOrg = me.gksc('S_ORG').getLink();
					const dh1 = new Date(recData.DH1);
					const dh2 = new Date(recData.DH2);
					const crossPeriods = inPeriods.filter(inPeriod => PeriodLib.getPeriodsCross(inPeriod, { DH1: dh1, DH2: dh2 }, 'DH', true));
					
					let badPeriods = [];
					crossPeriods.forEach(inPeriod => {
						let hasError;
						if (isResp) {
							//ошибка в случае, если не работает в своем и субподразделениях и не является руководителем орг-ии по должности
							hasError = !(me.gksd('subOtdels').indexOf(+inPeriod['S_OTDEL']) >= 0)
								&& !(me.gksd('dolgsDir').indexOf(+inPeriod['S_DOLG']) >= 0 && +inPeriod['S_ORG'] === +sOrg);
						} else {
							//ошибка в случае, если не работает в организации
							hasError = +inPeriod['S_ORG'] !== +sOrg;
						}
						if (hasError) badPeriods.push(inPeriod);
					});

					badPeriods = badPeriods.sort(function(a, b) {
						const keyA = new Date(a.DH1);
						const keyB = new Date(b.DH2);
						if (keyA < keyB) return -1;
						if (keyA > keyB) return 1;
						return 0;
					});
					
					if (badPeriods.length) {
						const existsMix = badPeriods.filter(r => r.MIX).length;
						if (!existsMix) { //нет совмещения
							recData.WRNNG = true;
							recData.INVALID_DATE_TEXT = isResp
								? KS.L10n.RecordEditView_CheckSave_Существуют_периоды__в_которые_ответственный_не_принадлежит_подразделению_
								: KS.L10n.RecordEditView_CheckSave_Существуют_периоды__в_которые_контролирующий_не_принадлежит_организации_;
							badPeriods.forEach(badPeriod => {
								let d1 = badPeriod.DH1;
								let d2 = badPeriod.DH2;
								//ограничиваем период Периодом действия ответственного/контролирующего
								if (dh1 > d1) d1 = dh1;
								if (dh2 < d2) d2 = dh2;
								recData.INVALID_DATE_TEXT += '\r\n\t' + PeriodLib.dateToDisplay(d1) + '-' + PeriodLib.dateToDisplay(d2);
							});
							continue;
						} else {
							let errorPeriodMsg = '';
							badPeriods.forEach(badPeriod => {
								const mix = badPeriod.MIX ? 1 : 0;
								let d1 = badPeriod.DH1;
								let d2 = badPeriod.DH2;
								const rowsByMix = crossPeriods.filter(prd => (prd.MIX ? 1 : 0) !== mix
									&& PeriodLib.getPeriodsCross(prd, {DH1: d1, DH2: d2}, 'DH', true));

								const goodPeriodsByMix = rowsByMix.filter(r => {
									let valid;
									if (isResp) {
										//ошибка в случае, если не работает в своем и субподразделениях и не является руководителем орг-ии по должности
										valid = (me.gksd('subOtdels').indexOf(r.S_OTDEL) >= 0)
											|| (me.gksd('dolgsDir').indexOf(r.S_DOLG) >= 0 && r.S_ORG === +sOrg);
									} else {
										//ошибка в случае, если не работает в организации
										valid = r.S_ORG === +sOrg;
									}
									return valid;
								});

								if (!goodPeriodsByMix.length) { //todo CheckPeriodsSkip
									//ограничиваем период Периодом действия ответственного/контролирующего
									if (dh1 > d1) d1 = dh1;
									if (dh2 < d2) d2 = dh2;

									errorPeriodMsg += '\r\n\t' + PeriodLib.dateToDisplay(d1) + '-' + PeriodLib.dateToDisplay(d2);
								} else {
									const dt1 = new Date(Math.min(...goodPeriodsByMix.map(prd => prd.DH1)));
									const dt2 = new Date(Math.max(...goodPeriodsByMix.map(prd => prd.DH2)));

									if (dt1 > d1 && dh1 < dt1 || dt2 < d2 && dh2 > dt2) {
										if (dh1 > d1) d1 = dh1;
										if (dh2 < d2) d2 = dh2;

										if (dt1 > d1) {
											errorPeriodMsg += '\r\n\t' + PeriodLib.dateToDisplay(d1) + '-' + PeriodLib.dateToDisplay(PeriodLib.addDays(dt1, -1));
										} else {
											errorPeriodMsg += '\r\n\t' + PeriodLib.dateToDisplay(PeriodLib.addDays(dt2, 1)) + '-' + PeriodLib.dateToDisplay(d2);
										}
									}
								}
							});
							if (errorPeriodMsg){
								recData.WRNNG = true;
								recData.INVALID_DATE_TEXT =recData.INVALID_DATE_TEXT = (isResp
									? KS.L10n.RecordEditView_CheckSave_Существуют_периоды__в_которые_ответственный_не_принадлежит_подразделению_
									: KS.L10n.RecordEditView_CheckSave_Существуют_периоды__в_которые_контролирующий_не_принадлежит_организации_) 
									+ errorPeriodMsg;
								continue;
							}
						}
					}
				}

				recData.WRNNG = false;
				recData.INVALID_DATE_TEXT = null;
			}
		}

		//Запускаем обновление данных
		me[isResp ? 'gridActionSelector' : 'gridRespSelector'](sel);
        me.checkErrorActions();
		if (!isResp) me.gksc('gridRespPers').view.refresh();
        me.gksc('gridAction').view.refresh();
	},
	//Получить периоды действия у сотрудников
	getPersonsIn: function(links, endFunc) {
		const me = this;
		if (links && links.length) {
			me.showLoadMask({
				msg: KS.L10n.updating_data,
				rid: ajaxRequest({
					url: 'SPerson/GetSPersonsIn_A',
					params: { links: links },
					success: function(value) {
						me.hideLoadMask();
						if (value && endFunc) endFunc(value);
					},
					failure: function() {
						me.hideLoadMask();
					}
				})
			});
		} else {
			if (endFunc) endFunc([]);
		}
	},
	//Селектор грида Операции
	gridActionSelector: function(rec) {
		var me = this,
			gridPers = me.gksc('gridRespPers'),
			//gridInsp = me.gksc('gridInspector'),
			respData = rec && rec.data ? ArrayLib.filter(me.gksd('responsibleData'), ['IFC_T_RECORD_ACTION'], rec.get('LINK')) : [];

		gridPers.loadData(respData);
		if (!respData.length) me.gridRespSelector();
		me.gksc('gridAction').view && me.gksc('gridAction').view.refresh();
		if (rec) me.gksc('ActionDelBtn').setDisabled(rec.data['MODIFICATION'] === true);
	},
	//Селектор грида Ответственные
	gridRespSelector: function(rec) {
		var me = this,
			field = 'IFC_RECORD_ACTION_RESP_PERS',
			actionRec = me.gksc('gridAction').getFrstSelect();

		if (!(actionRec && actionRec.data)) return _;

		var inspOfAction = ArrayLib.filter(me.gksd('inspectorData'), ['IFC_T_RECORD_ACTION'], actionRec.get('LINK'));

		if (rec && rec.data) {
			me.gksc('gridInspector').loadData(ArrayLib.filter(inspOfAction, [field], rec.get('LINK'))
				.concat(ArrayLib.filter(inspOfAction, [field], null))
				.concat(ArrayLib.filter(inspOfAction, [field], 0)), _, false);
		} else {
			me.gksc('gridInspector').loadData(inspOfAction);
		}

		me.gksc('gridInspector').store.sort('ORD', 'ASC');
	},
    //Селектор грида Контролирующие
    gridInspectorSelector: function(rec) {
        var me = this,
            grid = me.gksc('gridInspector');

        if (grid.readOnly) return;
        if (rec) {
            var ord = rec.get('ORD'),
                maxOrd = grid.store.count();

            me.gksc('InspectorTopBtn').setDisabled(!(ord - 1));
            me.gksc('InspectorUpBtn').setDisabled(!(ord - 1));
            me.gksc('InspectorDownBtn').setDisabled(ord === maxOrd);
            me.gksc('InspectorBottomBtn').setDisabled(ord === maxOrd);
        }
    },
    moveRec: function(d, pos) {
        var me = this,
            grid = me.gksc('gridInspector'),
            rec = grid.getFrstSelect();

        if (rec) {
            var ord = rec.get('ORD');
            if (pos === _) {
                pos = ord + d;

                var swapRec = grid.store.getRecord(pos, 'ORD');
                if (swapRec) swapRec.set('ORD', ord);
            } else {
                grid.store.each(pos < ord
                    ? function(el) {
                        if (el.get('ORD') < ord) el.set('ORD', el.get('ORD') + 1);
                    }
                    : function(el) {
                        if (el.get('ORD') >= ord) el.set('ORD', el.get('ORD') - 1);
                    }
                );
            }
            rec.set('ORD', pos);
            grid.store.sort('ORD', 'ASC');
            me.gridInspectorSelector(rec);
        }
    },

	//Добавить или скопировать ответственного
	gridRespPersAdd: function(actionRec, d) {
		var me = this,
			dh = me.gksc('DH').getValue(),
			actionDh1 = new Date(actionRec.get('TEMP_ACTION_DH1')),
			actionDh2 = new Date(actionRec.get('TEMP_ACTION_DH2')),
			period = PeriodLib.findMinMaxPeriod(dh.dh1, dh.dh2, actionDh1 < dh.dh1 ? dh.dh1 : actionDh1, actionDh2 > dh.dh2 ? dh.dh2 : actionDh2);

		if (period.min > period.max) {
			var tmp = period.max;
			period.max = period.min;
			period.min = tmp;
		}

		me.gksd('responsibleData').push({
			LINK: me.respPersLink--,
			S_PERSON: null,
			DH1: period.min,
			DH2: period.max,
			ACTION_RUN_FREQUENCY: d ? d.ACTION_RUN_FREQUENCY : '',
			IFC_T_RECORD_ACTION: actionRec.get('LINK'),
			WRNNG: false,
			INVALID_DATE_TEXT: ''
		});

		me.gridActionSelector(actionRec);
		//me.gksc('gridRespPers').loadData(ArrayLib.filter(me.gksd('responsibleData'), ['IFC_T_RECORD_ACTION'], actionLink));
	},
	//Добавить или скопировать контролирующего
	gridInspAdd: function(actionRec, selResp, ord, d) {
		var me = this,
			dh = me.gksc('DH').getValue(),
			actionDh1 = new Date(actionRec.get('TEMP_ACTION_DH1')),
			actionDh2 = new Date(actionRec.get('TEMP_ACTION_DH2')),
			period = PeriodLib.findMinMaxPeriod(dh.dh1, dh.dh2, actionDh1 < dh.dh1 ? dh.dh1 : actionDh1, actionDh2 > dh.dh2 ? dh.dh2 : actionDh2),
			selRespLink = selResp ? selResp.get('LINK') : 0;

		if (period.min > period.max) {
			var tmp = period.max;
			period.max = period.min;
			period.min = tmp;
		}

		me.gksd('inspectorData').push({
			LINK: me.inspLink--,
			IFC_T_RECORD_ACTION: actionRec.get('LINK'),
			S_PERSON: null,
			TEMP_SPERSON_FIO: null,
			IFC_S_CMETHOD: d ? d.IFC_S_CMETHOD : null,
			TEMP_CMETHOD: d ? d.TEMP_CMETHOD : null,
			IFC_S_CACTION: d ? d.IFC_S_CACTION : null,
			TEMP_CACTION: d ? d.TEMP_CACTION : null,
			IFC_S_CTYPE: d ? d.IFC_S_CTYPE : null,
			TEMP_CTYPE: d ? d.TEMP_CTYPE : null,
			IFC_S_CMODE: d ? d.IFC_S_CMODE : null,
			TEMP_CMODE: d ? d.TEMP_CMODE : null,
			
			INSPECTION_RUN_FREQUENCY: d ? d.INSPECTION_RUN_FREQUENCY : '',
			DH1: period.min,
			DH2: period.max,
			IFC_RECORD_ACTION_RESP_PERS: selRespLink || null,
			ORD: ord
		});

		me.gridActionSelector(actionRec);
		if (selResp) me.gksc('gridRespPers').getSelectionModel().select(selResp);
	},
	setReadOnly: function(v, reason, fake) {
		var me = this;

		var sr = me.mixins['Keysystems.Base.Edit'].setReadOnly;
		sr.call(me, v, reason, fake);

		if (me.modification) {
			me.gksc('planModInfo').setReadOnly(//me.planModInfoReadOnly ||
				me.gksd('readOnlyStatuses').indexOf(me.gksc('S_STATUS').getValue()) !== -1);
		}

		me.gksc('printBtn').setKsReadOnly(!me.gksd('isPrint'));
	},
	
	// Добавить фиктивную запись операции для корректного выделения группы
	addFictOperationData: function (data){
		var pos = ArrayLib.find(data, ['LINK'], 0);
		if (pos === -1){
			const groups = new Set(data.map(r => r["TEMP_PROCEDURE_NAME"]));
			groups.forEach(group => {
				data.push({
					LINK: 0,
					TEMP_PROCEDURE_NAME: group
				})
			});
		}
		return data;
	}	
});