﻿Ext.define('Keysystems.Procedure.Edit', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Edit'],
	title: 'Бюджетные процедуры',
	linkCode: 'SProcedure',
	isWindow: true,
	flex: 1,
	autoScroll: true,
	autoRender: true,
	border: 0,
	bodyPadding: 0,
	layout: { type: 'vbox', align: 'stretch' },

	isCodeEdit: true,
	codeEditCfg: { maxWidth: 255, enforceMaxLength: true },
	isNameEdit: true,
	nameEditCfg: { className: 'Keysystems.form.field.Trigger.TextEditor', height: 60, enforceMaxLength: true, padding: '0 0 5 0' },
	isDHEdit: true,
	dhEditCfg: { maxWidth: 375 },
	_arr: ['CODE', 'NAME'],
	profileListeners: [{ name: 'view', method: 'FormParam' }],
	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initKsData: function(data) { data.processesLink = -1; },

	initKsMethods: function(methods) {
		var me = this;

		methods.joinSOrg = function(r, field) {
			return ArrayLib.joinBy(ArrayLib.filter(me.gksd('T_PROCESS_SORG'), ['IFC_S_PROCESS'], r.get('LINK')), field, '; ');
		};

		methods.TEMP_S_ORG_CODE = function(v, m, r) { return methods.joinSOrg(r, 'S_ORG_CODE'); };

		methods.TEMP_S_ORG_NAME = function(v, m, r) { return methods.joinSOrg(r, 'S_ORG_NAME'); };
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		result.minWidth = 500;
		result.minHeight = 400;
		return result;
	},

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		me.baseInitComponent();

		me.callParent(arguments);

		me.afterInitComponent();
	},

	createGridTBar: function() {
		var me = this;
		return [
			me.sksc('btnNewProcess', Ext.create('Ext.Button', {
				iconCls: 'x_btn_new',
				tooltip: 'Создать',
				tooltipType: 'title',
				handler: function() { me.editProcesses(); }
			})),
			me.sksc('btnEditProcess', Ext.create('Ext.Button', {
				key: 'edit',
				iconCls: 'x_btn_edit',
				tooltip: 'Редактировать',
				tooltipType: 'title',
				disabled: true,
				handler: function() {
					let rec = me.gksc('gridProcesses').getFrstSelect();
					if (rec) {
						me.editProcesses(rec);
					}
				}
			})),
			me.sksc('btnDeleteProcess', Ext.create('Ext.Button', {
				key: 'edit',
				iconCls: 'x_btn_delete',
				tooltip: 'Удалить',
				tooltipType: 'title',
				disabled: true,
				handler: function() { me.gksc('gridProcesses').removeSelection(); }
			}))
		];
	},

	editProcesses: function(rec) {
		var me = this,
			tpo = me.gksd('T_PROCESS_SORG');

		Ext.create('Keysystems.Procedure.Edit.Processes', {
			code: 'DICTIONARY_IFC_S_PROCESS',
			linkCode: 'SProcess',
			f: rec ? 'edit' : 'new',
			data: rec,
			readOnly: !me.gksd('proccessAccess'),
			dh: me.gksc('DH').getValue(),
			S_ORG: rec ? ArrayLib.filter(tpo, ['IFC_S_PROCESS'], rec.get('LINK')) : [],
			baseSaveData: function(params, callBack) {
				if (!params.link) this.setLink(params.link = me.ksData.processesLink--);
				this.oldData = JSON.stringify(params);
				params.LINK = params.link;

				me.bindData(
					ArrayLib.filter(tpo, ['IFC_S_PROCESS'], params.link),
					params.S_ORG,
					tpo,
					function(l, d) { return ArrayLib.find(l, ['S_ORG'], d.LINK); },
					function(d) {
						return {
							IFC_S_PROCESS: params.link,
							S_ORG: d.LINK,
							S_ORG_CODE: d.CODE,
							S_ORG_NAME: d.NAME
						};
					}
				);

				var codesOrg = [],
					namesOrg = [];
				Ext.each(params.S_ORG, function(d){
					codesOrg.push(d.data.CODE);
					namesOrg.push(d.data.NAME);
				});
				params.TEMP_S_ORG_CODE = codesOrg.join(';')
				params.TEMP_S_ORG_NAME = namesOrg.join(';')
				
				if (rec) {
					rec.set(params);
				} else {
					rec = me.gksc('gridProcesses').store.add(params)[0];
				}

				this.f = 'edit';
				
				QuickMsgs.save();

				if (callBack) callBack();
			}
		});
	},

	createItems: function() {
		var me = this;

		return [
			Ext.create('Ext.form.FieldContainer', {
				layout: {type: 'vbox', align: 'stretch'},
				padding: '10 10 0 10',
				items: me.callParent(arguments)
			}),
			me.sksc('gridProcesses', Ext.create('Ext.grid.Panel', {
				title: 'Процессы',
				userCls: 'rks-filter-panel',
				flex: 1,
				autoScroll: true,
				autoRender: true,
				tbar: me.createGridTBar(),
				border: 0,
				features: [
					{
						ftype: 'summary',
						showSummaryRow: false
					}
				],
				store: Ext.create('Ext.data.Store', { fields: [], data: [], proxy: 'memory' }),
				listeners: {
					itemdblclick: function (th, rec) {
						me.editProcesses(rec);
					},
					selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('gridProcesses'), sels)
				},
				columns: [],
				columnLines: true,
				plugins: ['gridclipboard']
			}))
		];
	},

	getExtra: function(callBack, link) {
		var me = this;

		me.baseGetExtra({ link: link }, function(value) {
			if (value.ErrorMsg) {
				showError(value.ErrorMsg);
				me.isExit = true;
				LoadMask.hide();
				return;
			}

			var row = value.row,
				maxLen = row._MaxLength;

			Ext.each(me._arr, function(n) {
				var c = me.gksc(n);
				if (maxLen[n] > 0) c.maxLength = maxLen[n];
				c.setValue(row[n]);
			});

			me.sksd('proccessAccess', value.proccessAccess);
			if (!value.proccessAccess) {
				me.gksc('btnNewProcess').setDisabled(true);
				me.gksc('btnEditProcess').setIconCls('x_btn_open');
				me.gksc('btnDeleteProcess').setDisabled(true);
			}

			me.gksc('DH').setValue(row.DH1, row.DH2);

			var orgColumn = ArrayLib.filter(value.Processes.columns, ['dataIndex'], 'Организация')[0];
			if (orgColumn) Ext.each(orgColumn.columns, function(col) { col.renderer = me.gksm(col.dataIndex); });

			me.sksd('T_PROCESS_SORG', value.Processes.T_PROCESS_SORG);

			me.gksc('gridProcesses').setMetaDate(value.Processes, {
				profileCode: me.code,
				profileKey: 'gridProcesses',
				gateCode: me.keyEdit
			});

			me.ksData.processesMaxLen = value.Processes._MaxLength;

			if (callBack) callBack();
		});
	},

	dataCollector: function() {
		var me = this,
			res = me.callParent(arguments);

		res.Processes = me.gksc('gridProcesses').store.getDataExt(_, 1);
		res.T_PROCESS_SORG = me.gksd('T_PROCESS_SORG', 1);

		return res;
	},

	isFilled: function() {
		const me = this;
		
		let res = true;
		Ext.each(me._arr, function(n) {
			const c = me.gksc(n);
			if (c.isEmpty()) {
				me.addToInvalidControls(c);
				res = false;
			}
		});

		if (res) {
			const dh = me.gksc('DH').getValue();
			me.gksc('gridProcesses').store.each(function(rec) {
				if (!PeriodLib.contain(rec.get('DH1'), dh) || !PeriodLib.contain(rec.get('DH2'), dh)) {
					me.errorMessages.push('Период действия за пределами периода действия Бюджетной процедуры');
				}
			});
		}
		return res;
	}
});