﻿Ext.define('Keysystems.Procedure.Edit.Processes', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Edit'],
	title: 'Процесс',
	isWindow: true,
	flex: 1,
	autoScroll: true,
	autoRender: true,
	border: 0,
	layout: { type: 'vbox', align: 'stretch' },

	isCodeEdit: true,
	codeEditCfg: { maxWidth: 255, enforceMaxLength: true, maxLength: 15 },
	isNameEdit: true,
	nameEditCfg: { enforceMaxLength: true, maxLength: 255 },
	isDHEdit: true,
	dhEditCfg: { maxWidth: 375 },
	_arr: ['CODE', 'NAME'],

	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		me.baseInitComponent();

		me.callParent(arguments);

		me.afterInitComponent();
	},

	createItems: function() {
		var me = this;

		return me.callParent([
			[
				me.createDictEdit({
					key: 'S_ORG',
					mode: 'MULTI',
					code: dnl.S_ORG,
					ksAllowEmpty: true,
					whereArgs: { SType: { value: JSON.stringify([Ext.Object.getKey(miscTypes.TypeOrg, 'Проверяющая')]), type: 'List_int' } },
					fieldLabel: 'Организация'
				})
			]
		]);
	},
	loadNewData: function() {
		var me = this;
		me.gksc('DH').setValue(me.dh.dh1, me.dh.dh2);
		return me.callParent(arguments);
	},
	_getExtra: function(callBack) {
		var me = this,
			c = me.gksc('S_ORG');

		me.S_ORG.length ? c.setValueBy(me.S_ORG, 'S_ORG') : c.setValue(user.org);

		if (callBack) callBack();
	},
	getExtra: function(endFunc) { this._getExtra(endFunc, this.data.data.LINK); },
	getExtraNew: function(endFunc) { this._getExtra(endFunc, 0); },

	getWindowCfg: function() {
		var me = this,
			res = me.callParent(arguments);
		res.maximizable = false;
		res.resizable = false;
		delete res.height;
		return res;
	},

	dataCollector: function() {
		var me = this,
			res = me.callParent(arguments);

		res.S_ORG = me.gksc('S_ORG').getValue();

		return res;
	},

	isFilled: function() {
		var me = this,
			res = true;

		Ext.each(me._arr.concat(['S_ORG']), function(n) {
			const c = me.gksc(n);
			if (c.isEmpty()) {
				me.addToInvalidControls(c);
				res = false;
			}
		});

		var dh = me.gksc('DH').getValue();
		if (!PeriodLib.contain(dh.dh1, me.dh)) {
			me.errorMessages.push('Дата начала за пределами действия бюджетной процедуры');
		}

		if (!PeriodLib.contain(dh.dh2, me.dh)) {
			me.errorMessages.push('Дата окончания за пределами действия бюджетной процедуры');
		}
		return res;
	}
});