﻿Ext.define('Keysystems.Operation.Edit', {
	extend: 'Keysystems.Base.Edit',
	tSNarSNpaLink: -1,
	createItems: function() {
		var me = this,
			items = [
				[
					me.createDictEdit({
						key: 'S_NPA',
						mode: 'MULTI',
						code: dnl.S_NPA,
						fieldLabel: 'НПА',
						flex: 1,
						initWhereArgs: function() { return me.gksc('DH').getAsWhereArgs(); },
						listCfg: {
							isArticle: true,
							getT_SNPA: function() { return me.gksd('S_NPA_VALUE'); },
							getT_SNPA_SARTICLE: function() { return me.gksd('ACTIONNPA_ARTICLE'); },
							fieldTSNarSNar: 'IFC_T_SACTION_SNPA',
							creTSNpa: function (rec) {
								return {
									LINK: me.tSNarSNpaLink--,
									S_NPA: rec.LINK || rec.get('LINK'),
									S_NPA_CODE: rec.CODE || rec.get('CODE'),
									S_NPA_NAME: rec.NAME || rec.get('NAME')
								};
							}
						}
					})
				]
			];

		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 50, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 1500, enforceMaxLength: true };
		me.isDHEdit = true;

		return me.callParent([items]);
	},

	dataCollector: function() {
		var me = this,
			data = me.callParent(arguments);

		var l = [];
		Ext.each(me.gksd('S_NPA_VALUE'), function(v) {
			l.push(ArrayLib.copyByKeys(['LINK', 'S_NPA'], v, {
				S_ARTICLE: JSON.stringify(ArrayLib.getLinks(
					ArrayLib.filter(me.gksd('ACTIONNPA_ARTICLE'), ['IFC_T_SACTION_SNPA'], v.LINK),
					'S_ARTICLE'
				))
			}));
		});
		data.S_NPA = JSON.stringify(l);
		
		return data;
	},

	getExtra: function(endFunc, link) {
		var me = this;
		me.baseGetExtra({ link: link }, function(value) {
			me.autoFillControl(value.row);

			me.sksd('ACTIONNPA_ARTICLE', value.ACTIONNPA_ARTICLE);
			me.gksc('S_NPA').setValue(me.convertListToDictList(me.sksd('S_NPA_VALUE', value.S_NPA), 'S_NPA'));

			KsLib.tryRun(endFunc);
		});
	},
	isFilled: function() {
		const me = this;
		let res = me.callParent(arguments);

		const dh = me.gksc('DH').getValue();
		if (dh.dh1 > dh.dh2) {
			me.errorMessages.push(wmc.get('ActionPeriodStartMoreThenEnd'));
		}
		return res;
	}

});