﻿Ext.define('Keysystems.Action.Edit', {
	extend: 'Ext.tab.Panel',
	mixins: ['Keysystems.Base.Edit'],
	isWindow: true,
	flex: 1,
	title: 'Операции (действия)',
	linkCode: 'SAction',
	bodyPadding: 0,

	profileListeners: [{ name: 'view', method: 'FormParam' }],
	viewMinSize: [700, 500],	
	userCls: 'rks-panel-edit',
	bodyCls: 'rks-panel-edit-body',
	tSNarSNpaLink: -1,
	persLink: -1,
	attrLink: -1,
	tmpDH1: new Date('1900/01/01'),
	tmpDH2: new Date('2100/12/31'),

	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		me.baseInitComponent();

		me.callParent(arguments);

		me.afterInitComponent();
	},

	createItems: function() {
		var me = this;
		return me.objs.items = [me.getTab('General'), me.getTab('RisksValue'), me.getTab('RationaleRiskLevel')];
	},

	//#region таб Общие

	createTabGeneral: function() {
		var me = this;			
		return Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 10,
			border: 0,
			scrollable: true,
			items: [
				me.createDictEdit({
					key: 'S_ORG',
					code: dnl.S_ORG,
					mode: 'SINGL',
					fieldLabel: 'Организации',
					initWhereArgs: function() {
						return me.getWhereArgsAndPeriod({
							SType: { value: JSON.stringify([KsLib.getKeyByValue(miscTypes.TypeOrg, 'Проверяющая') * 1]), type: 'List_int' }
						});
					},
					_clear: function() { this.ksSetValue(); },
					ksSetValue: function(v) {
						var c = this,
							oLink = c.getLink();
						c.setValue(v);

						var nLink = c.getLink();
						if (oLink !== nLink) {
							Ext.each(['S_OTDEL', 'S_PROCEDURE'], function(k) {
								var c1 = me.gksc(k),
									dis = c.isEmpty();
								c1.setDisabled(dis);
								(c1.ksSetValue || c1.setValue).call(c1);
							});

							me.gksc('S_PROCESS').setValue();
						}
					}
				}),
				me.createDictEdit({
					key: 'S_OTDEL',
					code: dnl.S_OTDEL,
					disabled: true,
					getSOrg: function() { return me.gksc('S_ORG').getLink(); },
					mode: 'SINGL',
					fieldLabel: 'Подразделение',
					initWhereArgs: function () { return me.getWhereArgsAndPeriod({ SOrgs: { value: me.gksc('S_ORG').getLinks(1), type: 'List_int' } }); }
				}),
				me.createDictEdit({
					key: 'S_PROCEDURE',
					disabled: true,
					code: dnl.IFC_S_PROCEDURE,
					mode: 'SINGL',
					fieldLabel: 'Бюджетная процедура',
					initWhereArgs: function () { return me.getWhereArgsAndPeriod({ SOrgs: { value: me.gksc('S_ORG').getLinks(1), type: 'List_int' } }); },
					_clear: function() { this.ksSetValue(); },
					ksSetValue: function(v) {
						this.setValue(v);
						me.gksc('S_PROCESS').setDisabled(this.isEmpty());
					}
				}),
				me.createDictEdit({
					key: 'S_PROCESS',
					disabled: true,
					code: dnl.IFC_S_PROCESS,
					mode: 'SINGL',
					fieldLabel: 'Процесс',
					initWhereArgs: function() {
						return me.getWhereArgsAndPeriod({
							SOrg: { value: me.gksc('S_ORG').getLink(), type: 'int' },
							ProcedureLink: { value: me.gksc('S_PROCEDURE').getLink(), type: 'int' }
						});
					},
					listCfg: { hideTBar: true }
				}),
				me.createDictEdit({
					key: 'IFC_S_ACTION',
					disabled: false,
					code: dnl.IFC_S_ACTION,
					mode: 'SINGL',
					fieldLabel: 'Операция',
					initWhereArgs: function() {
						return me.getWhereArgsAndPeriod({ SOrgs: { value: me.gksc('S_ORG').getLinks(1), type: 'List_int' } });
					},
					_clear: function() { this.ksSetValue(); },
					ksSetValue: function(v) {
						var c = this,
							oLink = c.getLink();
						c.setValue(v);

						var nLink = c.getLink();

						if (oLink !== nLink) {
							var c1 = me.gksc('S_NPA');
							c1.setDisabled(this.isEmpty());
							(c1.ksSetValue || c1.setValue).call(c1);

							if (!me.isLoaded) {
								me.getNpa(nLink,
									function(res) {
										me.sksd('ACTIONNPA_ARTICLE', res.article);
										me.gksc('S_NPA').setValue(me.convertListToDictList(me.sksd('S_NPA_VALUE', res.sNpa), 'S_NPA'));
									});
							}
						}
					}
				}),

				me.createDictEdit({
					key: 'S_NPA',
					disabled: true,
					mode: 'MULTI',
					code: dnl.S_NPA,
					fieldLabel: 'НПА',
					initWhereArgs: function () { return me.getWhereArgsAndPeriod(); },
					listCfg: {
						isArticle: true,
						getT_SNPA: function () { return me.gksd('S_NPA_VALUE'); },
						getT_SNPA_SARTICLE: function () { return me.gksd('ACTIONNPA_ARTICLE'); },
						fieldTSNarSNar: 'IFC_T_ACTION_SNPA',
						creTSNpa: function (rec) {
							return {
								LINK: me.tSNarSNpaLink--,
								S_NPA: rec.LINK || rec.get('LINK'),
								S_NPA_CODE: rec.CODE || rec.get('CODE'),
								S_NPA_NAME: rec.NAME || rec.get('NAME')
							};
						}
					}
				}),

				me.createParentEdit()
			]
		});
	},

	_arrDictGeneral: ['S_ORG', 'S_OTDEL', 'S_PROCEDURE', 'S_PROCESS', 'IFC_S_ACTION'],

	getDateValue: function () {
		return {
			dh1: this.tmpDH1,
			dh2: this.tmpDH2
		};
	},

	getWhereArgsAndPeriod: function(res) {
		var dh = this.getDateValue();
		(res || (res = {}))['DH1'] = { value: dh.dh1, type: 'Date' };
		res['DH2'] = { value: dh.dh2, type: 'Date' };
		return res;
	},

	//загрузка данных
	getExtraGeneral: function(value) {
		var me = this,
			row = value.row;

		Ext.each(me._arrDictGeneral, function(k) {
			var c = me.gksc(k);
			(c.ksSetValue || c.setValue).call(c, value[k]);
		});

		me.tmpDH1 = row.TEMP_DH1;
		me.tmpDH2 = row.TEMP_DH2;

		me.sksd('ACTIONNPA_ARTICLE', value.ACTIONNPA_ARTICLE);
		me.gksc('S_NPA').setValue(me.convertListToDictList(me.sksd('S_NPA_VALUE', value.S_NPA), 'S_NPA'));

		me.gksc('PARENT').hide();
		me.gksc('PARENT').setValue(value.LINK_SELF);
	},

	//Сборка данных
	dataCollectorGeneral: function() {
		var me = this,
			data = { LINK_SELF: me.gksc('PARENT').getLink() };

		Ext.each(me._arrDictGeneral, function(k) { data[k] = me.gksc(k).getLink(); });

		var l = [];
		Ext.each(me.gksd('S_NPA_VALUE'), function(v) {
			l.push(ArrayLib.copyByKeys(['LINK', 'S_NPA'], v, {
				S_ARTICLE: JSON.stringify(ArrayLib.getLinks(
					ArrayLib.filter(me.gksd('ACTIONNPA_ARTICLE'), ['IFC_T_ACTION_SNPA'], v.LINK),
					'S_ARTICLE'
				))
			}));
		});
		data.S_NPA = JSON.stringify(l);

		return data;
	},

	//#endregion таб Общие

	//#region таб Оценка рисков

	createTabRisksValue: function() {
		var me = this;

		return Ext.create('Ext.panel.Panel', {
			title: 'Оценка рисков',
			layout: { type: 'vbox', align: 'stretch' },
			bodyPadding: 0,
			border: 0,
			scrollable: true,
			items: [
				me.createRiskValueGrid('Probability', 'Риски по критерию "Вероятность"', 'S_ACTIVITY_INDEX', 1),
				me.createRiskValueGrid('Implication', 'Риски по критерию "Последствия"', 'S_ACTIVITY_INDEX', 2)
			]
		});
	},

	createRiskValueGrid: function(key, title, riskField, groupCriteria) {
		var me = this,
			totalRiskField,
			gridKey = 'grid' + key,
			name = groupCriteria === 1 ? 'TEMP_SPROBRISK_NAME' : 'TEMP_SIMPLRISK_NAME',	
			result = me.sksc(gridKey, Ext.create('Ext.grid.Panel', {
				title: title,
				userCls: 'rks-filter-panel',
				selModel: Ext.create('Ext.selection.RowModel', { mode: 'MULTI' }),
				autoScroll: true,
				autoRender: true,
				border: 1,
				columns: [
					{
						text: 'усл.ед.',
						dataIndex: 'VALUE',
						width: 150,
						editor: {
							xtype: 'numberfield',
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							listeners: { blur: { fn: function() { me.calculateTotalRisk(me.gksc(gridKey), key); }, buffer: 500 } },
							ksLimitMaxMin: true,
							allowDecimals: false,
							allowExponential: false,
							minValue: -32766,
							maxValue: 32766
						}
					},
					{
						text: 'Наименование', 
						dataIndex: name,
						flex: 1
					}
				],
				columnLines: true,
				bbar: [
					totalRiskField = Ext.create('Ext.form.field.Text', {
						fieldLabel: 'Суммарная оценка риска',
						labelWidth: me.labelWidth + 10,
						readOnly: true,
						maxWidth: 200,
						padding: 5
					})
				],
				flex: 1,
				plugins: [Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }), 'gridclipboard'],
				rowLines: true,
				split: true,
				store: Ext.create('Ext.data.Store', { fields: [riskField, name, 'VALUE'], data: [], proxy: 'memory' }),
				tbar: [
					Ext.create('Ext.Button', {
						iconCls: 'x_btn_dict',
						tooltip: 'Выбрать',
						tooltipType: 'title',
						handler: function() {
							var grid = me.gksc(gridKey),
								sel = [];
							grid.store.each(function(r) { sel.push({ LINK: r.get(riskField) }); });

							dictFunc({
								settings: 'MULTI',
								title: "Риски по критерию " + (groupCriteria == 1 ? '"Вероятность"' : '"Последствия"'),
								whereArgs: me.getWhereArgsAndPeriod({'ObjType': { value: 1, type: 'int' }, 'CGroup': { value: groupCriteria, type: 'int' }}),
								selectLinks: sel,
								code: dnl.S_ACTIVITY_INDEX
							}, {
								ok: function(value) {
									var data = grid.store.getDataExt();

									me.bindData(
										ArrayLib.copy(data),
										value,
										data,
										function(l, d) { return ArrayLib.find(l, [riskField], d.LINK); },
										function(d) {
											var o = {};
											o[name] = d.NAME;
											o[riskField] = d.LINK;
											return o;
										}
									);

									grid.store.loadData(data, false);

									me.calculateTotalRisk(grid, key);
								}
							});
						}
					}),
					Ext.create('Ext.Button', {
						key: 'delete',
						iconCls: 'x_btn_delete',
						tooltip: 'Удалить',
						tooltipType: 'title',
						disabled: true,
						handler: function() {
							var grid = me.gksc(gridKey);
							grid.removeSelection(_, function() { me.calculateTotalRisk(grid, key); });
						}
					})
				],
				listeners: {
					selectionchange: (_, sels) => me.enableToolsGrid(me.gksc(gridKey), sels)
				}
			}));

		result.totalRiskField = totalRiskField;
		Ext.create('Keysystems.Controls.Grid.ColumnManager',
			{
				inputColumns:  result.config.columns.slice(),
				code: me.profileCode,
				profileKey: gridKey,
				gateCode: 'edit',
				grid: result
			});

		return result;
	},

	getTotalValue: function(grid) {
		var v = 0;
		grid.store.each(r => {
			v += (r.get('VALUE') || 0) * 1; 
		});
		return v;
	},

	calculateTotalRisk: function(grid, key) {
		var me = this;
		grid.totalRiskField.setValue(me.getTotalValue(grid));
		me.cbLevelUpdStore(me.gksc('cb' + key), me.gksd(key + 'LevelData'), grid);
	},

	//загрузка данных
	getExtraRisksValue: function(value) {
		var me = this,
			key = 'Probability',
			gridKey = 'grid',
			grid = me.gksc(gridKey + key);
		value && grid.store.loadData(value.probabilityRisks, false);
		me.calculateTotalRisk(grid, key);

		key = 'Implication';
		grid = me.gksc(gridKey + key);
		value && grid.store.loadData(value.implicationRisks, false);
		me.calculateTotalRisk(grid, key);
	},

	//Сборка данных
	dataCollectorRiskValue: function() {
		var me = this;
		return {
			probability: me.gksc('gridProbability').store.getDataExt(_, 1),
			implication: me.gksc('gridImplication').store.getDataExt(_, 1)
		};
	},

	//#endregion таб Оценка рисков

	//#region таб Обоснование уровня риска

	createTabRationaleRiskLevel: function() {
		var me = this,
			labelWidth = 200;
		let res = Ext.create('Ext.panel.Panel', {
			title: 'Обоснование уровня риска',
			border: 0,
			scrollable: true,
			layout: { type: 'vbox', align: 'stretch' },
			items: [
				Ext.create('Ext.panel.Panel', {
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: 10,
					border: 0,					
					items: [
						me.sksc('cbProbability', Ext.create('Keysystems.Controls.ComboBoxExtra', {
							value: null,
							fieldLabel: 'Уровень риска по критерию "Вероятность"',
							labelWidth: labelWidth + 80,
							editable: false,
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: CBDataLib.getStore(CBDataLib.get(_, true, [])),
							listeners: { change: function() { me.cbRiskLevelValueUpdStore(); } }
						})),
						me.sksc('cbImplication', Ext.create('Keysystems.Controls.ComboBoxExtra', {
							value: null,
							fieldLabel: 'Уровень риска по критерию "Последствия"',
							labelWidth: labelWidth + 80,
							editable: false,
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: CBDataLib.getStore(CBDataLib.get(_, true, [])),
							listeners: { change: function() { me.cbRiskLevelValueUpdStore(); } }
						})),
						me.sksc('cbRiskLevel', Ext.create('Keysystems.Controls.ComboBoxExtra', {
							value: null,
							fieldLabel: 'Значение уровня риска',
							labelWidth: labelWidth + 80,
							maxWidth: 500,
							editable: false,
							displayField: CBDataLib.displayField,
							valueField: CBDataLib.valueField,
							store: CBDataLib.getStore(CBDataLib.get(_, true, []))
						})),
						me.sksc('RATIONALE', Ext.create('Ext.form.field.TextArea', {
							fieldLabel: 'Обоснование уровня риска',
							labelWidth: labelWidth,
							autoScroll: true,
							enforceMaxLength: true,
							maxLength: 3000,
							height: 75
						})),
						me.sksc('OFFERS', Ext.create('Ext.form.field.TextArea', {
							fieldLabel: 'Предложения по устранению причин риска',
                            labelWidth: labelWidth,
                            autoScroll: true,
                            enforceMaxLength: true,
                            maxLength: 3000,
                            height: 75
                        })),
						me.sksc('IS_ACTIVATED', Ext.create('Ext.form.field.Checkbox', {
							labelWidth: labelWidth,
							fieldLabel: 'Включить в карту ВФК'
						}))
					]
				}),
				Ext.create('Ext.panel.Panel', {
					layout: { type: 'hbox', align: 'stretch' },
					bodyPadding: 0,
					border: 0,
					flex: 1,
					items: [
						me.sksc('gridResponsiblePersons', Ext.create('Ext.grid.Panel', {
							title: 'Ответственные лица',
							userCls: 'rks-filter-panel',
							autoScroll: true,
							autoRender: true,
							border: 1,
							flex: 2,
							tbar: [
								Ext.create('Ext.Button', {
									iconCls: 'x_btn_new',
									tooltip: 'Создать',
									tooltipType: 'title',
									handler: function() {
										var grid = me.gksc('gridResponsiblePersons');
										grid.getSelectionModel().select(grid.store.add({ LINK: me.persLink-- }));
									}
								}),
								Ext.create('Ext.Button', {
									key: 'delete',
									iconCls: 'x_btn_delete',
									tooltip: 'Удалить',
									tooltipType: 'title',
									disabled: true,
									handler: function() { me.gksc('gridResponsiblePersons').removeSelection(); }
								})
							],
							plugins: [Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }), 'gridclipboard'],
							store: Ext.create('Ext.data.Store', {
								fields: ['LINK', 'ACTION_RUN_FREQUENCY', 'S_PERSON', 'S_PERSON_NAME'],
								data: [],
								proxy: 'memory'
							}),
							columns: [
								{
									text: 'Периодичность выполнения',
									dataIndex: 'ACTION_RUN_FREQUENCY',
									width: 125,
									editor: {
										xtype: 'textfield',
										enforceMaxLength: true,
										maxLength: 500
									}
								},
								{
									text: 'Ответственное лицо',
									dataIndex: 'S_PERSON_NAME',
									xtype: 'dictcolumn',
									flex: 1,
									code: dnl.S_PERSON,
									ignoreCodeField: true,
									cleaningKey: false,
									getInputDicts: function() { return [Ext.create('InputEditDict', { name: 'S_ORG', data: me.gksc('S_ORG').getValue() })]; },
									beforeHandler: function (callback) {
										const th = this;
										const prd = me.getDateValue();
										ajaxRequest({
											url: 'SAction/GetRespPersonWhereArgs_A',
											params: {
												org: me.gksc('S_ORG').getLink(),
												otdel: me.gksc('S_OTDEL').getLink(),
												dt1: new Date(prd.dh1)?.toDateString(),
												dt2: new Date(prd.dh2)?.toDateString()
											},
											success: function(response) {
												if (!th.whereArgs) th.whereArgs = {};
												if (response.directors) {
													th.whereArgs.OrInLinks = {
														value: JSON.stringify(response.directors),
														type: 'List_int'
													};
												}
												if (response.otdels) {
													th.whereArgs.SOtdel = {
														value: JSON.stringify(response.otdels),
														type: 'List_int'
													};
												}
												KsLib.tryRun(callback);
											}
										})
									},
									initWhereArgs: function() {
										const th = this;
										if (!th.whereArgs) th.whereArgs = {};
										th.whereArgs.SOrgs = { value: me.gksc('S_ORG').getLink() ? me.gksc('S_ORG').getLinks(1) : "[0]", type: 'List_int' };
										return me.getWhereArgsAndPeriod(th.whereArgs);
									},
									ksSetValue: function(v, rec){
										var me = this,
											d = v[0];
										d = d ? d.data || d : _;
										var link = d && d[me.fieldLink] || 0,
											name = window.getTextByVisibleFields(me.code || me.Code, me.visibleFields, d, me.fieldName);

										rec.beginEdit();
										rec.set(me.dataIndex, name);
										rec.set('S_PERSON', link);
										rec.endEdit();
									},
									ksGetValue: function(rec) {
										return [{ LINK: rec.get("S_PERSON") }];
									},
									defaultRenderer: function (v, meta, rec) {
										var me = this;
										return rec.get(me.dataIndex);
									}
								}
							],
							columnLines: true,
							listeners: {
								selectionchange: function(th, sels) {
									var grid = me.gksc('gridInspectionAttributes'),
										rec = sels[0];

									grid.loadData(rec ? me.getInspectAttrByRespPersonLink(rec.get('LINK')) : []);
									grid.setDisabled(!rec);

									me.enableToolsGrid(me.gksc('gridResponsiblePersons'), sels);
								}
							}
						})),
						me.sksc('gridInspectionAttributes', Ext.create('Ext.grid.Panel', {
							title: 'Характеристики контрольных действий',
							autoScroll: true,
							autoRender: true,
							userCls: 'rks-filter-panel',
							//disabled: true,
							border: 1,
							flex: 3,
							tbar: [
								Ext.create('Ext.Button', {
									iconCls: 'x_btn_new',
									tooltip: 'Создать',
									tooltipType: 'title',
									handler: function() {
										var pRec = me.gksc('gridResponsiblePersons').getFrstSelect();
										if (pRec) {
											var rec = {
												LINK: me.attrLink--,
												IFC_ACTION_RESP_PERS: pRec.get('LINK')
											};
											me.gksd('InspectionAttributes').push(rec);
											var grid = me.gksc('gridInspectionAttributes');
											grid.getSelectionModel().select(grid.store.add(rec));
										}
									}
								}),
								Ext.create('Ext.Button', {
									key: 'delete',
									iconCls: 'x_btn_delete',
									tooltip: 'Удалить',
									tooltipType: 'title',
									handler: function() {
										me.gksc('gridInspectionAttributes').removeSelection(function(rec) {
											var list = me.gksd('InspectionAttributes'),
												i = ArrayLib.find(list, ['LINK'], rec.get('LINK'));
											if (i !== -1) list.splice(i, 1);
										});
									},
									disabled: true
								})
							],
							plugins: [
								Ext.create('Ext.grid.plugin.CellEditing', {
									clicksToEdit: 1,
									listeners: {
										ksAfteredit: function (editor, e) {

											if (e.value !== null) {
												if (Ext.isDate(e.value) && Ext.Date.isEqual(e.originalValue, e.value) && !e.ksDhSwaped) return;

												var recLink = e.record.get('LINK'),
													oldData = me.gksd('InspectionAttributes'),
													i = ArrayLib.find(oldData, ['LINK'], recLink);

												if (i !== -1) {
													oldData[i] = e.record.data;
												}
											}
										}
									}
								}),
								'gridclipboard'
							],
							store: Ext.create('Ext.data.Store', { fields: [], data: [], proxy: 'memory' }),
							columns: [],
							columnLines: true,
							listeners: {
								selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('gridInspectionAttributes'), sels)
							}
						}))
					]
				})
			]
		});

		let grid = me.gksc('gridResponsiblePersons');
		Ext.create('Keysystems.Controls.Grid.ColumnManager',
			{
				inputColumns: grid.config.columns.slice(),
				code: me.code,
				profileKey: 'gridResponsiblePersons',
				gateCode: 'edit',
				grid: grid
			});
		return res;			
	},

	filterByLevel: function(data, v) {
		var res = [];
		Ext.each(data, function(r) { if (r.MIN_VALUE <= v && (!r.MAX_VALUE || r.MAX_VALUE >= v)) res.push(r); });
		return res;
	},

	converToCbData: function(data, filedLink, filedName) {
		var res = {};
		filedLink = filedLink || 'LINK';
		filedName = filedName || 'NAME';
		Ext.each(data, function(r) { res[r[filedLink]] = r[filedName]; });
		return res;
	},

	cbLevelUpdStore: function(cbControl, data, grid) {
		var me = this;
		data = PeriodLib.filterDataByPeriod(data, this.tmpDH1, this.tmpDH2);
		data = me.filterByLevel(data, me.getTotalValue(grid));
		cbControl.loadData(CBDataLib.get(_, false, me.converToCbData(data)));		
		data.length === 1 && cbControl.setValue(data[0].LINK);
		cbControl.setValueSelectOrFrst();
	},

	cbRiskLevelValueUpdStore: function() {
		var me = this,
			cbRiskLevel = me.gksc('cbRiskLevel'),
			probability = me.gksc('cbProbability').getValue(),
			implication = me.gksc('cbImplication').getValue(),
			data = CBDataLib.get(_, 1, {});

		if (probability !== null && implication !== null) {
			let riskLevelData = me.gksd('RiskLevelValueData'),
				list = [];

			Ext.each(riskLevelData, function(r) {
				if (r.IFC_S_PROB_RISK_L == probability && r.IFC_S_IMPL_RISK_L == implication) list.push(r);
			});

			if (list.length) {
				data = CBDataLib.get(_, 0, me.converToCbData(list));
			}
		}

		cbRiskLevel.loadData(data);
		cbRiskLevel.setValueSelectOrFrst();
	},

	_arrRationaleRiskLevelCb: [
		//[controlKey, fieldLink, data]
		['cbProbability', 'IFC_S_PROB_RISK_L', 'ProbabilityLevelData'],
		['cbImplication', 'IFC_S_IMPL_RISK_L', 'ImplicationLevelData'],
		['cbRiskLevel', 'IFC_RISK_L_VALUE', 'RiskLevelValueData']
	],

	_arrRationaleField: ['RATIONALE', 'OFFERS', 'IS_ACTIVATED'],

	inspectAttrColumnSetEditor: function(columns, dataIndex, storeValue) {
		storeValue[0] = '...';

		var col = ArrayLib.filter(columns, ['dataIndex'], dataIndex)[0];
		col.editor = {
			xtype: 'comboextra',
			editable: false,
			displayField: CBDataLib.displayField,
			valueField: CBDataLib.valueField,
			store: Ext.create('Ext.data.Store', {
				fields: CBDataLib.getFields(),
				data: CBDataLib.get(_, 0, storeValue),
				proxy: 'memory'
			})
		};
		col.flex = 1;
		col.renderer = function(v) { return storeValue[v]; };
	},

	inspectAttrColumnUpd: function(value) {
		var me = this,
			columns = value.columns,
			defaultRenderer = function (v, meta, rec) {
				var me = this,
					di = me.linkFieldName + '_',
					res = '',
					val = rec.get(di + me.fieldCode);
				if (val && !me.ignoreCodeField) res += val;
				val = rec.get(di + me.fieldName);
				if (val) {
					if (res) res += '. ';
					res += val;
				}
				return res;
			},
			ksGetValue = function(rec) {
				var me = this,
					o = {};
				o[me.fieldLink] = rec.get(me.linkFieldName);

				if (!me.ignoreCodeField) {
					o[me.fieldCode] = rec.get(me.linkFieldName + '_' + me.fieldCode);
				}

				o[me.fieldName] = rec.get(me.linkFieldName + '_' + me.fieldName);
				return [o];
			},
			ksSetValue = function(v, rec) {
				var me = this,
					d = v[0];
				d = d ? d.data || d : _;
				var link = d && d[me.fieldLink] || 0,
					code = d && d[me.fieldCode] || '',
					name = window.getTextByVisibleFields(me.code || me.Code, me.visibleFields, d, me.fieldName);
				rec.beginEdit();

				if (!me.ignoreCodeField) {
					rec.set(me.linkFieldName + '_' + me.fieldCode, code);
				}

				rec.set(me.linkFieldName + '_' + me.fieldName, name);
				rec.set(me.linkFieldName, link);
				rec.endEdit();
				this.ownerCt?.ownerCt?.view?.refresh();
			}

		Ext.each(columns,
			function(el) {
				switch (el.dataIndex) {
				case 'IFC_S_CMETHOD':
				{
					el.hidden = false;
					el.xtype = 'dictcolumn';
					el.code = dnl.IFC_S_CMETHOD;
					el.ignoreCodeField = false;
					el.cleaningKey = false;
					el.controlName = 'dictIfcMethod';
					el.linkFieldName = 'IFC_S_CMETHOD';
					el.dataIndex = 'TEMP_IFC_S_CMETHOD';
					el.defaultRenderer = defaultRenderer;
					el.ksGetValue = ksGetValue;
					el.ksSetValue = ksSetValue;

					break;
				}
				case 'IFC_S_CACTION':
				{
					el.hidden = false;
					el.xtype = 'dictcolumn';
					el.code = dnl.IFC_S_CACTION;
					el.ignoreCodeField = false;
					el.cleaningKey = false;
					el.controlName = 'dictIfcAction';
					el.linkFieldName = 'IFC_S_CACTION';
					el.dataIndex = 'TEMP_IFC_S_CACTION';
					el.defaultRenderer = defaultRenderer;
					el.ksGetValue = ksGetValue;
					el.ksSetValue = ksSetValue;

					break;
				}
				case 'IFC_S_CTYPE':
				{
					el.hidden = false;
					el.xtype = 'dictcolumn';
					el.code = dnl.IFC_S_CTYPE;
					el.ignoreCodeField = false;
					el.cleaningKey = false;
					el.controlName = 'dictIfcType';
					el.linkFieldName = 'IFC_S_CTYPE';
					el.dataIndex = 'TEMP_IFC_S_CTYPE';
					el.defaultRenderer = defaultRenderer;
					el.ksGetValue = ksGetValue;
					el.ksSetValue = ksSetValue;

					break;
				}
				case 'IFC_S_CMODE':
				{
					el.hidden = false;
					el.xtype = 'dictcolumn';
					el.code = dnl.IFC_S_CMODE;
					el.ignoreCodeField = false;
					el.cleaningKey = false;
					el.controlName = 'dictIfcMode';
					el.linkFieldName = 'IFC_S_CMODE';
					el.dataIndex = 'TEMP_IFC_S_CMODE';
					el.defaultRenderer = defaultRenderer;
					el.ksGetValue = ksGetValue;
					el.ksSetValue = ksSetValue;

					break;
				}
				}
			});

		var col = ArrayLib.filter(columns, ['dataIndex'], 'INSPECTION_RUN_FREQUENCY')[0];
		col.flex = 1;
		col.editor = {
			xtype: 'textfield',
			enforceMaxLength: true,
			maxLength: 500
		};

		return columns;
	},

	getInspectAttrByRespPersonLink: function(link) {
		return ArrayLib.filter(this.gksd('InspectionAttributes'), ['IFC_ACTION_RESP_PERS'], link);
	},

	//загрузка данных
	getExtraRationaleRiskLevel: function(value) {
		var me = this;

		Ext.each(me._arrRationaleField, function(key) { me.gksc(key).setValue(value.row[key]); });

		Ext.each(me._arrRationaleRiskLevelCb, function(arr) {
			var c = me.gksc(arr[0]);

			c.loadData(CBDataLib.get(_, false, me.converToCbData(me.gksd(arr[2]).filter(d => { 
				return d.LINK == value.row[arr[1]];
			}))));
			
			me.f != 'new' && c.setValue(value.row[arr[1]]);

			c.setValueSelectOrFrst();
		});

		me.sksd('InspectionAttributes', value.InspectionAttributes.data);
		value.InspectionAttributes.data = [];
		me.inspectAttrColumnUpd(value.InspectionAttributes);
		me.gksc('gridInspectionAttributes').setMetaDate(value.InspectionAttributes, {		
			code: me.code,
			profileKey: 'gridInspectionAttributes',
			gateCode: 'edit'			
		});
		me.gksc('gridResponsiblePersons').loadData(value.ResponsiblePersons);
	},

	//Сборка данных
	dataCollectorRationaleRiskLevel: function() {
		var me = this,
			res = {};

		Ext.each(me._arrRationaleField, function(key) { res[key] = me.gksc(key).getValue(); });

		Ext.each(me._arrRationaleRiskLevelCb, function(arr) { res[arr[1]] = me.gksc(arr[0]).getValue(); });

		res.ResponsiblePersons = me.gksc('gridResponsiblePersons').store.getDataExt(function(d) {
			d.InspectionAttributes = JSON.stringify(me.getInspectAttrByRespPersonLink(d.LINK));
			return d;
		}, 1);

		return res;
	},

	//#endregion таб Обосновние уровня риска

	dataCollector: function() {
		var me = this,
			data = me.callParent(arguments);

		data.General = JSON.stringify(me.dataCollectorGeneral());
		data.RiskValue = JSON.stringify(me.dataCollectorRiskValue());
		data.RationaleRiskLevel = JSON.stringify(me.dataCollectorRationaleRiskLevel());

		return data;
	},
	isFilled: function() {
		const me = this;
		const store = me.gksc('gridResponsiblePersons').store;
		let res = true;
		if (store.count()) {
			store.each(function (rec) {
				if (!rec.get('S_PERSON')) {
					me.addToInvalidControls(me.gksc('gridResponsiblePersons'), {
						title: 'Ответственное лицо',
						parent: me,
						tab: me.getTab('RationaleRiskLevel')
					});
					res = false;
					return false;
				}

				if (!me.getInspectAttrByRespPersonLink(rec.get('LINK')).length) {
					me.warningMessages.push('Не заполнены характеристики контрольных действий!');
				}
			});
		} else {
			me.warningMessages.push('Не заполнена информация по Ответственным лицам!');
		}
		return res;
	},

	getExtra: function(callBack, link) {
		var me = this;

		me.baseGetExtra({ link: link, }, function(value) {
			me.getExtraGeneral(value);

			me.sksd('ProbabilityLevelData', value.ProbabilityLevelData);
			me.sksd('ImplicationLevelData', value.ImplicationLevelData);
			me.sksd('RiskLevelValueData', value.RiskLevelValueData);

			me.getExtraRisksValue(value);
			me.getExtraRationaleRiskLevel(value);

			if (callBack) callBack();
		});
	},

	//Получить данные по НПА и статьям
	getNpa: function(actionLink, endFunc) {
		const me = this;
		me.showLoadMask({
			msg: KS.L10n.updating_data,
			view: this.parentView,
			rid: ajaxRequest({
				url: 'SAction/getNpa_A',
				params: {
					actionLink: actionLink
				},
				success: function(value) {
					if (value) endFunc(value);
				},
				callback: function() { me.hideLoadMask(); }
			})
		});
	}
})