﻿import LoadMask from '../Other/LoadMask';
import LocalStorage from '../Other/LocalStorage';
import NavigatorLib from '../Other/Navigator';
import Desktop from "../Other/Desktop";

var HeadLib = {
	init: function() {
		var me = this;
		me.strategy = me['strategy' + KsLib.getClientType()];
	},

	//список справочников, для которых нужно вызвать обновление листовых форм после обновления рассчетной даты
	needRefreshThisDicts: [
		'DOCUMENT_IFC_RECORD',
		'DOCUMENT_PLANREVIZ',
		'DOCUMENT_REVIZ',
		'DOCUMENT_PLANREVIZINFO'
	],

	getIconBtn: function() {
		return objs.keysBtn = Ext.create('Ext.Button',
			{
				cls: 'ks-svg-icon',
				width: 180,
				minWidth: 180,
				height: 50,
				scale: 'large1'
			});
	},
	getVersionLabel: function() {
		return objs.versionLbl = Ext.create('Ext.form.Label', { text: version });
	},
	getSignalRControl: function() {
		objs.checkSignal = Ext.create('Keysystems.Controls.Signal', { cls: 'ks-signal ks-login' });
		objs.checkSignal.show();
		objs.checkSignal.hide();
		return objs.checkSignal;
	},
	getRashDate: function() {
		var prevValue = '';

		return objs.rashDate = Ext.create('Ext.form.field.Date',
			{
				fieldLabel: KS.L10n.raschetnayadata,
				margin: '0 15px 0 0',
				flex: 1,
				width: 210,
				minWidth: 210,
				maxWidth: 210,
				format: 'd.m.Y',
				//hideTrigger: false,
				minValue: '01.01.1900',
				maxValue: '31.12.2100',
				listeners: {
					blur: function(th) {
						var newValue = th.getValue();

						if (!Ext.Date.isEqual(newValue, prevValue)) {
							ajaxRequest({
								params: {
									currentDate: newValue.toDateString()
								},
								url: '/Data/ChangeRashDate_A',
								callback: function(result) {
									if (result && result.result) {
										prevValue = newValue;

										var needReloadTabs = window.tabView.items.items;

										if (needReloadTabs && needReloadTabs.filter) {
											needReloadTabs = needReloadTabs.filter(function(tab) {
												return HeadLib.needRefreshThisDicts.indexOf(tab.code) !== -1;
											});

											Ext.each(needReloadTabs,
												function(tab) {
													tab.dict && tab.dict.refresh && tab.dict.refresh(true);
												});
										}
									}

								}
							});
						}

					}
				}
			});
	},
	getBusinessPeriod: function() {
		return objs.businessPeriod =Ext.create('Keysystems.Controls.KsPeriod', {
			fieldLabel: 'Период',
			labelWidth: 55,
			state: 8,
			allStates: 8,
			width: 290,
			margin: '0 15px 0 0',
			ignoreColorize: true,
			listeners: {
				ksChange: function(dh1, dh2) {
					ajaxRequest({
						params: {
							businessPeriodDH1: dh1.toDateString(),
							businessPeriodDH2: dh2.toDateString()
						},
						url: '/Data/ChangeBussinessPeriod_A',
						callback: function (result) {
							
						}
					});
				}
			}
		})
	},
	
	getUserBtn: function() {
		return objs.userBtn = Ext.create('Ext.button.Split',
			{
				iconCls: 'x_btn_user',
				cls: 'ks-login',
				handler: function() {
					this.showMenu();
				},
				menu: new Ext.menu.Menu({
					width: 220,
					items: [
						{
							key: 'changePassword',
							text: KS.L10n.izmenenie_parolya,
							handler: function() {
								Ext.create('Keysystems.ChangePass', {
									closable: true,
								})
							}
						},
						{
							text: KS.L10n.rekvizitipolzovatelya,
							handler: function() {
								Ext.create('Keysystems.UserProperties');
							}
						},
						/*,
						{
							iconCls: 'x_btn_desktop',
							visible: window.isDebug,
							text: 'Создать рабочий стол',
							handler: function() { Desktop.add(); }
						}*/
					]
				})
			});
	},
	getLoginBtn: function() {
		return objs.loginBtn = Ext.create('Ext.Button', { cls: 'ks-login'});
	},
	getServiceBtn: function() {
		return objs.serviceBtn = Ext.create('Ext.button.Split',
			{
				text: 'Сервис',
				cls: 'ks-login',
				handler: function() {
					this.showMenu();
				},
				menu: new Ext.menu.Menu({
					width: 220,
					items: [
						{
							iconCls: 'x_btn_users',
							text: 'Пользователи',
							handler: function() {
								let tab = window.tabView.items.items.filter(tab => tab.code === dnl.USERS_ADM)[0];
								if (tab) {
									tab.show();
								} else {
									dictFunc({
										code: dnl.USERS_ADM,
										parentView: window.tabView,
										tabMode: true
									});
								}
							}
						},
						{
							iconCls: 'x_btn_user_groups',
							text: 'Группы пользователей',
							handler: function() {
								let tab = window.tabView.items.items.filter(tab => tab.code === dnl.GROUPS_ADM)[0];
								if (tab) {
									tab.show();
								} else {
									dictFunc({
										code: dnl.GROUPS_ADM,
										parentView: window.tabView,
										tabMode: true
									});
								}
							}
						}
					]
				})
			});
	},
	getAboutBtn: function() {
		return Ext.create('Ext.button.Split',
			{
				text: 'Справка',
				cls: 'ks-login',
				handler: function() {
					this.showMenu();
				},
				menu: new Ext.menu.Menu({
					width: 220,
					items: [
						{
							text: KS.L10n.oprogramme,
							handler: function() {
								Ext.create('AboutView').show();
							}
						}
					]
				})
			});
	},
	getNotificationBtn: function() {
		objs.notificationBtn = Ext.create('Ext.Button',
			{
				cls: 'ks-login',
				iconCls: 'x_btn_bell',
				tooltip: KS.L10n.tsentropoveshchenii,
				hidden: true,
				tooltipType: 'title',
				handler: function() {
					window.NotificationManager.Show();
				}
			});
		//красный круг рядом с кнопкой для новых оповещений
		objs.notificationBtn.on('render', (cmp) => {
			cmp.pnlNewNotify = Ext.create('Ext.panel.Panel',
				{
					hidden: true,
					border: false,
					bodyBorder: false,
					width: 8,
					height: 8,
					style:
						{
							borderWidth: '1px',
							borderStyle: 'solid',
							borderColor: '#FFF',
							backgroundColor: '#F83E33',
							borderRadius: '5px',
							left: '9px',
							top: '1px'
						},
					renderTo: cmp.btnIconEl
				})
		})
		return objs.notificationBtn;
	},

	getHeadPanel: function() {
		var me = this;
		me.init();
		return me.createPanel();
	},

	createPanel: function() {
		var me = this,
			strategy = me.strategy;

		return Ext.create('Ext.panel.Panel',
			strategy.appendBasePanelCfg({
				region: 'north',
				hidden: true,
				unstyled: true,
				cls: 'ribbon_header',
				padding: '0 0 5 0',
				layout: { type: 'hbox', align: 'stretch' },
				items: strategy.getItems()
			}));
	},

	strategyPC: {
		appendBasePanelCfg: function(cfg) {
			cfg.minHeight = 47;
			cfg.maxHeight = 47;
			return cfg;
		},
		getItems: function() {
			return [
				HeadLib.getIconBtn(),
				//{xtype: 'tbfill'},
				Ext.create('Ext.form.FieldContainer',
					{
						layout: { type: 'vbox', align: 'stretch' },
						flex: 3,
						padding: '0 0 5px 5px',
						items: [{xtype: 'tbfill'}, HeadLib.getVersionLabel()]
					}),				
				Ext.create('Ext.form.FieldContainer',
					{
						layout: { type: 'hbox', align: 'bottom' },
						items: [
							Ext.create('Ext.toolbar.Toolbar',{
								border: 0,			
								userCls: 'rks-head-toolbar',
								items: [
									HeadLib.getRashDate(),
									HeadLib.getBusinessPeriod(),
									HeadLib.getSignalRControl(),
									HeadLib.getUserBtn(),
									HeadLib.getServiceBtn(),
									HeadLib.getAboutBtn(),
									HeadLib.getNotificationBtn(),
									HeadLib.getLoginBtn()
								]
							})
							
						],
						
					})
			];
		}
	}
};

Ext.define('RevizorHead',
	{
		objs: undefined,
		pingIntervalId: null,
		DataSourceTypes: {},
		DatabaseList: {},
		constructor: function(cfg) {
			var me = this;

			me.objs = cfg.objs;

			Ext.EventManager.onWindowResize(function() {
				if (me.loginView) me.loginView.center();
			});

			window.SignalR.start(function() {
				me.printLoginLabel(false);
				ajaxRequest({
					url: '/Home/GetDBParams_A',
					timeout: 60000,
					params: {},
					success: (res) => {
						me.DataSourceTypes = res.DataSourceTypes;
						me.DatabaseList = res.DatabaseList;
						me.AllowCustomizeDB = res.AllowCustomizeDB;

						if (me.customizeDbPanel) {
							me.customizeDbPanel.setVisible(me.AllowCustomizeDB);
							me.setDBParams();
						}

						if (res.hasCertBtn) {
							me.btnOK.setMenu(Ext.create('Ext.menu.Menu', {
								items: [
									{
										text: KS.L10n.certLogin,
										handler: function () {
											me.certLogin();
										}
									}
								]
							}));
						}
						else {
							me.btnOK?.setArrowVisible(false);
						}
					}
				});
			})

			let expandDB = Ext.util.Cookies.get('expandDb');
			me.expandDB = !expandDB || +expandDB === 1;
		},
		printLoginLabel: function(isLogIn) {
			var me = this,
				objs = me.objs;
			if (isLogIn) {
				var loginLabel = Ext.util.Cookies.get('LoginLabel').split('</b>');
				objs.userBtn.setText(loginLabel[0]);
				objs.versionLbl.setText(loginLabel[1]);
				objs.loginBtn.setText(KS.L10n.viiti);
				objs.loginBtn.handler = function() {
					me.LogOut();
				};
			} else {
				objs.userBtn.setText('Гость');
				objs.loginBtn.setText('Вход');
				objs.loginBtn.handler = function() {
					me.showLoginView();
				};
			}
		},

		setDBParams: function() {
			const me = this;
			me.setValuesInProgress = true;
			
			const {
				DatabaseList,
				DefaultServer: server,
				DefaultBase: database,
				DataSourceType
			} = me.DatabaseList;

			me.selectDbCombo.bindStore(DatabaseList);

			const cookieDatabase = me.AllowCustomizeDB ? Ext.util.Cookies.get('dbValue') : null;
			const cookieServer = me.AllowCustomizeDB ? Ext.util.Cookies.get('serverValue') : null;
			const cookieDBType = me.AllowCustomizeDB ? Ext.util.Cookies.get('dataSourceType') : null;

			me.selectDbCombo.setValue(cookieDatabase || database);
			me.selectServer.setValue(cookieServer || server);
			me.selectDbType.setValue(cookieDBType || (DataSourceType + ''));

			me.setValuesInProgress = false;
		},

		authorize: function() {
			var me = this;

			me.fingerprint = new Fingerprint({ screen_resolution: true }).get();

			const serverValue = me.selectServer ? me.selectServer.getValue() : (Ext.util.Cookies.get('serverValue') || '');
			const dbValue = me.selectDbCombo ? me.selectDbCombo.getValue() : (Ext.util.Cookies.get('dbValue') || '');
			const dataSourceType = me.selectDbType ? me.selectDbType.getValue() : (Ext.util.Cookies.get('dataSourceType') || 0);

			const loadMask = new Ext.LoadMask({
				msg: KS.L10n.login_in_progress,
				target: me.loginView ?? window.RevizorHead.objs.mp,
				autoShow: true,
				rid: ajaxRequest({
					url: '/Home/Authorize_A',
					timeout: 60000,
					params: {
						login: Ext.util.Cookies.get('Login'),
						password: Ext.util.Cookies.get('pwd'),
						tokien: Ext.util.Cookies.get('tokien'),
						clientID: me.fingerprint,
						serverName: serverValue,
						dbName: dbValue,
						dataSourceType,
						certData: JSON.stringify(me.certData),
						esgfkLogin: Ext.util.Cookies.get('esgfkLogin'),
						esgfkPassword: Ext.util.Cookies.get('esgfkPassword')
					},
					success: function(result) {
						
						Ext.util.Cookies.clear('pwd');
						if (result.result) {
							window.cacheEngine = Ext.create('Keysystems.ux.CacheEngine');
							window.SignalR.bind(result.sessionId);
							window.globalVisible(true);

							var login = Ext.util.Cookies.get('Login'),
								date = new Date((new Date()).getTime() + cacheTime);
							Ext.util.Cookies.set('LoginLabel', result.title);
							Ext.util.Cookies.set('UserName', login, date);
							Ext.util.Cookies.set('dbVersion', result.dbVersion, date);
							Ext.util.Cookies.set('ClientID', me.fingerprint);
							Ext.util.Cookies.set('tokien', result.tokien);
							window.user = result.user;

							if (result.user.holidays) {
								var holidays = result.user.holidays,
									key = Object.keys(holidays)[0];

								holidays[key] = holidays[key].map(function(v) {
									return new Date(v).toString()
								});
							}

							me.addLoginList(login, date);

							//Заменил это на LocalStorage
							//window.profile.tree = result.treeSetts;
							window.profile.tree =
								LocalStorage.get(window.user.login + window.user.DataBase + 'WEB_NAVIGATOR_TREE');

							window.isOuter = result.isOuter;
							//добавление навигатора и других табов в навигатор - контейнер
							
							//данные навигатора грузим после захода в комплекс
							NavigatorLib.execute([], window.objs.navigator, 'subNavigator');
							//данные дерева проверяющих грузим после активации вкладки
							NavigatorLib.execute([], window.objs.navigator, 'sORGPTree');
							
							//добавление таба Почта
							if (result.mailInfo) {
								window.objs.mail = Ext.create('Keysystems.Revizor.Mail', {interval: result.mailInfo.interval * 1000});
								let tab =  window.objs.navigator.add(window.objs.mail.Tree);
								
								//надстройка над иконкой таба почти для отображения кол-ва непрочитанных
								window.objs.mail.createCounterWidget(tab);
								
								//центр оповещений
								window.NotificationManager = Ext.create('Keysystems.NotificationManager', {
									alignTarget: window.bodyPanel.body
								});
								//кнопка центра оповещений в верхней панели
								window.objs.notificationBtn.setVisible(true);
								//подписка на отображение центра оповещений для события получения новых писем
								window.NotificationManager.on({
									changeunradcount: (_, count) => {
										window.objs.notificationBtn.pnlNewNotify?.setVisible(count > 0);
									},
								});
								window.NotificationManager.show();
							}
							window.objs.navigator.setActiveTab(window.objs.subNavigator);

							me.objs.rashDate.setValue(result.currentDate);
							window.businessPeriod = {
								dh1: new Date(result.businessPeriod[0]),
								dh2: new Date(result.businessPeriod[1])
							};
							me.objs.businessPeriod.suspendEvents();
							me.objs.businessPeriod.setValue(window.businessPeriod.dh1, window.businessPeriod.dh2);
							me.objs.businessPeriod.resumeEvents();
							channelStart();
							window.link = result.link;
							window.serverNow = new Date(result.serverNow);
							window.dbNow = new Date(result.dbNow);
							me.printLoginLabel(true);
							window.isAuthorize = true;
							//настройка Общие - Пользовательские - Модальные окна редактирования
							window.modalEdit = result.modalEdit;
							window.checkStampInterval = +result.checkStampInterval;

							window.dbConfigName = result.dbConfigName;
							window.isRfn = result.dbConfigName === "RFN";
							window.useEDS = result.useEDS;
							if (result.useAuthorizationServer){
								const subMenuChangePwd = me.objs.userBtn?.menu?.items?.items?.filter(item=>item.key === 'changePassword')[0];
								subMenuChangePwd?.setHidden(true);
							}
							if (!window.user.isAdmin && !window.user.isSysAdmin){
								me.objs.serviceBtn?.setHidden(true);
							}
							//кэш для объектов, по которым уже были получены ресурсы
							window.cachedResources = {};
							window.render();
							objs.checkSignal.show();
							/*if (window.bgVideo.removeNode) window.bgVideo.removeNode();
							if (window.bgVideo.remove) window.bgVideo.remove();*/

							if (result.needChange) {
								var changePwdDialog = Ext.create('Keysystems.ChangePass'); //вызов окна смены пароля
								changePwdDialog.hideOldPassword();
								changePwdDialog.setTitle('Необходимо сменить пароль для входа в комплекс');
							}

							$(function() { // up session before sessionTimeOut. Set Start time after login
								window.ksPingFailure = 0;
								window.ksPingTimeout = 60000 * ((sessionTimeOut - 1) >= 1 ? (sessionTimeOut - 1) : 1);
								me.ping();
							});

							me.loginView?.close();
							loadMask.destroy();
							Desktop.show();

							//#region profile
							
							ajaxRequest({
								url: '/data/LoadProfileFromDb_A',
								ignoreError: true
							});

							//#endregion profile

							window.app.showDictList();
							//Если база данных не соответствует версии клиента-показываем сообщение (1 раз за сессию пользователя)
							if (result.infoMsg &&
								result.infoMsg.length &&
								(Ext.util.Cookies.get('dbVersionInfo') === result.sessionId)) {
								info(result.infoMsg);
								Ext.util.Cookies.set('dbVersionInfo', result.sessionId);
							}
                            if (window.isDebug && window.afterLoginDebugHandler) window.afterLoginDebugHandler();
                        } else {
							loadMask.destroy();
							
							const nextFn = () => {
								//Ext.util.Cookies.clear('Login');
								Ext.util.Cookies.clear('tokien');
								me.printLoginLabel(false);
								window.isAuthorize = false;
								
								if (!me.loginView) {
									me.showLoginView();
									me.customizeDbPanel.setVisible(me.AllowCustomizeDB);
									me.setDBParams();
								}
							}
							if (result.errorMsg) {
								info(result.errorMsg, nextFn);
							}
							else 
								nextFn();
							
						}
					},
					failure: function() {
						loadMask.destroy();
					},
					callback: function() {
						me.certData = _;
					}
				})
			});
		},
		
		pingBack: function(success) {
			var me = this;
			if (!success) {
				window.ksPingFailure++;
				if (window.ksPingFailure > 2) {
					try {
						if (!window.isDebug) $(window).off('beforeunload', window.beforeunloadFn);
						window.isAuthorize = false;
						channelStop = true;
						if (window.ksDontRelod) return;
						location.reload();
					} catch (ex) {
					}
				}
			}
			me.ping();
		},
		ping: function() {
			var me = this;
			me.pingTimeoutId = setTimeout(function() {
					ajaxRequest({
						url: '/Home/Ping_A',
						callback: function(r) {
							me.pingBack(r === true);
						}
					});
				},
				window.ksPingTimeout);
		},
		addLoginList: function(login, date) {
			var llJson = Ext.util.Cookies.get('LoginList'),
				loginList = llJson ? jQuery.parseJSON(llJson) : [];
			if (Ext.Array.indexOf(loginList, login) == -1) {
				loginList.push(login);
				llJson = JSON.stringify(loginList);
				Ext.util.Cookies.set('LoginList', llJson, date);
			}
		},
		getLoginPas: function() {
			var me = this;
			Ext.util.Cookies.set('Login', me.tLogin.getValue());
			Ext.util.Cookies.set('pwd', me.tPassword.getValue());

			const dataSourceType = me.selectDbType ? me.selectDbType.getValue() : 0;
			const serverValue = me.selectServer ? me.selectServer.getValue() : '';
			const dbValue = me.selectDbCombo ? me.selectDbCombo.getValue() : '';

			Ext.util.Cookies.set('dataSourceType', dataSourceType);
			Ext.util.Cookies.set('serverValue', serverValue);
			Ext.util.Cookies.set('dbValue', dbValue);

			//validate if login is null or empty
			if (me.tLogin.getValue() == null || me.tLogin.getValue().replace(/^\s+|\s+$/gm, '') == '') {
				me.tLogin.getEl().frame("#0000b9", 1, { duration: 1000 });
				me.tLogin.focus();
				return;
			}

			me.authorize();
		},
		saveExpandDbState: function (expandDb) {
			Ext.util.Cookies.set('expandDb', expandDb);
		},
		renderHead: function() {
			var me = this;
			if (!window.isAuthorize) {
				if (Ext.util.Cookies.get('Login') && Ext.util.Cookies.get('tokien')) {
					me.authorize();
				} else {
					me.printLoginLabel(false);
					me.showLoginView();
				}
			}
		},
		showLoginView: function() {
			var me = this,
				llJson = Ext.util.Cookies.get('LoginList'),
				loginList = llJson ? jQuery.parseJSON(llJson) : [];

			me.loginView = Ext.create('Ext.Window',
				{
					resizable: false,
					draggable: true,
					closable: false,
					iconCls: 'x_btn_keysystems',
					id: 'LoginView',
					//cls: 'ks-login',
					border: 0,
					modal: true,
					title: KS.L10n.authorization + (isDebug.toLowerCase() === 'true' ? ' [DEBUG]' : ''),
					autoHeight: true,
					plain: true,
					shadow: false,
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						Ext.create('Ext.panel.Panel',
							{
								width: 112,
								height: 238,
								hidden: true,
								border: 0,
								bodyCls: 'x_login1'
							}),
						Ext.create('Ext.form.FieldContainer',
							{
								layout: { type: 'vbox', align: 'stretch' },
								items: [
									Ext.create('Ext.panel.Panel',
										{
											width: 410,
											height: 65,
											//hidden: true,
											cls: 'ks-login',
											border: 0,
											bodyCls: 'x_login_head'
										}),
									Ext.create('Ext.panel.Panel',
										{
											frame: true,
											//height: 167,
											bodyStyle: 'padding:10px 10px 0;',
											flex: 1,
											buttonAlign: 'right',
											border: false,
											buttons: [
												me.btnOK = Ext.create('Ext.button.Split',
													{
														id: 'btnOK',
														text: KS.L10n.login,
														userCls: 'rks-split-button rks-split-button-login',
														tabIndex: 7,
														handler: function() {
															me.getLoginPas();
														}
													}),
												Ext.create('Ext.Button',
													{
														text: KS.L10n.otmena,
														hidden: true,
														handler: function() {
															if (!window.isDebug)
																$(window).off('beforeunload', window.beforeunloadFn);
															window.open(window.location, '_self').close();
														}
													}),
												Ext.create('Ext.Button',
													{
														iconCls: 'x_btn_keysystems',
														tooltip: 'Debug',
														// ReSharper disable UseOfImplicitGlobalInFunctionScope
														hidden: !(window.isDebug && window.debugBtnHandler2),
														// ReSharper restore UseOfImplicitGlobalInFunctionScope
														tooltipType: 'title',
														text: 'Debug',
														handler: function() {
															debugBtnHandler2();
														}
													})
											],
											items: [
												{
													xtype: 'fieldset',
													border: false,
													defaultType: 'textfield',
													layout: { type: 'vbox', align: 'stretch' },
													collapsible: false,
													autoHeight: true,
													defaults: {
														anchor: '95%',
														selectOnFocus: true,
														labelAlign: 'right',
														labelSeparator: '',
														labelStyle: 'font-weight:bold;'
													},
													items: [
														me.tLogin = Ext.create('Ext.form.field.ComboBox',
															{
																tabIndex: 1,
																fieldLabel: KS.L10n.user,
																store: loginList,
																emptyText: 'имя пользователя',
																autofocus: true,
																value: Ext.util.Cookies.get('Login') ||
																	Ext.util.Cookies.get('UserName'), // || 'revizor_admin',
																allowBlank: false,
																selectOnFocus: true,
																listeners: {
																	specialkey: function(field, e) {
																		if (e.getKey() === e.ENTER) {
																			me.getLoginPas();
																		}
																	}
																}
															}),
														me.tPassword = Ext.create('Ext.form.field.Text',
															{
																fieldLabel: KS.L10n.password,
																emptyText: KS.L10n.password,
																tabIndex: 2,
																inputType: 'password',
																selectOnFocus: true,
																//value: '1',
																listeners: {
																	specialkey: function(field, e) {
																		if (e.getKey() === e.ENTER) {
																			if (me.tLogin.getValue()) {
																				me.getLoginPas();
																			} else {
																				me.tLogin.focus();
																			}
																		}
																	}
																}
															})
													]
												},
												me.customizeDbPanel = Ext.create('Ext.form.FieldSet',
													{
														title: KS.L10n.db_settings,
														defaultType: 'textfield',
														collapsible: true,
														collapsed: !me.expandDB,
														hidden: !me.AllowCustomizeDB,
														layout: { type: 'vbox', align: 'stretch' },
														autoHeight: true,
														defaults: {
															anchor: '95%',
															labelAlign: 'right',
															labelStyle: 'font-weight:bold;'
														},
														listeners: {
															collapse: function() {
																me.saveExpandDbState(0);
															},
															expand: function() {
																me.saveExpandDbState(1);
															}
														},
														items: [
															me.selectDbType = Ext.create('Ext.form.field.ComboBox',
																{
																	tabIndex: 4,
																	fieldLabel: KS.L10n.datasource_type,
																	mode: 'local',
																	editable: false,
																	allowBlank: false,
																	value: null,
																	triggerAction: 'all',
																	displayField: 'name',
																	valueField: 'type',
																	margin: '5px 0 5px 0',
																	store: Ext.create('Ext.data.Store',
																		{
																			fields: ['type', 'name'],
																			data: [
																				{
																					type: '0',
																					name: 'MSSQL'
																				},
																				{
																					type: '3',
																					name: 'POSTGRESQL'
																				}
																			]
																		}),
																	listeners: {
																		change: function(combo, type) {
																			me.selectDbCombo.store.clearFilter();
																			me.selectDbCombo.store.loadData(me.DatabaseList.DatabaseList);
																			me.selectDbCombo.store.filter([
																				{
																					property: 'Type',
																					value: type
																				}
																			]);

																			let currentServer = me.selectServer.getValue();
																			let currentDb = me.selectDbCombo.getValue();
																			
																			const dbList = me.selectDbCombo.store.getDataExt(_, _, true);
																			if (dbList && dbList.length) {
																				if (!currentDb && !currentServer){
																					currentServer = dbList[0].Server;
																					currentDb = dbList[0].Name;
																				}

																				let dbInConfig = !me.setValuesInProgress || me.DatabaseList.DatabaseList.filter(r=>r.Name === currentDb).length > 0;
																				if (dbInConfig) {
																					const dbInd = ArrayLib.find(dbList, ['Database'], currentDb);
																					if (dbInd && dbInd !== -1) {
																						me.selectDbCombo.setValue(dbList[dbInd].Database);
																					} else {
																						me.selectDbCombo.setValue(dbList[0].Database);
																					}
																				}

																				let serverInConfig = !me.setValuesInProgress || me.DatabaseList.DatabaseList.filter(r=>r.Server === currentServer).length > 0;
																				if (serverInConfig) {
																					const serverInd = ArrayLib.find(dbList, ['Server'], currentServer);
																					if (serverInd && serverInd !== -1) {
																						me.selectServer.setValue(dbList[serverInd].Server);
																					} else {
																						me.selectServer.setValue(dbList[0].Server);
																					}
																				}
																			} else {
																				me.selectServer.setValue(currentServer);
																				me.selectDbCombo.setValue(currentDb);
																			}

																			Ext.util.Cookies.set('dataSourceType', type);
																		}
																	}
																}),
															me.selectServer = Ext.create('Ext.form.field.Text',
																{
																	tabIndex: 5,
																	fieldLabel: KS.L10n.server,
																	id: 'frmServer',
																	allowBlank: false,
																	selectOnFocus: true,
																	value: ''
																}),
															me.selectDbCombo = Ext.create('Ext.form.field.ComboBox',
																{
																	fieldLabel: KS.L10n.database,
																	mode: 'local',
																	id: 'frmDb',
																	tabIndex: 6,
																	editable: true,
																	allowBlank: false,
																	minChars: 10000,
																	value: '',
																	triggerAction: 'all',
																	store: Ext.create('Ext.data.Store',
																		{
																			fields: [
																				'Database', 'Name', 'Server', 'Type'
																			],
																			data: [],
																			proxy: 'memory'
																		}),
																	valueField: 'Database',
																	displayField: 'Name',
																	listeners: {
																		select: function (combo, record) {
																			if (!record || !record.data) return;
																			const {
																				Server,
																				Database
																			} = record.data;

																			me.selectServer.setValue(Server);
																			Ext.util.Cookies.set('dbValue', Database);
																			Ext.util.Cookies.set('serverValue', Server);
																		},
																		specialkey: function(field, e) {
																			if (e.getKey() === e.ENTER) {
																				if (me.tLogin.getValue()) {
																					me.getLoginPas();
																				} else {
																					me.tLogin.focus();
																				}
																			}
																		}
																	}
																})
														]
													})
											]
										})
								]
							})
					]
				});
			
			if (me.AllowCustomizeDB) {
				me.setDBParams();
			}

			me.loginView.show();
			me.loginView.center();
		},
		LogOut: function() {
			var me = this;
			selectDialogShow(KS.L10n.attention,
				KS.L10n.question_exit,
				function() {
					Ext.util.Cookies.clear('tokien');
					Ext.util.Cookies.clear('pwd');

					NavigatorLib.cleanLocalData();

					if (me.pingTimeoutId != null) {
						clearTimeout(me.pingTimeoutId); //put stop to ping session
					}

					ajaxRequest({
						url: '/Home/LogOut_A',
						//timeout: 3000,
						callback: function() {
							if (!window.isDebug) {
								$(window).off('beforeunload', window.beforeunloadFn);
							}
							window.isAuthorize = false;
							channelStop = true;
							location.reload();
						}
					});
				});
		},
		
		certLogin: function() {
			let me = this;
			
			const loadMask = new Ext.LoadMask({
				msg: 'Получение дополнительных параметров',
				target: me.loginView,
				autoShow: true,
				rid: ajaxRequest({
					url: '/Data/GetSignSettings_A',
					success: function(result) {
						if (result.signSettings) {
							KS.edsType = result.edsType;
							me.doCertLogin(result.signSettings);
						}
					},
					callback: function() {
						loadMask.destroy();
					}
				})
			});
		},

		doCertLogin: function(signSettings) {
			KS.apply(signSettings, {
				noNeedFilter: true,
				noNeedParams: true,
				noNeedReestr: true,
				onLogin: true,
				NastrKeyId: '',
				target: this.loginView
			});
			KS.XCrypt.viewContext = this;
			KS.XCrypt.initialize(signSettings, this.getCertificates, this, 'login');
		},

		getCertificates: function() {
			KS.XCrypt.selectCertificate(this.certificateSelected, this);
		},

		certificateSelected: function(data) {
			let sessionId = KS.XCrypt.signSettings.sessionId;
			this.certLoginArgs = {
				loginMode: 'certificate',
				text: sessionId,
				serial: data.serial
			}
			KS.XCrypt.sign(sessionId, data.serial, 0, 0, this.afterSigned, this);
		},

		afterSigned: function(sign) {
			KS.apply(this.certLoginArgs, {
				sign: sign
			});
			this.executeLogin(this.certLoginArgs);
		},

		executeLogin: function (loginArgs) {
			let me = this;
			
			KS.apply(loginArgs, {
				browserName: KS.browser.name,
				browserVersion: KS.browser.version,
				appUri: window.location.href
			});

			me.certData = loginArgs;
			
			Ext.util.Cookies.set('Login', me.tLogin.getValue());
			me.authorize();
		},

		checkHavePassword: function () {
			var sp = KS.getCookie('sp');
			this.hasPassCookie = sp != null && !$.string(sp).empty();
			this.storedPassword = sp;
		}
	});

export default HeadLib;