﻿Ext.define('Keysystems.GroupsAdm.List', {
    extend: 'Keysystems.UsersAdm.List',
    
    multiSelectGridVisible: false,
    hidePagging: true,
    ignoreLoadNextPrevPages: true,
    profileLinkCode: 'GroupsAdm',

    viewCfg: function() {
        let me = this,
            res = me.callParent(arguments);

        delete res.dict;
        res.tabID = 'PLT_GROUPS_ADM';

        return res;
    },
    createTBar: function() {
        let me = this,
            res = me.callParent(arguments);

        if (me.viewMode === 'viewShow') {
            for (var btn in me.objs.tbarBtns) {
                if (['mark_plt', 'unmark_plt', 'refresh_plt'].indexOf(me.objs.tbarBtns[btn].code) === -1) {
                    me.objs.tbarBtns[btn].setHidden(true);
                }
            }
        }
        
        return res;
    },
    baseGetData: function(endFunc, params) {
        let me = this;

        if (!params) {
            params = {};
        }
        params.contextSearch = me.contextSearch || '';
        params.excludeLinks = me.excludeLinks || [];
        
        me.callParent(arguments);
    },
    getRowClass: Ext.emptyFn,
    lockUser: function() {
        let me = this;

        me.ajaxFunc({
            msg: 'Блокирование пользователей',
            url: '/LockUsers_A',
            errorText: 'Ошибка при блокировании пользователей',
            params: {
                type: 'G',
                mode: 'set'
            }
        });
    },
    unlockUser: function() {
        let me = this;

        me.ajaxFunc({
            msg: 'Разблокирование пользователей',
            url: '/LockUsers_A',
            errorText: 'Ошибка при разблокировании пользователей',
            params: {
                type: 'G',
                mode: 'reset'
            }
        });
    },
    refresh: function(reload, hideMsg) {
        let me = this;

        me.showLoadMask({
            msg: KS.L10n.updating_data,
            rid: me.ridGet = ajaxRequest({
                url: me.linkCode + '/Get_A',
                params: {
                    gzipData: SignalR.pack({
                        contextSearch: me.contextSearch,
                        excludeLinks: JSON.stringify(me.excludeLinks),
                        reload: true
                    })
                },
                success: function (data) {
                    me.objs.Grid.store.loadData(data.data.data);
                    me.dataCount = data.data.total;
                    me.setChecks(me.checkList,  me.objs.Grid.store.getData().items);
                    if (!me.Grid.selModel.getSelected().length) {
                        me.Grid.extraSelectFrst();
                    }
                    me.hideLoadMask();
                },
                failure: function (response) {
                    console.error(response);
                    me.loadMask.setErrorState();
                },
                callback: function () {
                    delete me.ridGet;
                }
            }),
            cancelFn: function () {
                if (me.ridGet) SignalR.delCallBack(me.ridGet);
            }
        });
    }
});