Ext.define('Keysystems.GroupsAdm.Edit', {
    extend: 'Keysystems.UsersAdm.Edit',

    hideControlBtn: true,
    
    getViewTitle: function() {
        return dictListController.DICTIONARY_GROUPS_ADM.title;
    },
    viewCfg: function() {
        let me = this,
            res = me.callParent(arguments);
        
        me.objs.viewCfg.tabLink = me.f !== 'copy' && me.data ? me.data.data.UID : -1;
        
        return res;
    },
    loadNewData: function() {
        let me = this;
        this.setLink(-1);
    },
    loadNewCopyData: function() { this.setLink(-1); },
    loadCopyEditData: function() {
        let me = this;

        me.setLink(me.data.data.UID);
    },
    createTBar: function() {
        let me = this,
            objs = me.objs,
            res = me.callParent(arguments),
            saveBtn = res.splice(0, 1);
        
        res.unshift(me.sksc('saveBtn', objs.saveBtn = Ext.create('Ext.button.Split', {
            tooltip: 'Сохранить',
            tooltipType: 'title',
            iconCls: 'x_btn_save',
            menu: [
                {
                    text: 'Сохранить',
                    iconCls: 'x_btn_save',
                    handler: saveBtn[0].handler
                },
                {
                    iconCls: 'x_btn_save_and_close',
                    text: 'Выполнить',
                    handler: function() {
                        me.needClose = true;
                        saveBtn[0].handler.call(this, arguments);
                    }
                }
            ],
            handler: saveBtn[0].handler
        })));
        
        return res;
    },
    addGridRecord: function(gridName, cfg, linkField = 'LINK') {
        let me = this,
            grid = me.gksc(gridName),
            sel = [],
            itms = grid.store.data.items,
            len = itms.length,
            i = 0,
            settings = {
                parentView: me.objs.view,
                controlName: gridName + 'Add',
                selectLinks: sel,
                fieldLink: linkField
            };

        Ext.apply(settings, cfg);
    
        for (; i < len; i++) {
            let rec = { data: {} };
            rec.data[linkField] = itms[i].data[linkField];
            sel.push(rec);
        }
        
        dictFunc(settings, {
            ok: function(value) {
                let j = 0,
                    store = grid.store;

                for (len = value.length; j < len; j++) {
                    if (ArrayLib.find(itms, ['data', linkField], value[j].data[linkField]) === -1) {
                        let newRec = store.add({})[0];

                        newRec.beginEdit();
                        Ext.each(Object.keys(newRec.data), field => {
                            if (['CHECKED', 'id'].indexOf(field) === -1 && value[j].data.hasOwnProperty(field)) {
                                newRec.data[field] = value[j].data[field];
                            }
                        });
                        newRec.endEdit();
                    }
                }

                let dels = [];
                for (j = 0, len = itms.length; j < len; j++) {
                    if (ArrayLib.find(value, ['data', linkField], itms[j].data[linkField]) === -1) {
                        dels.push(itms[j]);
                    }
                }

                store.remove(dels);

                if (!grid.getSelectionModel().getSelection().length) {
                    grid.extraSelectFrst();
                }
            }
        });
    },
    removeGridRecord: function(grid) {
        let me = this,
            store = grid.getStore(),
            selModel = grid.getSelectionModel(),
            sel = selModel.getSelection(),
            checkRecs = store.data.items.filter(d => d.data.CHECKED),
            recs = checkRecs.length ? checkRecs : selModel.getSelection();

        if (recs.length) {
            let index = store.indexOf(sel[0]);
            store.remove(recs);
            selModel.selectByPosition({
                row: store.data.length > index ? index : store.data.length - 1
            });
        }
    },
    checkInversion: function(grid, value) {
        grid.store.each(function(rec) { rec.set('CHECKED', value !== _ ? value : !rec.get('CHECKED')); });
    },
    checkFstToSel: function(grid, reverse) {
        let me = this,
            sel = grid.getSelectionModel().getSelection();
        
        if (sel.length) {
            Ext.each(grid.store.data.items, function(rec) {
                if (!sel.length) return false;
                rec.set('CHECKED', true);
                ArrayLib.remove(sel, rec);
                return true;
            }, _, reverse);
        } else {
            me.checkInversion(grid, true);
        }
    },
    checkCheckToCheck: function(grid) {
        let me = this,
            store = grid.getStore(),
            frst = false,
            last = false;

        store.each(function(rec) {
            if (rec.get('CHECKED')) {
                if (!frst) frst = rec;
                last = rec;
            }
        });

        if (frst) {
            let start = store.indexOf(frst),
                end = store.indexOf(last);

            Ext.each(store.getRange(start, end), function(rec) { rec.set('CHECKED', true); });
        }
    },
    searchAndReplace: function(grid) {
        let me = this;

        Ext.create('Revizor.BatchChange',
            {
                title: `Поиск и замена (${grid.batchProps[0].CaptionText}): Все записи`,
                parentView: me.parentView,
                code: '',
                isPlatform: true,
                generateElements: function() {
                    let th = this,
                        cfg = {
                            DataType: 'String',
                            AllowDBNull: true,
                            AllowedConditions: ['0', '1']
                    };
                    th.batchProps = [];
                    
                    Ext.each(grid.batchProps, prop => th.batchProps.push(Ext.apply(prop, cfg)));

                    th.createItems();
                    th.cmbPropReplace.setValue(th.batchProps[0].Name);
                },
                controlChange: Ext.emptyFn,
                createTypedControls: function(prop) {
                    let th = this;
                    
                    th.callParent(arguments);

                    let cbCondition = th.gksc('FROM_VALUE_' + prop.Name).cbCondition;
                    cbCondition && cbCondition.setHidden(true);
                    th.gksc('FREE_VALUE_' + prop.Name).setValue(true);
                },
                genControlByElement: function(el) {
                    let propertyValues = JSON.parse(el.PropertyValues),
                        cfg = dictListController[propertyValues.Code];
                    
                    switch (miscTypes.ControlType[el.ControlType]) {
                        case 'Dictionary':
                            let dictEdit = Ext.create('Keysystems.Controls.DictName.Edit', {
                                clear: function () {
                                    dictEdit.change && dictEdit.change();
                                },
                                code: propertyValues.Code,
                                mode: el.mode ? el.mode : propertyValues.Action === 2 ? 'MULTI' : 'SINGL',
                                handler: function() {
                                    let cfg = {
                                        code: propertyValues.Code,
                                        mode: dictEdit.mode,
                                        checkList: dictEdit.getValue().slice(),
                                        parentView: me,
                                        controlName: el.Name,
                                        control: dictEdit,
                                        contextSearch: dictEdit.contextSearch,
                                    };
                                    
                                    Ext.apply(cfg, el.cfg);
                                    
                                    dictFunc(cfg, {
                                        ok: function (v) {
                                            dictEdit.setValue(v);
                                            dictEdit.change && dictEdit.change(dictEdit.getValue());
                                        }
                                    }, function(form) {
                                        if (dictEdit.contextSearch) {
                                            let field = dictEdit.fieldCode || dictEdit.fieldName || dictEdit,
                                                oldValue = dictEdit.fieldCode || dictEdit.fieldName
                                                    ? dictEdit.getOldContextValue(dictEdit.fieldCode ? dictEdit.codeField : dictEdit.nameField)
                                                    : dictEdit.originalValue;

                                            field.setValue(oldValue);
                                        }
                                    });
                                }
                            });
                    
                            return dictEdit;
                            break;
                        default:
                            return this.callParent(arguments);
                            break;
                    }
                },
                submit: function() {
                    let th = this,
                        propName = th.cmbPropReplace.getValue(),
                        prop = th.batchProps.filter(p => p.Name === propName)[0],
                        records = grid.store.data.items,
                        filterRecs = [],
                        linkField = prop.linkField ?? 'LINK';
                    
                    if (!propName || !prop) {
                        info(wmc.get('EmptyBatchProp'));
                        return false;
                    }

                    let freeValueEl = th.gksc('FREE_VALUE_' + propName),
                        fromEmptyEl = th.gksc('FROM_EMPTY_VALUE_' + propName),
                        fromValueEl = th.gksc('FROM_VALUE_' + propName),
                        filterVal = fromValueEl.getValue(),
                        emptyValueEl = th.gksc('TO_EMPTY_VALUE_' + propName),
                        toValueEl = th.gksc('TO_VALUE_' + propName),
                        newVal = toValueEl.getValue();
                    
                    // Найти: произвольное значение
                    if (freeValueEl.getValue()) {
                        filterRecs = records;
                    }
                    
                    // Найти: пустое значение
                    if (fromEmptyEl.getValue()) {
                        filterRecs = records.filter(r => !r.get(propName.toUpperCase()).length);
                    }
                    
                    // Найти: фильтр по значениям
                    if (filterVal.length) {
                        if (prop.ControlType === 6) {
                            let lst = [];
                            Ext.each(filterVal, v => lst.push(v.get(linkField)));
                            filterRecs = records.filter(r => lst.indexOf(r.get(linkField)) !== -1);
                        } else if (prop.ControlType === 5) {
                            filterRecs = records.filter(r => r.get(propName.toUpperCase()) === filterVal);
                        }
                    }
                    
                    if (!filterRecs.length) {
                        th.close();
                        return;
                    }
                    
                    if (newVal.length) {
                        if (prop.AllowEmptyStartValue) {
                            Ext.each(filterRecs, r => {
                                r.beginEdit();
                                r.set(propName.toUpperCase(), newVal);
                                r.endEdit();
                            })
                        } else {
                            // удалим отфильтрованные записи, т.к. не может быть несколько записей с одним и тем же значением
                            grid.store.remove(filterRecs);
                            // добавим одну запись
                            let newRec = grid.store.add({})[0];

                            newRec.beginEdit();
                            for (var field in newRec.data) {
                                if (field !== 'id') {
                                    newRec.set(field, newVal[0].get(field));
                                }
                            }
                            newRec.endEdit();
                        }
                    } else {
                        // Заменить на: пустое значение
                        if (prop.AllowEmptyStartValue) {
                            Ext.each(filterRecs, r => {
                                r.beginEdit();
                                r.set(propName.toUpperCase(), '');
                                r.endEdit();
                            })
                        } else {
                            // если не допустимы пустые значения, просто удаляем из грида записи,
                            // так как они теперь с пустым значением
                            grid.store.remove(filterRecs);
                        }
                    }
                    
                    th.close();
                }
            }).show();
    },
    getExclLinks: function(isParent) {
        let me = this,
            links = [me.getLink()];
        
        if (isParent) {
            Ext.each(me.gksc('gridSubGroups').store.getDataExt(), d => {
                links.push(d.UID);
            });
        } else {
            Ext.each(me.gksc('gridParentGroups').store.getDataExt(), d => {
                links.push(d.UID);
            });
        }
        
        return links;
    },
    createItems: function(items) {
        let me = this,
            objs = me.objs;

        return me.objs.items = [
            me.sksc('NAME', Ext.create('Ext.form.field.Text', {
                labelWidth: me.labelWidth,
                fieldLabel: 'Наименование группы',
                ksAllowEmpty: true,
                msgTarget: 'side',
                allowBlank: false,
                maxLength: 64,
                maxWidth: 700
            })),
            Ext.create('Ext.form.FieldContainer', {
                layout: {type: 'hbox', align: 'stretch'},
                items: [
                    me.sksc('NOTE', Ext.create('Ext.form.field.Text', {
                        labelWidth: me.labelWidth,
                        fieldLabel: 'Примечание',
                        maxLength: 250,
                        width: 700
                    })),
                    me.sksc('chbGroup', Ext.create('Ext.form.field.Checkbox', {
                        hideLabel: true,
                        boxLabel: 'Группа настроек',
                        padding: '0 0 0 15'
                    }))
                ]
            }),
            Ext.create('Ext.tab.Panel', {
                flex: 1,
                padding: '5 0 0 0',
                items: [
                    me.sksc('tabSubGroups', Ext.create('Ext.panel.Panel', {
                        title: 'Подгруппы',
                        items: [
                            me.sksc('gridSubGroups', Ext.create('Ext.grid.Panel', {
                                flex: 3,
                                minHeight: 120,
                                border: 0,
                                columnLines: true,
                                batchProps: [{
                                    ControlType: 6,
                                    Name: 'Name',
                                    CaptionText: 'Наименование',
                                    DictCode: 'DICTIONARY_GROUPS_ADM',
                                    linkField: 'UID',
                                    PropertyValues: JSON.stringify({Code: 'DICTIONARY_GROUPS_ADM', Action: 2})
                                }],
                                lbar: [
                                    me.sksc('btnAddSubGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_add_element',
                                        tooltip: 'Добавить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.addGridRecord('gridSubGroups', {
                                                code: dnl.GROUPS_ADM,
                                                excludeLinks: me.getExclLinks()
                                            }, 'UID');
                                        }
                                    })),
                                    me.sksc('btnRemoveSubGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_delete_element',
                                        tooltip: 'Удалить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.removeGridRecord(me.gksc('gridSubGroups'));
                                        }
                                    })),
                                    { 
                                        xtype: 'tbseparator'
                                    },
                                    me.sksc('btnInverseSubGroups', Ext.create('Ext.button.Split',
                                        {
                                            iconCls: 'x_btn_galka',
                                            tooltip: 'Инверсия',
                                            tooltipType: 'title',
                                            disabled: true,
                                            menu: [
                                                {
                                                    text: 'Инверсия',
                                                    iconCls: 'x_btn_galka',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridSubGroups'));
                                                    }
                                                }, {
                                                    text: 'Отметить все',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridSubGroups'), true);
                                                    }
                                                }, {
                                                    text: 'С начала до текущей',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridSubGroups'));
                                                    }
                                                }, {
                                                    text: 'С текущей до конца',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridSubGroups'), true);
                                                    }
                                                }, {
                                                    text: 'Между отмеченными',
                                                    handler: function() {
                                                        me.checkCheckToCheck(me.gksc('gridSubGroups'));
                                                    }
                                                }
                                            ],
                                            handler: function() {
                                                me.checkInversion(me.gksc('gridSubGroups'));
                                            }
                                        })),
                                    me.sksc('btnUnmarkSubGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_unmark',
                                        tooltip: 'Разметить все',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.checkInversion(me.gksc('gridSubGroups'), false);
                                        }
                                    })),
                                    me.sksc('btnSearchReplaceSubGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_search-replace',
                                        tooltip: 'Поиск и замена',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.searchAndReplace(me.gksc('gridSubGroups'));
                                        }
                                    }))
                                ],
                                store: Ext.create('Ext.data.Store', {
                                    fields: [],
                                    data: [],
                                    proxy: 'memory'
                                }),
                                listeners: {
                                    selectionchange: function(th, selected) {
                                        let sels = me.gksc('gridSubGroups').selModel.getSelection();
                                        me.gksc('btnInverseSubGroups').setDisabled(!sels.length);
                                        me.gksc('btnUnmarkSubGroups').setDisabled(!sels.length);
                                        me.gksc('btnSearchReplaceSubGroups').setDisabled(!sels.length);
                                    }
                                }
                            }))
                        ]
                    })),
                    me.sksc('tabUsers', Ext.create('Ext.panel.Panel', {
                        title: 'Пользователи в группе',
                        items: [
                            me.sksc('gridUsers', Ext.create('Ext.grid.Panel', {
                                flex: 3,
                                minHeight: 120,
                                border: 0,
                                columnLines: true,
                                batchProps: [{
                                    ControlType: 6,
                                    Name: 'Name',
                                    CaptionText: 'Имя входа',
                                    DictCode: 'DICTIONARY_USERS_ADM',
                                    linkField: 'UID',
                                    PropertyValues: JSON.stringify({Code: 'DICTIONARY_USERS_ADM', Action: 2}),
                                    cfg: {docCode: dnl.GROUPS_ADM}
                                }],
                                lbar: [
                                    me.sksc('btnAddUsers', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_add_element',
                                        tooltip: 'Добавить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.addGridRecord('gridUsers', {
                                                code: dnl.USERS_ADM,
                                                docCode: dnl.GROUPS_ADM
                                            }, 'UID');
                                        }
                                    })),
                                    me.sksc('btnRemoveUsers', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_delete_element',
                                        tooltip: 'Удалить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.removeGridRecord(me.gksc('gridUsers'));
                                        }
                                    })),
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    me.sksc('btnInverseUsers', Ext.create('Ext.button.Split',
                                        {
                                            iconCls: 'x_btn_galka',
                                            tooltip: 'Инверсия',
                                            tooltipType: 'title',
                                            disabled: true,
                                            menu: [
                                                {
                                                    text: 'Инверсия',
                                                    iconCls: 'x_btn_galka',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridUsers'));
                                                    }
                                                }, {
                                                    text: 'Отметить все',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridUsers'), true);
                                                    }
                                                }, {
                                                    text: 'С начала до текущей',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridUsers'));
                                                    }
                                                }, {
                                                    text: 'С текущей до конца',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridUsers'), true);
                                                    }
                                                }, {
                                                    text: 'Между отмеченными',
                                                    handler: function() {
                                                        me.checkCheckToCheck(me.gksc('gridUsers'));
                                                    }
                                                }
                                            ],
                                            handler: function() {
                                                me.checkInversion(me.gksc('gridUsers'));
                                            }
                                        })),
                                    me.sksc('btnUnmarkUsers', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_unmark',
                                        tooltip: 'Разметить все',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.checkInversion(me.gksc('gridUsers'), false);
                                        }
                                    })),
                                    me.sksc('btnSearchReplaceUsers', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_search-replace',
                                        tooltip: 'Поиск и замена',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.searchAndReplace(me.gksc('gridUsers'));
                                        }
                                    }))
                                ],
                                store: Ext.create('Ext.data.Store', {
                                    fields: [],
                                    data: [],
                                    proxy: 'memory'
                                }),
                                listeners: {
                                    selectionchange: function(th, selected) {
                                        let sels = me.gksc('gridUsers').selModel.getSelection();
                                        me.gksc('btnInverseUsers').setDisabled(!sels.length);
                                        me.gksc('btnUnmarkUsers').setDisabled(!sels.length);
                                        me.gksc('btnSearchReplaceUsers').setDisabled(!sels.length);
                                    }
                                }
                            }))
                        ]
                    })),
                    me.sksc('tabParentGroups', Ext.create('Ext.panel.Panel', {
                        title: 'Родительские группы',
                        items: [
                            me.sksc('gridParentGroups', Ext.create('Ext.grid.Panel', {
                                flex: 3,
                                minHeight: 120,
                                border: 0,
                                columnLines: true,
								batchProps: [{
                                    ControlType: 6,
                                    Name: 'Name',
                                    CaptionText: 'Наименование',
                                    DictCode: 'DICTIONARY_GROUPS_ADM',
                                    linkField: 'UID',
                                    PropertyValues: JSON.stringify({Code: 'DICTIONARY_GROUPS_ADM', Action: 2})
                                }],
                                lbar: [
                                    me.sksc('btnAddParentGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_add_element',
                                        tooltip: 'Добавить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.addGridRecord('gridParentGroups', {
                                                code: dnl.GROUPS_ADM,
                                                excludeLinks: me.getExclLinks(true)
                                            }, 'UID');
                                        }
                                    })),
                                    me.sksc('btnRemoveParentGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_delete_element',
                                        tooltip: 'Удалить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.removeGridRecord(me.gksc('gridParentGroups'));
                                        }
                                    })),
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    me.sksc('btnInverseParentGroups', Ext.create('Ext.button.Split',
                                        {
                                            iconCls: 'x_btn_galka',
                                            tooltip: 'Инверсия',
                                            tooltipType: 'title',
                                            disabled: true,
                                            menu: [
                                                {
                                                    text: 'Инверсия',
                                                    iconCls: 'x_btn_galka',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridParentGroups'));
                                                    }
                                                }, {
                                                    text: 'Отметить все',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridParentGroups'), true);
                                                    }
                                                }, {
                                                    text: 'С начала до текущей',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridParentGroups'));
                                                    }
                                                }, {
                                                    text: 'С текущей до конца',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridParentGroups'), true);
                                                    }
                                                }, {
                                                    text: 'Между отмеченными',
                                                    handler: function() {
                                                        me.checkCheckToCheck(me.gksc('gridParentGroups'));
                                                    }
                                                }
                                            ],
                                            handler: function() {
                                                me.checkInversion(me.gksc('gridParentGroups'));
                                            }
                                        })),
                                    me.sksc('btnUnmarkParentGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_unmark',
                                        tooltip: 'Разметить все',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.checkInversion(me.gksc('gridParentGroups'), false);
                                        }
                                    })),
                                    me.sksc('btnSearchReplaceParentGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_search-replace',
                                        tooltip: 'Поиск и замена',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.searchAndReplace(me.gksc('gridParentGroups'));
                                        }
                                    }))
                                ],
                                store: Ext.create('Ext.data.Store', {
                                    fields: [],
                                    data: [],
                                    proxy: 'memory'
                                }),
                                listeners: {
                                    selectionchange: function(th, selected) {
                                        let sels = me.gksc('gridParentGroups').selModel.getSelection();
                                        me.gksc('btnInverseParentGroups').setDisabled(!sels.length);
                                        me.gksc('btnUnmarkParentGroups').setDisabled(!sels.length);
                                        me.gksc('btnSearchReplaceParentGroups').setDisabled(!sels.length);
                                    }
                                }
                            }))
                        ]
                    }))
                ]
            })
        ];
    },
    getExtraNew: function (callBack) { this.getExtra(callBack, -1); },
    getExtra: function(callBack, link) {
        let me = this;

        me.baseGetExtra({ link: link }, function(value) {            
            let name = me.gksc('NAME'),
                isNew = me.gksd('link') < 0,
                isCopy = me.f === 'copy';
            
            name.setValue(value.row.NAME);
            me.gksc('NOTE').setValue(value.row.NOTE_ID);
            me.gksc('chbGroup').setValue(value.row.NASTR_ROLE);

            me.gksc('gridSubGroups').setMetaDate(value.groupData, {
                profileCode: me.code,
                profileKey: 'gridSubGroups',
                gateCode: me.keyEdit
            });

            me.gksc('gridUsers').setMetaDate(value.userData, {
                profileCode: me.code,
                profileKey: 'gridUsers',
                gateCode: me.keyEdit
            });

            me.gksc('gridParentGroups').setMetaDate(value.parentGroupData, {
                profileCode: me.code,
                profileKey: 'gridParentGroups',
                gateCode: me.keyEdit
            });
            
            name.setDisabled(!isNew);
            
            KsLib.tryRun(callBack);
        });
    },
    isFilled: function() {
        let me = this,
            res = true,
            name = me.gksc('NAME');
        
        if (name.isEmpty()) {
            me.addToInvalidControls(name);
            res = false;
        }
        
        return res;
    }, 
    dataCollector: function() {
        let me = this,
            data = { link: me.getLink() };
        
        data.isCopy = me.f === 'copy';
        
        data.NAME = me.gksc('NAME').getValue();
        data.NOTE = me.gksc('NOTE').getValue();
        data.NASTR_ROLE = me.gksc('chbGroup').getValue();
        
        data.groupData = me.gksc('gridSubGroups').store.getDataExt();
        data.userData = me.gksc('gridUsers').store.getDataExt();
        data.parentGroupData = me.gksc('gridParentGroups').store.getDataExt();
        
        data.continueSave = me.continueSave;
        
        return data;
    },
    
    cancel: Ext.emptyFn
});