﻿//файл расширения моделей Гантта.
Ext.define("StatusTaskModel", {
    extend: "Gnt.model.Task",
    idProperty: "LINK",
    isMilestone: function(a) { //переопределение ф-ии проверки на milestone.(см оригинал)
        return a ? this.isBaselineMilestone() : this.getDuration() < 0;
    }
});

Ext.define("TaskTaskModel", {
    extend: "Gnt.model.Task",
    idProperty: "LINK",
    isMilestone: function(a) { //переопределение ф-ии проверки на milestone.(см оригинал)
        return a ? this.isBaselineMilestone() : this.getDuration() < 0;
    }
});

Ext.define("StatusSeqModel", {
    extend: "Gnt.model.Dependency",
    idProperty: "LINK",
    fromField: "STATUSOBJP",
    toField: "STATUSOBJC"
});

Ext.define("TaskSeqModel", {
    extend: "Gnt.model.Dependency",
    idProperty: "LINK",
    fromField: "TASKDOCP",
    toField: "TASKDOCC"
});
var setGanttData = function(ganttModel) {
    var me = this;
    if (ganttModel) {
        //Загружаем колонки
        if (!me.lockedGrid.columns.length) {
            ganttModel.columns[ArrayLib.find(ganttModel.columns, ['dataIndex'], 'CODE')].width = 45;
            ganttModel.columns[ArrayLib.find(ganttModel.columns, ['dataIndex'], 'NAME')].width = 150;
            me.lockedGrid.reconfigure(me.taskStore, ganttModel.columns);
        }
        //Задаем старт - конец
        me.taskStore.getTasksTimeSpan = function() {
            return {
                start: ganttModel.StartDate,
                end: ganttModel.EndDate
            };
        };
        //Загружаем поля
        if (me.taskStore.fields.length === 1) {
            me.taskStore.fields = ganttModel.fields;
        }
        //Загружаем таскс и сортируем
        me.taskStore.loadData(ganttModel.tasks, false);
	    me.taskStore.sort([{ property: "Group", direction: "ASC" }], false);
        //Загружаем зависимости
        me.dependencyStore.loadData(ganttModel.sequence);
        me.timeAxis.setTimeSpan(ganttModel.StartDate, ganttModel.EndDate);
    } else {
        me.taskStore.loadData([], false);
    }
};
zoomLevels = function(preset) {
    return [
        {
            width: 2,
            increment: 1,
            resolution: 1,
            preset: "status",
            resolutionUnit: "DAY"
        },
        {
            width: 5,
            increment: 1,
            resolution: 1,
            preset: "status",
            resolutionUnit: "DAY"
        },
        {
            width: 10,
            increment: 1,
            resolution: 1,
            preset: "status",
            resolutionUnit: "DAY"
        },
        {
            width: 20,
            increment: 1,
            resolution: 1,
            preset: preset,
            resolutionUnit: "DAY"
        },
        {
            width: 30,
            increment: 1,
            resolution: 1,
            preset: preset,
            resolutionUnit: "DAY"
        },
        {
            width: 60,
            increment: 1,
            resolution: 1,
            preset: preset,
            resolutionUnit: "DAY"
        },
        {
            width: 120,
            increment: 1,
            resolution: 1,
            preset: preset,
            resolutionUnit: "DAY"
        },
        {
            width: 180,
            increment: 1,
            resolution: 1,
            preset: preset,
            resolutionUnit: "DAY"
        },
        {
            width: 300,
            increment: 1,
            resolution: 1,
            preset: preset,
            resolutionUnit: "DAY"
        },
        {
            width: 360,
            increment: 1,
            resolution: 1,
            preset: preset,
            resolutionUnit: "DAY"
        },
        {
            width: 480,
            increment: 1,
            resolution: 1,
            preset: preset,
            resolutionUnit: "DAY"
        }
    ];
}