﻿Ext.define('RevizorFunctionEditor', {
	objs: {},
	funcData: undefined,
	args: undefined,
	okFunc: undefined,
	parentView: undefined,

	constructor: function (cfg) {
		var me = this;
		me.objs = {};
		me.initConfig(cfg);		
		me.processingFuncData();
		me.createItems();
		me.createBtns();
		me.createView();
	},
	processingFuncData: function () {
		var me = this,
			objs = me.objs;
		objs.gridData = [];
		objs.types = [];
		Ext.each(me.funcData.Parameters, function (param) {
			objs.gridData.push([param.Name, '', param.TypeDesc, param]);
			if (Ext.Array.indexOf(objs.types, param.TypeDesc) === -1) {
				objs.types.push(param.TypeDesc);
			}
		});
		objs.allType = Ext.Array.indexOf(objs.types, 'Любой') !== -1;
	},
	viewCfg: function () {
		var me = this,
			objs = me.objs;
		objs.viewCfg = {
			iconCls: 'x_btn_keysystems',
			modal: true,
			title: 'Редактор функции',
			width: 800,
			height: 600,
			layout: {type: 'hbox', align: 'stretch'},
			border: 0,
			padding: 10,
			maximizable: true,
			items: objs.items,
			buttons: objs.btns,
			listeners: objs.listeners
		};
		return objs.viewCfg;
	},
	createView: function () {
		var me = this;
		me.viewCfg();
		me.objs.view = Ext.create('Ext.window.Window', me.objs.viewCfg);
		me.objs.view.on('afterrender', me.loadData.bind(me));
		me.show();
	},
	createItems: function () {
		var me = this,
			objs = me.objs;
		objs.items = [
			objs.ArgumentsField = Ext.create('Ext.form.FieldSet', {
				width: 250,
				padding: 0,
				autoScroll: true,
				title: 'Аргументы',
				layout: {type: 'vbox', align: 'stretch'},
			}),
			{
				xtype: 'splitter',
				border: 0
			},
			Ext.create('Ext.panel.Panel', {
				flex: 1,
				layout: {type: 'vbox', align: 'stretch'},
				layoutConfig: {
					align: 'stretch',
					pack: 'start',

				},
				border: 0,
				items: [
					objs.FuncField = Ext.create('Ext.form.FieldSet', {
						flex: 1,
						autoScroll: true,
						padding: 0,
						title: 'Функция',
						items: [
							objs.grid = Ext.create('Ext.grid.Panel', {
								title: me.funcData.Name,
								userCls: 'rks-filter-panel',
								border: 0,
								columnLines: true,
								plugins: [Ext.create('Ext.grid.plugin.CellEditing', {clicksToEdit: 1}), 'gridclipboard'],
								store: Ext.create('Ext.data.ArrayStore', {
									fields: ['name', 'value', 'type'],
									data: objs.gridData
								}),
								columns: [
									{
										text: 'Наименование',
										dataIndex: 'name',
										draggable: false,
										flex: 1
									}, {
										text: 'Значение',
										dataIndex: 'value',
										draggable: false,
										flex: 1,
										editor: {}
									}, {
										text: 'Тип',
										dataIndex: 'type',
										draggable: false,
										flex: 1
									}
								],
								listeners: {
									select: function (th1, record) {
										objs.AboutTextArea.setValue(record.data.id.Description);
									}
								}
							})
						]
					}),
					objs.AboutField = Ext.create('Ext.form.FieldSet', {
						height: 150,
						autoScroll: true,
						title: 'Описание',
						items: [
							objs.AboutTextArea = Ext.create('Ext.form.field.TextArea', {
								border: 0,
								anchor: '100% 100%',
								readOnly: true,
								userCls: 'rks-noborder-textarea'
							})
						]
					})
				]
			}),

		];
	},
	createBtns: function () {
		var me = this,
			objs = me.objs;
		objs.btns = [
			Ext.create('Ext.Button', {
				text: 'OK',
				handler: function () {
					if (me.okFunc) {
						var text = '';
						Ext.each(objs.grid.getStore().data.items, function (rec) {
							text += ', ' + rec.get('value');
						});

						me.okFunc(me.funcData.Name + '(' + text.substr(2) + ')');
					}
					objs.view.close();
				}
			}),
			Ext.create('Ext.Button', {
				text: 'Отмена',
				handler: function () {
					objs.view.close();
				}
			})
		];
	},
	loadData: function () {
		var me = this;
		me.loadArgs();
	},
	loadArgs: function () {
		var me = this,
			objs = me.objs,
			argPanels = {},
			argsFieldNames = [];
		const loadMask = new Ext.LoadMask({
			msg: KS.L10n.loading_data,
			view: me.objs.view,
			autoShow: true,
			cancelFn: function () {
				me.objs.view.close();
			}
		});
		
		Ext.each(me.args, function (arg) {
			if (objs.allType || (Ext.Array.indexOf(objs.types, arg.TypeDesc) !== -1)) {
				if (!argPanels[arg.TypeDesc]) {
					argPanels[arg.TypeDesc] = Ext.create('Ext.grid.Panel', {
						title: arg.TypeDesc,
						userCls: 'rks-filter-panel',
						border: 0,
						flex: 1,
						collapsible: true,
						collapsed: true,
						store: Ext.create('Ext.data.ArrayStore', {
							fields: ['add', 'text'],
							sorters: 'text',
							data: []
						}),
						columns: [
							{
								xtype: 'actioncolumn',
								flex: 1,
								iconCls: 'x_btn_add',
								align: 'center',
								items: [
									{
										handler: function (grid, rowIndex) {
											var rec = grid.getStore().getAt(rowIndex);
											me.argAdd(rec.data.arg);
										}
									}
								]
							}, {
								text: 'Наименование',
								dataIndex: 'text',
								draggable: false,
								flex: 9,
								editor: {}
							}
						],
						listeners: {
							itemdblclick: function (th1, record) {
								me.argAdd(record.data.arg);
							},
							render: function (th) {
								if (!th.headerClick) {
									th.headerClick = true;
									th.header.on('click', function () {
										if (this.ownerCt.collapsed) {
											this.ownerCt.expand();
										} else {
											this.ownerCt.collapse();
										}
									});
								}
							}
						},
						plugins: ['gridclipboard']
					});
					argsFieldNames.push(arg.TypeDesc);
				}
				argPanels[arg.TypeDesc].store.add({
					text: arg.Name,
					arg: arg
				});
			}
		});
		//argsFieldNames.sort();
		for (var i in argsFieldNames) {
			objs.ArgumentsField.add(argPanels[argsFieldNames[i]]);
		}
		loadMask.destroy();
	},
	argAdd: function (arg) {
		var me = this,
			objs = me.objs,
			store = objs.grid.getStore(),
			selModel = objs.grid.getSelectionModel(),
			sel = selModel.getSelection();
		if (!sel.length) {
			sel = [store.getAt(0)];
			selModel.select(sel);
		}
		sel[0].set('value', '{' + arg.Name + '}');
		if (sel[0] == store.last()) {
			selModel.select(store.getAt(0));
		} else {
			selModel.selectNext();
		}
	},
	show: function () {
		var me = this,
			view = me.objs.view;
		view.show(me.parentView, function () {
			if (view.getX() < 0) {
				view.setX(0);
			}
			if (view.getY() < 0) {
				view.setY(0);
			}
		});
	}
});