﻿Ext.define('Keysystems.Controls.FormulaEditor', {
	objs: {},
	config: {
		okFunc: undefined,
		parentView: undefined
	},
	text: '',
	constructor: function (cfg) {
		var me = this;
		me.objs = {};
		me.initConfig(cfg);
		
		me.createItems();
		me.createBtns();
		me.createView();
	},
	viewCfg: function () {
		var me = this,
			objs = me.objs;
		objs.viewCfg = {
			modal: true,
			title: 'Редактор формул',
			iconCls: 'x_btn_keysystems',
			border: 0,
			width: 800,
			height: 600,
			layout: {type: 'hbox', align: 'stretch'},
			maximizable: true,
			items: objs.items,
			buttons: objs.btns,
			listeners: objs.listeners
		};
		return objs.viewCfg;
	},
	createView: function () {
		var me = this;
		me.viewCfg();
		me.objs.view = Ext.create('Ext.window.Window', me.objs.viewCfg);
		me.objs.view.on('afterrender', me.loadData.bind(me));
		me.show();
	},
	createItems: function () {
		var me = this,
			objs = me.objs;
		objs.items = [
			Ext.create('Ext.panel.Panel', {
				width: 290,
				layout: {type: 'vbox', align: 'stretch'},
				layoutConfig: {
					align: 'stretch',
					pack: 'start',
				},
				border: 0,
				items: [
					objs.tab = Ext.create('Ext.tab.Panel', {
						flex: 1,
						userCls: 'rks-panel-edit',
						bodyCls: 'rks-panel-edit-body',
						border: 1,
						//anchor: '100%',
						items: [
							objs.functionPanel = Ext.create('Ext.panel.Panel', {
								autoScroll: true,
								title: 'Функции',
							}),
							objs.argumentsPanel = Ext.create('Ext.panel.Panel', {
								autoScroll: true,
								title: 'Аргументы',
								border: 0,
							})
						]
					}),
					objs.info = Ext.create('Ext.panel.Panel', {
						border: 0,
						height: 75,
						items: [
							objs.infoTextArea = Ext.create('Ext.form.field.TextArea', {
								height: '100%',
								width: '100%',
								readOnly: true
							})
						]
					}),
				]
			}),
			{
				xtype: 'splitter',
				border: 0
			},
			Ext.create('Ext.panel.Panel', {
				flex: 1,
				layout: {type: 'vbox', align: 'stretch'},
				layoutConfig: {
					align: 'stretch',
					pack: 'start',
				},
				border: 1,
				minWidth: 410,
				items: [
					objs.editPanel1 = Ext.create('Ext.panel.Panel', {
						flex: 1,
						border: 0,
						minButtonWidth: 25,
						items: [
							objs.textArea = Ext.create('Ext.form.field.TextArea', {
								height: '100%',
								width: '100%',
								//maxLength: 500,
								value: me.text,
								listeners: {
									focus: function (th1) {
										th1.lastSelection = null;
									},
									blur: function (th1, the) {
										th1.lastSelection = {
											start: the.target.selectionStart,
											end: the.target.selectionEnd
										};
									}
								}
							})
						],
						buttons: [
							Ext.create('Ext.Button', {
								text: '+',
								handler: function () {
									objs.textArea.insertText('+');
								}
							}),
							Ext.create('Ext.Button', {
								text: '*',
								handler: function () {
									objs.textArea.insertText('*');
								}
							}),
							Ext.create('Ext.Button', {
								text: '^',
								handler: function () {
									objs.textArea.insertText('^');
								}
							}),
							Ext.create('Ext.Button', {
								text: '&',
								handler: function () {
									objs.textArea.insertText('&');
								}
							}),
							Ext.create('Ext.Button', {
								text: '=',
								handler: function () {
									objs.textArea.insertText('=');
								}
							}),
							Ext.create('Ext.Button', {
								text: '<>',
								width: 55,
								handler: function () {
									objs.textArea.insertText('<>');
								}
							}),
							Ext.create('Ext.Button', {
								text: '(',
								handler: function () {
									objs.textArea.insertText('(');
								}
							}),
							Ext.create('Ext.Button', {
								text: ')',
								handler: function () {
									objs.textArea.insertText(')');
								}
							}),
							Ext.create('Ext.Button', {
								text: '[',
								handler: function () {
									objs.textArea.insertText('[');
								}
							}),
							Ext.create('Ext.Button', {
								text: ']',
								handler: function () {
									objs.textArea.insertText(']');
								}
							}),
							Ext.create('Ext.Button', {
								text: 'ИСТИНА',
								width: 75,
								handler: function () {
									objs.textArea.insertText('ИСТИНА');
								}
							})
						]
					}),
					objs.editPanel2 = Ext.create('Ext.panel.Panel', {
						border: 0,
						minButtonWidth: 25,
						buttons: [
							Ext.create('Ext.Button', {
								text: '-',
								handler: function () {
									objs.textArea.insertText('-');
								}
							}),
							Ext.create('Ext.Button', {
								text: '/',
								handler: function () {
									objs.textArea.insertText('/');
								}
							}),
							Ext.create('Ext.Button', {
								text: '%',
								handler: function () {
									objs.textArea.insertText('%');
								}
							}),
							Ext.create('Ext.Button', {
								text: '$',
								handler: function () {
									objs.textArea.insertText('$');
								}
							}),
							Ext.create('Ext.Button', {
								text: '!',
								handler: function () {
									objs.textArea.insertText('!');
								}
							}),
							Ext.create('Ext.Button', {
								text: '<',
								handler: function () {
									objs.textArea.insertText('<');
								}
							}),
							Ext.create('Ext.Button', {
								text: '>',
								handler: function () {
									objs.textArea.insertText('>');
								}
							}),
							Ext.create('Ext.Button', {
								text: '{',
								handler: function () {
									objs.textArea.insertText('{');
								}
							}),
							Ext.create('Ext.Button', {
								text: '}',
								handler: function () {
									objs.textArea.insertText('}');
								}
							}),
							Ext.create('Ext.Button', {
								text: 'пробел',
								width: 65,
								handler: function () {
									objs.textArea.insertText(' ');
								}
							}),
							Ext.create('Ext.Button', {
								text: 'ЛОЖЬ',
								width: 55,
								handler: function () {
									objs.textArea.insertText('ЛОЖЬ');
								}
							})
						]
					})
				]
			}),

		];

		objs.textArea.insertText = function (value) {
			var dom = this.inputEl.dom,
				val = dom.value,
				start = dom.selectionStart,
				end = dom.selectionEnd;
			if ((!start) && (!end) && (val.length) && (this.lastSelection)) {
				start = this.lastSelection.start;
				end = this.lastSelection.end;
			}
			var val1 = val.substr(0, start),
				val2 = val.substr(end);
			this.setValue(val1 + value + val2);
			this.selectText(start + value.length, start + value.length);
		};
	},
	createBtns: function () {
		var me = this,
			objs = me.objs;
		objs.btns = [
			Ext.create('Ext.Button', {
				text: 'Проверить',
				handler: function () {
					ajaxRequest({
						url: 'formula/Compail_A',
						params: {
							formula: objs.textArea.getValue()
						},
						success: function (data) {
							if (data == '') {
								info(wmc.get('NoErrors'));
							} else {
								warning(data);
							}
						}
					});
				}
			}),
			Ext.create('Ext.Button', {
				text: 'Очистить',
				handler: function () {
					objs.textArea.setValue('');
					objs.textArea.lastSelection = null;
				}
			}),
			Ext.create('Ext.Button', {
				text: 'OK',
				handler: function () {
					if (me.okFunc || me._okFunc) {
						var func = (me.okFunc || me._okFunc);
						func(objs.textArea.getValue());
					}
					objs.view.close();
				}
			}),
			Ext.create('Ext.Button', {
				text: 'Отмена',
				handler: function () {
					objs.view.close();
				}
			})
		];
	},
	loadData: function () {
		var me = this,
			objs = me.objs,
			params = {
				Code: me.Code,
				IncludeThruNumber: me.IncludeThruNumber,
				IncludeSCalc: me.IncludeSCalc,
				SCalcLinks: me.SCalcLinks,
				SWorkLinks: me.SWorkLinks,
				DH1: me.DH1,
				DH2: me.DH2,
				IsMask: me.IsMask
			};
		const loadMask = new Ext.LoadMask({
			msg: KS.L10n.loading_data,
			view: me.objs.view,
			autoShow: true,
			rid: ajaxRequest({
				url: 'Formula/Fill_A',
				params: {gzipData: SignalR.pack(params)},
				success: function (data) {
					loadMask.destroy();
					objs.funcs = data.Functions;
					objs.args = data.Arguments;
					me.loadFuncs(data.Functions);
					me.loadArgs(data.Arguments);
				}
			}),
			cancelFn: function () {
				me.objs.view.close();
			}
		});
	},
	loadFuncs: function (dataFuncs) {
		var me = this,
			objs = me.objs,
			funcs = {},
			funcsFieldNames = [];
		Ext.each(dataFuncs, function (func) {
			if (!funcs[func.Category]) {
				funcs[func.Category] = Ext.create('Ext.grid.Panel', {
					title: func.Category,
					userCls: 'rks-filter-panel',
					border: 0,
					flex: 1,
					collapsible: true,
					collapsed: true,
					store: Ext.create('Ext.data.ArrayStore', {
						fields: ['add', 'text'],
						sorters: 'text',
						data: []
					}),
					columns: [
						{
							xtype: 'actioncolumn',
							text: '',
							width: '10%',
							iconCls: 'x_btn_add',
							align: 'center',
							items: [
								{
									handler: function (grid, rowIndex) {
										var rec = grid.getStore().getAt(rowIndex);
										me.funcAdd(rec.data.func);
									}
								}
							]
						}, {
							text: 'Наименование',
							dataIndex: 'text',
							draggable: false,
							width: '90%',
							editor: {}
						}
					],
					listeners: {
						itemclick: function (th1, record) {
							objs.infoTextArea.setValue(wmc.get('InfoTextArea', record.data.text, record.data.func.Description, record.data.func.ReturnTypeDesc));
						},
						itemdblclick: function (th1, record) {
							me.funcAdd(record.data.func);
						},
						render: function (th) {
							if (!th.headerClick) {
								th.headerClick = true;
								th.header.on('click', function () {
									if (this.ownerCt.collapsed) {
										this.ownerCt.expand();
									} else {
										this.ownerCt.collapse();
									}
								});
							}
						}
					},
					plugins: ['gridclipboard']
				});
				funcsFieldNames.push(func.Category);
			}
			var params = '';
			for (var i = 0; i < func.Parameters.length; i++) {
				if (func.Parameters[i].Multi) {
					params += ', [ ' + func.Parameters[i].Name + ' ...]';
				} else {
					params += ', ' + func.Parameters[i].Name;
				}
			}
			funcs[func.Category].store.add({
				text: func.Name + '(' + params.substr(2) + ')',
				func: func
			});
		});
		funcsFieldNames.sort();
		for (i in funcsFieldNames) {
			objs.functionPanel.add(funcs[funcsFieldNames[i]]);
		}
	},
	loadArgs: function (dataArgs) {
		var me = this,
			objs = me.objs,
			args = {},
			argsFieldNames = [];
		Ext.each(dataArgs, function (arg) {
			if (!args[arg.TypeDesc]) {
				args[arg.TypeDesc] = Ext.create('Ext.grid.Panel', {
					title: arg.TypeDesc,
					userCls: 'rks-filter-panel',
					store: Ext.create('Ext.data.ArrayStore', {
						fields: ['add', 'text'],
						sorters: 'text',
						data: []
					}),
					columns: [
						{
							xtype: 'actioncolumn',
							text: '',
							width: '10%',
							iconCls: 'x_btn_add',
							align: 'center',
							items: [
								{
									handler: function (grid, rowIndex) {
										var rec = grid.getStore().getAt(rowIndex);
										objs.textArea.insertText('{' + rec.data.arg.Name + '}');
									}
								}
							]
						}, {
							text: 'Наименование',
							dataIndex: 'text',
							draggable: false,
							width: '90%',
							editor: {}
						}
					],
					border: 0,
					width: 270,
					collapsible: true,
					collapsed: true,
					listeners: {
						/*select*/
						itemclick: function (th1, record) {
							objs.infoTextArea.setValue(record.data.arg.Description);
							/*Ext.each(objs['argumentsPanel'].items.items, function (a) {
                            if (a.title != record.data.arg.TypeDesc) {
                            a.getSelectionModel().deselectAll();
                            }
                            });*/
						},
						itemdblclick: function (th1, record) {
							objs.textArea.insertText('{' + record.data.arg.Name + '}');
						},
						render: function (th) {
							if (!th.headerClick) {
								th.headerClick = true;
								th.header.on('click', function () {
									if (this.ownerCt.collapsed) {
										this.ownerCt.expand();
									} else {
										this.ownerCt.collapse();
									}
								});
							}
						}
					},
					plugins: ['gridclipboard']
				});
				argsFieldNames.push(arg.TypeDesc);
			}
			args[arg.TypeDesc].store.add({
				text: arg.Description || arg.Name,
				arg: arg
			});
		});
		//argsFieldNames.sort();
		for (i in argsFieldNames) {
			objs.argumentsPanel.add(args[argsFieldNames[i]]);
		}
	},
	funcAdd: function (func) {
		var me = this,
			objs = me.objs;
		if (func.Parameters.length) {
			Ext.create('RevizorFunctionEditor', {
				funcData: func,
				args: objs.args,
				okFunc: function (value) {
					objs.textArea.insertText(value);
				},
				parentView: objs.view
			});
		} else {
			objs.textArea.insertText(func.Name + '()');
		}
	},
	show: function () {
		var me = this,
			view = me.objs.view;
		view.show(me.parentView, function () {
			if (view.getX() < 0) {
				view.setX(0);
			}
			if (view.getY() < 0) {
				view.setY(0);
			}			
		});
	}
});