﻿Ext.define('Keysystems.Financ.List', {
	extend: 'Keysystems.Base.List',
	deleteCode: 'DOCUMENT_FINANC',
	startYear: (new Date()).getFullYear(),
	bodyPadding: 10,
	labelWidth: 150,
	disableToolBar: true,

	profileListeners: [
		{ name: 'holdingPeriod', method: 'KsPeriodChange' },
		{ name: 'Statuses', method: 'ksCheckBoxChange' }
	],

	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	
	setWhereArgs: function() {
		let me = this,
			objs = me.objs,
			statuses = (objs.Statuses.getValue() || []).filter(status => Ext.isNumber(status)),
			dh = objs.holdingPeriod.getValue(),
			whereArgs = {
				DBegin: { value: dh.dh1, type: 'Date' },
				DEnd: { value: dh.dh2, type: 'Date' },
				Statuses: { value: Ext.isNumber(statuses[0]) ? JSON.stringify(statuses) : JSON.stringify([]), type: 'List_int' },
				ObjLinks: me.getWhereArgs().ObjLinks,
				NpaObjLinks: me.getWhereArgs().NpaObjLinks
			};

		return Ext.apply(me.whereArgs, whereArgs);
	},
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = me.callParent(arguments);

		items.unshift(objs.filterPanel = Ext.create('Ext.panel.Panel', {
			layout: { type: 'vbox', align: 'stretch' },
			collapsible: !me.hideBottomPanel,
			bodyPadding: !me.hideBottomPanel ? me.bodyPadding : ( me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding),
			border: 0,
			bodyBorder: 0,
			userCls: 'rks-filter-panel',
			header: {
				title: 'Фильтр по Финансированию',
				hidden: me.hideBottomPanel,
			},
			animCollapse: false,
			items: [
				Ext.create('Ext.form.FieldContainer',
					{
						layout: { type: 'hbox', align: 'stretch' },
						items: [
							objs.holdingPeriod = Ext.create('Keysystems.Controls.KsPeriod', {
								startYear: me.startYear,
								state: 4,
								allStates: 13,
								width: 400,
								listeners: {
									ksChange: function () {
										if (me.isLoading) return;
										me.refreshData();
									}
								}
							}),
							objs.Statuses = Ext.create('Keysystems.Controls.ComboBoxExtra', {
								multiSelect: true,
								value: null,
								fieldLabel: 'Статус',
								labelWidth: 50,
								width: 400,
								padding: '0 0 0 10',
								editable: false,
								queryMode: 'local',
								displayField: CBDataLib.displayField,
								valueField: CBDataLib.valueField,
								store: Ext.create('Ext.data.Store', {
									fields: CBDataLib.getFields(),
									data: CBDataLib.get('FinancStatus'),
									proxy: 'memory'
								}),
								listeners: {
									change: function (th, val) {
										if (me.isLoading) return;
										me.refreshData();
									}
									
								}
							})
						]
					})
			]
		}));
		objs.Year = objs.holdingPeriod.Quarter.holdingYear;
		objs.Quarter = objs.holdingPeriod.Quarter.holdingQuarter;
		// objs.Statuses.on('change', function() {
		// 	if (me.isLoading) return;
		// 	me.refreshData(); });

		if (me.hideFilterPanel) 
			objs.filterPanel.hide();		
		
		return items;
	},

	addRecord: function() {
		var me = this,
			rec = me.callParent(arguments);

		KsLib.tryRun(me.addRevizRecord, me, rec);
	},

	refreshData: function() {
		var me = this,
			objs = me.objs;

		me.setWhereArgs();
		//objs.holdingPeriod.getYear(), objs.Quarter.getValue(), objs.Statuses.getValue()
		me.refresh();
	},

	initializeFilter: function () {
		let me = this;
		if (!me.whereArgs) return;

		me.updateDateFromWhereArg(me.whereArgs.DBegin.value, me.whereArgs.DEnd.value, me.objs.holdingPeriod);
	},

	createTBar: function () {
		let me = this,
			objs = me.objs;

		me.callParent(arguments);

		if (me.visibleShowFinanc) {
			me.objs.tbarBtns.showFinanc = me.sksc('btnShow',
				Ext.create('Ext.Button',
					{
						iconCls: 'x_btn_currency',
						tooltip: 'Финансирование по объекту',
						tooltipType: 'title',
						hidden: !me.visibleShowFinanc,
						disabled: true,
						handler: function() {
							let whereArgsShow = me.getWhereArgs();
							delete whereArgsShow.Statuses;
							delete whereArgsShow.NpaObjLinks;
							
							let	cfg = {
								code: me.code,
								parentView: me.parentView,
								title: me.title,
								linkCode: me.linkCode,
								editClass: 'Keysystems.Financ.Edit',
								handler: 'Keysystems.Financ.List',
								iconCls: 'x_btn_currency',
								whereArgs: whereArgsShow,
								hidePagging: true,
								checkModel: false,
								setRecord: function (row, cmp) {
									return me.setRecord(row, cmp);
								},
								addRecord: function (row) {
									var grid = me.objs.FINANC_LIST.objs.Grid,
										rec = grid.store.createModel(row);
									grid.loadData([rec], true);
									me.objs.FINANC_LIST.refresh(true, 1);
									me.addRecord(row);
									return rec;
								}
							};
							me.objs.FINANC_LIST = Ext.create('Keysystems.Financ.List', cfg);
						}
					}));
			objs.tbar.unshift(objs.tbarBtns.showFinanc);
		}
		me.setReadOnly(me.accessTab === 1);
		return objs.tbar;
	},

	getGridCfg: function(){
		let res = this.callParent(arguments);
		res.userCls = 'rks-grid-with-filter-panel';
		return res;
	},

	setReadOnly: function(state) {
		var me = this,
			objs = me.objs,
			btns = objs.tbar;
		me.callParent(arguments);

		if (me.disableToolBar && objs.tbarBtns) {
			Ext.Array.each(btns,
			function (btn) {
				if (Ext.isFunction(btn.setReadOnly)) {
					btn.setReadOnly(state);
				}
			});
			objs.tbarBtns.showFinanc && objs.tbarBtns.showFinanc.setReadOnly(false);
		}
	}
});